#ifndef _riff_H
#define _riff_H

#include <stdio.h>
#include <stdbool.h>
#include <windows.h>
#include <mmsystem.h>

// Definitions for RIFF file I/O

#pragma pack(1)

// Strukturen fr die Cue-List

// CUECHUNK ist ein Sub-Chunk des RIFF-Chunks:

typedef struct _CUECHUNK
{
	DWORD chunkID;			// Chunk-ID = "cue "
	DWORD chunkSize;		// Chunk-Gre
	DWORD dwCuePoints;		// Anzahl (n) der nachfolgenden CUEPOINT-Strukturen
} CUECHUNK;

typedef struct _CUEPOINT	// (n) solcher Strukturen folgen hinter CUECHUNK.
{
	DWORD dwIdentifier;		// = Nummer der Cue (1...n)
	DWORD dwPosition;		// = Start-Sample ("play order")
	DWORD fccChunk;			// = "data"
	DWORD dwChunkStart;		// = 0
	DWORD dwBlockStart;		// = 0
	DWORD dwSampleOffset;	// = Start-Sample
} CUEPOINT;

// Die folgenden Chunks sind Sub-Chunks des LIST-Chunks:

typedef struct _CUELABELTEXTCHUNK
{
	DWORD chunkID;			// Chunk-ID = "ltxt"
	DWORD chunkSize;		// Chunk-Gre
	DWORD dwIdentifier;		// = Nummer der Cue (1...n)
	DWORD dwSampleLength;	// = Cue-Lnge in Samples
	DWORD dwPurpose;		// = "rgn ", "beat", "trak", "indx", etc.
	DWORD dw1;				// = 0
	DWORD dw2;				// = 0
} CUELABELTEXTCHUNK;

typedef struct _CUETEXTCHUNK
{
	DWORD chunkID;			// Chunk-ID = "labl" bzw. "note"
	DWORD chunkSize;		// Chunk-Gre
	DWORD dwIdentifier;		// Nummer der Cue (1...n)
	char szText[256];		// Text-String (Label bzw. Description)
} CUETEXTCHUNK;

typedef struct _PLAYLISTCHUNK
{
	DWORD chunkID;			// Chunk-ID = "plst"
	DWORD chunkSize;		// Chunk-Gre
	DWORD dwSegments;		// Anzahl (n) der nachfolgenden PLAYLISTITEM-Strukturen
} PLAYLISTCHUNK;

typedef struct _PLAYLISTITEM// (n) solcher Strukturen folgen hinter PLAYLISTCHUNK.
{
	DWORD dwIdentifier;		// = Nummer der Cue (1...n)
	DWORD dwLength;			// = Cue-Lnge in Samples
	DWORD dwRepeats;		// = Anzahl der Wiederholungen (Loops)
} PLAYLISTITEM;

#pragma pack()

// Funktionen zum Parsen von RIFF-Files

void FOURCCToString(DWORD dwFOURCC, char* pszFOURCC);
DWORD StringToFOURCC(char* pszFOURCC);
int FindChunk(FILE *pFile, LPMMCKINFO pChunk, LPMMCKINFO pParentChunk);
int SeekBehindChunk(FILE *pFile, LPMMCKINFO pChunk);

#endif

