#include "riff.h"

void FOURCCToString(DWORD dwFOURCC, char* pszFOURCC)
{
	for(int i = 0; i < 4; i++)
	{
		char c = (dwFOURCC >> (8 * i)) & 0xFF;
		pszFOURCC[i] = c;
	}

	pszFOURCC[4] = '\0';

	// TrimRight
	while (strlen(pszFOURCC) > 0 && pszFOURCC[strlen(pszFOURCC) - 1] == ' ')
		pszFOURCC[strlen(pszFOURCC) - 1] = '\0';
}

DWORD StringToFOURCC(char* pszFOURCC)
{
	DWORD dwFOURCC = 0;

	for(int i = 3; i >= 0; i--)
	{
		dwFOURCC *= 0x100;
		dwFOURCC += strlen(pszFOURCC) <= i ? ' ' : pszFOURCC[i];
	}

	return dwFOURCC;
}

//
// Diese Funktion entspricht im Wesentlichen mmioDescend(), jedoch mit folgenden Unterschieden:
// - Es werden auch Chunks mit ungerader Chunksize und fehlendem Padbyte gefunden.
// - Der Parameter uFlags entfllt; stattdessen ist pChunk->ckid zu fllen (wie bei Subchunks).
//
int FindChunk(FILE *pFile, LPMMCKINFO pChunk, LPMMCKINFO pParentChunk)
{
	DWORD dwChunkId = pChunk->ckid;

	int nBytesToRead = 8;
	if(dwChunkId == StringToFOURCC("RIFF") || dwChunkId == StringToFOURCC("LIST")) nBytesToRead = 12;

	int nBytesMax = 0x7fffffff;
	if(pParentChunk) nBytesMax = pParentChunk->cksize + pParentChunk->dwDataOffset - ftell(pFile);

	int nBytesReadSoFar = 0;

	do
	{
		if(nBytesReadSoFar + nBytesToRead > nBytesMax) return -1;
		int nBytesRead = fread(pChunk, 1, nBytesToRead, pFile);
		if(nBytesRead != nBytesToRead) return -1;
		if((pChunk->ckid & 0xff) == 0)		 // 1. Byte = Padbyte?
		{
			fseek(pFile, 1 - nBytesToRead, SEEK_CUR);		// File-Pointer zurcksetzen + 1 Byte vor
			nBytesReadSoFar++;
			if(nBytesReadSoFar + nBytesToRead > nBytesMax) return -1;
			nBytesRead = fread(pChunk, 1, nBytesToRead, pFile);	// nochmal lesen
			if(nBytesRead != nBytesToRead) return -1;
		}
		nBytesReadSoFar += nBytesRead;
		if(pChunk->ckid == dwChunkId)
		{
			pChunk->dwDataOffset = ftell(pFile) + 8 - nBytesToRead;
			return 0;
		}
		if(pChunk->cksize <= 0) return -1; // unsinniger Wert?
		int nBytesToSkip = pChunk->cksize + 8 - nBytesToRead;
		if(nBytesReadSoFar + nBytesToSkip > nBytesMax) return -1;
		if(fseek(pFile, nBytesToSkip, SEEK_CUR) != 0) return -1;
		nBytesReadSoFar += nBytesToSkip;
	}
	while(true);
}

//
// Diese Funktion entspricht im Wesentlichen mmioAscend(), jedoch mit folgenden Unterschieden:
// - Es knnen damit keine Chunks geschrieben werden (siehe mmioCreateChunk)
//
int SeekBehindChunk(FILE *pFile, LPMMCKINFO pChunk)
{
	return fseek(pFile, pChunk->cksize + pChunk->dwDataOffset - ftell(pFile), SEEK_CUR);
}

