###############################################################################
# Perl-Script zur Konvertierung von MBROLA-PHO-Dateien in SPRICH-Phoneme.
# Die Ziel-Phonemzeichen entsprechen denen in der Phonemdatei "phoneme.waw".
# Falls ein Phonemsatz mit anderen Phonemzeichen verwendet wird, ist das 
# Script entsprechend anzupassen.
# 
# Aufruf: perl mb2sp.pl < PHO-Datei > Textdatei
# Beispiel: perl mb2sp.pl < wetter.pho > wetter.txt
###############################################################################

while(<>) # zeilenweise Bearbeitung
{
	s/^\s+|\s+$//g; # Fhrende und anhngende Leerzeichen entfernen
	next if /^[\s*#;]/; # Leerzeilen und Bemerkungszeilen berspringen
	s/\s+/ /g; # Mehrfache Whitespaces zu einem Leerzeichen zusammenfassen
	($pho, $par) = (split(/ /))[0,1]; # Phonem und 1. Parameter

	if($pho eq '_')
	{
		# Pausen
		$p1000 = int($par / 1000); $par -= $p1000 * 1000; while($p1000--) { $out .= '#'; }
		$p500 = int($par / 500); $par -= $p500 * 500; while($p500--) { $out .= '.'; }
		$p200 = int($par / 200); $par -= $p200 * 200; while($p200--) { $out .= '  '; }
		$p100 = int($par / 100); $par -= $p100 * 100; while($p100--) { $out .= ' '; }
		$p50 = int($par / 50); $par -= $p50 * 50; while($p50--) { $out .= '|'; }
		if($par > 0) { $out .= '|'; }
	}
	else
	{
		# Phoneme
		$pho = (split(/_/, $pho))[0]; # Suffixe hinter "_" entfernen
		$out .= $pho;
	}
}

# Phoneme aus mehreren Zeichen ersetzen

# a) Franzsische Nasallaute
$out =~ s/9~/3:/g;
$out =~ s/a~/0:/g;
$out =~ s/e~/:/g;
$out =~ s/E~/:/g;
$out =~ s/o~/o:/g;

# b) Sonstige
$out =~ s/eI/i/g;
$out =~ s/OY/0i/g;
$out =~ s/r=/3:/g;

# Phoneme aus 1 Zeichen ersetzen
$out =~ tr/24569?@ACDEHILOQRsTUvVwyYzZ{/tl03 3acsil00rzzuwausJ/;

print $out;
