
// HtmlWindowDlg.h: Headerdatei
//

#pragma once


// CHtmlWindowDlg-Dialogfeld
class CHtmlWindowDlg : public CDHtmlDialog
{
// Konstruktion
public:
	CHtmlWindowDlg(CString strTitle, CString strUrl, CString strSec, CString strZoom, CWnd* pParent = NULL);	// Standardkonstruktor

// Dialogfelddaten
	enum { IDD = IDD_HTMLWINDOW_DIALOG, IDH = IDR_HTML_HTMLWINDOW_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV-Untersttzung

	HRESULT OnButtonOK(IHTMLElement *pElement);
	HRESULT OnButtonCancel(IHTMLElement *pElement);

// Implementierung
protected:
	HICON m_hIcon;

	// Generierte Funktionen fr die Meldungstabellen
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnOK();
	afx_msg void OnCancel();
	afx_msg void OnClose();
	afx_msg void OnDestroy();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnMove(int x, int y);
	afx_msg void OnTimer(UINT nIDEvent);
	virtual void OnNavigateComplete(LPDISPATCH pDisp, LPCTSTR szUrl);

	DECLARE_MESSAGE_MAP()
	DECLARE_DHTML_EVENT_MAP()

	bool SetBrowserEmulationMode();
	int GetIEMajorVersion();
	CString GetExeName();

	void LoadSettings();
	void StoreSettings();

	void SetSettingsTimer();
	void KillSettingsTimer();

	void SetRefreshTimer();
	void KillRefreshTimer();

	CString m_strTitle;
	CString m_strUrl;
	int m_nRefreshSec;
	int m_nZoomLevel;

	UINT m_nSettingsTimerID;
	UINT m_nRefreshTimerID;
};
