
// HtmlWindowDlg.cpp: Implementierungsdatei
//

#include "stdafx.h"
#include "HtmlWindow.h"
#include "HtmlWindowDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define SETTINGS_TIMER_ID 1
#define REFRESH_TIMER_ID 2

// CHtmlWindowDlg-Dialogfeld

BEGIN_DHTML_EVENT_MAP(CHtmlWindowDlg)
	DHTML_EVENT_ONCLICK(_T("ButtonOK"), OnButtonOK)
	DHTML_EVENT_ONCLICK(_T("ButtonCancel"), OnButtonCancel)
END_DHTML_EVENT_MAP()



CHtmlWindowDlg::CHtmlWindowDlg(CString strTitle, CString strUrl, CString strSec, CString strZoom, CWnd* pParent /*=NULL*/)
	: CDHtmlDialog(CHtmlWindowDlg::IDD, CHtmlWindowDlg::IDH, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_strTitle = strTitle;
	m_strUrl = strUrl;
	m_nRefreshSec = StrToInt(strSec);
	m_nZoomLevel = StrToInt(strZoom);
	m_nSettingsTimerID = 0;
	m_nRefreshTimerID = 0;
}

void CHtmlWindowDlg::DoDataExchange(CDataExchange* pDX)
{
	CDHtmlDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CHtmlWindowDlg, CDHtmlDialog)
	//}}AFX_MSG_MAP
	ON_WM_CLOSE()
	ON_WM_SIZE()
	ON_WM_MOVE()
	ON_WM_TIMER()
	ON_WM_DESTROY()
END_MESSAGE_MAP()


// CHtmlWindowDlg-Meldungshandler

BOOL CHtmlWindowDlg::OnInitDialog()
{
	CDHtmlDialog::OnInitDialog();

	// Symbol fr dieses Dialogfeld festlegen. Wird automatisch erledigt
	//  wenn das Hauptfenster der Anwendung kein Dialogfeld ist
	SetIcon(m_hIcon, TRUE);			// Groes Symbol verwenden
	SetIcon(m_hIcon, FALSE);		// Kleines Symbol verwenden

	// TODO: Hier zustzliche Initialisierung einfgen

	m_pBrowserApp->put_Silent(VARIANT_TRUE); // Skriptfehler-Meldungen unterbinden

	SetBrowserEmulationMode(); // Browser-Emulationsmodus auf IE11 setzen

	if(!m_strTitle.IsEmpty())
	{
		SetWindowText(m_strTitle);
		ModifyStyleEx(WS_EX_APPWINDOW, 0);
	}

	LoadSettings();

	if(!m_strUrl.IsEmpty())
	{
		Navigate(m_strUrl, navNoHistory | navNoReadFromCache);
	}

	SetRefreshTimer();

	return TRUE;  // TRUE zurckgeben, wenn der Fokus nicht auf ein Steuerelement gesetzt wird
}

// Wenn Sie dem Dialogfeld eine Schaltflche "Minimieren" hinzufgen, bentigen Sie 
//  den nachstehenden Code, um das Symbol zu zeichnen. Fr MFC-Anwendungen, die das 
//  Dokument/Ansicht-Modell verwenden, wird dies automatisch ausgefhrt.

void CHtmlWindowDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // Gertekontext zum Zeichnen

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Symbol in Clientrechteck zentrieren
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Symbol zeichnen
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDHtmlDialog::OnPaint();
	}
}

// Die System ruft diese Funktion auf, um den Cursor abzufragen, der angezeigt wird, whrend der Benutzer
//  das minimierte Fenster mit der Maus zieht.
HCURSOR CHtmlWindowDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

HRESULT CHtmlWindowDlg::OnButtonOK(IHTMLElement* /*pElement*/)
{
	OnOK();
	return S_OK;
}

HRESULT CHtmlWindowDlg::OnButtonCancel(IHTMLElement* /*pElement*/)
{
	OnCancel();
	return S_OK;
}

void CHtmlWindowDlg::OnOK()
{
	CString strUrl;
	GetCurrentUrl(strUrl);
	if (strUrl != m_strUrl)
	{
		CDHtmlDialog::OnOK();
	}
}

void CHtmlWindowDlg::OnCancel()
{
	StoreSettings();
	CDHtmlDialog::OnCancel();
}

void CHtmlWindowDlg::OnClose()
{
	StoreSettings();
	CDHtmlDialog::OnClose();
}

void CHtmlWindowDlg::OnDestroy()
{
	CDHtmlDialog::OnDestroy();

	KillSettingsTimer();
	KillRefreshTimer();
}

void CHtmlWindowDlg::OnSize(UINT nType, int cx, int cy)
{
	CDHtmlDialog::OnSize(nType, cx, cy);

	KillSettingsTimer();
	SetSettingsTimer();
}

void CHtmlWindowDlg::OnMove(int x, int y)
{
	CDHtmlDialog::OnMove(x, y);

	KillSettingsTimer();
	SetSettingsTimer();
}

void CHtmlWindowDlg::OnTimer(UINT nIDEvent)
{
	CDHtmlDialog::OnTimer(nIDEvent);

	if (nIDEvent == m_nSettingsTimerID)
	{
		KillSettingsTimer();
		StoreSettings();
	}
	else if (nIDEvent == m_nRefreshTimerID)
	{
		Navigate(m_strUrl, navNoHistory | navNoReadFromCache);
	}
}

//
// After the HTML page has been loaded, set the zoom level.
//
void CHtmlWindowDlg::OnNavigateComplete(LPDISPATCH pDisp, LPCTSTR szUrl)
{
	if (m_nZoomLevel <= 0)
		return;

	// Don't zoom the welcome message...
	if (CString(szUrl).Left(6) == "res://")
		return;

	CComVariant vZoomLevel = m_nZoomLevel;
	m_pBrowserApp->ExecWB(OLECMDID_OPTICAL_ZOOM, OLECMDEXECOPT_DODEFAULT, &vZoomLevel, NULL);
}

//
// Sets the browser emulation mode for the WebBrowser Control dependent on the installed IE version.
// If the IE version can't be determined, the emulation mode will be set to 11001 (IE 11).
// See also: http://msdn.microsoft.com/en-us/library/ie/ee330730%28v=vs.85%29.aspx
//
bool CHtmlWindowDlg::SetBrowserEmulationMode()
{
	bool bSuccess = false;

	DWORD dwEmulationMode = 11001; // default value (IE11 in Edge Mode)

	switch (GetIEMajorVersion())
	{
	case 8:
		dwEmulationMode = 8000;
		break;
	case 9:
		dwEmulationMode = 9000;
		break;
	case 10:
		dwEmulationMode = 10000;
		break;
	case 11:
		dwEmulationMode = 11001;
		break;
	}

	CString strExeFileName = GetExeName();
	if (!strExeFileName.IsEmpty())
	{
		CRegKey regBrowserEmulation;
		if (ERROR_SUCCESS == regBrowserEmulation.Create(HKEY_CURRENT_USER, L"Software\\Microsoft\\Internet Explorer\\Main\\FeatureControl\\FEATURE_BROWSER_EMULATION"))
		{
			if (ERROR_SUCCESS == regBrowserEmulation.SetDWORDValue(strExeFileName, dwEmulationMode))
			{
				bSuccess = true;
			}
			regBrowserEmulation.Close();
		}
	}

	return bSuccess;
}

//
// Returns the major version number of the installed Internet Explorer.
// If the IE version can't be determined, the result will be -1.
//
int CHtmlWindowDlg::GetIEMajorVersion()
{
	int nMajorVersion = -1;

	CRegKey regInternetExplorer;
	if (ERROR_SUCCESS == regInternetExplorer.Open(HKEY_LOCAL_MACHINE, L"SOFTWARE\\Microsoft\\Internet Explorer", KEY_READ))
	{
		WCHAR szValue[MAX_PATH] = L"";
		DWORD nCount = MAX_PATH;

		if (ERROR_SUCCESS == regInternetExplorer.QueryStringValue(L"svcVersion", szValue, &nCount))
		{
			nMajorVersion = StrToInt(szValue);
		}
		else
		{
			nCount = MAX_PATH;

			if (ERROR_SUCCESS == regInternetExplorer.QueryStringValue(L"Version", szValue, &nCount))
			{
				nMajorVersion = StrToInt(szValue);
			}
		}

		regInternetExplorer.Close();
	}

	return nMajorVersion;
}

//
// Returns the file name of the currently running module without the path (e.g. "BKServer.exe").
//
CString CHtmlWindowDlg::GetExeName()
{
	CString strExeName;

	CString strModuleFilename;
	DWORD dwResult = GetModuleFileName(NULL, strModuleFilename.GetBuffer(MAX_PATH), MAX_PATH);
	strModuleFilename.ReleaseBuffer();

	if (dwResult != NULL)
	{
		strExeName = strModuleFilename.Mid(strModuleFilename.ReverseFind('\\') + 1);
	}

	return strExeName;
}

void CHtmlWindowDlg::LoadSettings()
{
	if(m_strTitle.IsEmpty())
		return;

	int nWindowLeft = AfxGetApp()->GetProfileInt(m_strTitle, _T("WindowLeft"), -1);
	int nWindowTop = AfxGetApp()->GetProfileInt(m_strTitle, _T("WindowTop"), -1);
	int nWindowWidth = AfxGetApp()->GetProfileInt(m_strTitle, _T("WindowWidth"), -1);
	int nWindowHeight = AfxGetApp()->GetProfileInt(m_strTitle, _T("WindowHeight"), -1);

	if(nWindowLeft != -1 && nWindowTop != -1 && nWindowWidth != -1 && nWindowHeight != -1)
	{
		SetWindowPos(NULL, nWindowLeft, nWindowTop, nWindowWidth, nWindowHeight, SWP_SHOWWINDOW);
	}

	if (m_nZoomLevel == 0)
	{
		m_nZoomLevel = AfxGetApp()->GetProfileInt(m_strTitle, _T("ZoomLevel"), 0);
	}
}

void CHtmlWindowDlg::StoreSettings()
{
	if(m_strTitle.IsEmpty())
		return;

	CRect rcWindowRect;
	GetWindowRect(rcWindowRect);

	AfxGetApp()->WriteProfileInt(m_strTitle, _T("WindowLeft"), rcWindowRect.left);
	AfxGetApp()->WriteProfileInt(m_strTitle, _T("WindowTop"), rcWindowRect.top);
	AfxGetApp()->WriteProfileInt(m_strTitle, _T("WindowWidth"), rcWindowRect.Width());
	AfxGetApp()->WriteProfileInt(m_strTitle, _T("WindowHeight"), rcWindowRect.Height());

	CComVariant vZoomLevel;
	m_pBrowserApp->ExecWB(OLECMDID_OPTICAL_ZOOM, OLECMDEXECOPT_DODEFAULT, NULL, &vZoomLevel);

	AfxGetApp()->WriteProfileInt(m_strTitle, _T("ZoomLevel"), vZoomLevel.intVal);
}

void CHtmlWindowDlg::SetSettingsTimer()
{
	m_nSettingsTimerID = SetTimer(SETTINGS_TIMER_ID, 1000, NULL);
}

void CHtmlWindowDlg::KillSettingsTimer()
{
	if (m_nSettingsTimerID != 0)
	{
		KillTimer(m_nSettingsTimerID);
		m_nSettingsTimerID = 0;
	}
}

void CHtmlWindowDlg::SetRefreshTimer()
{
	if (m_nRefreshSec > 0)
	{
		m_nRefreshTimerID = SetTimer(REFRESH_TIMER_ID, m_nRefreshSec * 1000, NULL);
	}
}

void CHtmlWindowDlg::KillRefreshTimer()
{
	if (m_nRefreshTimerID != 0)
	{
		KillTimer(m_nRefreshTimerID);
		m_nRefreshTimerID = 0;
	}
}

