////////////////////////////////////////////////////////////////////////////////
//
// gallery.js - JavaScripts zur Verwendung in den HTML-Templates des
// Perl-Scripts "AutoGallery" (Originalname: autogallery.pl).
//
// (c) 2011-2012 by Stefan Bion
// http://www.StefanBion.de
//
////////////////////////////////////////////////////////////////////////////////

// Farben fr Rahmen der Vorschaubilder

var strImageFrameColorCheckedVoted = '#40FF40';	// ausgewhlt, bewertet
var strImageFrameColorChecked = '#4040FF';		// ausgewhlt, nicht bewertet
var strImageFrameColorVoted = '#FFFF80';		// nicht ausgewhlt, bewertet
var strImageFrameColor = '#FFFFFF';				// nicht ausgewhlt, nicht bewertet

////////////////////////////////////////////////////////////////////////////////
// Diese Funktion wird nach dem Laden der Seite einmalig aufgerufen:
////////////////////////////////////////////////////////////////////////////////

function Initialize()
{
	UpdateButtonLabels();
}

////////////////////////////////////////////////////////////////////////////////
// Diese Funktion wird nach Bettigen des Buttons "Seite aktualisieren"
// aufgerufen:
////////////////////////////////////////////////////////////////////////////////

function ReloadPage()
{
	if(parent.frames['content'])
	{
		parent.frames['content'].location.reload();
	}
	else
	{
		location.reload();
	}
}

////////////////////////////////////////////////////////////////////////////////
// Funktionen zur Anzeige der Bilder in Originalgre beim Anklicken:
////////////////////////////////////////////////////////////////////////////////

function ShowImage(strUrl, e)
{
	document.getElementById('PopupImage').src = strUrl;
	document.getElementById('ImagePopup').style.display = 'block';	// MSIE: width & height werden erst gesetzt, wenn Element sichtbar

	var nImageWidth = document.getElementById('PopupImage').offsetWidth;
	var nImageHeight = document.getElementById('PopupImage').offsetHeight;

	var nMouseX = e.clientX;
	var nMouseY = e.clientY;

	var nPopupLeft = nMouseX - nImageWidth / 2;
	var nPopupTop = nMouseY - nImageHeight / 2;

	var nClientWidth = document.documentElement.clientWidth;
	var nClientHeight = document.documentElement.clientHeight;

	var nMaxX = nClientWidth - nImageWidth;
	var nMaxY = nClientHeight - nImageHeight;

	if(nPopupLeft < 0) nPopupLeft = 0;
	if(nPopupLeft > nMaxX) nPopupLeft = nMaxX;
	if(nPopupTop < 0) nPopupTop = 0;
	if(nPopupTop > nMaxY) nPopupTop = nMaxY;

	document.getElementById('ImagePopup').style.left = nPopupLeft + 'px';
	document.getElementById('ImagePopup').style.top = nPopupTop + 'px';
	document.getElementById('ImagePopup').style.width = nImageWidth + 'px';
	document.getElementById('ImagePopup').style.height = nImageHeight + 'px';
}

function HideImage()
{
	document.getElementById('ImagePopup').style.display = 'none';
}

////////////////////////////////////////////////////////////////////////////////
// Funktionen im Zusammenhang mit den Bildmarkierungen (Checkboxen):
////////////////////////////////////////////////////////////////////////////////

function UpdateButtonLabels()
{
	var nCheckedCount = 0;

	var arrCheckboxes = GetInputElementsByName("image");

	// Anzahl der markierten Bilder ermitteln
	for(var nIndex = 0; nIndex < arrCheckboxes.length; nIndex++)
	{
		// IDs der Bild-Elemente ermitteln
		var strChechboxId = arrCheckboxes[nIndex].id;
		var strImageId = strChechboxId.replace(/^checkbox-/, "image-");
		var strVotesId = strChechboxId.replace(/^checkbox-/, "votes-");

		// Bild bewertet?
		var bVoted = (document.getElementById(strVotesId).innerHTML != '0')

		if(arrCheckboxes[nIndex].checked)
		{
			nCheckedCount++;

			// Bild-Rahmenfarbe fr ausgewhltes Bild
			document.getElementById(strImageId).style.backgroundColor = bVoted ? strImageFrameColorCheckedVoted : strImageFrameColorChecked;
		}
		else
		{
			document.getElementById(strImageId).style.backgroundColor = bVoted ? strImageFrameColorVoted : strImageFrameColor;
		}
	}

	// Lschen-Button aktualisieren
	var arrDeleteButtons = GetInputElementsByName("delete");
	for(var nIndex = 0; nIndex < arrDeleteButtons.length; nIndex++)
	{
		arrDeleteButtons[nIndex].value = nCheckedCount + " markierte Bilder lschen";
		arrDeleteButtons[nIndex].disabled = (nCheckedCount <= 0);
	}

	// Abstimmen-Button aktualisieren
	var arrVoteButtons = GetInputElementsByName("vote");
	for(var nIndex = 0; nIndex < arrVoteButtons.length; nIndex++)
	{
		arrVoteButtons[nIndex].value = "Fr " + nCheckedCount + " markierte Bilder stimmen";
		arrVoteButtons[nIndex].disabled = (nCheckedCount <= 0);
	}
}

function CanDelete()
{
	var nCheckedVotedCount = 0;

	var arrCheckboxes = GetInputElementsByName("image");

	// Anzahl der markierten bewerteten Bilder ermitteln
	for(var nIndex = 0; nIndex < arrCheckboxes.length; nIndex++)
	{
		if(arrCheckboxes[nIndex].checked)
		{
			// IDs der Bild-Elemente ermitteln
			var strChechboxId = arrCheckboxes[nIndex].id;
			var strVotesId = strChechboxId.replace(/^checkbox-/, "votes-");

			// Bild bewertet?
			if(document.getElementById(strVotesId).innerHTML != '0')
			{
				nCheckedVotedCount++;
			}
		}
	}

	if(nCheckedVotedCount > 0)
	{
		return confirm("Achtung: " + nCheckedVotedCount + " der markierten Bilder sind bewertet worden!\nSollen wirklich alle markierten Bilder gelscht werden?");
	}
	else
	{
		return true;
	}
}

function MarkAllImages(bNewCheckState)
{
	var arrCheckboxes = GetInputElementsByName("image");

	for(var nIndex = 0; nIndex < arrCheckboxes.length; nIndex++)
	{
		arrCheckboxes[nIndex].checked = bNewCheckState;
	}

	UpdateButtonLabels();
}

function MarkAllVotedImages(bMustBeVoted, bNewCheckState)
{
	var arrCheckboxes = GetInputElementsByName("image");

	for(var nIndex = 0; nIndex < arrCheckboxes.length; nIndex++)
	{
		// IDs der Bild-Elemente ermitteln
		var strChechboxId = arrCheckboxes[nIndex].id;
		var strVotesId = strChechboxId.replace(/^checkbox-/, "votes-");

		// Bild bewertet?
		var bIsVoted = (document.getElementById(strVotesId).innerHTML != '0');

		if(bIsVoted == bMustBeVoted)
		{
			arrCheckboxes[nIndex].checked = bNewCheckState;
		}
	}

	UpdateButtonLabels();
}

// Funktionen zur Behandlung der Checkbox-Events

var nLastImageNumber = 0;
var bLastCheckState = false;

function ChangeImageSelection(input, e)
{
	var arrCheckboxes = GetInputElementsByName("image");

	var nImageNumberOffset = arrCheckboxes[0].value.split("|")[0];
	var nImageNumber = input.value.split("|")[0];
	var bCheckState = input.checked;
	var bShiftKeyPressed = e.shiftKey;

	// String-Variable in numerische Variable umwandeln
	nImageNumberOffset *= 1;
	nImageNumber *= 1;

	if(bShiftKeyPressed && nLastImageNumber != 0 && nImageNumber != nLastImageNumber)
	{
		var nStartIndex = nLastImageNumber - nImageNumberOffset;
		var nEndIndex = nImageNumber - nImageNumberOffset;

		if(nImageNumber < nLastImageNumber)
		{
			nStartIndex = nImageNumber - nImageNumberOffset;
			nEndIndex = nLastImageNumber - nImageNumberOffset;
		}

		for(var nIndex = nStartIndex; nIndex <= nEndIndex; nIndex++)
		{
			arrCheckboxes[nIndex].checked = bLastCheckState;
		}

		nLastImageNumber = nImageNumber;
	}
	else
	{
		nLastImageNumber = nImageNumber;
		bLastCheckState = bCheckState;
	}

	UpdateButtonLabels();
}

function GetInputElementsByName(strInputName)
{
	var arrResult = new Array();

	var arrInputElements = document.galleryform.getElementsByTagName("input");

	for(var nIndex = 0; nIndex < arrInputElements.length; nIndex++)
	{
		if(arrInputElements[nIndex].name == strInputName)
		{
			arrResult.push(arrInputElements[nIndex]);
		}
	}

	return arrResult;
}

