                   .model medium
                   .code

;--------------------------------------------------------------------------
; DX:CX:BX:AX = DX:CX:BX:AX >> DI (16<DI<31, Vorzeichen wird bercksichtigt)
;--------------------------------------------------------------------------
LSHR               proc near

                   push si
                   push di
                   push bp

                   xchg cx,di
                   sub cl,16
                   mov ch,cl
                   neg ch
                   add ch,16

                   mov ax,bx
                   mov bx,di
                   mov di,dx

                   xchg ax,di
                   cwd
                   xchg ax,di

                   mov bp,bx
                   shr ax,cl
                   xchg cl,ch
                   shl bx,cl
                   xchg cl,ch

                   or ax,bx
                   mov bx,bp
                   mov bp,di
                   shr bx,cl
                   sar di,cl

                   xchg cl,ch
                   shl bp,cl
                   xchg cl,ch
                   or bx,bp
                   mov cx,di

                   pop bp
                   pop di
                   pop si
                   ret

LSHR               endp

;--------------------------------------------------------------------------
; DX:CX:BX:AX = DX:AX * CX:BX (Vorzeichen werden bercksichtigt)
;--------------------------------------------------------------------------
LMUL               proc near

                   push    si               ; Register sichern
                   push    di
                   push    bp

                   xor si,si                ; Vorzeichen := 0

                   or dx,dx                 ; DX:AX negativ ?
                   jnl LMUL0
                   not dx                   ; Ja: DX:AX negieren und
                   neg ax
                   xor si,8000h             ; Vorzeichen umdrehen.

LMUL0:             or cx,cx                 ; CX:BX negativ ?
                   jnl LMUL1
                   not cx                   ; Ja: CX:BX negieren und
                   neg bx
                   xor si,8000h             ; Vorzeichen umdrehen.

LMUL1:             push si                  ; Vorzeichen merken.

                   mov     di,dx
                   mov     si,ax
                   mul     bx               ; Low x Low
                   xchg    ax,si            
                   mov     bp,dx            ; Produkt in BP:SI
                   mul     cx               ; Low x High
                   add     bp,ax            
                   mov     ax,di            
                   xchg    cx,dx            
                   adc     cx,0             ; Produkt in CX:BP:SI
                   mul     dx               ; High x High
                   add     cx,ax            
                   mov     ax,di            
                   mov     di,dx            
                   adc     di,0             ; Produkt in DI:CX:BP:SI
                   mul     bx               ; High x Low
                   mov     bx,bp            
                   add     bx,ax            
                   adc     cx,dx            
                   mov     dx,0             
                   adc     dx,di
                   mov     ax,si            ; Produkt in DX:CX:BX:AX

                   pop si                   ; Vorzeichen holen.
                   or si,si                 ; Negativ ?
                   jnl LMUL2                ; Nein: Weiter...
                   not dx                   ; Ja: Ergebnis negieren
                   not cx
                   not bx
                   neg ax

LMUL2:             pop     bp
                   pop     di
                   pop     si
                   ret

LMUL               endp

;--------------------------------------------------------------------------
;
;--------------------------------------------------------------------------
                   public  _mulfix
_mulfix            proc

                   arg     a_lo:word, a_hi:word, b_lo:word, b_hi:word, c:word

                   push    bp
                   mov     bp,sp
                   push    di

                   mov     ax,a_lo
                   mov     dx,a_hi
                   mov     bx,b_lo
                   mov     cx,b_hi
                   call    near ptr LMUL
                   push    dx               ; Vorzeichen merken (Bit 15 von DX)
                   mov     di,c
                   call    near ptr LSHR
                   pop     dx
                   and     dx,8000h
                   or      bx,dx
                   mov     dx,bx

                   pop     di
                   mov     sp,bp
                   pop     bp
                   ret

_mulfix            endp

;--------------------------------------------------------------------------
                   end

;--------------------------------------------------------------------------
