/***********************************************************************/
/* WINDOW.H                                                            */
/*---------------------------------------------------------------------*/
/* HEADER-Datei zum Modul WINDOW.H aus der DATA-BECKER-C-TOOLBOX       */
/*---------------------------------------------------------------------*/
/* Autor: Michael Maier                                                */
/*---------------------------------------------------------------------*/
/*     (C) 1989/90 by Michael Maier u. DATA BECKER GmbH Dsseldorf     */
/***********************************************************************/

#define ZENTRIERT       1                    /* Lage des Fenstertitels */
#define LINKS           0
#define RECHTS          2


typedef struct {

        BYTE bSpalte,          /* Spalte der linken oberen Fensterecke */
             bZeile,          /* Spalte der rechten oberen Fensterecke */
		   bBreite,                                 /* Fensterbreite */
             bLaenge;                                  /* Fensterhoehe */
        BYTE bStart,                             /* Startscanzeile und */
             bStop;                       /* Stopscanzeile des Cursors */
        PSTR pstrInfozeile;       /* Zeiger auf den Text der Infozeile */
        WORD wRahmenart : 2;                 /* Rahmenart des Fensters */
        WORD wSchatten  : 1;        /* 0 => Schatten aus   1 => S. ein */
        WORD wCenter    : 3;  /* Lage des Titels: Links, Mitte, Rechts */
        WORD wArrowUp   : 1;          /* Scrollpfeil nach oben ein/aus */
        WORD wArrowDown : 1;         /* Scrollpfeil nach unten ein/aus */

                } FKB;                         /* FensterKontrollBlock */

typedef struct {

        WORD wColTitel,                     /* Farbe des Fenstertitels */
             wColRahmen,                                /* Rahmenfarbe */
             wColBackground,         /* Farbe des Fensterhintergrundes */
             wColHervorhebung,             /* Farbe fr Hervorhebungen */
             wColArrows;                     /* Farbe der Scrollpfeile */

                } FRAMECOLOR;

typedef FKB* PFKB;            /* Zeiger auf einen Fensterkontrollblock */


extern FRAMECOLOR aFCol_g[];

PFKB FrmInit(PFKB pfkbFrame, BYTE bSpalte, BYTE bZeile, BYTE bBreite,
             BYTE bLaenge, PSTR pstrInfo);
VOID FrmSetRahmen(PFKB pfkbFrame, WORD wRahmenart);
VOID FrmSetInfo(PFKB pfkbFrame, WORD wLage);
VOID FrmSetSchatten(PFKB pfkbFrame, WORD wSchattenStatus);
VOID FrmShow(PFKB pfkbFrame);
VOID FrmClrscr(PFKB pfkbFrame);
VOID FrmScrollUp(PFKB pfkbFrame, BYTE bZeilen);
VOID FrmScrollDown(PFKB pfkbFrame, BYTE bZeilen);
VOID FrmSetCrsr(PFKB pfkbFrame, BYTE bZeile, BYTE bSpalte);
BYTE FrmGetCrsr(PFKB pfkbFrame, BYTE *pbZeile, BYTE *pbSpalte,
                BYTE *pbStart, BYTE *pbStop);
VOID FrmSetCrsrForm(BYTE bStart, BYTE bEnd);
VOID FrmCrsrOn(PFKB pfkbFrame);
VOID FrmCrsrOff(PFKB pfkbFrame);
VOID FrmInfo(BYTE bSpalte, BYTE bZeile, PSTR pstrText, BYTE bStatus);
VOID FrmBackground(PFKB pfkbFrame, BYTE bColor);
VOID FrmPrint(PFKB pfkbFrame, BYTE bZeile, BYTE bSpalte, PSTR pstrString);
VOID FrmWca(PFKB pfkbFrame, BYTE bZeile, BYTE bSpalte, BYTE bZeichen,
            BYTE bFarbe);
VOID FrmWa(PFKB pfkbFrame, BYTE bZeile, BYTE bSpalte, BYTE bFarbe);
BYTE FrmRa(PFKB pfkbFrame, BYTE bZeile, BYTE bSpalte);
CHAR FrmRc(PFKB pfkbFrame, BYTE bZeile, BYTE bSpalte);
VOID FrmRca(PFKB pfkbFrame, BYTE bZeile, BYTE bSpalte,
                  BYTE *pbZeichen, BYTE *pbFarbe);
VOID FrmArrowUpOn(PFKB pfkbFrame);
VOID FrmArrowDownOn(PFKB pfkbFrame);
VOID FrmArrowUpOff(PFKB pfkbFrame);
VOID FrmArrowDownOff(PFKB pfkbFrame);
BYTE FrmPush(PFKB pfkbFrame);
VOID FrmPull(PFKB pfkbFrame);
VOID FrmLoeschen(PFKB pfkbFrame);

#define DBCT_WINDOW  1

