/***********************************************************************/
/* MENU.H                                                              */
/*---------------------------------------------------------------------*/
/* HEADER-Datei zum Modul MENU.C aus der DATA-BECKER-C-TOOLBOX         */
/*---------------------------------------------------------------------*/
/* Autor: Michael Maier                                                */
/*---------------------------------------------------------------------*/
/*     (C) 1989/90 by Michael Maier u. DATA BECKER GmbH Dsseldorf     */
/***********************************************************************/

#define MONOSCREEN              1           /* Konstante fr MONOCHROM */
#define COLORSCREEN             0
#define ERROR                   0
#define HOTKEY                  '#'                          /* HOTKEY */

#define MNU_TRENNER             { "---", NULL }     /* Menu-Trennlinie */ 
#define MNU_END                 { NULL,  NULL }     /* Ende ITEM-Array */


typedef struct {

        PSTR pstrItemText,                /* Zeiger auf den Item-Text */
             pstrHilfszeile;                 /* Zeiger auf Hilfszeile */

                } ITEM;                              /* Item-Struktur */

typedef ITEM * PITEM;                     /* Zeiger auf Item-Struktur */

typedef struct {

        WORD wColMnuZeile,                      /* Farbe der Menuzeile */
             wColMnuAuswahl,           /* Farbe ausgewhlter Menutitel */
             wColMnuHotkey,                /* Farbe Menleisten-Hotkey */
             wColMnuHilfszeile;                /* Farbe der Hilfszeile */

        WORD wColFrmItems,                                                   /* Farbe Items */
             wColFrmInaktiv,            /* Farbe eines inaktiven Items */
             wColFrmCrsrItem,        /* Auswahlbalken auf aktivem Item */
             wColFrmCrsrInaktiv,             /* ... auf inaktivem Item */
             wColFrmHotkey;                          /* Hotkey im Item */

        WORD wColWorkArea;               /* Farbe des Arbeitsbereiches */

                } MENUCOLOR;

extern MENUCOLOR aMCol_g[];

void MenuTitle(PITEM psiLeiste);
void MnuItem(PITEM psiItems);
WORD MnuControl(void);
void MnuSchatten(WORD wShadow);
void MnuSetMarker(WORD wNum);
WORD MnuGetMarker(WORD wItem);
void MnuKillMarker(WORD wNum);
void MnuChangeMarker(WORD wNum);
void MnuEnable(WORD wNum);
void MnuDisable(WORD wNum);
WORD MnuNewItemText(WORD wNum, PSTR pstrItemText);


#define DBCT_MENU   1

