/*********************************************************************/
/* Dateiname: DVRAMIO.H (Direct VideoRAM Input/Output)			    */
/*-------------------------------------------------------------------*/
/* Autor: Michael Maier							14.09.1989/V1 */
/* ------------------------------------------------------------------*/
/* In dieser HEADER-Datei sind smtliche DEFINES und Konstanten ent- */
/* halten, die fr die Arbeit des Moduls DVRAMIO.C ntig sind, sowie */
/* die verschiedenen Farben als Konstanten definiert.			    */
/*===================================================================*/
/* 			Copyright (C) 1989 by MAGUS-Soft Ingolstadt		    */
/*********************************************************************/

/*     Zuerst einmal die Farb-Attribute fr eine monochrome Karte    */

#define NORMAL			0x07				   /* Normaldarstellung */
#define INVERS      	0x70
#define MATT_INVERS 	0x78
#define UNTERSTRICHEN   	0x01
#define HELL			0x0f
#define HELL_UNTER		0x09
#define BLINKEN		0x80

/*				Farb-Attribute fr Color-Karten				*/

#define SCHWARZ		0x00
#define BLAU			0x01
#define GRUEN			0x02
#define KOBALT			0x03
#define ROT			0x04
#define VIOLETT		0x05
#define BRAUN			0x06
#define HELLGRAU		0x07
#define DUNKELGRAU		0x08
#define HELLBLAU		0x09
#define HELLGRUEN		0x0a
#define HELLKOBALT		0x0b
#define HELLROT		0x0c
#define HELLVIOLETT		0x0d
#define GELB			0x0e
#define WEISS			0x0f

/*    Segmentadressen des Videoram bei Monochrom- bzw. Color-Karten   */

#define MONO			0xb000
#define COLOR			0xb800

/* 			Zeiger auf Variablen aus dem BIOS-Segment 			*/

#define CRT_START ((unsigned far*) MK_FP(0x40, 0x4e))
#define ADDR_6845 ((unsigned far*) MK_FP(0x40, 0x63))

/*			Attribut des Zeichens, sowie der Hintergrundfarbe 	*/

#define FARBE(vorne,hinten) ((hinten << 3) + vorne)