/***********************************************************************/
/* DVRAMIO.H                                                           */
/*---------------------------------------------------------------------*/
/* HEADER-Datei zum Modul DVRAMIO.C aus der DATA-BECKER-C-TOOLBOX      */
/*---------------------------------------------------------------------*/
/* Autor: Michael Maier                                                */
/*---------------------------------------------------------------------*/
/*     (C) 1989/90 by Michael Maier u. DATA BECKER GmbH Dsseldorf     */
/***********************************************************************/

/*      Zuerst einmal die Farb-Attribute fr eine monochrome Karte     */

#define NORMAL          0x07                      /* Normaldarstellung */
#define INVERS          0x70
#define MATT_INVERS     0x78
#define UNTERSTRICHEN   0x01
#define HELL            0x0f
#define HELL_UNTER      0x09
#define BLINKEN         0x80

/*                Farb-Attribute fr Color-Karten                      */

#define SCHWARZ         0x00
#define BLAU            0x01
#define GRUEN           0x02
#define KOBALT          0x03
#define ROT             0x04
#define VIOLETT         0x05
#define BRAUN           0x06
#define HELLGRAU        0x07
#define DUNKELGRAU      0x08
#define HELLBLAU        0x09
#define HELLGRUEN       0x0a
#define HELLKOBALT      0x0b
#define HELLROT         0x0c
#define HELLVIOLETT     0x0d
#define GELB            0x0e
#define WEISS           0x0f


extern WORD wGrafikCard_g;      	 /* Grafikkarte: 1=>MONO 0=>FARBE */

void dvio_init(void);
void dviowca(BYTE bSpalte, BYTE bZeile, char cZeichen, BYTE bFarbe);
void dviowsa(BYTE bSpalte, BYTE bZeile, char* psString, BYTE bFarbe);
void dviowa(BYTE bSpalte, BYTE bZeile, BYTE bFarbe);
void dviows(BYTE bSpalte, BYTE bZeile, char* psString);
void dviorca(BYTE bSpalte, BYTE bZeile, BYTE *pbZeichen, BYTE *pbFarbe);
void dviorc(BYTE bSpalte, BYTE bZeile, BYTE *pbZeichen);
void dviora(BYTE bSpalte, BYTE bZeile, BYTE *pbFarbe);
void dviorlin(BYTE bZeile, char* psString);
void dviowlin(BYTE bZeile, char* psString);
void dviorwin(BYTE bSpalte, BYTE bZeile, BYTE bBreite, BYTE bLaenge,
              BYTE *pbBuffer);
void dviowwin(BYTE abBuffer[]);
void dvio_cllin(BYTE bZeile, BYTE bFarbe);
void dvio_cls(BYTE bFarbe);
void UtlGetViomode(int *piModus, int *piAnzahl, int *piSeite);

#define DBCT_DVRAMIO  1


