/***********************************************************************/
/* CUTL.H                                                              */
/*---------------------------------------------------------------------*/
/* HEADER-Datei zum Modul CUTL.C aus der DATA-BECKER-C-TOOLBOX         */
/*---------------------------------------------------------------------*/
/* Autor: Michael Maier                                                */
/*---------------------------------------------------------------------*/
/*     (C) 1989/90 by Michael Maier u. DATA BECKER GmbH Dsseldorf     */
/***********************************************************************/


#define ALTCODE         256      /* erweiterter Code fuer Sondertasten */
#define TRUE            1                   /* Englisch ist modern ... */
#define FALSE           0

#define MIN(x,y)        (((x) < (y)) ? (x) : (x))   /* Minimum von x,y */
#define MAX(x,y)        (((x) > (y)) ? (x) : (y))   /* Maximum von x,y */

#define TASTEN_EVENT    1           /* Ereignis: Taste wurde gedrueckt */
#define ALT_P_EVENT     2                 /* ALT-Taste wurde gedrueckt */
#define ALT_R_EVENT     3               /* ALT-Taste wurde losgelassen */
#define MAUS_EVENT      4                         /* Maus wurde gewegt */
#define BUTTON_P_EVENT  5         /* linker Mausbutton wurde gedrueckt */
#define BUTTON_R_EVENT  6                    /* und wieder losgelassen */

#define CRSR_LEFT       331          /* einige Codes fuer Sondertasten */
#define CRSR_RIGHT      333
#define HOME            327
#define END             335
#define DELETE          339
#define INSERT          338
#define BACKSPACE       8
#define CNTRL_Y         25
#define CNTRL_U         21
#define CNTRL_LEFT      371
#define CNTRL_RIGHT     372


typedef unsigned int    WORD;                /* die TOOLBOX-Datentypen */
typedef unsigned char   BYTE;
typedef void            VOID;
typedef unsigned long   LONG;
typedef char *          PSTR;
typedef unsigned char   BOOL;
typedef int             SINT;
typedef char            CHAR;


typedef struct {                  

                BYTE bReserved[21];             /* fuer DOS reserviert */
                BYTE bAttrib;             /* Art der Datei: ORDNER,... */
                WORD wTime;        /* Uhrzeit und Datum der Erstellung */
                WORD wDate;
                LONG lFilesize;                   /* Groesse der Datei */
                char acFilename[13];                 /* Name der Datei */

                } DTA;      /* Disk-Transfer-Adress fr UtlGetFirst... */


extern BOOL boDoBreak_g;                /* keine Mausunterbrechung der */
                                             /* INPUT-Routine zulassen */


WORD UtlAsciiToAlt(WORD wAltCode);
VOID UtlSetCrsr(BYTE bSpalte, BYTE bZeile);
WORD UtlGetKey(VOID);
WORD UtlBounds(WORD wMin, WORD wMax, WORD wWert);
int  UtlAntiBounds(int iMin, int iMax, int iWert);
WORD UtlBioskey(VOID);
LONG UtlBiostime(VOID);
WORD UtlToupper(WORD wKey);
WORD UtlTolower(WORD wKey);
WORD UtlGetDisk(VOID);
VOID UtlSetDisk(WORD wDrive);
BYTE UtlGetFirst(PSTR pstrPath, WORD wAttribut);
BYTE UtlGetNext(VOID);
VOID UtlSetDta(WORD wOffset);
WORD UtlLprint(PSTR pstrString, BOOL boEpson);
WORD UtlPrinterInit(WORD wDrucker);
BYTE UtlFileExist(PSTR pstrFilename);
BOOL UtlProofPath(PSTR pstrPath);
int  UtlDiskParameter(PSTR pstrPath, PSTR pstrName);
WORD UtlInput(PSTR pstrInput, WORD wCol, WORD wLin, WORD wLen, WORD wBox,
              BOOL boKill, PSTR pstrChars, WORD wReturn[]);
VOID UtlGetCrsrForm(BYTE *pbStart, BYTE *pbStop);

#define DBCT_CUTL     1


