/**********************************************************************/
/*                                                                    */
/*             F r a k t a l g e n e r a t o r:                       */
/*                                                                    */
/**********************************************************************/
#include <stdio.h>
#include <conio.h>
#include <bios.h>
#include <stdlib.h>
#include <toolbox.h>
#include <grafik.h>

/**********************************************************************/
/* Variablen der Toolbox:                                             */
/**********************************************************************/

ITEM Menuleiste[]=
{
  { "#Datei ", "Funktionen zur Dateibearbeitung" },
  { "#Bearbeiten ", "Funktionen zum Erstellen von Mandelbrot-Grafiken" },
  MNU_END,
};

ITEM Datei[]=
{
  { "Datei #laden ", "Ldt eine Grafikdatei von Platte" },
  { "Datei #speichern ", "Speichert eine Grafikdatei auf Platte" },
  MNU_TRENNER,
  { "#DOS-Kommandoebene ", "Kehrt vorbergehend zum DOS zurck" },
  { "Programm#ende ", "Programm beenden" },
  MNU_END,
};

ITEM Bearbeiten[]=
{
  { "#Eingeben ", "Eingabe der Koordinaten fr die Mandelbrotmenge" },
  MNU_TRENNER,
  { "#Testen ", "Erstellt eine Testgrafik mit Blockgrafikzeichen" },
  { "#Zeichnen ", "Zeichnet die Mandelbrotmenge mit den eingegebenen Koordinaten" },
  MNU_END
};

/**********************************************************************/
/* Variablen des Programms:                                           */
/**********************************************************************/

char buffer[640];
unsigned int nmax=50, vmode=VGA320X200;
double rmin=-2.0, rmax=1.2, imin=-1.2, imax=1.2;
long amin, amax, bmin, bmax;
long astep, bstep, apart, bpart, astart, bstart;

FILE *fp;

/**********************************************************************/
/* Externe Assembler-Routine zum Multiplizieren zweier Fixpunktzahlen */
/* a und b. Die Anzahl der fr die Nachkommastellen relevanten Bits   */
/* wird in c bergeben.                                               */
/**********************************************************************/
extern long mulfix(long a, long b, int c);

/**********************************************************************/
/* Errechnet aus Real- und Imaginrteil die Anzahl der Iterationen:   */
/**********************************************************************/
unsigned int iterate(long a, long b)
{
  unsigned int n=0;
  long x=0, y=0, x2=0, y2=0;

  do
  {
    y=mulfix(x,y,24)+b;                /* y = 2*x*y+b */
    x=x2-y2+a;                             /* x = x*x-y*y+a */
    x2=mulfix(x,x,25), y2=mulfix(y,y,25);
    n++;
  }
  while(x2+y2<=134217728 && n<nmax);   /* 4 * 2^25 */
  return(n);
}

/**********************************************************************/
/* Rekursive Funktion: Berechnet einen quadratischen Ausschnitt       */
/**********************************************************************/
void berechne(int x1, int x2, int y1, int y2, int wert)
{
  int a, b, c, d, h;
  long a1, a2, b1, b2;

  if(x1==x2)
  {
    putpixel(x1, y1, wert%maxc);
  }
  else
  {
    a1=amin+x1*astep;
    a2=amin+x2*astep;
    b1=bmin+y1*bstep;
    b2=bmin+y2*bstep;
    a=iterate(a1, b1);
    b=iterate(a2, b1);
    c=iterate(a1, b2);
    d=iterate(a2, b2);

    if(a==b && a==c && a==d)
    {
      fillrect(x1, x2, y1, y2, a%maxc);
    }
    else
    {
      h=((x2-x1+1)>>1)-1;
      berechne(x1, x1+h, y1, y1+h, a);
      berechne(x2-h, x2, y1, y1+h, b);
      berechne(x1, x1+h, y2-h, y2, c);
      berechne(x2-h, x2, y2-h, y2, d);
    }
  }
}

/**********************************************************************/
/* Zeichnet die Mandelbrotmenge mit den eingegebenen Werten:          */
/**********************************************************************/
void zeichne(void)
{
  int x, y, xq, yq, xx, yy;

  setvidmode(vmode);

  amin=rmin*33554432;
  amax=rmax*33554432;
  bmin=imin*33554432;
  bmax=imax*33554432;

  xq=maxx>>6, yq=maxy>>6;   /* Anzahl 64x64-Pixel-Quadrate */
  astep=(amax-amin)/maxx;
  bstep=(bmax-bmin)/maxy;

  for(yy=0; yy<yq; yy++)
  {
    for(xx=0; xx<xq && bioskey(1)==0; xx++)
    {
      berechne(xx<<6, ((xx+1)<<6)-1, yy<<6, ((yy+1)<<6)-1, 0);
    }
  }

  if(maxy==200)
  {
    xq=maxx>>3;
    for(xx=0; xx<xq && bioskey(1)==0; xx++)
    {
      berechne(xx<<3, ((xx+1)<<3)-1, 192, 199, 0);
    }
  }

  fp=fopen("fraktmp.dat","w+b");
  buffer[0]=vmode;
  fwrite(buffer,1,1,fp);

  for(y=0; y<maxy; y++)
  {
    for(x=0; x<maxx; x++) buffer[x]=getpixel(x,y);
    fwrite(buffer,1,maxx,fp);
  }
  fclose(fp);
  getch();
  setvidmode(TEXT80X25);
}

/*************************************************************************/
/* Erstellt eine Testgrafik mit Blockgrafikzeichen                       */
/*************************************************************************/
void teste()
{
  int x, y;
  long a, b;

  amin=rmin*33554432;
  amax=rmax*33554432;
  bmin=imin*33554432;
  bmax=imax*33554432;

  astep=(amax-amin)/maxx;
  bstep=(bmax-bmin)/maxy;

  for(x=0; x<maxx && bioskey(1)==0; x++)
  {
    a=amin+x*astep;
    for(y=1; y<maxy; y++)
    {
      b=bmin+y*bstep;
      putpixel(x, y, iterate(a,b)%maxc);
    }
  }
}

/**********************************************************************/
/* Ldt eine Grafikdatei und zeigt sie auf dem Bildschirm an:         */
/**********************************************************************/
showfile(char *file)
{
  int x, y;

  if((fp=fopen(file,"rb"))!=NULL)
  {
    fread(buffer,1,1,fp);
    setvidmode(buffer[0]);

    for(y=0; y<maxy; y++)
    {
      fread(buffer,1,maxx,fp);
      for(x=0; x<maxx; x++) putpixel(x,y,buffer[x]);
    }
    fclose(fp);
    getch();
    setvidmode(TEXT80X25);
  }
}

/**********************************************************************/
/* Hauptprogramm: Mensteuerung                                       */
/**********************************************************************/
void main(void)
{
  WORD Auswahl;
  CHAR Path[85], File[85];

  aMCol_g[0].wColMnuZeile=       0x17;            /* Farbe der Menuzeile */
  aMCol_g[0].wColMnuAuswahl=     0x5F;   /* Farbe ausgewhlter Menutitel */
  aMCol_g[0].wColMnuHotkey=      0x1E;       /* Farbe Menleisten-Hotkey */
  aMCol_g[0].wColMnuHilfszeile=  0x30;           /* Farbe der Hilfszeile */
  aMCol_g[0].wColFrmItems=       0x17;                    /* Farbe Items */
  aMCol_g[0].wColFrmInaktiv=     0x13;    /* Farbe eines inaktiven Items */
  aMCol_g[0].wColFrmCrsrItem=    0x5F; /* Auswahlbalken auf aktivem Item */
  aMCol_g[0].wColFrmCrsrInaktiv= 0x57;         /* ... auf inaktivem Item */
  aMCol_g[0].wColFrmHotkey=      0x1E;                 /* Hotkey im Item */
  aMCol_g[0].wColWorkArea=       0x70;     /* Farbe des Arbeitsbereiches */

  MausInit();
  MnuTitle(Menuleiste);
  MnuItem(Datei);
  MnuItem(Bearbeiten);
  dvio_cls(aMCol_g[0].wColWorkArea);
  MausCrsrOn();
  UtlSetCrsr(1,26);

  while((Auswahl=MnuControl())!=104)
  {
    switch(Auswahl)
    {
      case 101:
        strcpy(Path, "\0");
        strcpy(File, "*.dat");
        if(DlgLoadFile(Path, File, " Grafikdatei laden ")==13)
        {
          MausCrsrOff();
          showfile(File);
          dvio_cls(aMCol_g[0].wColWorkArea);
          MausCrsrOn();
        }
        break;

      case 102:
        strcpy(File, "\0");
        DlgSaveFile(File);
        if(rename("fraktmp.dat", File)!=0)
            DlgInfo(2, AWB_EINGABE, "Datei speichern",
            "Fehler beim Speichern der Datei ", NULL);
        break;

      case 103:
        DlgDos();
        break;

      case 202:
        MausCrsrOff();
        teste();
        MausCrsrOn();
        break;

      case 203:
        MausCrsrOff();
        zeichne();
        dvio_cls(aMCol_g[0].wColWorkArea);
        MausCrsrOn();
        break;
    }
    UtlSetCrsr(1,26);
  }
  MausCrsrOff();
  MnuReset();
  setvidmode(TEXT80X25);
}
