#include <stdio.h>      /*************************************************/
#include <stdlib.h>     /*                                               */
#include <dos.h>        /*      T E T R I S   (C) 1992 Stefan Bion       */
#include <conio.h>      /*                                               */
#include <time.h>       /*************************************************/
#include <signal.h>

extern void def_klotz(void); /* ASM-Funktion, definiert die beiden */
                             /* ASCII-Zeichen "" zu einem 3D-Klotz um */
int score, level, lines;
int next, s, r;         /* Nchste Stein-Nr, Aktuelle Stein-Nr, Rotation */
int xpos, ypos;         /* Stein-Position innerhalb des Spielfeldes */
char pname[80];         /* Name des Spielers (fr Highscore-Liste) */
char fname[80];         /* Name der Highscore-Datei */

struct highscore        /* Highscore-Liste */
{
  long score;
  char name[40];
} player[11];           /* 11 Spieler */

FILE *fp;

char field[26][16];     /* Spielfeld */
static char oldfield[26][16];

char stone[7][4][4][4]= /* Stein [Nr][y][Rotation][x] */
{
  0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
  0,0,0,0, 0,1,0,0, 0,1,0,0, 0,1,0,0,
  1,1,1,0, 0,1,1,0, 1,1,1,0, 1,1,0,0,
  0,1,0,0, 0,1,0,0, 0,0,0,0, 0,1,0,0,

  0,0,0,0, 0,1,0,0, 0,0,0,0, 0,1,0,0,
  0,0,0,0, 0,1,0,0, 0,0,0,0, 0,1,0,0,
  1,1,1,1, 0,1,0,0, 1,1,1,1, 0,1,0,0,
  0,0,0,0, 0,1,0,0, 0,0,0,0, 0,1,0,0,

  0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
  0,0,0,0, 1,0,0,0, 0,0,0,0, 1,0,0,0,
  0,1,1,0, 1,1,0,0, 0,1,1,0, 1,1,0,0,
  1,1,0,0, 0,1,0,0, 1,1,0,0, 0,1,0,0,

  0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
  0,0,0,0, 0,1,0,0, 0,0,0,0, 0,1,0,0,
  1,1,0,0, 1,1,0,0, 1,1,0,0, 1,1,0,0,
  0,1,1,0, 1,0,0,0, 0,1,1,0, 1,0,0,0,

  0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
  0,0,0,0, 0,1,0,0, 0,0,1,0, 1,1,0,0,
  1,1,1,0, 0,1,0,0, 1,1,1,0, 0,1,0,0,
  1,0,0,0, 0,1,1,0, 0,0,0,0, 0,1,0,0,

  0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
  0,0,0,0, 0,1,1,0, 1,0,0,0, 0,1,0,0,
  1,1,1,0, 0,1,0,0, 1,1,1,0, 0,1,0,0,
  0,0,1,0, 0,1,0,0, 0,0,0,0, 1,1,0,0,

  0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
  0,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,
  0,1,1,0, 0,1,1,0, 0,1,1,0, 0,1,1,0,
  0,1,1,0, 0,1,1,0, 0,1,1,0, 0,1,1,0
};

char *number[10][3]=
{
 "",
 " ",
 "",
 " ",
 "  ",
 "  ",
 "",
 "",
 "",
 "",
 "",
 "",
 " ",
 "",
 "  ",
 "",
 "",
 "",
 "",
 "",
 "",
 "",
 "  ",
 "  ",
 "",
 "",
 "",
 "",
 "",
 ""
};

void show_highscore(void)
{
  int i;

  textattr(0x17), clrscr();
  textattr(7), gotoxy(1,25), clreol();

  textattr(0x19);
  gotoxy(1,1); for(i=0; i<39; i++) cputs("");
  gotoxy(3,24); for(i=0; i<39; i++) cputs("");
  for(i=1; i<24; i++) gotoxy(79,i), cputs("");

  textattr(0x1F);
  gotoxy(32,3), cputs("Ѹ͸Ѹ͸  ͸");
  textattr(0x17), cputs("sb"), textattr(0x1F);
  gotoxy(32,4), cputs("  Ƶ   Ѿ  ͸");
  gotoxy(32,5), cputs("  ;    ;");

  textattr(0x1B), gotoxy(10,7);
  cputs(" Top Ten High Score ");

  for(i=0; i<10; i++) player[i].name[0]=0, player[i].score=0;
  if((fp=fopen(fname,"rb"))!=NULL)
  {
    fread(player,1,10*sizeof(player[0]),fp);
    fclose(fp);
  }

  textattr(0x1E);
  for(i=0; i<10; i++)
  {
    gotoxy(13,i+9), cprintf("%2d.", i+1);
    if(player[i].score) cprintf(" %-40s  %10d", player[i].name, player[i].score);
  }

  textattr(0x1B), gotoxy(10,20);
  cputs("");
}

typedef (*fcmp)(const void*, const void*);

int pcompare(int *e1, int *e2) { return(*e2-*e1); }

void write_highscore(void)
{
  strcpy(player[10].name,pname), player[10].score=score;
  qsort(&player[0], 11, sizeof(player[0]), (fcmp) pcompare);

  if((fp=fopen(fname,"w+b"))!=NULL)
  {
    fwrite(player,1,10*sizeof(player[0]),fp);
    fclose(fp);
  }
}

void print_titel(void)
{
  int i,x,y;

  textattr(0x70), clrscr();
  textattr(7), gotoxy(1,25), clreol();

  textattr(0x08);
  gotoxy(1,1); for(i=0; i<39; i++) cputs("");
  gotoxy(3,24); for(i=0; i<39; i++) cputs("");
  for(i=1; i<24; i++) gotoxy(79,i), cputs("");

  textattr(0x70);
  gotoxy(7,4),  cputs("Score");
  gotoxy(7,10), cputs("Level");
  gotoxy(7,16), cputs("Lines");
  gotoxy(63,4),cputs("Next");

  textattr(0x78); for(y=2; y<22; y++)
  gotoxy(30,y+1), cputs("                    ");
  gotoxy(30,y+1), cputs("");
}

void print_next(void)
{
  int a,x,y;

  for(y=1; y<4; y++)
  {
    gotoxy(62,y+4);
    for(x=0; x<4; x++)
    {
      if(stone[next][y][0][x]) a=next+1, textattr((a<<4)+a+8), cputs("");
      else textattr(0x70), cputs("  ");
    }
  }
}

void print_digit(int n)
{
  int i,x,y;

  x=wherex(), y=wherey(), textattr(0x7C);
  for(i=0; i<3; i++) gotoxy(x,y+i), cputs(number[n][i]);
  gotoxy(x+4,y);
}

void print_number(int n)
{
  int r=n%10, d=n/10;

  if(d) print_number(d);
  print_digit(r);
}

void drawfield(void)
{
  int a,x,y;

  for(y=3; y<23; y++)
  {
    for(x=3; x<13; x++)
    {
      if(oldfield[y][x]!=field[y][x])
      {
        gotoxy(2*x+25,y);
        a=field[y][x];
        if(a) textattr((a<<4)+a+8), cputs("");
        else textattr(0x70), cputs("  ");
        oldfield[y][x]=field[y][x];
      }
    }
  }
}

void delstone(int xp, int yp)
{
  int x,y;

  for(y=0; y<4; y++)
    for(x=0; x<4; x++)
      if(stone[s][y][r][x]) field[yp+y][xp+x]=0;
}

void putstone(int xp, int yp)
{
  int x,y,c;

  for(y=0; y<4; y++)
    for(x=0; x<4; x++)
      if(stone[s][y][r][x]) field[yp+y][xp+x]=s+1;
}

int teststone(int xp, int yp)
{
  int x,y,no=0;

  for(y=0; y<4 && !no; y++)
    for(x=0; x<4 && !no; x++)
      if(stone[s][y][r][x]) no=field[yp+y][xp+x];
  return(no);
}

void delfullines(void)
{
  int i,j,x,y,sum,y1,c;

  for(y=3; y<23; y++)
  {
    for(x=3,sum=3; x<13; x++) if(field[y][x]) sum++;
    if(sum==x)
    {
      for(i=0; i<8; i++)
      {
        for(j=3; j<13; j++) field[y][j]^=7;
        drawfield(), delay(20);
      }
      for(y1=y; y1>3; y1--) for(x=3; x<13; x++) field[y1][x]=field[y1-1][x];
      for(x=3; x<13; x++) field[y1][x]=0;
      drawfield(), gotoxy(7,18), print_number(++lines);
      if(lines%10==0 && level<10) level++;
    }
  }
}

void drawnew(void)
{
  putstone(xpos,ypos), drawfield(), delstone(xpos,ypos);
}

void init_pfield(void)
{
  int x,y;

  for(y=0; y<26; y++) for(x=0; x<16; x++) field[y][x]=1;
  for(y=0; y<23; y++) for(x=3; x<13; x++) field[y][x]=0;
}

int again(void)
{
  char c;
  int x,y;

  textattr(0x2A);
  for(y=0; y<10; y++)
    gotoxy(31,y+3), cputs(""),
    gotoxy(31,22-y),cputs(""),
    delay(50);

  textattr(0xCE), gotoxy(31,12), cputs("  G A M E  O V E R  "), getch();

  show_highscore(),gotoxy(32,22), textattr(0x1F), cputs("Play again (y/n)?");
  do c=tolower(getch()); while(c!='y'&&c!='n'); return(c=='y');
}

void get_name(void)
{
  _setcursortype(_NOCURSOR), show_highscore();
  gotoxy(15,22), textattr(0x1F), cputs("Your name: "), gotoxy(26,22);
  textattr(0x07), cputs("                                        ");
  gotoxy(26,22);
  _setcursortype(_NORMALCURSOR), gets(pname), _setcursortype(_NOCURSOR);
}

void progend(void)
{
  _setcursortype(_NORMALCURSOR);
  textattr(7), clrscr(), exit(0);
}

void main(int argc, char *argv[])
{
  int stop,s1,r1,n;

  signal(SIGINT,progend);
  strcpy(fname,argv[0]), strcpy(fname+strlen(fname)-3,"HSC");
  srand(time(NULL)), next=rand()%7;
  def_klotz(), get_name();

  do
  {
    print_titel();
    gotoxy(7,6), print_number(score=0);
    gotoxy(7,12), print_number(level=1);
    gotoxy(7,18), print_number(lines=0);
    init_pfield(), drawfield();

    do
    {
      r=0, s=next, next=rand()%7, print_next();

      if(!(stop=teststone(xpos=6, ypos=1)))
      {
        score+=24+level*2;
        while(ypos<23 && !stop)
        {
          drawnew();
          for(n=level; n<=16; n++)
          {
            if(kbhit())
            {
              switch(getch())
              {
                case 0: switch(getch()){
                case 0x4B: if(!teststone(xpos-1,ypos)) xpos--, drawnew(); break;
                case 0x4D: if(!teststone(xpos+1,ypos)) xpos++, drawnew(); break;
                case 0x50: while(!teststone(xpos,ypos+1)) ypos++; drawnew(); n=16;} break;
                case 0x20: while(!teststone(xpos,ypos+1)) ypos++; drawnew(); n=16; break;
                case 0x0D: r1=r, r++, r%=4; if(!teststone(xpos,ypos)) drawnew(); else r=r1;
              }
            }
            delay(30);
          }
          stop=teststone(xpos, ++ypos);
          score--;
        }
        putstone(xpos, ypos-1);
        gotoxy(7,6), print_number(score);
        delfullines();
        gotoxy(7,12), print_number(level);
      }
    }
    while(ypos>1);
    write_highscore();
  }
  while(again());
  progend();
}
