#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <graphics.h>

#define IOPORT 0x3BC

int g_driver, g_mode, maxx, maxy;
unsigned long bit[8];
unsigned int savebit[256];

unsigned char getport()
{
  unsigned char b;

  outportb(IOPORT+2,8);           // Strobe := H, Autofeed := H
  outportb(IOPORT+2,9);           // Strobe := L, Autofeed := H

  b=(inportb(IOPORT+1)>>3)&0x0F;  // Untere 4 Bits einlesen

  outportb(IOPORT+2,11);          // Strobe := L, Autofeed := L

  b|=(inportb(IOPORT+1)<<1)&0xF0; // Obere 4 Bits einlesen

  return(b);
}

void main(void)
{
  int i;
  unsigned long max_byte, max_bit;
  unsigned char b;
  double f;

  detectgraph(&g_driver, &g_mode);
  initgraph(&g_driver, &g_mode, "");
  maxx=getmaxx(), maxy=getmaxy();

  setviewport(0, 0, 257, 102, 1);
  setcolor(7), rectangle(0, 0, 257, 102);

  while(!kbhit())
  {
    b=getport();

    for(i=0; i<8; i++)
    {
      if(b&1) bit[i]++;
      b>>=1;
    }

    for(i=0, max_bit=0; i<8; i++) if(max_bit<bit[i]) max_bit=bit[i];

    for(i=1; i<257; i++)
    {
      putpixel(i*32+16, savebit[i], 0);
      savebit[i]=100-bit[i]*100/max_bit;
      putpixel(i*32+16, savebit[i], 2);
    }
  }
  getch(); closegraph();
}
