#ifndef __LARGE__
#  error Bitte Speichermodell LARGE benutzen!
#endif

#include <stdio.h>
#include <dos.h>
#include <alloc.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <time.h>

typedef unsigned char BYTE;
typedef unsigned int  WORD;

#define IOPORT 0x3BC

extern int getdport(void);
extern void play(BYTE *block);
extern void lplay(BYTE *block);

enum { RANDOM, EXTERN };

int SPEAKER=0;

char SEGFILE[40]="PHONEME.PHO";
char DEFFILE[40]="PHONEME.DEF";
char ASCFILE[40]="";
char PROTOFILE[40]="";

FILE *proto=NULL;

struct soundstruc
{
  BYTE *a;
  BYTE *e;
  BYTE r;
} sblock;

// Segmenttabelle:

#define MAXSEG 1024
int NSEGS;

struct segstruc
{
  long a;
  long e;
  BYTE r;
} segtab[MAXSEG];

#define MAXPHO 128

char phonem[MAXPHO][8];

char segfile_id[22]="AUDIG segment file\x0d\x0a\x1a";
char segfile_bf[22];

long start, len;                  // Startadresse, Lnge des Audio-Speichers
BYTE rate=54, mstep=10;           // Taktrate Digitalisierung, Mark.-Schritte

long ptl(BYTE *p)                 // Pointer to Long
{
  long l=FP_SEG(p);
  return((l<<4)+FP_OFF(p)-start);
}

BYTE *ltp(long l)                 // Long to Pointer
{
  int s=(l+=start)>>4;
  return(MK_FP(s, l&15));
}

void wiedergabe(long a, long e)   // Block abspielen
{
  if(a<e)
  {
    sblock.a=ltp(a);
    sblock.e=ltp(e);
    sblock.r=rate;
    if(SPEAKER) lplay((BYTE*)&sblock);
    else         play((BYTE*)&sblock);
  }
}

int load_deffile(void)
{
  FILE *fp;
  int i, l;

  if((fp=fopen(DEFFILE,"r"))==NULL)
  {
    cprintf("Fehler: Definitionsdatei \"%s\" kann nicht geffnet werden!\r\n", DEFFILE);
    exit(1);
  }

  cprintf("Lade Definitionsdatei \"%s\" ...", DEFFILE);

  for(i=0; i<MAXPHO && fgets(phonem[i], 8, fp)!=NULL; i++)
  {
    l=strlen(phonem[i]);
    if(phonem[i][l-1]=='\n') phonem[i][l-1]=0;
  }

  cprintf("\r\n%8d Phoneme sind definiert\r\n", i);
  if(!i) exit(1);
  return(i);
}

void load_segfile(void)
{
  FILE *fp;
  long a=0, e=len;

  if((fp=fopen(SEGFILE,"rb"))==NULL)
  {
    cprintf("Fehler: Phonemdatei \"%s\" kann nicht geffnet werden!\r\n", SEGFILE);
    exit(1);
  }

  fread(segfile_bf, strlen(segfile_id), 1, fp);

  if(strcmp(segfile_id, segfile_bf)!=0)
  {
    cprintf("Fehler: Phonemdatei \"%s\" ist keine AUDIG-Segmentdatei!\r\n", SEGFILE);
    exit(1);
  }

  cprintf("Lade Phonemdatei \"%s\" ...", SEGFILE);
  fread(&segtab, sizeof(segtab), 1, fp);

  while(e-a>32768 && !feof(fp)) a+=fread(ltp(a), 1, 32768, fp);
  if(!feof(fp)) a+=fread(ltp(a), 1, e-a, fp);

  fclose(fp);
  cprintf("\r\n%8lu Bytes geladen\r\n%8lu Bytes sind noch frei\r\n", a, e-a);
}

void sprich(char *p)
{
  int i;
  char pho_str[16];

  while(*p)
  {
    while(*p==' ') p++;
    for(i=0; i<16 && *p!=' ' && *p!=0; pho_str[i++]=*p++);
    if (i) pho_str[i]=0; else return;

    for(i=0; i<MAXPHO && *phonem[i] && strcmp(phonem[i], pho_str); i++);
    if(i==MAXPHO || !*phonem[i]) textattr(12), cprintf("Syntaxfehler: %s\r\n", pho_str);
    else wiedergabe(segtab[i].a, segtab[i].e);
  }
}

void hilfe(void)
{
//sprich("h i l f 3 100 tz u m 100 p r o g r a m");
  textattr(3); cprintf(
  "SPRICH V1.0  Copyright (c) 1993 Stefan Bion\r\n"
  "Sie knnen beim Aufruf des Programmes SPRICH folgende Optionen angeben:\r\n"
  "\r\n"
  "  -l                    Ausgabe ber eingebauten Lautsprecher\r\n"
  "  -p<Phonemdatei>       Phonemdatei (AUDIG-Segmentdatei) [%s]\r\n"
  "  -d<Definitionsdatei>  Phonem-Definitionsdatei (ASCII) [%s]\r\n"
  "  <Textdatei>           Diese Textdatei (Phonemschrift) wird sofort vorgelesen\r\n"
  "\r\n"
  "Im interaktiven Modus stehen folgende Kommandos zur Verfgung:\r\n"
  "\r\n"
  "  lese [<Datei>]        Liest die Textdatei [%s] vor\r\n"
  "  schr [<Datei>]        Hngt den zuletzt gesprochenen Satz an die Textdatei an\r\n"
  "  proto <Datei>|ein|aus ffnet/schliet die angegebene Protokolldatei\r\n"
  "  random                Erzeugt zufallsgesteuerten Phonemsalat\r\n"
  "  extern                Extern gesteuerte Ausgabe von Phonemen\r\n"
  "  list                  Listet alle Phoneme mit ihrer Lnge auf\r\n"
  "  hilfe                 Zeigt diesen Hilfstext an\r\n"
  "  ende                  Beendet das Programm SPRICH\r\n"
  "\r\n"
  "Ansonsten knnnen Sie direkt Phonemschrift eingeben, die das Programm sofort\r\n"
  "nachpricht. Eine leere Eingabe (nur RETURN) wiederholt das letzte Kommando.\r\n"
  , SEGFILE, DEFFILE, ASCFILE);
}

void list(void)
{
  char c;
  int i, l;

  for(i=0, l=0; i<NSEGS; i++, ++l)
  {
    if(l==24)
    {
      l=0;
      textattr(14); cprintf("Weiter (Esc = Ende) ...");
      textattr(3); c=getch(); cprintf("\r");
      if(c==27)
      {
        clreol();
        break;
      }
    }
    cprintf("%3d.) %-16s %7.3f s\r\n", i+1, phonem[i],
    (double)((segtab[i].e-segtab[i].a)*rate)/1193180);
  }
}

int play_file(void)
{
  FILE *fp;
  char s[256];
  int l;

  if((fp=fopen(ASCFILE,"r"))==NULL)
  {
    cprintf("Fehler: Datei \"%s\" kann nicht geffnet werden!\r\n", ASCFILE);
    return(1);
  }

  while(fgets(s,256,fp)!=NULL && !kbhit())
  {
    l=strlen(s);
    if(s[l-1]=='\n') s[l-1]=0;
    sprich(s);
  }
  if(kbhit()) getch();
  fclose(fp);
  return(0);
}

void write_file(char *s)
{
  FILE *fp;
  int l;

  if(!*s) return;

  if((fp=fopen(ASCFILE,"a"))==NULL)
    cprintf("Fehler: Datei \"%s\" kann nicht beschrieben werden!\r\n", ASCFILE);
  else
    fprintf(fp, "%s\n", s), fclose(fp);
}

void proto_cmd(char *s)
{
  if(*(s)!=' '||!*(++s))
    cprintf("Protokolldatei: \"%s\" (%s)\r\n",
    PROTOFILE, proto==NULL?"AUS":"EIN");
  else if(!strncmp(s,"aus",3))
  {
    if(proto!=NULL) fclose(proto), proto=NULL;
  }
  else
  {
    if(strncmp(s,"ein",3)!=0) strcpy(PROTOFILE,s);
    if(*PROTOFILE)
    {
      if(proto!=NULL) fclose(proto), proto=NULL;
      if((proto=fopen(PROTOFILE,"a"))==NULL) textattr(12), cprintf(
      "Fehler: Protokolldatei \"%s\" kann nicht geffnet werden!\r\n", PROTOFILE);
    }
    else textattr(12), cprintf("Fehler: Keine Protokolldatei angegeben!\r\n");
  }
}

unsigned char getport(void)
{
  unsigned char b;

  outportb(IOPORT+2,8);           // Strobe := H, Autofeed := H
  outportb(IOPORT+2,9);           // Strobe := L, Autofeed := H

  b=(inportb(IOPORT+1)>>3)&0x0F;  // Untere 4 Bits einlesen

  outportb(IOPORT+2,11);          // Strobe := L, Autofeed := L

  b|=(inportb(IOPORT+1)<<1)&0xF0; // Obere 4 Bits einlesen

  return(b);
}

void sprich_random(int modus)
{
  int i, n=0;

  do
  {
    i=modus==RANDOM?random(NSEGS):getport();

    if(i<NSEGS)
    {
      wiedergabe(segtab[i].a, segtab[i].e);

      if(proto!=NULL)
      {
        n+=strlen(phonem[i])+1;
        fprintf(proto, "%s%s", phonem[i], n<75?" ":"\n");
        if(n>=75) n=0;
      }
    }
  }
  while(!kbhit());
  if(proto!=NULL) fprintf(proto, "%s\n", n?"\n":"");
  while(kbhit()) getch();
}

void main(int argc, char *argv[])
{
  char s[256], s1[256]="", save[256]="";

  if(!getdport())
  {
    printf("Keine Soundkarte gefunden!\n");
    exit(1);
  }

  randomize();

  while(--argc)
  {
    switch(argv[argc][0])
    {
      case '-':
        switch(argv[argc][1])
        {
          case 'l': SPEAKER=1; break;
          case 'p': strcpy(SEGFILE, argv[argc]+2); break;
          case 'd': strcpy(DEFFILE, argv[argc]+2); break;
          default: cprintf("Unbekannte Option: %c\r\n", argv[argc][1]);
        }
        break;
      default: strcpy(ASCFILE, argv[argc]);
    }
  }

  len=farcoreleft()-8192;         // Etwas Platz lassen fr fopen() usw.
  start=ptl(farmalloc(len));

  NSEGS=load_deffile();
  load_segfile();

  if(*ASCFILE) exit(play_file());

//sprich("w i l k 0 m 3 n 100 tz u m 100 p r o g r a m 100 sch p r i c 500");
//sprich("w  n 100 s i: 100 f r a: g 3 n 100 h a: b 3 n 200 d a n 100 g e: b 3 n 100");
//sprich("s i: 100 d 0 x 100 ai n f a x 100 d e n 100 b 3 f e: l 200 h i l f 3 200 ai n");

  while(1)
  {
    textattr(14); cprintf("Sprich>"); textattr(3); gets(s);
    if(*s) strcpy(s1,s); else strcpy(s,s1);

    if(!strcmp(s,"ende")) sprich("tsch  z"), fcloseall(), exit(0);

    else if(!strcmp(s,"hilfe")) hilfe();

    else if(!strcmp(s,"list")) list();

    else if(!strncmp(s,"lese",4))
    {
      if(*(s+4)==' ' && *(s+5)) strcpy(ASCFILE,s+5);
      if(proto!=NULL) fclose(proto), proto=NULL;
      play_file();
    }

    else if(!strncmp(s,"schr",4))
    {
      if(*(s+4)==' ' && *(s+5)) strcpy(ASCFILE,s+5);
      write_file(save);
    }

    else if(!strncmp(s,"proto",5)) proto_cmd(s+5);

    else if(!strcmp(s,"random")) sprich_random(RANDOM);

    else if(!strcmp(s,"extern")) sprich_random(EXTERN);

    else
    {
      if(proto!=NULL) fprintf(proto, "%s\n", s);
      strcpy(save,s), sprich(s);
    }
  }
}
