#ifndef __LARGE__
#  error Bitte Speichermodell LARGE benutzen!
#endif

#include <stdio.h>
#include <dos.h>
#include <alloc.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>
#include <graphics.h>             //  = [,  = \\,  = ],  = ^
#include <bios.h>

#define IOPORT 0x3BC

typedef unsigned char      BYTE;
typedef unsigned int       WORD;

// Fehlerbehandlung MS-DOS-Fehler:

extern int errno;                 // Fehlernummer Systemfehler
extern char *sys_errlist[];       // Liste Systemfehler-Texte

// Externe Assemblerroutinen des Moduls CDIGIT.ASM:

extern void getdport(void);       // Initialisierung der Schnittstelle
extern void listen(char rate);    // Funktion "Zuhren"
extern void rec(BYTE *block);     // Funktion "Aufnehmen"
extern void play(BYTE *block);    // Funktion "Wiedergeben"
extern void rep(BYTE *block);     // Funktion "Repetieren"

// Die Adresse dieser Struktur wird den externen Digitalisierungsfunktionen
// bergeben, um den Speicherbereich und die Taktrate zu bestimmen:

struct soundstruc
{
  BYTE *a;                        // Pointer auf Anfangsadresse
  BYTE *e;                        // Pointer auf Endadresse
  BYTE r;                         // Taktrate (f = 1193180 / rate)
} sblock;

// Segmenttabelle:

struct segstruc                   // Tabelle mit Anfangs- und Endadresse
{                                 // der einzelnen Segmente
  long a;
  long e;
  BYTE r;
} segtab[1024], hlptab[1024];

char segfile_id[22]="AUDIG segment file\x0d\x0a\x1a";
char segfile_bf[22];

// Audio-Speicher:

long start, len;                  // Startadresse, Lnge des Audio-Speichers

// Markierungen:

int mark[2], oldmark[2];          // X-Positionen der beiden Markierungen
int markbuf[2][512];              // Puffer fr Markierungen (alter Inhalt)

long merker1, merker2;            // Merker fr Anfang + Ende

BYTE rate, mstep=10;              // Taktrate Digitalisierung, Mark.-Schritte

// Variablen fr Grafikfunktionen:

int g_driver, g_mode, maxx, maxy;


// Umwandlungen von BYTE* (Segment/Offset) nach LONG und zurck unter
// Bercksichtigung des Anfangs des freien Arbeitsspeichers START

long ptl(BYTE *p)                 // Pointer to Long
{
  long l=FP_SEG(p);
  return((l<<4)+FP_OFF(p)-start);
}

BYTE *ltp(long l)                 // Long to Pointer
{
  int s=(l+=start)>>4;
  return(MK_FP(s, l&15));
}


// Digitalisierungsfunktionen:

void wiedergabe(long a, long e)   // Block abspielen
{
  if(a<e)
  {
    sblock.a=ltp(a);
    sblock.e=ltp(e);
    sblock.r=rate;
    play((BYTE*)&sblock);
  }
}

void repeat(long a, long e)       // Block repetieren
{
  if(a<e)
  {
    sblock.a=ltp(a);
    sblock.e=ltp(e);
    sblock.r=rate;
    rep((BYTE*)&sblock);
  }
}

void aufnahme(long a, long e)     // Block aufnehmen
{
  if(a<e)
  {
    sblock.a=ltp(a);
    sblock.e=ltp(e);
    sblock.r=rate;
    rec((BYTE*)&sblock);
  }
}


// Markierungsfunktionen:

void setmark(char m)              // Setzt Markierung mark[m]
{
  int y;
  for(y=0; y<=maxy-50; y++) markbuf[m][y]=getpixel(mark[m], y);
  setcolor(4);
  line(mark[m], 0, mark[m], maxy-50);
  setcolor(7);
  oldmark[m]=mark[m];
}

void delmark(char m)              // Lscht Markierung oldmark[m]
{
  int y;
  for(y=0; y<=maxy-50; y++) putpixel(oldmark[m], y, markbuf[m][y]);
}

void movmark(char m)              // Bewegt Markierung von oldmark[m]
{                                 // nach mark[m]
  delmark(m);
  setmark(m);
}

void initmark()                   // Setzt die Markierungen in die Mitte
{
  mark[0]=maxx/3, setmark(0);
  mark[1]=maxx-maxx/3, setmark(1);
}


// Text in der untersten Zeile ausgeben:

void delmsg(void)
{
  setviewport(0, maxy-8, maxx, maxy, 1);
  clearviewport();
  setviewport(0, 0, maxx, maxy, 1);
}

void message(char *s)
{
  delmsg();
  moveto(0, maxy-8);
  outtext(s);
}


// Longwert an Cursorposition ausgeben:

void outlong(long l)
{
  char s[20];
  ltoa(l, s, 10);
  outtext(s);
}


// Zeichen an Position(x, y) ausgeben:

void outcharxy(int x, int y, char c)
{
  char s[2];
  s[0]=c, s[1]=0;

  setviewport(x, y, x+8, y+8, 1);
  clearviewport();
  outtext(s);
}


// String von Tastatur einlesen

void instring(char *string)
{
  struct viewporttype v;
  int x, y, taste, i=0;

  getviewsettings(&v);
  x=getx()+v.left;
  y=gety()+v.top;

  outcharxy(x, y, '_');

  while((taste=getch())!=13)
  {
    if(taste==8)
    {
      if(i>0)
      {
        outcharxy(x, y, ' '), x-=8;
        outcharxy(x, y, '_'), i--;
      }
    }
    else
    {
      outcharxy(x, y, taste), x+=8;
      outcharxy(x, y, '_');
      string[i++]=taste;
    }
  }
  string[i]=0;
  outcharxy(x, y, ' ');
  setviewport(v.left, v.top, v.right, v.bottom, v.clip);
  moveto(x-v.left, y-v.top);
}


// Feststellen, ob und welche <SHIFT>-Taste gedrckt wurde:
// 0 = keine, 1 = rechte, 2 = linke, 3 = beide

int shiftpressed(void)
{
  return(bioskey(2)&3);
}


// J/N-Abfrage

int ja(void)
{
  char c;

  do c=toupper(getch()); while(c!='J' && c!='N' && c!=27);
  return(c=='J');
}


// Soundkurve zeichnen

void drawgraph(long a, long e)
{
  WORD x, y;
  WORD nullinie=(maxy-50)>>1;
  double dstep=(double)(e-a)/maxx;
  long off;
  int color=2;

  setviewport(0, 0, maxx, maxy-50, 1);
  clearviewport();
  rectangle(0, 0, maxx, maxy-50);

  line(0, nullinie, maxx, nullinie);
  moveto(1, nullinie);

  setcolor(color);

  for(x=1; x<maxx; x++)
  {
    off=a+(long)(x*dstep);
    y=nullinie-127+*(ltp(off));

    if(off>merker2) { if(color!=2) setcolor(color=2); } else
    if(off>=merker1) { if(color!=10) setcolor(color=10); }

    lineto(x, y);
  }

  setcolor(7);
  setviewport(0, 0, maxx, maxy, 1);
}


// Hauptmen und Parameter ausgeben

void mainmenu(int zeile)
{
  char s[256];

  if(zeile==0 || zeile==1)
  {
    sprintf(s, "Speicher: %6lu (%7.3f s)  Frequenz: %5lu Hz  Markierungsschrittweite: %2d",
    len, (double)(len*rate)/1193180, 1193180/rate, mstep),
    setviewport(0, maxy-48, maxx, maxy-41, 1), clearviewport(), outtext(s);
  }

  if(zeile==0 || zeile==2)
  {
    sprintf(s, "Links   : %6lu (%7.3f s)  Rechts  : %6lu (%7.3f s) = %6lu (%7.3f s)",
    ptl(sblock.a),   (double)(ptl(sblock.a)*rate)/1193180,
    ptl(sblock.e),   (double)(ptl(sblock.e)*rate)/1193180,
    ptl(sblock.e)-ptl(sblock.a), (double)((ptl(sblock.e)-ptl(sblock.a))*rate)/1193180),
    setviewport(0, maxy-40, maxx, maxy-33, 1), clearviewport(), outtext(s);
  }

  if(zeile==0 || zeile==3)
  {
    sprintf(s, "Merker 1: %6lu (%7.3f s)  Merker 2: %6lu (%7.3f s) = %6lu (%7.3f s)",
    merker1,         (double)(merker1*rate)/1193180,
    merker2,         (double)(merker2*rate)/1193180,
    merker2-merker1, (double)((merker2-merker1)*rate)/1193180),
    setviewport(0, maxy-32, maxx, maxy-25, 1), clearviewport(), outtext(s);
  }

  setviewport(0, 0, maxx, maxy, 1);
}


// Hilftext ausgeben

void helpscreen(void)
{
  int y=0;

  setviewport(0, 0, maxx, maxy, 1); clearviewport();
  setcolor(2); rectangle(0, 0, maxx, maxy);
  outtextxy(8*38,y+=2,"Hilfe"); setcolor(7);

  outtextxy(0,y+=10, "Digitalisierung:");

  outtextxy(0,y+=16, "<H> Zuh\\ren   <A> Aufnehmen   <W> Wiedergeben (dargestellten Bereich)");
  outtextxy(0,y+=10, "<M> Wiedergeben (markierten Bereich)   <R> Repetieren (markierten Bereich)");
  outtextxy(0,y+=10, "<Z> Zufallsgesteuerte Wiedergabe der Segmente   <Alt-A> Auto-Cut");
  outtextxy(0,y+=10, "<E> Extern gesteuerte Wiedergabe der Segmente   <I> Schnittstelle init.");
  outtextxy(0,y+=10, "<-><+> Taktrate [ndern  <T> Taktrate eingeben   <Alt-X> Beenden");

  outtextxy(0,y+=16, "Markierungen:");

  outtextxy(0,y+=16, "<Ins>     Gesamten Bereich markieren        <Del> Mittleres Drittel markieren");
  outtextxy(0,y+=10, "<Ctrl-CR> Gesamten Bereich darstellen       <CR> Markierten Bereich darstellen");
  outtextxy(0,y+=10, "<ESC>     Darstellung vergr\\^ern (3-fach)   <ALT-M> Schrittweite umschalten");
  outtextxy(0,y+=10, "<Alt-P>   Positionieren auf Segment n");

  outtextxy(0,y+=16, "Folgende Markierungsfunktionen beziehen sich ohne <Shift> auf beide, mit <Shift>");
  outtextxy(0,y+=10, "auf die linke oder rechte Markierung (entspr. linke oder rechte <Shift>-Taste):");

  outtextxy(0,y+=16, "<CuLe>/<CuRi> Markierung(en) schrittweise nach links/rechts bewegen");
  outtextxy(0,y+=10, "<Home>/<End>  Markierung(en) zum Anfang/Ende bewegen");

  outtextxy(0,y+=16, "Bearbeitung des markierten Bereiches (jeweils mit <Alt>-Taste):");

  outtextxy(0,y+=16, "<D> L\\schen   <U> Signal umkehren (r]ckw[rts)   <E> Echo berechnen");
  outtextxy(0,y+=10, "<H> Hochpa^   <T> Tiefpa^   (jeweils 1. Ordnung)");
  outtextxy(0,y+=10, "<W> Datei schreiben   <R> Datei Lesen");

  getch();
  clearviewport();
  drawgraph(ptl(sblock.a), ptl(sblock.e));
  setmark(0), setmark(1);
  mainmenu(0);
}


// Taktrate eingeben

void getrate(void)
{
  char frequenz[20];
  long f, r;

  message("Taktrate (Hz): ");
  instring(frequenz);
  delmsg();

  if((f = atol(frequenz)) > 0)
  {
    r = 1193180 / f;
    if(r >= 28 && r <= 255) rate = r;
  }
}


// Signal aufnehmen

void aufnehmen(void)
{
  char c;
  long a=merker1, e=merker2;
  BYTE *save_a, *save_e;

  message("Wohin? 0) Ab Start, 1) Ab Merker 1, 2) Ab Merker 1 bis max. Merker 2 (0/1/2)?");
  do c=getch(); while(c!=27 && c!='0' && c!='1' && c!='2');
  switch(c)
  {
    case 27: delmsg(); return;
    case '0': a=0;
    case '1': e=len;
  }
  message("Achtung, Aufnahme ...");

  save_a=sblock.a, save_e=sblock.e;
  aufnahme(a,e);
  sblock.a=save_a, sblock.e=save_e;

  drawgraph(ptl(sblock.a), ptl(sblock.e));
  setmark(0), setmark(1); delmsg();
}


// Signalform lschen

void delsig(long a, long e)
{
  message("L\\sche Signal zwischen Merker 1 und Merker 2 ...");
  while(a<=e) *(ltp(a++))=127;
  drawgraph(ptl(sblock.a), ptl(sblock.e));
  setmark(0), setmark(1); delmsg();
}


// Signalform umdrehen

void flip(long a, long e)
{
  BYTE h, *ap, *ep;

  message("Drehe Signal zwischen Merker 1 und Merker 2 um ...");

  while(a<=e)
  {
    ap=ltp(a++);
    ep=ltp(e--);

    h=*ap, *ap=*ep, *ep=h;
  }
  drawgraph(ptl(sblock.a), ptl(sblock.e));
  setmark(0), setmark(1); delmsg();
}


// Echo berechnen

void echo(long a, long e)
{
  long n, i, anz=e-a;
  char dist[20], fade[20];
  long d, f, h;
  BYTE *p1, *p2;

  message("Verz\\gerung (ms): "); instring(dist);
  outtext("   Abschw[chung (%): "); instring(fade);
  n=atol(dist); f=atol(fade); if(f>100) f=0;

  if(n&&f)
  {
    message("Berechne Echo fr Signal zwischen Merker 1 und Merker 2 ...");
    d=n*119318/rate/100;

    for(i=d; i<=anz; i++)
    {
      p1=ltp(a+i-d);
      p2=ltp(a+i);

      h=(*p1-127) * f / 100 + *p2;
      if(h>255) h=255; else if(h<0) h=0;
      *p2=h;
    }
    drawgraph(ptl(sblock.a), ptl(sblock.e));
    setmark(0), setmark(1);
  }
  delmsg();
}


// Hoch- und Tiefpa

void filter(long a, long e, char type)
{
  long c, h1, h2, f;
  char fg[20];
  BYTE *p=ltp(a);
  long i, anz=e-a;

  message("Grenzfrequenz Tief...Hoch (99...0): "); instring(fg);
  outtext("   Eingabe ok (j/n) ?");
  if(ja())
  {
    c = atol(fg);
    if(type == 'T')
    {
      message("F]hre Tiefpa^berechnung durch fr Signal zwischen Merker 1 und Merker 2 ...");
      for(i = 0, f = 100 - c, h1 = 127; i <= anz; i++)
      {
        h1 = *(p + i) + (h1 - 127) * c / 100;
        *(p + i) = (h1 - 127) * f / 100 + 127;
      }
    }
    else
    {
      message("F]hre Hochpa^berechnung durch fr Signal zwischen Merker 1 und Merker 2 ...");
      for(i = 0, h1 = h2 = 127; i <= anz; i++)
      {
        h1 = *(p + i) - h2 + 127 + (h1 - 127) * c / 100;
        h2 = *(p + i);
        *(p + i) = h1;
      }
    }
    drawgraph(ptl(sblock.a), ptl(sblock.e));
    setmark(0), setmark(1);
  }
  delmsg();
}


// Datei schreiben

void writefile(long a, long e)
{
  FILE *fp;
  char file[80];

  message("Datei schreiben - Dateiname: "); instring(file);
  if(!*file) { delmsg(); return; }

  if((fp=fopen(file,"wb"))!=NULL)
  {
    message("Schreibe Bereich zwischen Merker 1 und Merker 2 in die Datei ...");

    while(e-a>32768) fwrite(ltp(a), 32768, 1, fp), a+=32768;
    fwrite(ltp(a), e-a, 1, fp);

    fclose(fp);
  }
  else
  {
    message("Fehler beim Erstellen der Datei: ");
    outtext(sys_errlist[errno]);
    getch();
  }
  delmsg();
}


// Datei laden

void readfile(long a, long e)
{
  FILE *fp;
  char file[80], c;

  message("Datei laden - Dateiname: "); instring(file);
  if(!*file) { delmsg(); return; }

  if((fp=fopen(file,"rb"))!=NULL)
  {
    message("Wohin? 0) Ab Start, 1) Ab Merker 1, 2) Ab Merker 1 bis max. Merker 2 (0/1/2)?");
    do c=getch(); while(c!=27 && c!='0' && c!='1' && c!='2');
    switch(c)
    {
      case 27: delmsg(); return;
      case '0': a=0;
      case '1': e=len;
    }
    message("Lade Datei ...");

    while(e-a>32768 && !feof(fp)) a+=fread(ltp(a), 1, 32768, fp);
    if(!feof(fp)) fread(ltp(a), 1, e-a, fp);

    fclose(fp);
    drawgraph(ptl(sblock.a), ptl(sblock.e));
    setmark(0), setmark(1);
  }
  else
  {
    message("Diese Datei kann nicht ge\\ffnet werden: ");
    outtext(sys_errlist[errno]);
    getch();
  }

  delmsg();
}


// Segment speichern:

void store_segment(void)
{
  int n;
  char s[20];

  message("Segment speichern unter Nummer (0...1023): "); instring(s);
  if(!*s) { delmsg(); return; }

  n=atoi(s);

  if(n<0 || n>1023)
  {
    message("Falsche Segmentnummer - bitte Taste dr]cken ...");
    getch(); delmsg(); return;
  }

  if(segtab[n].a<segtab[n].e)
  {
    message("Diese Segmentnummer ist bereits belegt - ]berschreiben (j/n)?");
    if(!ja()) { delmsg(); return; }
  }

  segtab[n].a=merker1;
  segtab[n].e=merker2;
  segtab[n].r=rate;

  delmsg();
}


// Automatisches Einteilen des Audiospeichers in Segmente:

void autocut(void)
{
  char s[20];
  int i, n, a, max;
  long d, p;

  message("Segmentl[nge (ms): "); instring(s);
  if(!*s) { delmsg(); return; }
  n=atol(s); d=n*119318/rate/100;
  if(d<1 || d>len)
  {
    message("Segmentl[nge fehlerhaft - bitte Taste dr]cken ...");
    getch(); delmsg(); return;
  }

  max=len/d>1024?1024:len/d;

  outtext("   Anzahl Segmente (1...");
  outlong(max); outtext("): "); instring(s);
  if(!*s) { delmsg(); return; }
  a=atoi(s);
  if(a<1 || a>max)
  {
    message("Anzahl Segmente fehlerhaft - bitte Taste dr]cken ...");
    getch(); delmsg(); return;
  }

  for(i=0, p=0; i<a; i++)
  {
    segtab[i].a=p;
    p+=d;
    segtab[i].e=p;
    segtab[i].r=rate;
  }

  for(; i<1024; i++)
  {
    segtab[i].a=0;
    segtab[i].e=0;
    segtab[i].r=0;
  }
  delmsg();
}


// Segment(e) lschen:

void clear_segment(void)
{
  int n1, n2, i;
  char s[20], *p;

  message("Welche(s) Segment(e) lschen (0...1023): "); instring(s);
  if(!*s) { delmsg(); return; }

  if((p=strchr(s,'-'))!=NULL)
  {
    *p++=0;
    n1=*s?atoi(s):0;
    n2=*p?atoi(p):1023;
    if(n1<0 || n2>1023 || n1>=n2)
    {
      message("Falsche Segmentnummer - bitte Taste dr]cken ...");
      getch();
    }
    else
    {
      for(i=n1; i<=n2; i++)
      {
        segtab[i].a=0;
        segtab[i].e=0;
        segtab[i].r=0;
      }
    }
  }
  else
  {
    n1=atoi(s);
    if(n1<0 || n1>1023)
    {
      message("Falsche Segmentnummer - bitte Taste dr]cken ...");
      getch();
    }
    else
    {
      segtab[n1].a=0;
      segtab[n1].e=0;
      segtab[n1].r=0;
    }
  }

  delmsg();
}


// Markierungen positionieren auf Segmentgrenzen

void pos_seg(void)
{
  int n;
  char s[20];
  long a, m0, m1, e;

  for(n=0; n<1024 && segtab[n].a>=segtab[n].e; n++);
  if(n==1024)
  {
    message("Keine Segmente vorhanden - bitte Taste dr]cken ...");
    getch(); delmsg(); return;
  }

  message("Auf welches Segment positionieren (0...1023): ");
  instring(s); if(!*s) { delmsg(); return; }

  n=atoi(s);

  if(n<0 || n>1023)
  {
    message("Falsche Segmentnummer - bitte Taste dr]cken ...");
    getch(); delmsg(); return;
  }

  if(segtab[n].a>=segtab[n].e)
  {
    message("Diese Segmentnummer ist nicht belegt - bitte Taste dr]cken ...");
    getch(); delmsg(); return;
  }

  merker1=m0=segtab[n].a, merker2=m1=segtab[n].e;

  a=m0-(m1-m0); if(a<0)   a=0;   sblock.a=ltp(a);
  e=m1+(m1-m0); if(e>len) e=len; sblock.e=ltp(e);

  mark[0]=(m0-a)*maxx/(e-a);
  mark[1]=(m1-a)*maxx/(e-a);

  drawgraph(a,e); setmark(0), setmark(1); mainmenu(0);
}


// Segment abspielen:

void play_segment(void)
{
  static int n=1024;
  char s[20];
  BYTE *a, *e;

  message("Welches Segment abspielen (0...1023): "); instring(s);
  if(!*s && n>1023) { delmsg(); return; }

  if(*s!=0) n=atoi(s); else outlong(n);

  if(n<0 || n>1023)
  {
    message("Falsche Segmentnummer - bitte Taste dr]cken ...");
    getch(); delmsg(); return;
  }

  if(segtab[n].a>=segtab[n].e)
  {
    message("Diese Segmentnummer ist nicht belegt - bitte Taste dr]cken ...");
    getch(); delmsg(); return;
  }

  a=sblock.a, e=sblock.e;
  wiedergabe(segtab[n].a, segtab[n].e);
  sblock.a=a, sblock.e=e;

  delmsg();
}

// Zufallsgesteuerte Wiedergabe der Segmente

void zufall(void)
{
  int i, j, last=1024;
  int segs, segment[1024];
  BYTE *a, *e;

  for(i=0, segs=0; i<1024; i++) if(segtab[i].a<segtab[i].e) segment[segs++]=i;

  if(segs<2)
  {
    message("Es m]ssen mindestens 2 Segmente vorhanden sein - bitte Taste dr]cken ...");
    getch(); delmsg(); return;
  }

  message("Zufallsgesteuerte Wiedergabe der Segmente ...");
  a=sblock.a, e=sblock.e;

  do
  {
    i=random(segs);

    if(i!=last)
    {
      last=i;
      j=segment[i];
      wiedergabe(segtab[j].a, segtab[j].e);
    }
  }
  while(!kbhit());

  sblock.a=a, sblock.e=e; delmsg();
}

// Einlesen eines 8-Bit-Wertes von der externen Schnittstelle

BYTE getport(void)
{
  unsigned char b;

  outportb(IOPORT+2,8);           // Strobe := H, Autofeed := H
  outportb(IOPORT+2,9);           // Strobe := L, Autofeed := H

  b=(inportb(IOPORT+1)>>3)&0x0F;  // Untere 4 Bits einlesen

  outportb(IOPORT+2,11);          // Strobe := L, Autofeed := L

  b|=(inportb(IOPORT+1)<<1)&0xF0; // Obere 4 Bits einlesen

  return(b);
}

// Extern gesteuerte Wiedergabe der Segmente

void extern_play(void)
{
  int i, j;
  int segs, segment[1024];
  BYTE *a, *e;

  for(i=0, segs=0; i<1024; i++) if(segtab[i].a<segtab[i].e) segment[segs++]=i;

  if(segs<2)
  {
    message("Es m]ssen mindestens 2 Segmente vorhanden sein - bitte Taste dr]cken ...");
    getch(); delmsg(); return;
  }

  message("Extern gesteuerte Wiedergabe der Segmente ...");
  a=sblock.a, e=sblock.e;

  do
  {
    i=getport();
    if(i<segs)
    {
      j=segment[i];
      wiedergabe(segtab[j].a, segtab[j].e);
    }
  }
  while(!kbhit());

  sblock.a=a, sblock.e=e; delmsg();
}

// Segmente auflisten:

void list_segments(void)
{
  char c;
  int sp, ze, n=0, nseg=0;
  int ende=0, titel;
  int maxze, pze=8;

  if(maxy>199) pze=10;
  maxze=(maxy+1-24)/pze;
  setviewport(0, 0, maxx, maxy, 1);

  do
  {
    clearviewport(); setcolor(2);
    rectangle(0, 0, maxx, maxy);
    setcolor(7);

    for(sp=0; sp<3 && !ende; sp++)
    {
      titel=1;
      for(ze=0; ze<maxze && !ende; ze++)
      {
        while(n<1024 && segtab[n].a>=segtab[n].e) n++;
        if(n<1024)
        {
          nseg++;
          if(titel)
          {
            setcolor(2);
            outtextxy(12+sp*28*8,2,"Segm  Speicherbereich");
            setcolor(7);
            titel=0;
          }
          moveto(12+sp*28*8,    12+ze*pze), outlong(n);
          moveto(12+sp*28*8+6*8,12+ze*pze),
          outlong(segtab[n].a), outtext("-"), outlong(segtab[n].e);
          n++;
        }
        else ende=1;
      }
    }
    setcolor(2); moveto(12,maxy-12);
    if(!nseg) outtext("Es ist keine Segmentnummer belegt! ");
    outtext("Dr]cken Sie ");
    if(!ende) outtext("<CR>, um fortzusetzen oder ");
    outtext("<ESC> zum Beenden ...");
    setcolor(7);
    do c=getch(); while(c!=13 && c!=27); if(c==27) ende=1;
  }
  while(!ende);

  clearviewport();
  drawgraph(ptl(sblock.a), ptl(sblock.e));
  setmark(0), setmark(1);
  mainmenu(0);
}


// Segmente auf Platte sichern:

void save_segfile(void)
{
  FILE *fp;
  char file[80];
  int n=0;
  long a, e, off=0, size;

  for(n=0; n<1024 && segtab[n].a>=segtab[n].e; n++);
  if(n==1024)
  {
    message("Keine Segmente vorhanden - bitte Taste dr]cken ...");
    getch(); delmsg(); return;
  }

  message("Segmentdatei schreiben - Dateiname: "); instring(file);
  if(!*file) { delmsg(); return; }

  if((fp=fopen(file,"wb"))==NULL)
  {
    message("Fehler beim Erstellen der Datei: ");
    outtext(sys_errlist[errno]);
    getch(); delmsg(); return;
  }

  for(n=0; n<1024; n++)
  {
    hlptab[n].a=segtab[n].a;
    hlptab[n].e=segtab[n].e;
    hlptab[n].r=segtab[n].r;
  }

  message("Schreibe Datei ...");
  fwrite(segfile_id, strlen(segfile_id), 1, fp);
  fwrite(&hlptab, sizeof(hlptab), 1, fp);
  for(n=0; n<1024; n++)
  {
    if(hlptab[n].a<hlptab[n].e)
    {
      a=hlptab[n].a, e=hlptab[n].e, size=e-a;
      hlptab[n].a=off, hlptab[n].e=off+size, off+=size;

      while(e-a>32768) fwrite(ltp(a), 32768, 1, fp), a+=32768;
      fwrite(ltp(a), e-a, 1, fp);
    }
  }
  fseek(fp, strlen(segfile_id), SEEK_SET);
  fwrite(&hlptab, sizeof(hlptab), 1, fp),
  fclose(fp);

  delmsg();
}


// Segmente von Platte laden:

void load_segfile(void)
{
  FILE *fp;
  char file[80];
  int n=0, i, segs=0;
  long a=0, e, size, frei;

  message("Segmentdatei laden - Dateiname: "); instring(file);
  if(!*file) { delmsg(); return; }

  if((fp=fopen(file,"rb"))==NULL)
  {
    message("Diese Datei kann nicht ge\\ffnet werden: ");
    outtext(sys_errlist[errno]);
    getch(); delmsg(); return;
  }

  *segfile_bf=0;
  fread(segfile_bf, strlen(segfile_id), 1, fp);

  if(strcmp(segfile_id, segfile_bf)!=0)
  {
    message("Dies ist keine AUDIG-Segmentdatei - bitte Taste dr]cken ...");
    getch(); delmsg(); return;
  }

  message("Lade Datei ...");
  fread(&hlptab, sizeof(hlptab), 1, fp);

  for(n=0; n<1024; n++)
    if(segtab[n].a<segtab[n].e)
      if(segtab[n].e>a) a=segtab[n].e;

  frei=len-a;

  for(n=0; n<1024; n++)
  {
    if(hlptab[n].a<hlptab[n].e)
    {
      size=hlptab[n].e-hlptab[n].a;

      if(frei<size)
      {
        message("Zuwenig Platz! Es wurden nur "); outlong(segs);
        outtext(" Segmente geladen - bitte Taste dr]cken ...");
        getch(); break;
      }

      for(i=0; i<1024 && segtab[i].a<segtab[i].e; i++);
      if(i==1024)
      {
        message("Alle Segmentnummern belegt! "); outlong(segs);
        outtext(" Segmente geladen - bitte Taste dr]cken ...");
        getch(); break;
      }

      e=a+size;
      segtab[i].a=a, segtab[i].e=e, segtab[i].r=hlptab[n].r;

      while(e-a>32768 && !feof(fp)) a+=fread(ltp(a), 1, 32768, fp);
      if(!feof(fp)) a+=fread(ltp(a), 1, e-a, fp);
      else
      {
        message("Datei zuende! Es wurden nur "); outlong(segs);
        outtext(" Segmente geladen - bitte Taste dr]cken ...");
        getch(); break;
      }

      frei-=size, segs++;
    }
  }
  fclose(fp);
  drawgraph(ptl(sblock.a), ptl(sblock.e));
  setmark(0), setmark(1);

  delmsg();
}


// Beginn des Hauptprogramms

void main(void)
{
  BYTE *h_start;
  BYTE *h_end;
  long a, e, bereich;
  double dstep;

  detectgraph(&g_driver, &g_mode);
  initgraph(&g_driver, &g_mode, "");
  maxx=getmaxx(), maxy=getmaxy();

  start=0;
  len=farcoreleft()-8192;         // Etwas Platz lassen fr fopen() usw.
  start=ptl(farmalloc(len));

  merker1=0;
  merker2=len;

  rate = 54;
  getdport();

  sblock.a=ltp(0);
  sblock.e=ltp(len);

  randomize();

  setcolor(14);
  outtextxy(92+20*8, maxy/2-24, "AUDIG Version 3.0");
  setcolor(12);
  outtextxy(92+11*8, maxy/2,    "Copyright (c) 1992-1993 Stefan Bion");
  setcolor(10);
  outtextxy(92,      maxy/2+24, "Freigegeben zu Forschungszwecken des VTF e.V., Dsseldorf");

  setcolor(7);
  outtextxy(128, maxy-8, "Moment noch, der Speicher wird initialisiert ...");
  for(bereich=0; bereich<=len; bereich++) *(ltp(bereich))=127; delmsg();

  drawgraph(ptl(sblock.a), ptl(sblock.e)); initmark(); mainmenu(0);

  for(;;)
  {
    dstep = (double) (ptl(sblock.e) - ptl(sblock.a)) / maxx;
    a=ptl(sblock.a)+mark[0]*dstep;
    e=ptl(sblock.a)+mark[1]*dstep;

    while(kbhit()) getch();

    switch(toupper(getch()))
    {
      case 0:
        switch(getch())
        {
          case 75:
            switch(shiftpressed())
            {
              case 0:                                      // <CuLe>
                if(mark[0]-mstep>=0)
                  mark[0]-=mstep, movmark(0),
                  mark[1]-=mstep, movmark(1);
                break;
              case 2:                                      // <L-Sh-CuLe>
                if(mark[0]-mstep>=0)
                  mark[0]-=mstep, movmark(0);
                break;
              case 1:                                      // <R-Sh-CuLe>
                if(mark[1]-mstep>mark[0])
                  mark[1]-=mstep, movmark(1);
                break;
            }
            break;

          case 77:
            switch(shiftpressed())
            {
              case 0:                                      // <CuRi>
                if(mark[1]+mstep<=maxx)
                  mark[1]+=mstep, movmark(1),
                  mark[0]+=mstep, movmark(0);
                break;
              case 2:                                      // <L-Sh-CuRi>
                if(mark[0]+mstep<mark[1])
                  mark[0]+=mstep, movmark(0);
                break;
              case 1:                                      // <R-Sh-CuRi>
                if(mark[1]+mstep<=maxx)
                  mark[1]+=mstep, movmark(1);
                break;
            }
            break;

          case 71:
            switch(shiftpressed())
            {
              case 0:                                      // <Home>
                mark[1]-=mark[0], mark[0]=0;
                movmark(0), movmark(1);
                break;
              case 2:                                      // <L-Sh-Home>
                mark[0]=0, movmark(0);
                break;
              case 1:                                      // <R-Sh-Home>
                mark[1]=mark[0]+1, movmark(1);
                break;
            }
            break;

          case 79:
            switch(shiftpressed())
            {
              case 0:                                      // <End>
                mark[0]=mark[0]+maxx-mark[1],              
                mark[1]=maxx;                              
                movmark(1), movmark(0);                    
                break;                                     
              case 2:                                      // <L-Sh-End>
                mark[0]=mark[1]-1, movmark(0);             
                break;
              case 1:                                      // <R-Sh-End>
                mark[1]=maxx, movmark(1);                  
                break;                                     
            }                                              
            break;                                         

          case 82:                                         // <Ins>
            mark[0]=0, movmark(0);                         
            mark[1]=maxx, movmark(1);                      
            break;                                         

          case 83:                                         // <Del>
            mark[0]=maxx/3, movmark(0);
            mark[1]=maxx-maxx/3, movmark(1);
            break;

          case 50:                                         // <ALT-M>
            mstep=mstep==1?10:1; mainmenu(1); break;

          case 25:                                         // <ALT-P>
            pos_seg(); break;                              

          case 30:                                         // <ALT-A>
            autocut(); break;

          case 32:                                         // <ALT-D>
            delsig(merker1,merker2); break;

          case 22:                                         // <ALT-U>
            flip(merker1,merker2); break;

          case 18:                                         // <ALT-E>
            echo(merker1,merker2); break;

          case 17:                                         // <ALT-W>
            writefile(merker1,merker2); break;

          case 19:                                         // <ALT-R>
            readfile(merker1,merker2); break;

          case 35:                                         // <ALT-H>
            filter(merker1,merker2,'H'); break;

          case 20:                                         // <ALT-T>
            filter(merker1,merker2,'T'); break;

          case 45:                                         // <ALT-X>
            closegraph(); exit(0);                         

          case 59:                                         // <F1>
            helpscreen(); break;                           

          case 31:                                         // <ALT-S>
            save_segfile(); break;                         

          case 38:                                         // <ALT-L>
            load_segfile(); break;
        }
        break;

      case 10:                                             // <Ctrl-CR>
        sblock.a=ltp(0), sblock.e=ltp(len);
        drawgraph(0,len); initmark();
        mstep=10; mainmenu(0); break;

      case 13:                                             // <CR>
        if((long) (mark[1] - mark[0]) * dstep >= 1)
        {
          a=ptl(sblock.a), e=ptl(sblock.e);
          e=a+(long)(mark[1]*dstep);
          a=a+(long)(mark[0]*dstep);
          sblock.a=ltp(a), sblock.e=ltp(e);
          drawgraph(a,e); initmark();
          mstep=10; mainmenu(0);
        }
        break;

      case 27:                                             // <ESC>
        a=ptl(sblock.a), e=ptl(sblock.e), bereich=e-a;
        a=a-bereich<0?0:a-bereich;
        e=e+bereich>len?len:e+bereich;
        sblock.a=ltp(a), sblock.e=ltp(e);
        drawgraph(a,e); initmark();
        mstep=10; mainmenu(0); break;

      case 'H':
        message("Zuh\\ren ...");
        listen(rate); delmsg();
        break;

      case 'A': aufnehmen(); break;

      case 'W':
        message("Dargestellten Bereich wiedergeben ...");
        wiedergabe(ptl(sblock.a), ptl(sblock.e)); delmsg();
        break;

      case 'M':
        message("Gebe Signal zwischen Merker 1 und Merker 2 wieder ...");
        h_start=sblock.a, h_end=sblock.e;
        wiedergabe(merker1,merker2);
        sblock.a=h_start, sblock.e=h_end;
        delmsg();
        break;

      case 'R':
        message("Repetiere Signal zwischen Merker 1 und Merker 2 ...");
        h_start=sblock.a, h_end=sblock.e;
        repeat(merker1,merker2);
        sblock.a=h_start, sblock.e=h_end;
        delmsg();
        break;

      case '+': if(rate>28) rate--; mainmenu(0); break;

      case '-': if(rate<255) rate++; mainmenu(0); break;

      case '1': if(a<merker2)
                {
                  merker1=a, mainmenu(3);
                  drawgraph(ptl(sblock.a), ptl(sblock.e));
                  setmark(0), setmark(1);
                }
                break;

      case '2': if(e>merker1)
                {
                  merker2=e, mainmenu(3);
                  drawgraph(ptl(sblock.a), ptl(sblock.e));
                  setmark(0), setmark(1);
                }
                break;

      case 'T': getrate(); mainmenu(0); break;

      case 'I': getdport(); break;

      case 'S': store_segment(); break;

      case 'C': clear_segment(); break;

      case 'L': list_segments(); break;

      case 'P': play_segment(); break;

      case 'E': extern_play(); break;

      case 'Z': zufall(); break;
    }
  }
}
