                   .model small
                   .code

aktiv              db 0                     ; 1 = aktiviert

newint21h:         cmp ah,40h               ; Funktion = 40h ?
                   je func_40h
                   cmp ah,4Ch               ; Funktion = 4Ch ?
                   je func_4Ch

oldint21h:         db 0EAh                  ; Far-Sprung zum Original-Handler.
oldint21h_ofs      dw ?
oldint21h_seg      dw ?

func_4Ch:          push ax                  ; Bevor "Terminate Process":
                   mov ax,2521h             ; FastWrite-Routine deaktivieren:
                   mov dx,oldint21h_ofs
                   mov ds,oldint21h_seg     ; Alten Int-21h-Vektor zurck-
                   int 21h                  ; speichern.
                   pop ax
                   jmp oldint21h

func_40h:          cmp bx,2                 ; Handle = 2 (StdErr) ?
                   je oldint21h
                   push bp
                   mov bp,sp
                   clc
                   pushf
                   pop ax
                   mov word ptr [bp+6],ax
                   pop bp
                   mov ax,cx
                   iret

_doswrite          proc
                   public _doswrite
                   arg schalter:word

                   push bp
                   mov bp,sp
                   push ds
                   push cs
                   pop ds

                   cmp schalter,0
                   je dw_on

                   cmp aktiv,0              ; FastWrite-Routine deaktivieren
                   je dw_end                ; (falls nicht schon deaktiviert):
                   mov ax,2521h
                   mov dx,oldint21h_ofs
                   mov ds,oldint21h_seg     ; Alten Int-21h-Vektor zurck-
                   int 21h                  ; speichern.
                   mov aktiv,0
                   jmp dw_end

dw_on:             cmp aktiv,1
                   je dw_end
                   mov ax,3521h             ; Alten Int-21h-Vektor sichern.
                   int 21h
                   mov oldint21h_ofs,bx
                   mov oldint21h_seg,es
                   mov ax,2521h             ; Neuen Int-21h-Vektor
                   lea dx,newint21h         ; initialisieren.
                   int 21h
                   mov aktiv,1

dw_end:            pop ds
                   pop bp
                   ret

_doswrite          endp

                   end
