/*****************************************************************************
*                                                                            *
*  R86 V1.00 Re-Assembler (C) 1992 Stefan Bion                               *
*                                                                            *
*  R86.H: Headerdatei mit Definitionen der Arrays und Strukturen fr die     *
*         Mnemomics                                                          *
*                                                                            *
*****************************************************************************/

#define C 0   /* Datentyp Code */
#define W 1   /* Datentyp Word */
#define B 2   /* Datentyp Byte */
#define A 3   /* Datentyp ASCII */

/*****************************************************************************
Definitionen der IDs fr die Adressierungsarten
*****************************************************************************/
#define implicit              0
#define unknown               1
#define mnem_aa               2
#define fwait_op              3
#define imul                  4
#define opcode0F              5
#define mult                  7
#define floatingp             8
#define prefix                9
#define offset               10
#define address              11
#define disp8                12
#define disp16               13
#define data8                14
#define data8i               15
#define data16               16
#define data16_1             17
#define data16_data8         18
#define reg16                19
#define reg8_data8           20
#define reg16_data16         21

#define modregrm             30
#define mod000rm             31
#define mod0srrm             32
#define modr16rm             33
#define modxxxrm             34

/*****************************************************************************
String-Array mit den 8086-Mnemonics
*****************************************************************************/
char

  /* 00...3F, 80...83 */

  _ADD     [4] ="add",            /* 00...07, 80...83 */
  _ADD_AL  [8] ="add al,",
  _ADD_AX  [8] ="add ax,",

  _OR      [3] ="or",             /* 08...0F, 80...83 */
  _OR_AL   [7] ="or al,",
  _OR_AX   [7] ="or ax,",

  _ADC     [4] ="adc",            /* 10...17, 80...83 */
  _ADC_AL  [8] ="adc al,",
  _ADC_AX  [8] ="adc ax,",

  _SBB     [4] ="sbb",            /* 18...1F, 80...83 */
  _SBB_AL  [8] ="sbb al,",
  _SBB_AX  [8] ="sbb ax,",

  _AND     [4] ="and",            /* 20...27, 80...83 */
  _AND_AL  [8] ="and al,",        
  _AND_AX  [8] ="and ax,",        
  _SEG_ES  [3] ="es",
  _DAA     [4] ="daa",

  _SUB     [4] ="sub",            /* 28...2F, 80...83 */
  _SUB_AL  [8] ="sub al,",        
  _SUB_AX  [8] ="sub ax,",        
  _SEG_CS  [3] ="cs",
  _DAS     [4] ="das",
                                  /* 30...37, 80...83 */
  _XOR     [4] ="xor",            
  _XOR_AL  [8] ="xor al,",        
  _XOR_AX  [8] ="xor ax,",
  _SEG_SS  [3] ="ss",
  _AAA     [4] ="aaa",
                                  /* 38...3F, 80...83 */
  _CMP     [4] ="cmp",
  _CMP_AL  [8] ="cmp al,",
  _CMP_AX  [8] ="cmp ax,",
  _SEG_DS  [3] ="ds",
  _AAS     [4] ="aas",

  /* 40...5F, 8F, FE, FF */

  _INC     [4] ="inc",            /* 40...47, FE, FF */
  _DEC     [4] ="dec",            /* 48...4F, FE, FF */
  _PUSH    [5] ="push",           /* 50...57, FF */
  _POP     [4] ="pop",            /* 58...5F, 8F */

  /* 70...7F */

  _JO      [3] ="jo",             /* 70 */
  _JNO     [4] ="jno",            /* 71 */
  _JB      [3] ="jb",             /* 72 */
  _JAE     [4] ="jae",            /* 73 */
  _JE      [3] ="je",             /* 74 */
  _JNE     [4] ="jne",            /* 75 */
  _JBE     [4] ="jbe",            /* 76 */
  _JA      [3] ="ja",             /* 77 */
  _JS      [3] ="js",             /* 78 */
  _JNS     [4] ="jns",            /* 79 */
  _JP      [3] ="jp",             /* 7A */
  _JNP     [4] ="jnp",            /* 7B */
  _JL      [3] ="jl",             /* 7C */
  _JGE     [4] ="jge",            /* 7D */
  _JLE     [4] ="jle",            /* 7E */
  _JG      [3] ="jg",             /* 7F */

  /* 84...8E, A0...A3, B0...BF, C6, C7, F6, F7 */

  _TEST    [5] ="test",           /* 84, 85, F6, F7 */
  _XCHG    [5] ="xchg",           /* 86, 87 */
  _MOV     [4] ="mov",            /* 88...8C, 8E, A0...A3, B0...BF, C6, C7 */
  _LEA     [4] ="lea",            /* 8D */

  /* 90...9F, E8, FF */

  _NOP     [4] ="nop",            /* 90 */
  _XCHG_AX [9] ="xchg ax,",       /* 91...97 */
  _CBW     [4] ="cbw",            /* 98 */
  _CWD     [4] ="cwd",            /* 99 */
  _CALL    [5] ="call",           /* 9A, E8, FF */
  _FWAIT   [6] ="fwait",          /* 9B */
  _PUSHF   [6] ="pushf",          /* 9C */
  _POPF    [5] ="popf",           /* 9D */
  _SAHF    [5] ="sahf",           /* 9E */
  _LAHF    [5] ="lahf",           /* 9F */

  /* A4...A7, AA...AF */

  _MOVSB   [6] ="movsb",          /* A4 */
  _MOVSW   [6] ="movsw",          /* A5 */
  _CMPSB   [6] ="cmpsb",          /* A6 */
  _CMPSW   [6] ="cmpsw",          /* A7 */
  _TEST_AL [9] ="test al,",       /* A8 */
  _TEST_AX [9] ="test ax,",       /* A9 */
  _STOSB   [6] ="stosb",          /* AA */
  _STOSW   [6] ="stosw",          /* AB */
  _LODSB   [6] ="lodsb",          /* AC */
  _LODSW   [6] ="lodsw",          /* AD */
  _SCASB   [6] ="scasb",          /* AE */
  _SCASW   [6] ="scasw",          /* AF */

  /* C2...C5, CA...CF */

  _RET     [4] ="ret",            /* C2, C3 */
  _LES     [4] ="les",            /* C4 */
  _LDS     [4] ="lds",            /* C5 */
  _RETF    [5] ="retf",           /* CA, CB */
  _INT_3   [6] ="int 3",          /* CC */
  _INT     [5] ="int ",           /* CD */
  _INTO    [5] ="into",           /* CE */
  _IRET    [5] ="iret",           /* CF */

  /* D0...D7 */

  _ROL     [4] ="rol",            /* D0...D3 */
  _ROR     [4] ="ror",            /* D0...D3 */
  _RCL     [4] ="rcl",            /* D0...D3 */
  _RCR     [4] ="rcr",            /* D0...D3 */
  _SHL     [4] ="shl",            /* D0...D3 */
  _SHR     [4] ="shr",            /* D0...D3 */
  _SAR     [4] ="sar",            /* D0...D3 */
  _AAM     [4] ="aam",            /* D4 */
  _AAD     [4] ="aad",            /* D5 */
  _XLAT    [5] ="xlat",           /* D7 */

  /* E0...E7, E9...EF, FF */

  _LOOPNZ  [7] ="loopnz",         /* E0 */
  _LOOPZ   [6] ="loopz",          /* E1 */
  _LOOP    [5] ="loop",           /* E2 */
  _JCXZ    [5] ="jcxz",           /* E3 */
  _IN_AL   [7] ="in al,",         /* E4 */
  _IN_AX   [7] ="in ax,",         /* E5 */
  _OUT     [5] ="out ",           /* E6, E7 */
  _JMP     [4] ="jmp",            /* E9...EA, FF */
  _JMP_S   [10]="jmp short",      /* EB */
  _IN_ALDX [9] ="in al,dx",       /* EC */
  _IN_AXDX [9] ="in ax,dx",       /* ED */
  _OUT_DXAL[10]="out dx,al",      /* EE */
  _OUT_DXAX[10]="out dx,ax",      /* EF */

  /* F0...FD */

  _LOCK    [5] ="lock",           /* F0 */
  _REPNZ   [6] ="repnz",          /* F2 */
  _REPZ    [5] ="repz",           /* F3 */
  _HLT     [4] ="hlt",            /* F4 */
  _CMC     [4] ="cmc",            /* F5 */
  _NOT     [4] ="not",            /* F6, F7 */
  _NEG     [4] ="neg",            /* F6, F7 */
  _MUL     [4] ="mul",            /* F6, F7 */
  _IMUL    [5] ="imul",           /* F6, F7 */
  _DIV     [4] ="div",            /* F6, F7 */
  _IDIV    [5] ="idiv",           /* F6, F7 */
  _CLC     [4] ="clc",            /* F8 */
  _STC     [4] ="stc",            /* F9 */
  _CLI     [4] ="cli",            /* FA */
  _STI     [4] ="sti",            /* FB */
  _CLD     [4] ="cld",            /* FC */
  _STD     [4] ="std",            /* FD */

  /* Spezielle Mnemonics fr 80287- und NEC-Prozessoren */

  _SLDT    [5] ="sldt",
  _STR     [4] ="str",
  _LLDT    [5] ="lldt",
  _LTR     [4] ="ltr",
  _VERR    [5] ="verr",
  _VERW    [5] ="verw",
  _SGDT    [5] ="sgdt",
  _SIDT    [5] ="sidt",
  _LGDT    [5] ="lgdt",
  _LIDT    [5] ="lidt",
  _SMSW    [5] ="smsw",
  _LMSW    [5] ="lmsw",
  _LAR     [4] ="lar",
  _LSL     [4] ="lsl",
  _CLTS    [5] ="clts",
  _TESTBIT [8] ="testbit",
  _CLRBIT  [7] ="clrbit",
  _SETBIT  [7] ="setbit",
  _NOTBIT  [7] ="notbit",
  _ADD4S   [6] ="add4s",
  _SUB4S   [6] ="sub4s",
  _CMP4S   [6] ="cmp4s",
  _ROL4    [5] ="rol4",
  _ROR4    [5] ="ror4",
  _STOBITS [8] ="stobits",
  _LODBITS [8] ="lodbits",
  _CALL80  [7] ="call80",
  _PUSHA   [6] ="pusha",
  _POPA    [5] ="popa",
  _BOUND   [6] ="bound",
  _ARPL    [5] ="arpl",
  _REPNC   [6] ="repnc",
  _REPC    [5] ="repc",
  _PUSH_   [6] ="push ",
  _INSB    [5] ="insb",
  _INSW    [5] ="insw",
  _OUTSB   [6] ="outsb",
  _OUTSW   [6] ="outsw",
  _ENTER   [6] ="enter",
  _LEAVE   [6] ="leave",

  /* Datentypen */

  _DB      [3] ="db",
  _OFFSET  [8] ="offset ";

/*****************************************************************************
String-Array mit den 80x87-Mnemonics
*****************************************************************************/
char
  _F2XM1    [6] ="f2xm1",
  _F4X4     [5] ="f4x4",
  _FABS     [5] ="fabs",
  _FADD     [5] ="fadd",
  _FBANK_0  [8] ="fbank 0",
  _FBANK_1  [8] ="fbank 1",
  _FBANK_2  [8] ="fbank 2",
  _FBLD     [5] ="fbld",
  _FBSTP    [6] ="fbstp",
  _FCHS     [5] ="fchs",
  _FCOM     [5] ="fcom",
  _FCOMP    [6] ="fcomp",
  _FCOMPP   [7] ="fcompp",
  _FCOS     [5] ="fcos",
  _FDECSTP  [8] ="fdecstp",
  _FDISI    [23]="db 0DBh,0E1h   ; fdisi",
  _FDIV     [5] ="fdiv",
  _FDIVR    [6] ="fdivr",
  _FENI     [22]="db 0DBh,0E0h   ; feni",
  _FFREE    [6] ="ffree",
  _FIADD    [6] ="fiadd",
  _FICOM    [6] ="ficom",
  _FICOMP   [7] ="ficomp",
  _FIDIV    [6] ="fidiv",
  _FIDIVR   [7] ="fidivr",
  _FILD     [5] ="fild",
  _FIMUL    [6] ="fimul",
  _FINCSTP  [8] ="fincstp",
  _FIST     [5] ="fist",
  _FISTP    [6] ="fistp",
  _FISUB    [6] ="fisub",
  _FISUBR   [7] ="fisubr",
  _FLD      [4] ="fld",
  _FLD1     [5] ="fld1",
  _FLDCW    [6] ="fldcw",
  _FLDENV   [7] ="fldenv",
  _FLDL2E   [7] ="fldl2e",
  _FLDL2T   [7] ="fldl2t",
  _FLDLG2   [7] ="fldlg2",
  _FLDLN2   [7] ="fldln2",
  _FLDPI    [6] ="fldpi",
  _FLDZ     [5] ="fldz",
  _FMUL     [5] ="fmul",
  _FNCLEX   [17]="fnclex   ; fclex",
  _FNINIT   [17]="fninit   ; finit",
  _FNOP     [5] ="fnop",
  _FPATAN   [7] ="fpatan",
  _FPREM    [6] ="fprem",
  _FPREM1   [7] ="fprem1",
  _FPTAN    [6] ="fptan",
  _FRNDINT  [8] ="frndint",
  _FRSTOR   [7] ="frstor",
  _FSAVE    [6] ="fsave",
  _FSCALE   [7] ="fscale",
  _FSETPM   [7] ="fsetpm",
  _FSIN     [5] ="fsin",
  _FSINCOS  [8] ="fsincos",
  _FSQRT    [6] ="fsqrt",
  _FST      [4] ="fst",
  _FSTCW    [6] ="fstcw",
  _FSTENV   [7] ="fstenv",
  _FSTP     [5] ="fstp",
  _FSTSW    [6] ="fstsw",
  _FSTSW_AX [9] ="fstsw ax",
  _FSUB     [5] ="fsub",
  _FSUBR    [6] ="fsubr",
  _FTST     [5] ="ftst",
  _FUCOM    [6] ="fucom",
  _FUCOMP   [7] ="fucomp",
  _FUCOMPP  [8] ="fucompp",
  _FXAM     [5] ="fxam",
  _FXCH     [5] ="fxch",
  _FXTRACT  [8] ="fxtract",
  _FYL2X    [6] ="fyl2x",
  _FYL2XP1  [8] ="fyl2xp1";

/*****************************************************************************
String-Array mit den 8086-Registern (reg [w] [nr])
*****************************************************************************/
char *regtab[2][8]={ "al", "cl", "dl", "bl", "ah", "ch", "dh", "bh",
                     "ax", "cx", "dx", "bx", "sp", "bp", "si", "di" };

char *sregtab[4]={ "es", "cs", "ss", "ds" };

/*****************************************************************************
Effektive Adressen (abhngig von rm und mod des ModRM-Bytes)
*****************************************************************************/
char *modrmtab[8]={ "bx+si","bx+di","bp+si","bp+di","si","di","bp","bx" };

/*****************************************************************************
Mnemonic-Tabellen fr 8086-Opcodes 80-83, D0-D3, F6-F7, FE und FF
*****************************************************************************/
char *mnemtab80[8]={ _ADD, _OR,  _ADC, _SBB, _AND, _SUB, _XOR, _CMP };
char *mnemtabD0[8]={ _ROL, _ROR, _RCL, _RCR, _SHL, _SHR, _DB,  _SAR };
char *mnemtabF6[8]={ _TEST, _DB, _NOT, _NEG, _MUL, _IMUL,_DIV, _IDIV};
char *mnemtabFE[8]={ _INC, _DEC, _DB,  _DB,  _DB,  _DB,  _DB,  _DB  };
char *mnemtabFF[8]={ _INC, _DEC, _CALL,_CALL,_JMP, _JMP, _PUSH,_DB  };
char *mnemtab0F00[8]={ _SLDT,_STR, _LLDT,_LTR, _VERR,_VERW,_DB,  _DB  };
char *mnemtab0F01[8]={ _SGDT,_SIDT,_LGDT,_LIDT,_SMSW,_DB,  _LMSW,_DB  };
char *mnemtab0F10[4]={ _TESTBIT,   _CLRBIT,    _SETBIT,    _NOTBIT    };

/*****************************************************************************
Mnemonic-Tabellen fr 80x87-Opcodes
*****************************************************************************/
char *fmnemtab8[8]={ _FADD,_FMUL,_FCOM,_FCOMP,_FSUB,_FSUBR,_FDIV,_FDIVR};
char *fmnemtab9[8]={ _FLD, "",_FST,_FSTP,_FLDENV,_FLDCW,_FSTENV,_FSTCW};
char *fmnemtabA[8]={ _FIADD,_FIMUL,_FICOM,_FICOMP,_FISUB,_FISUBR,_FIDIV,_FIDIVR};
char *fmnemtabB[8]={ _FILD, "",_FIST,_FISTP, "",_FLD, "",_FSTP};
char *fmnemtabC[8]={ _FADD,_FMUL, "", "",_FSUBR,_FSUB,_FDIVR,_FDIV};
char *fmnemtabD[8]={ _FLD, "",_FST,_FSTP,_FRSTOR, "",_FSAVE,_FSTSW};
char *fmnemtabE[8]={ _FFREE, "",_FST,_FSTP,_FUCOM,_FUCOMP, "", ""};
char *fmnemtabF[8]={ _FILD, "",_FIST,_FISTP,_FBLD,_FILD,_FBSTP,_FISTP};

/*****************************************************************************
Mnemonic-Tabellen fr 8086-Opcodes 00...FF und deren IDs
*****************************************************************************/
struct OPCODE { char *mnem; int id; } opcode[256]={

  _ADD     , modregrm,                 /* 00...0F */
  _ADD     , modregrm,
  _ADD     , modregrm,
  _ADD     , modregrm,
  _ADD_AL  , data8,
  _ADD_AX  , data16,
  _PUSH    , mult,
  _POP     , mult,
  _OR      , modregrm,
  _OR      , modregrm,
  _OR      , modregrm,
  _OR      , modregrm,
  _OR_AL   , data8,
  _OR_AX   , data16,
  _PUSH    , mult,
  _DB      , opcode0F,

  _ADC     , modregrm,                 /* 10...1F */
  _ADC     , modregrm,
  _ADC     , modregrm,
  _ADC     , modregrm,
  _ADC_AL  , data8,
  _ADC_AX  , data16,
  _PUSH    , mult,
  _POP     , mult,
  _SBB     , modregrm,
  _SBB     , modregrm,
  _SBB     , modregrm,
  _SBB     , modregrm,
  _SBB_AL  , data8,
  _SBB_AX  , data16,
  _PUSH    , mult,
  _POP     , mult,

  _AND     , modregrm,                 /* 20...2F */
  _AND     , modregrm,
  _AND     , modregrm,
  _AND     , modregrm,
  _AND_AL  , data8,
  _AND_AX  , data16,
  _SEG_ES  , prefix,
  _DAA     , implicit,
  _SUB     , modregrm,
  _SUB     , modregrm,
  _SUB     , modregrm,
  _SUB     , modregrm,
  _SUB_AL  , data8,
  _SUB_AX  , data16,
  _SEG_CS  , prefix,
  _DAS     , implicit,

  _XOR     , modregrm,                 /* 30...3F */
  _XOR     , modregrm,
  _XOR     , modregrm,
  _XOR     , modregrm,
  _XOR_AL  , data8,
  _XOR_AX  , data16,
  _SEG_SS  , prefix,
  _AAA     , implicit,
  _CMP     , modregrm,
  _CMP     , modregrm,
  _CMP     , modregrm,
  _CMP     , modregrm,
  _CMP_AL  , data8,
  _CMP_AX  , data16,
  _SEG_DS  , prefix,
  _AAS     , implicit,

  _INC     , mult,                     /* 40...4F */
  _INC     , mult,
  _INC     , mult,
  _INC     , mult,
  _INC     , mult,
  _INC     , mult,
  _INC     , mult,
  _INC     , mult,
  _DEC     , mult,
  _DEC     , mult,
  _DEC     , mult,
  _DEC     , mult,
  _DEC     , mult,
  _DEC     , mult,
  _DEC     , mult,
  _DEC     , mult,

  _PUSH    , mult,                     /* 50...5F */
  _PUSH    , mult,
  _PUSH    , mult,
  _PUSH    , mult,
  _PUSH    , mult,
  _PUSH    , mult,
  _PUSH    , mult,
  _PUSH    , mult,
  _POP     , mult,
  _POP     , mult,
  _POP     , mult,
  _POP     , mult,
  _POP     , mult,
  _POP     , mult,
  _POP     , mult,
  _POP     , mult,

  _PUSHA   , implicit,                 /* 60...6F */
  _POPA    , implicit,
  _BOUND   , modr16rm,
  _ARPL    , modregrm,
  _REPNC   , prefix,
  _REPC    , prefix,
  _DB      , unknown,
  _DB      , unknown,
  _PUSH_   , data16,
  _IMUL    , imul,
  _PUSH_   , data8i,
  _IMUL    , imul,
  _INSB    , implicit,
  _INSW    , implicit,
  _OUTSB   , implicit,
  _OUTSW   , implicit,

  _JO      , disp8,                    /* 70...7F */
  _JNO     , disp8,
  _JB      , disp8,
  _JAE     , disp8,
  _JE      , disp8,
  _JNE     , disp8,
  _JBE     , disp8,
  _JA      , disp8,
  _JS      , disp8,
  _JNS     , disp8,
  _JP      , disp8,
  _JNP     , disp8,
  _JL      , disp8,
  _JGE     , disp8,
  _JLE     , disp8,
  _JG      , disp8,

  0        , modxxxrm,                 /* 80...8F */
  0        , modxxxrm,
  0        , modxxxrm,
  0        , modxxxrm,
  _TEST    , modregrm,
  _TEST    , modregrm,
  _XCHG    , modregrm,
  _XCHG    , modregrm,
  _MOV     , modregrm,
  _MOV     , modregrm,
  _MOV     , modregrm,
  _MOV     , modregrm,
  _MOV     , mod0srrm,
  _LEA     , modr16rm,
  _MOV     , mod0srrm,
  _POP     , mod000rm,

  _NOP     , implicit,                 /* 90...9F */
  _XCHG_AX , reg16,
  _XCHG_AX , reg16,
  _XCHG_AX , reg16,
  _XCHG_AX , reg16,
  _XCHG_AX , reg16,
  _XCHG_AX , reg16,
  _XCHG_AX , reg16,
  _CBW     , implicit,
  _CWD     , implicit,
  _CALL    , address,
  _FWAIT   , fwait_op,
  _PUSHF   , implicit,
  _POPF    , implicit,
  _SAHF    , implicit,
  _LAHF    , implicit,

  _MOV     , offset,                   /* A0...AF */
  _MOV     , offset,
  _MOV     , offset,
  _MOV     , offset,
  _MOVSB   , implicit,
  _MOVSW   , implicit,
  _CMPSB   , implicit,
  _CMPSW   , implicit,
  _TEST_AL , data8,
  _TEST_AX , data16,
  _STOSB   , implicit,
  _STOSW   , implicit,
  _LODSB   , implicit,
  _LODSW   , implicit,
  _SCASB   , implicit,
  _SCASW   , implicit,

  _MOV     , reg8_data8,               /* B0...BF */
  _MOV     , reg8_data8,
  _MOV     , reg8_data8,
  _MOV     , reg8_data8,
  _MOV     , reg8_data8,
  _MOV     , reg8_data8,
  _MOV     , reg8_data8,
  _MOV     , reg8_data8,
  _MOV     , reg16_data16,
  _MOV     , reg16_data16,
  _MOV     , reg16_data16,
  _MOV     , reg16_data16,
  _MOV     , reg16_data16,
  _MOV     , reg16_data16,
  _MOV     , reg16_data16,
  _MOV     , reg16_data16,

  0        , modxxxrm,                 /* C0...CF */
  0        , modxxxrm,
  _RET     , data16_1,
  _RET     , implicit,
  _LES     , modr16rm,
  _LDS     , modr16rm,
  _MOV     , mod000rm,
  _MOV     , mod000rm,
  _ENTER   , data16_data8,
  _LEAVE   , implicit,
  _RETF    , data16_1,
  _RETF    , implicit,
  _INT_3   , implicit,
  _INT     , data8,
  _INTO    , implicit,
  _IRET    , implicit,

  0        , modxxxrm,                 /* D0...DF */
  0        , modxxxrm,
  0        , modxxxrm,
  0        , modxxxrm,
  _AAM     , mnem_aa,
  _AAD     , mnem_aa,
  _DB      , unknown,
  _XLAT    , implicit,
  _DB      , floatingp,
  _DB      , floatingp,
  _DB      , floatingp,
  _DB      , floatingp,
  _DB      , floatingp,
  _DB      , floatingp,
  _DB      , floatingp,
  _DB      , floatingp,

  _LOOPNZ  , disp8,                    /* E0...EF */
  _LOOPZ   , disp8,
  _LOOP    , disp8,
  _JCXZ    , disp8,
  _IN_AL   , data8,
  _IN_AX   , data8,
  _OUT     , data8,
  _OUT     , data8,
  _CALL    , disp16,
  _JMP     , disp16,
  _JMP     , address,
  _JMP_S   , disp8,
  _IN_ALDX , implicit,
  _IN_AXDX , implicit,
  _OUT_DXAL, implicit,
  _OUT_DXAX, implicit,

  _LOCK    , prefix,                   /* F0...FF */
  _DB      , unknown,
  _REPNZ   , prefix,
  _REPZ    , prefix,
  _HLT     , implicit,
  _CMC     , implicit,
  0        , modxxxrm,
  0        , modxxxrm,
  _CLC     , implicit,
  _STC     , implicit,
  _CLI     , implicit,
  _STI     , implicit,
  _CLD     , implicit,
  _STD     , implicit,
  0        , modxxxrm,
  0        , modxxxrm };

/*****************************************************************************
                             Ende von R86.H
*****************************************************************************/
