#include <stdio.h>
#include <conio.h>
#include <string.h>

int mnucol=0x3F, subcol=0x30, letcol=0x3E, actcol=0x4F, hlpcol=0x1F, bkgcol=0x17;
int COLS, ROWS;

char hlpfile[80]="", hlpbuf[10000], *hlptext=
  " Scroll:  <PgUp>  <PgDn>  <CuUp>  <CuDn>"
  "                            End:  <ESC> ";

struct text_info ti;

typedef struct men
{
  char *tit, *hlp;
  int hnr, id;
  struct men *sub[16];
} MENU;

void (*mnuhandler)(int);

void initmnu(void (*func)(int), char *file)
{
  mnuhandler=func;
  strcpy(hlpfile,file);
  gettextinfo(&ti), COLS=ti.screenwidth, ROWS=ti.screenheight;
  _setcursortype(_NOCURSOR);
  textattr(bkgcol);
  clrscr();
}

void endmnu(void)
{
  _setcursortype(_NORMALCURSOR);
  textattr(7);
  clrscr();
}

void menuhlp(int n)
{
  FILE *fp;
  char *hp;
  int i, l, y=0;
  long foffs;

  if(n)
  {
    if((fp=fopen(hlpfile,"rb"))!=NULL)
    {
      fseek(fp, (n-1)*sizeof(long), SEEK_SET);
      fread(&foffs, sizeof(long), 1, fp);

      if(foffs)
      {
        fseek(fp, foffs, SEEK_SET);
        for(l=0, hp=hlpbuf; fread(hp,1,1,fp) && *hp!=EOF; hp++) if(!(*hp)) l++;
        fclose(fp);

        textattr(hlpcol), clrscr(), textattr(subcol), cputs(hlptext), textattr(hlpcol);

        for(;;)
        {
          for(i=0, hp=hlpbuf; i<y; i++)
          {
            if(*hp!=EOF) hp+=strlen(hp)+1;
          }

          for(i=2; i<=ROWS; i++)
          {
            gotoxy(1,i);
            if(*hp!=EOF) cputs(hp), hp+=strlen(hp)+1;
            clreol();
          }

          switch(getch())
          {
            case 27: textattr(bkgcol); clrscr(); return;
            case 0: switch(getch()) {
              case 72: if(y) y--; break;
              case 80: if(l>y+ROWS-1) y++; break;
              case 73: if(y) y-=(y>ROWS-1)?ROWS-1:y; break;
              case 81: if(l>y+ROWS-1) y+=(l>y+2*(ROWS-1))?ROWS-1:l-y-(ROWS-1);
                break; } break;
          }
        }
      }
    }
  }
}

int countch(char *s)
{
  int n=0;
  while(*s)
  {
    if(*s!='^') n++;
    s++;
  }
  return(n);
}

void printit(char *s, int f)
{
  char c=0;
  while(*s)
  {
    if(*s=='^')
    {
      c=*(++s);
      if(f) textattr(letcol);
      cprintf("%c",c);
      if(f) textattr(subcol);
    }
    else cprintf("%c",*s);
    s++;
  }
}

int printmnu(MENU *m, int n)
{
  MENU *p;
  int i,u,o,a,x,x1;

  gotoxy(1,1); textattr(mnucol);
  cputs(" "), printit(m->tit,0), cputs(": ");
  for(a=0; m->sub[a]; a++);
  x=countch(m->tit)+3;
  for(i=0, u=0, o=a; i<o; i++)
  {
    x1=COLS; if(u) x1-=3; if(i+1<a) x1-=3;
    p=m->sub[i]; x+=countch(p->tit)+2;
    if(x>x1)
    {
      if(i<=n) x=countch(m->tit)+countch(p->tit)+5, u=i;
      else o=i;
    }
  }
  textattr(subcol); if(u>0) cputs("...");
  for(i=u;i<o;i++)
  {
    p=m->sub[i];
    if(i==n)
    {
      textattr(actcol);
      cputs(" "), printit(p->tit,0), cputs(" ");
      textattr(subcol);
    }
    else
      cputs(" "), printit(p->tit,1), cputs(" ");
  }
  if(o<a) cputs("...");
  clreol(); gotoxy(1,2); textattr(hlpcol);
  p=m->sub[n]; cputs(p->hlp); clreol();
  return(a);
}

int mnukey(MENU *m, char c)
{
  MENU *p;
  char h, *t;
  int i;

  c=toupper(c);
  for(i=0; p=m->sub[i]; i++)
  {
    t=p->tit;
    while(*t)
    {
      if(*t=='^') if(toupper(*(t+1))==c) return(i);
      t++;
    }
  }
  return(EOF);
}

void menudlg(MENU *m)
{
  MENU *p;
  char c=0;
  int n=0,n1,a;

  for(;;)
  {
    a=printmnu(m,n); p=m->sub[n];
    if(c!=13) c=getch();
    switch(c)
    {
      case 0:
        switch(getch())
        {
          case 59: menuhlp(p->hnr); break;
          case 77: n++; n%=a; break;
          case 75: n--; if(n<0) n=a-1;
        } break;
      case 27: return;
      case 13: c=0;
        if(!p->id) menudlg(p);
        else if(p->id==EOF) return;
          else (*mnuhandler)(p->id);
      default: if((n1=mnukey(m,c))!=EOF) n=n1,c=13;
    }
  }
}
