/*****************************************************************************
*                                                                            *
*  GENHLP.C: Hilfsprogramm zum Uebersetzen von Hilfstextdateien fr das      *
*            Menuesystem MENU.H                                              *
*                                                                            *
*  Hilfstextdateien werden im ASCII-Format erstellt und muessen mit diesem   *
*  Programm uebersetzt werden, bevor sie von der Menuebibliothek benutzt     *
*  werden koennen. Zeilen, die mit einem Semikolon beginnen, werden          *
*  innerhalb der ASCII-Datei als Kommentar betrachtet und von GENHLP         *
*  ignoriert. Die mit dem Feld helpnr in der Menuestruktur jedes Menue-      *
*  punktes korrespondierenden Hilfstextnummern (1...256), denen der          *
*  entsprechende Hilfstext folgt, werden direkt hinter einem Punkt am        *
*  Zeilenbeginn angegeben. Die uebersetzte Datei erhaelt am Anfang eine      *
*  Indextabelle aus 256 Elementen, wobei die Position jedes Elementes        *
*  dem Wert einer Hilfstextnummer minus 1 (0...255) entspricht und die       *
*  Elemente selbst den Dateioffset enthalten, an dem der passsende Hilfstext *
*  zu finden ist. Jede Zeile des Hilfstextes in dem Compilat ist mit einer   *
*  0 abgeschlossen, das Ende eines jeden Hilfstextabschnittes ist mit EOF    *
*  (Zeichen -1) gekennzeichnet.                                              *
*                                                                            *
*  (C) 1992 Stefan Bion                                                      *
*                                                                            *
*****************************************************************************/
#include <stdio.h>
#include <string.h>

typedef unsigned char BYTE;
typedef unsigned int  WORD;
typedef unsigned long DWORD;

FILE *srcfp, *objfp;
char srcfile[80], objfile[80];
DWORD idxtab[256], fileoffs=sizeof(idxtab);
char srcline[256], txtend=EOF;
WORD linecounter=0, idxptr, linelen;

void main(int argc, char *argv[])
{
  if(argc!=2)
  {
    printf("GENHLP V1.00  (C) 1992 Stefan Bion\n");
    printf("Hilfsprogramm zum Uebersetzen von Hilfstextdateien fr das Menuesystem MENU.H\n\n");
    printf("Aufruf: GENHLP datei\n\n");
    printf("Der Name der zu uebersetzenden Datei muss das Suffix .txt enthalten, welcher\n");
    printf("in der Kommandozeile jedoch nicht mit anzugeben ist. Die uebersetzte Datei\n");
    printf("erhaelt das Suffix .hlp\n");
    exit(1);
  }

  strcat(strcpy(srcfile, argv[1]), ".txt");
  strcat(strcpy(objfile, argv[1]), ".hlp");

  if((srcfp=fopen(srcfile,"r"))==NULL)
    printf("Datei %s kann nicht zum Lesen geoeffnet werden\n", srcfile),
    exit(1);

  if((objfp=fopen(objfile,"w+b"))==NULL)
    printf("Datei %s kann nicht zum Schreiben geoeffnet werden\n", objfile),
    fclose(srcfp), exit(1);

  fwrite(idxtab, sizeof(idxtab), 1, objfp);

  while(fgets(srcline, sizeof(srcline), srcfp))
  {
    linecounter++;
    if(srcline[0]!=';')      /* Kommentar nach Semikolon */
    {
      if(srcline[0]=='.')    /* Hilfstextnummer nach Punkt */
      {
        if(fileoffs>sizeof(idxtab)) fwrite(&txtend, 1, 1, objfp), fileoffs++;
        idxptr=atoi(srcline+1);
        if(!(idxptr>=1 && idxptr<=256))
        {
          printf("Fehlerhafte Hilfstextnummer in Zeile %d\n", linecounter);
          fclose(srcfp), fclose(objfp), remove(objfile), exit(1);
        }
        idxtab[idxptr-1]=fileoffs;
      }
      else                   /* Hilfstextzeile */
      {
        linelen=strlen(srcline);
        if(srcline[linelen-1]=='\n') srcline[--linelen]=0;
        fwrite(srcline, 1, linelen+1, objfp);
        fileoffs+=linelen+1;
      }
    }
  }
  fwrite(&txtend, 1, 1, objfp);
  fseek(objfp, 0, SEEK_SET);
  fwrite(idxtab, sizeof(idxtab), 1, objfp);
  fclose(srcfp), fclose(objfp), exit(0);
}
