#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <dir.h>
#include <dos.h>
#include <string.h>
#include <fcntl.h>

#define true 1
#define false 0

int src_time, obj_time, src_date, obj_date;
char src_name[128], obj_name[128], a86call[128]="A86 ", extension[5]=".COM";

/**************************************************************************
 Name, Datum und Uhrzeit der OBJ-Datei ermitteln und zurckgeben, ob gef.
**************************************************************************/

int search_obj(void)
{
  struct ffblk objdta;
  char notfound;

  notfound=findfirst(obj_name,&objdta,0x27);
  obj_time=objdta.ff_ftime;
  obj_date=objdta.ff_fdate;
  return(notfound);
}

/**************************************************************************
 Assemblieren der Quelldatei mit Einbeziehung der im Quelltext angegebenen
 #INCLUDE- und #LINK-Dateien.
**************************************************************************/

void make86(char source_file[20])
{
  char scan_flag=true, i=0,
       read_line[128], inc_path[64]="\0", include_files[256]="\0",
       link_files[128]="\0", obj_file[16], command_line[512]="\0";

  FILE *fp;

  strcpy(obj_file,source_file);
  while(i<13 && obj_file[i]!='.' && obj_file[i]!=0) i++;
  obj_file[i]=0;
  strcat(obj_file,extension);

  strcat(source_file," ");
  strcpy(inc_path,getenv("A86INC"));

  if((fp=fopen(source_file,"r"))!=NULL)
  {
    while(!feof(fp) && scan_flag)
    {
      fscanf(fp,"%s",&read_line);
      if(strstr(strupr(read_line),"#INCLUDE")!=NULL)
      {
        fscanf(fp,"%s",&read_line);
        strcat(include_files,inc_path);
        strcat(include_files,read_line);
        strcat(include_files," ");
      }
      else
      if(strstr(strupr(read_line),"#LINK")!=NULL)
      {
        fscanf(fp,"%s",&read_line);
        if(strstr(read_line,"!")==NULL)
        {
          strcat(link_files,read_line);
          strcat(link_files," ");
          fclose(fp);
          if((fp=fopen(read_line,"r"))==NULL)
          {
            printf("MAKE86: Error opening linkfile %s\n",strupr(read_line));
            return;
          }
        }
        else scan_flag=false;
      }
    }
    fclose(fp);
  }
  else
  {
    printf("MAKE86: Error opening sourcefile %s\n",strupr(source_file));
    return;
  }

  strcat(command_line,a86call);       /*******************************/
  strcat(command_line,include_files); /* Kommandozeile zusammen-     */
  strcat(command_line,source_file);   /* stellen und A86 aufrufen.   */
  strcat(command_line,link_files);    /*******************************/
  strcat(command_line,obj_file);
  system(command_line);
}

/**************************************************************************
 Hauptprogramm:

 1. Eingabe der Quelldatei (Wildcards erlaubt) in source_file.
 2. Mit findfirst() und findnext() alle dieser Maske entsprechenden Quell-
    dateien suchen. Fr jede gefundene Quelldatei:
 3. Den gefundenen Namen der Quelldatei in src_name, die Zeit in src_time
    und das Datum in src_date speichern.
 4. Den Namen der Quelldatei (src_name) nach obj_name kopieren und die
    Extension durch extension ersetzen.
 5. Mit Hilfe der Funktion search_obj() die zur Quelldatei gehrende
    Objektdatei (obj_name) suchen, Zeit und Datum in obj_time und obj_date
    speichern.
 6. Wenn keine Objektdatei gefunden wurde, deren Zeit und Datum mit den
    Werten der Quelldatei bereinstimmen:
    a) Namen der Quelldatei (src_name) an die Funktion make86() bergeben
       und assemblieren.
    b) Datum und Uhrzeit der erzeugten Objektdatei gleich den entsprechen-
       den Werten der Quelldatei setzen.
**************************************************************************/

void main(int argc, char *argv[])
{
  struct ffblk srcdta;
  struct ftime dattime;
  char   source_file[128], src_ok, no_objfile, i;
  int    handle;

  if((argc<2) || (argc>3))
  {
    printf(
      "MAKE86 V1.01  Make-Utility fr den Assembler A86  (C) 1991-1992 Stefan Bion\n"\
      "Aufruf: MAKE86 [<a86-optionen>] quelldatei\n\n"\

      "Es knnen die blichen Optionen an A86 bergeben werden. Standardmig werden\n"\
      "COM-Dateien erzeugt. Die Option +O veranlat A86 beispielsweise, OBJ-Dateien\n"\
      "zu erzeugen.\n\n"\

      "Bei Angabe der A86-Quelldatei sind Wildcards zulssig. Es werden nur diejenigen\n"\
      "Module im aktuellen Verzeichnis assembliert,\n\n"\

      "  a) zu denen noch kein OBJ- bzw. COM-Modul existiert, oder\n\n"\

      "  b) deren Erstellungsdatum/-uhrzeit nicht mit dem der zugehrigen\n"\
      "     OBJ- bzw. COM-Module bereinstimmt.\n\n"\

      "Die im Sourcecode als Remark hinter #INCLUDE oder #LINK angegebenen Dateien\n"\
      "werden beim Assemblieren mit einbezogen.\n");
    exit(1);
  }

  if(argc==3)
  {
    strcat(a86call,argv[1]);
    if((strstr(a86call,"+o")!=NULL) || (strstr(a86call,"+O")!=NULL))
    {
      strcpy(extension,".OBJ");
    }
    strcat(a86call," ");
  }

  strcpy(source_file,argv[argc-1]);

  src_ok=findfirst(source_file,&srcdta,0x27); /* 1. Quelldatei */

  while(!src_ok)                /* Fr jede gefundene Quelldatei: */
  {
    strcpy(src_name,srcdta.ff_name);   /* Name, Datum und Uhrzeit */
    src_time=srcdta.ff_ftime;          /* der Quelldatei ermitteln */
    src_date=srcdta.ff_fdate;

    i=0;
    strcpy(obj_name,src_name);
    while(i<13 && obj_name[i]!='.' && obj_name[i]!=0) i++;
    obj_name[i]=0;
    strcat(obj_name,extension);      /* Name der OBJ-Datei */

    no_objfile=search_obj();         /* OBJ-Datei suchen */

    if(no_objfile || src_time!=obj_time || src_date!=obj_date)
    {
      make86(src_name); /* Assemblieren, falls keine OBJ-Datei  */
                        /* vorhanden oder Datum/Zeit verschieden */

      handle=open(src_name,O_RDONLY);  /* Datum und Uhrzeit der erzeugten */
      if(handle!=NULL)                 /* OBJ-Datei auf die Werte der */
      {                                /* assemblierten Quelldatei setzen */
        getftime(handle,&dattime);
        close(handle);
        handle=open(obj_name,O_RDONLY);
        if(handle!=NULL)
        {
          setftime(handle,&dattime);
          close(handle);
        }
      }
    }
    else printf("MAKE86: File %s is up to date\n",obj_name);

    src_ok=findnext(&srcdta);   /* Nchste Quelldatei suchen */
  }
}
