#include <stdio.h>
#include <dos.h>
#include <conio.h>
#include <string.h>

FILE *fp;
int foffs;

int newpal=0;

struct REGPACK r;

unsigned char oldpal[17], usrpal[17];

unsigned char normal[17]=
{
  0x00,0x01,0x02,0x03,0x04,0x05,0x14,0x07,
  0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
  0
};

unsigned char arizona[17]=
{
  0x00,0x26,0x06,0x0E,0x20,0x1C,0x14,0x07,
  0x38,0x26,0x2E,0x34,0x24,0x04,0x27,0x3F,
  0x00
};

unsigned char bordeaux[17]=
{
  0x00,0x15,0x05,0x0D,0x1D,0x0F,0x31,0x07,
  0x38,0x21,0x28,0x0C,0x2F,0x37,0x35,0x3F,
  0x00
};

unsigned char ocean[17]=
{
  0x00,0x01,0x02,0x03,0x04,0x05,0x2E,0x07,
  0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
  0x00
};

unsigned char pastel[17]=
{
  0x00,0x1F,0x13,0x2B,0x35,0x2F,0x2E,0x07,
  0x38,0x0B,0x17,0x3B,0x0F,0x3D,0x37,0x3F,
  0x00
};

unsigned char rugby[17]=
{
  0x00,0x01,0x2F,0x02,0x0C,0x11,0x26,0x07,
  0x38,0x39,0x21,0x0B,0x24,0x37,0x3E,0x3F,
  0x00
};

unsigned char stdcol[17]=
{
  0x00,0x01,0x13,0x23,0x04,0x05,0x14,0x07,
  0x38,0x2B,0x3A,0x1B,0x3C,0x3D,0x3E,0x3F,
  0
};

unsigned char windows[17]=
{
  0x00,0x01,0x02,0x03,0x0C,0x11,0x26,0x07,
  0x38,0x39,0x3A,0x3B,0x1D,0x37,0x3E,0x3F,
  0x00
};

unsigned char wingtp[17]=
{
  0x00,0x18,0x30,0x37,0x20,0x1C,0x14,0x07,
  0x38,0x26,0x2E,0x34,0x24,0x04,0x27,0x3F,
  0
};

enum
{
  lines,                  // Anzahl Zeilen
  backgnd_col,            // Hintergrundfarbe
  inverse_col,            // Inverse Farbe auf Hintergrund
  intens_col,             // Intensive Farbe auf Hintergrund
  active_col,             // Aktiver Titel
  inactive_col,           // Inaktiver Titel
  lightlet_col,           // Erhellter Men-Buchstabe
  menu_col,               // Men-Windows
  mbar_col,               // Men-Auswahlbalken
  shadow_col,             // Schatten
  box_col,                // Fensterfarbe
  bbar_col,               // Fenster-Auswahlbalken
  box_titelcol,           // Fenster-Titel
  box_intenscol,          // Intensive Fensterfarbe
  input_col,              // Eingabefelder
  ctrl_col,               // Steuerzeichen (Editor)
  cursor_col,             // Cursor (Editor)
  ANZ_ELEM
};

unsigned char colors[ANZ_ELEM];

char *colors_txt[]=
{
  "",
  "Dateifenster und Editor",
  "Datei-Auswahlbalken, Editor-Markierung",
  "Hervorgehobener Text Dateifenster",
  "Aktiver Titel",
  "Inaktiver Titel",
  "Hervorgehobener Buchstabe Men",
  "Mens",
  "Gewhlter Menpunkt",
  "Schatten Mens und Fenster",
  "Fenster",
  "Fenster-Auswahlbalken",
  "Fenster-Titel",
  "Intensive Fensterfarbe",
  "Eingabefelder",
  "Steuerzeichen Editor",
  "Cursor Editor"
};

char *bild[]=
{
  " Datei  Verzeichnis  C:\\ASM\\M43\\   ",
  " Name Ŀytes  Zeit  ",
  " [..]  Kopieren        23:31:16",
  " CLUST Lschen     363204:30:00",
  " COPY  Umbenennen  133616:38:36",
  " DSKLA Verschieben 150304:30:00",
  " KEYSP Packen       37604:30:00",
  "\04MEMPA Anlegen     985004:30:00",
  "\04MEMPA556304:30:00",
  "\04MEMPATCH.HLP      3034304:30:00",
  " README  .TXT       395904:30:00",
  " Datei: README.TXT       Zeile 6   ",
  "README.TXT   MemPatch V 4.3   (C) 1",
  "                                   ",
  "MemPatch bietet die Mglichkeit, al",
  "IBM PC unter Titel ",
  "und stellt s                      ",
  "dar, eignet   Eingabe     Intensiv",
  "Rechners nh                      ",
  "~                  Auswahl        ",
  "~           ",
  "~                                  ",
  "~                                  "
};

char *attr[]=
{
  "EEEEEEEDDDDDDDDDDDDDEEEEEEEEEEEEEEE",
  "AACCCCAGGGGGGGGGGGGGGGCCCCAAACCCCAA",
  "AAAAAAAGHHHHHHHHHHHHHGIIAAAAAAAAAAA",
  "AAAAAAAGGFGGGGGGGGGGGGIIAAAAAAAAAAA",
  "AAAAAAAGGFGGGGGGGGGGGGIIAAAAAAAAAAA",
  "AAAAAAAGGFGGGGGGGGGGGGIIAAAAAAAAAAA",
  "AAAAAAAGGFGGGGGGGGGGGGIIAAAAAAAAAAA",
  "ABBBBBBGGFGGGGGGGGGGGGIIBBBBBBBBBBB",
  "ACAAAAAGGGGGGGGGGGGGGGIIAAAAAAAAAAA",
  "ACAAAAAAAIIIIIIIIIIIIIIIAAAAAAAAAAA",
  "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA",
  "EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE",
  "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA",
  "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA",
  "AAABBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBB",
  "BBBBBBBBBBBBJJJJJJJJJJJLLLLLLLJJJJJ",
  "BBBAAAAAAAAAJJJJJJJJJJJJJJJJJJJJJJJ",
  "AAAAAAPAAAAAJJJNNNNNNNNNNJJMMMMMMMM",
  "AAAAAAAAAAAAJJJJJJJJJJJJJJJJJJJJJJJ",
  "OAAAAAAAAAAAJJJJJJJKKKKKKKKKJJJJJJJ",
  "OAAAAAAAAAAAJJJJJJJJJJJJJJJJJJJJJJJ",
  "OAAAAAAAAAAAAAIIIIIIIIIIIIIIIIIIIII",
  "OAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA"
};

void setpal(char *pal)
{
  r.r_ax=0x1002;
  r.r_es=FP_SEG(pal);
  r.r_dx=FP_OFF(pal);
  intr(0x10,&r);
}

void getpal(char *pal)
{
  r.r_ax=0x1009;
  r.r_es=FP_SEG(pal);
  r.r_dx=FP_OFF(pal);
  intr(0x10,&r);
}

void loadpal(char *pal)
{
  newpal=1;
  setpal(pal);

  fputc(1,fp);
  fwrite(pal,1,17,fp);
}

void setblink (int m)
{
  unsigned char c;

  r.r_ax=0x1003;
  r.r_bx=m;
  intr(0x10,&r);

  c=peekb(0x40,0x65);

  if(m) c|=0x20;
  else  c&=0xDF;

  pokeb(0x40,0x65,c);
  outportb(0x3B8,c);
  outportb(0x3D8,c);
}

int editpal(void)
{
  int i, j, col=0, upd=1;

  newpal=1;
  setpal(usrpal);

  clrscr(), _setcursortype(_NOCURSOR), textattr(7);
  gotoxy(14,2);
  cprintf("Palette editieren: \033\032\030\031   Fertig: \021   Abbruch: <Esc>");

  gotoxy(15,12); for(j=0; j<16; j++) textattr(j), cprintf("");
  textattr(7); cprintf("Ŀ");
  gotoxy(15,13); for(j=0; j<16; j++) textattr(j), cprintf("");
  textattr(7); cprintf(" ");
  gotoxy(15,14); for(j=0; j<16; j++) textattr(j), cprintf("");
  textattr(7); cprintf("");

  while(1)
  {
    if(upd)
    {
      gotoxy(15,11);
      for(i=0; i<17; i++) cprintf(" %.2X", usrpal[i]);
      gotoxy(15,15);
      for(i=0; i<17; i++) cprintf(" %c ", i==col ? 24 : ' ');
    }

    switch(getch())
    {
      case 75: col--; if(col<0) col=16; upd=1; break;
      case 77: col++; if(col>16) col=0; upd=1; break;
      case 80: usrpal[col]--; usrpal[col]&=0x3F; setpal(usrpal); break;
      case 72: usrpal[col]++; usrpal[col]&=0x3F; setpal(usrpal); break;
      case 27: setpal(oldpal);
               _setcursortype(_NORMALCURSOR); return(1);
      case 13: fputc(1,fp); fwrite(usrpal,1,17,fp);
               _setcursortype(_NORMALCURSOR); return(0);
    }
  }
}

void main(void)
{
  int col, i, j, n;
  char c, e, u, s[100];

  getpal(oldpal);

  if((fp=fopen("FM.COM","r+b"))==NULL)
    puts("Kann FM.COM nicht ffnen."), exit(1);

/* Farbpalette: */

  fseek(fp,5,SEEK_SET), fread(&foffs,1,2,fp), foffs-=256;
  fseek(fp,foffs,SEEK_SET); c=fgetc(fp); fread(usrpal,1,17,fp);
  fseek(fp,foffs,SEEK_SET);

  do
  {
    i=0; clrscr();
    cprintf("Welche Farbpalette soll verwendet werden?\r\n"
            "\r\n"
            "0 - Unverndert\r\n"
            "1 - Standard\r\n"
            "2 - Arizona\r\n"
            "3 - Bordeaux\r\n"
            "4 - Ocean\r\n"
            "5 - Pastel\r\n"
            "6 - Rugby\r\n"
            "7 - PC Tools\r\n"
            "8 - Windows\r\n"
            "9 - Wing Tips\r\n"
            "E - Eigene Palette editieren\r\n"
            "\r\n"
            "(aktuell: %c)\r\n"
            "\r\n"
            "--> ", c ? 'E' : '0');

    switch(getch())
    {
      case '0': fputc(0,fp); break;
      case '1': loadpal(normal); break;
      case '2': loadpal(arizona); break;
      case '3': loadpal(bordeaux); break;
      case '4': loadpal(ocean); break;
      case '5': loadpal(pastel); break;
      case '6': loadpal(rugby); break;
      case '7': loadpal(stdcol); break;
      case '8': loadpal(windows); break;
      case '9': loadpal(wingtp); break;
      case 13 : if(c==0) break;
      case 'e':
      case 'E': i=editpal(); break;
    }
  }
  while(i);

/* Farben auswhlen: */

  fseek(fp,3,SEEK_SET), fread(&foffs,1,2,fp), foffs-=256+1;
  fseek(fp,foffs,SEEK_SET), fread(&colors,1,sizeof(colors),fp);

  setblink(0);
  clrscr();
  _setcursortype(_NOCURSOR);

  textattr(15);
  gotoxy(38,1), cprintf("Whlen Sie die Farbart mit Bild%c%c:", 25, 24);
  gotoxy(38,20), cprintf("%c%c: Hintergrundfarbe ndern", 25, 24);
  gotoxy(38,21), cprintf("%c%c: Vordergrundfarbe ndern", 27, 26);
  gotoxy(38,23), cprintf("Mit RETURN beenden Sie die Farbauswahl");

  e=0, n=1, u=1;

  while(!e)
  {
    if(u==1)    // Update erforderlich?
    {
      gotoxy(1,1);                      // Farb-Beispiel ausgeben
      for(i=0; i<23; i++)
      {
        for(j=0; j<35; j++)
        {
          textattr(colors[attr[i][j]-'A'+1]);
          cprintf("%c", bild[i][j]);
        }
        cprintf("\r\n");
      }
      u=0;
    }

    for(i=1; i<=ANZ_ELEM-1; i++)        // Farbart-Men ausgeben
    {
      gotoxy(38,i+2);
      textattr(n==i ? 0x70 : 7);
      cprintf("%-40s", colors_txt[i]);
    }

    gotoxy(23,18);
    _setcursortype(_NORMALCURSOR);

    switch(getch())
    {
      case 13: e=1; break;
      case 0: switch(getch())
      {
        case 73: n--; if(n<1) n=ANZ_ELEM-1; break;
        case 81: n++; if(n>ANZ_ELEM-1) n=1; break;
        case 80: colors[n]-=16; u=1; break;
        case 72: colors[n]+=16; u=1; break;
        case 75: c=colors[n]&0x0F; c--; colors[n]=(colors[n]&0xF0)|(c&0x0F); u=1; break;
        case 77: c=colors[n]&0x0F; c++; colors[n]=(colors[n]&0xF0)|(c&0x0F); u=1; break;
      }
      break;
    }
    _setcursortype(_NOCURSOR);
  }
  setblink(1);
  textattr(7);
  _setcursortype(_NORMALCURSOR);

/* Anzahl Bildschirmzeilen: */

  do
  {
    i=0; clrscr();
    cprintf("Wieviele Bildschirmzeilen sollen dargestellt werden?\r\n"
            "\r\n"
            "0 - Unverndert\r\n"
            "1 - 25 (VGA und EGA)\r\n"
            "2 - 28 (nur VGA)\r\n"
            "3 - 43 (EGA) bzw. 50 (VGA)\r\n"
            "\r\n"
            "(aktuell: %d)\r\n"
            "\r\n"
            "--> ", colors[lines]);

    switch(getch())
    {
      case '0': colors[lines]=0; break;
      case '1': colors[lines]=1; break;
      case '2': colors[lines]=2; break;
      case '3': colors[lines]=3; break;
    }
  }
  while(i);

  fseek(fp,foffs,SEEK_SET), fwrite(&colors,1,sizeof(colors),fp), fclose(fp);

  setpal(oldpal);
  clrscr(), cprintf("Die Einstellungen wurden gespeichert.\r\n");
  exit(0);
}
