#include "inkey.ch"

// Standard-Farben

STANDARD := "BG+/B,/W,B"
NORMAL   := "BG+/B,/W"
NORMBLINK:= "BG+*/B"

// Hauptmen-Farben

HAUPTMEN := "B/W"
AKTIV    := "W+/B"
INAKTIV  := "/W"
SCHATTEN := "/W"

// Eingabemasken

MASKE1   := "W+/GR"
MASKE2   := "W+/G"
MASKE3   := "W+/RB"
MASKE4   := "W+/BG"
MASKE4TXT:= "B/BG"
SUCHEN   := "BG+/B,W+/BG"
MSGDELETD:= "R+/GR"
MSGFILTER:= "GR+*/B"
TXTIDXORD:= "GR+/GR"

// Picklisten

PCKORT   := "GR+/R,W+/BG"
PCKGHALT := "GR+/RB,W+/BG"
PCKKONT  := "GR+/G,W+/R"

// Drucken

MNUDRUCK := "W+/B,W+/BG"
TXTDRUCK := "GR+/B"
BOXDATNAM:= "W+/BG"
BOXAUFBER:= "GR+/R"
TXTAUFBER:= "GR+*/R"

// Filter

BOXFILTER:= "W+/GR"
BOXAKTF  := "W+/R,W+/B"
TXTAKTF  := "GR+/R"
BOXWAITF := "W+/B"
TXTWAITF := "W+*/B"

// Verschiedenes

STERNCHEN:= "R+*/B"
BOXCRDB  := "W+/R"
BOXINDDB := "W+/G"
BOXSUCHEN:= "W+/R,W+/BG"
BOXLOESCH:= "GR+/R"
BOXDATERR:= "GR+/R"

BOXSTARTR:="W+/G"
TXTSTARTR:="GR+/G"

filterbed := ""

screen := ""

p_land    := ""
p_plz     := ""
p_ort     := ""
p_breite  := ""
p_laenge  := ""
p_ghalter := ""
p_kontakt := ""

ende := .F.

initialize()

DO WHILE !ende

  Auswahl := hauptmenue()   && Mensystem aufrufen

  DO CASE

    CASE Auswahl =   0      && Datenbank
      datenbank()

    CASE Auswahl =   1      && Filterbedingung
      filter()

    CASE Auswahl =   2      && Listendruck -> Bildschirm
      liste()

    CASE Auswahl =   3      && Reindizierung
      indizieren()

    CASE Auswahl =   4      && Hilfe
      hilfe()

    CASE Auswahl =   5      && Beenden
      SET COLOR TO
      ende = .T.

  ENDCASE

ENDDO

CLOSE ALL
CLEAR
QUIT



FUNCTION hauptmenue()

  STATIC wahl := 0
  LOCAL colors := SETCOLOR()
  LOCAL x_wahl := wahl % 3
  LOCAL y_wahl := INT(wahl / 3)
  LOCAL taste := 0
  LOCAL titel := ""

  LOCAL icon := {;
    {"GR+/RB",;
     "           ",;
     "          ",;
     " /\Ŀ ",;
     " /\˾ ",;
     "           ",;
     "Datenbank"},;
    {"GR+/GR",;
     "  _______  ",;
     "  \ 1x4 / ",;
     "   \___/ ",;
     "      ",;
     "           ",;
     "Filter"},;
    {"W+/B", ;
     "  ķ  ",;
     "    ",;
     "    ",;
     "",;
     "  ",;
     "Liste"},;
    {"W+/G",;
     " Ŀ ",;
     " : A-Z  ",;
     " :      ",;
     " :      ",;
     " ;  ",;
     "Reindizierung"},;
    {"B/BG",;
     "  ",;
     "  ",;
     " \"+CHR(1)+"/ ",;
     "  ",;
     "  ",;
     "Hilfe"},;
    {"W+/R",;
     "    ͻ ",;
     "    EXIT ",;
     "  o/    ",;
     " /_     ",;
     " /   ",;
     "Ende"};
  }

  SET CURSOR OFF

  SET COLOR TO (HAUPTMEN)
  @ 0,0 CLEAR TO 24,79
  @ 0,0 TO 24,79
  @ 0,6 SAY "[FLY Version 1.0   Fluggebiete-Datenbank   (c) 1995 by Stefan Bion]"
  @ 23,28 SAY "Auswahl mit "+CHR(24)+CHR(25)+CHR(27)+CHR(26)+" und "+CHR(17)+""

  FOR y := 0 TO 1
    FOR x := 0 TO 2
      FOR z := 0 TO 4
        @ y*10+4+z, x*23+11 SAY icon[y*3+x+1][z+2] COLOR icon[y*3+x+1][1]
        @ y*10+4+z, x*23+22 SAY IF(z=0,"","") COLOR SCHATTEN
      NEXT
      @ y*10+4+5, x*23+12 SAY "" COLOR SCHATTEN
    NEXT
  NEXT

  DO WHILE taste != K_RETURN

    FOR y := 0 TO 1
      FOR x := 0 TO 2
        titel = " "+icon[y*3+x+1][7]+" "
        @ y*10+10, x*23+9+(16-LEN(titel))/2 SAY titel COLOR IF(y*3+x = y_wahl*3+x_wahl, AKTIV, INAKTIV)
      NEXT
    NEXT

    taste = inkey(0)

    DO CASE
      CASE taste = K_UP
        IF y_wahl>0; y_wahl--; ENDIF
      CASE taste = K_DOWN
        IF y_wahl<1; y_wahl++; ENDIF
      CASE taste = K_LEFT
        IF x_wahl>0; x_wahl--; ENDIF
      CASE taste = K_RIGHT
        IF x_wahl<2; x_wahl++; ENDIF
    ENDCASE

  ENDDO

  wahl = y_wahl*3+x_wahl

  SET CURSOR ON
  SET COLOR TO (colors)

RETURN wahl



FUNCTION del_keys()
  SET KEY K_F1 TO
  SET KEY K_ALT_L TO
  SET KEY K_ALT_N TO
  SET KEY K_ALT_K TO
RETURN



FUNCTION set_keys()
  SET KEY K_F1 TO suchen()
  SET KEY K_ALT_L TO loeschen()
  SET KEY K_ALT_N TO neueing()
  SET KEY K_ALT_K TO karte()
RETURN



FUNCTION janein(eingabe)

  LOCAL ok := .T.

  IF eingabe <> "J" .AND. eingabe <> "N"
    ok = .F.
  ENDIF

RETURN ok



FUNCTION beep_fehler()
  TONE(1000,1)
RETURN



FUNCTION beep_ngef()
  TONE(100,3)
RETURN



FUNCTION initialize()

  LOCAL GetList := {}

  SETCANCEL(.F.)
  SET EXACT ON
  SET DATE TO GERMAN
  SET WRAP ON
  SET CONFIRM ON
  SET DELETED ON
  SET COLOR TO (STANDARD)
  CLEAR

  IF !FILE("fly.dbf")
    cr_fly()
  ENDIF

  IF !FILE("selekt.dbf")
    cr_selekt()
  ENDIF

  USE selekt

  USE fly INDEX l_p_o, g_name, g_halter, kontakt, o_l_p, ort NEW
  SET ORDER TO 1

RETURN



FUNCTION cr_fly()

  LOCAL GetList := {}, eingabe := "J"

  LOCAL fly := {               ;
    {"LAND",       "C",  3, 0},;
    {"PLZ",        "C",  5, 0},;
    {"ORT",        "C", 38, 0},;
    {"GEL_NAME",   "C", 62, 0},;
    {"GEL_HALTER", "C", 62, 0},;
    {"KONTAKT",    "C", 62, 0},;
    {"STARTR1",    "C",  8, 0},;
    {"STARTART1",  "C",  1, 0},;
    {"HDIFF1",     "N",  5, 0},;
    {"STARTR2",    "C",  8, 0},;
    {"STARTART2",  "C",  1, 0},;
    {"HDIFF2",     "N",  5, 0},;
    {"STARTR3",    "C",  8, 0},;
    {"STARTART3",  "C",  1, 0},;
    {"HDIFF3",     "N",  5, 0},;
    {"STARTR4",    "C",  8, 0},;
    {"STARTART4",  "C",  1, 0},;
    {"HDIFF4",     "N",  5, 0},;
    {"STARTR5",    "C",  8, 0},;
    {"STARTART5",  "C",  1, 0},;
    {"HDIFF5",     "N",  5, 0},;
    {"STARTR6",    "C",  8, 0},;
    {"STARTART6",  "C",  1, 0},;
    {"HDIFF6",     "N",  5, 0},;
    {"LAENGE",     "N",  5, 2},;
    {"BREITE",     "N",  5, 2},;
    {"BEMERKUNG1", "C", 76, 0},;
    {"BEMERKUNG2", "C", 76, 0},;
    {"BEMERKUNG3", "C", 76, 0},;
    {"BEMERKUNG4", "C", 76, 0},;
    {"BEMERKUNG5", "C", 76, 0}}

  SET COLOR TO (BOXCRDB)
  @ 10,10 CLEAR TO 14,70
  @ 10,10 TO 14,70
  @ 12,15 SAY "Datei FLY existiert noch nicht! Erzeugen (J/N)?";
          GET eingabe PICTURE "!" VALID janein(eingabe); READ
  SET COLOR TO (NORMAL)

  IF eingabe = "J"
    DBCREATE("fly", fly)
    USE fly
    SET COLOR TO (BOXINDDB)
    @ 10,20 CLEAR TO 14,59
    @ 10,20 TO 14,59
    ind_fly()
    SET COLOR TO (NORMAL)
    CLOSE fly
  ENDIF

RETURN



FUNCTION cr_selekt()

  LOCAL GetList := {}, eingabe := "J"

  LOCAL selekt := {           ;
    {"LAND",      "C",  3, 0},;
    {"PLZ1",      "C",  5, 0},;
    {"PLZ2",      "C",  5, 0},;
    {"ORT",       "C", 38, 0},;
    {"BREITE1",   "N",  5, 2},;
    {"BREITE2",   "N",  5, 2},;
    {"LAENGE1",   "N",  5, 2},;
    {"LAENGE2",   "N",  5, 2},;
    {"RADIUS",    "N",  4, 0},;
    {"RBREITE",   "N",  5, 2},;
    {"RLAENGE",   "N",  5, 2},;
    {"GNAME",     "C", 62, 0},;
    {"GHALTER",   "C", 62, 0},;
    {"KONTAKT",   "C", 62, 0},;
    {"GHALTER",   "C", 62, 0},;
    {"STARTR1",   "C",  3, 0},;
    {"STARTR2",   "C",  3, 0},;
    {"STARTART",  "C",  1, 0},;
    {"HDIFF1",    "N",  5, 0},;
    {"HDIFF2",    "N",  5, 0}}

  SET COLOR TO (BOXCRDB)
  @ 10,10 CLEAR TO 14,70
  @ 10,10 TO 14,70
  @ 12,15 SAY "Datei SELEKT existiert noch nicht! Erzeugen (J/N)?";
          GET eingabe PICTURE "!" VALID janein(eingabe); READ
  SET COLOR TO (NORMAL)

  IF eingabe = "J"
    DBCREATE("selekt", selekt)
    USE selekt
    APPEND BLANK
    CLOSE selekt
  ENDIF

RETURN



FUNCTION ind_fly()

  @ 12,24 SAY " Indiziere Land, Plz und Ort ..."
  INDEX ON UPPER(land + plz + ort) TO l_p_o

  @ 12,24 SAY "   Indiziere Gelndenamen ...   "
  INDEX ON UPPER(gel_name) TO g_name

  @ 12,24 SAY "   Indiziere Gelndehalter ...  "
  INDEX ON UPPER(gel_halter) TO g_halter UNIQUE

  @ 12,24 SAY "  Indiziere Kontaktpersonen ... "
  INDEX ON UPPER(kontakt) TO kontakt UNIQUE

  @ 12,24 SAY " Indiziere Ort, Land und Plz ..."
  INDEX ON UPPER(ort + land + plz) TO o_l_p UNIQUE

  @ 12,24 SAY "        Indiziere Ort ...       "
  INDEX ON UPPER(ort) TO ort

RETURN



FUNCTION indizieren()

  SET COLOR TO (BOXINDDB)
  @ 10,20 CLEAR TO 14,59
  @ 10,20 TO 14,59
  @ 12,24 SAY "Reorganisiere die Stammdatei ..."

  SET INDEX TO
  PACK
  ind_fly()
  SET INDEX TO l_p_o, g_name, g_halter, kontakt, o_l_p, ort

  SET COLOR TO (NORMAL)

RETURN



FUNCTION datenbank()

  LOCAL ende := .F.

  maske()

  @  0,  2 SAY "F1:Suchen  Alt+N:Neu  Alt+L:Lschen  Alt+K:Karte"
  @  0, 70 SAY "Esc:Ende"

  set_keys()

  DO WHILE !ende

    editieren()
    taste := LASTKEY()

    DO CASE

      CASE taste = K_ESC
        ende := .T.

      CASE taste = K_PGUP
        @ 23,34 SAY "Bitte warten" COLOR NORMBLINK
        SKIP -1
        IF BOF()
          @ 23,34 SAY "Dateianfang!"
        ELSE
          @ 23,34 CLEAR TO 23,45
        ENDIF

      CASE taste = K_PGDN
        @ 23,34 SAY "Bitte warten" COLOR NORMBLINK
        SKIP +1
        IF EOF()
          SKIP -1
          @ 23,34 SAY " Dateiende! "
        ELSE
          @ 23,34 CLEAR TO 23,45
        ENDIF

    ENDCASE

  ENDDO

  del_keys()
  SET KEY K_F3 TO

  COMMIT      // Alle DB-Puffer auf Platte schreiben!

RETURN



FUNCTION maske()

  CLEAR

  SET COLOR TO (MASKE1)
  @  1,  0  CLEAR TO   6, 79
  @  1,  0  TO   6, 79
  @  1, 33  SAY "[Fluggelnde]"
  @  2,  2  SAY "Land-Plz/Ort     -"
  @  2, 70  SAY "N"
  @  2, 77  SAY "E"
  @  3,  2  SAY "Gelndename"
  @  4,  2  SAY "Gelndehalter"
  @  5,  2  SAY "Kontaktperson"

  SET COLOR TO (MASKE2)
  @  7,  0  CLEAR TO   15, 34
  @  7,  0  TO   15, 34
  @  7, 11  SAY "[Startpltze]"
  @  8, 15  SAY "Richtung Art h[m]"
  @  9,  2  SAY "Startplatz 1"
  @ 10,  2  SAY "Startplatz 2"
  @ 11,  2  SAY "Startplatz 3"
  @ 12,  2  SAY "Startplatz 4"
  @ 13,  2  SAY "Startplatz 5"
  @ 14,  2  SAY "Startplatz 6"

  SET COLOR TO (MASKE3)
  @ 16,  0  CLEAR TO   22, 79
  @ 16,  0  TO   22, 79
  @ 16, 34  SAY "[Bemerkung]"

  SET COLOR TO (MASKE4)
  @  7, 55  CLEAR TO   15, 79
  @  7, 55  TO   15, 79
  @  7, 58  SAY "[Editierfunktionen]"
  SET COLOR TO (MASKE4TXT)
  @  8, 56  SAY "Cursor bewegen: RETURN,"
  @  9, 56  SAY "TAB, "+CHR(24)+CHR(25)+CHR(27)+CHR(26)+", Ctrl"+CHR(27)+CHR(26)+", Pos1"
  @ 10, 56  SAY "Ende; Blttern: Bild"+CHR(24)+CHR(25)
  @ 11, 56  SAY "Strg+T: Wort "+CHR(26)+" lschen"
  @ 12, 56  SAY "Strg+Y: Feld "+CHR(26)+" lschen"
  @ 13, 56  SAY "Alt+U : Originalwert"
  @ 14, 56  SAY "Einfg : Einfg/berschr"

  SET COLOR TO (MASKE1)
  @  6, 40  SAY      ""

  SET COLOR TO W+/B
  @  7, 37  SAY   "            "
  @  8, 35  SAY "               "
  @  9, 35  SAY "               "
  @ 10, 35  SAY ".              ."
  @ 11, 36  SAY  ".           ."
  @ 12, 37  SAY   ".       .    "
  @ 13, 38  SAY    ".   .   "
  @ 14, 39  SAY     ".   "
  @ 15, 45  SAY           ""

  SET COLOR TO W/B
  @ 15, 37  SAY   ""

  SET COLOR TO W+/W
  @  7, 38  SAY    "         "
  @  8, 36  SAY  "   "

  SET COLOR TO W/B
  @  8, 40  SAY      ""
  @  9, 35  SAY ""

  SET COLOR TO GR+/B
  @  9, 39  SAY " "
  @ 10, 39  SAY "    "
  @ 11, 39  SAY "      "

  SET COLOR TO (NORMAL)

RETURN



FUNCTION editieren()

  LOCAL GetList := {}

  IF DELETED()
    @  1,70 SAY "GELSCHT" COLOR MSGDELETD
  ELSE
    @  1,70 TO 1,77 COLOR MASKE1
  ENDIF

  IF DBFILTER() <> ""
    @  0,52 SAY "FILTER" COLOR MSGFILTER
  ELSE
    @  0,52 CLEAR TO 0,57
  ENDIF

  SET COLOR TO (TXTIDXORD)
  @  2, 15  SAY IF(INDEXORD()=1, ">", " ")
  @  2, 64  SAY IF(INDEXORD()=1, "<", IF(INDEXORD()=6, "<", " "))
  @  2, 25  SAY IF(INDEXORD()=6, ">", " ")
  @  3, 15  SAY IF(INDEXORD()=2, ">", " ")
  @  3, 78  SAY IF(INDEXORD()=2, "<", " ")
  SET COLOR TO (NORMAL)

  @  2, 16  GET  LAND        PICTURE "@! AAA" WHEN when_ort() VALID val_ort() .AND. clr_line24()
  @  2, 20  GET  PLZ         PICTURE "99999" WHEN when_ort() VALID val_ort() .AND. clr_line24()
  @  2, 26  GET  ORT         WHEN when_ort() VALID val_ort() .AND. clr_line24()
  @  2, 65  GET  BREITE      PICTURE "@Z" WHEN when_breite() VALID val_min(breite) .AND. clr_line24()
  @  2, 72  GET  LAENGE      PICTURE "@Z" WHEN when_laenge() VALID val_min(laenge) .AND. clr_line24()
  @  3, 16  GET  GEL_NAME
  @  4, 16  GET  GEL_HALTER  WHEN when_ghalter() VALID val_ghalter() .AND. clr_line24()
  @  5, 16  GET  KONTAKT     WHEN when_kontakt() VALID val_kontakt() .AND. clr_line24()

  @  9, 15  GET  STARTR1     PICTURE "@!" WHEN when_richt() VALID val_richt(STARTR1)
  @  9, 25  GET  STARTART1   PICTURE "!" WHEN when_art() VALID clr_line24()
  @  9, 28  GET  HDIFF1      PICTURE "@Z"
  @ 10, 15  GET  STARTR2     PICTURE "@!" WHEN when_richt() VALID val_richt(STARTR2)
  @ 10, 25  GET  STARTART2   PICTURE "!" WHEN when_art() VALID clr_line24()
  @ 10, 28  GET  HDIFF2      PICTURE "@Z"
  @ 11, 15  GET  STARTR3     PICTURE "@!" WHEN when_richt() VALID val_richt(STARTR3)
  @ 11, 25  GET  STARTART3   PICTURE "!" WHEN when_art() VALID clr_line24()
  @ 11, 28  GET  HDIFF3      PICTURE "@Z"
  @ 12, 15  GET  STARTR4     PICTURE "@!" WHEN when_richt() VALID val_richt(STARTR4)
  @ 12, 25  GET  STARTART4   PICTURE "!" WHEN when_art() VALID clr_line24()
  @ 12, 28  GET  HDIFF4      PICTURE "@Z"
  @ 13, 15  GET  STARTR5     PICTURE "@!" WHEN when_richt() VALID val_richt(STARTR5)
  @ 13, 25  GET  STARTART5   PICTURE "!" WHEN when_art() VALID clr_line24()
  @ 13, 28  GET  HDIFF5      PICTURE "@Z"
  @ 14, 15  GET  STARTR6     PICTURE "@!" WHEN when_richt() VALID val_richt(STARTR6)
  @ 14, 25  GET  STARTART6   PICTURE "!" WHEN when_art() VALID clr_line24()
  @ 14, 28  GET  HDIFF6      PICTURE "@Z"

  @ 17,  2  GET  BEMERKUNG1
  @ 18,  2  GET  BEMERKUNG2
  @ 19,  2  GET  BEMERKUNG3
  @ 20,  2  GET  BEMERKUNG4
  @ 21,  2  GET  BEMERKUNG5

  READ

RETURN



FUNCTION when_ort()

  @ 24, 0
  @ 24,30 SAY "F3 = Pickliste Orte"
  SET KEY K_F3 TO pick_ort()

RETURN .T.



FUNCTION val_ort()
  SET KEY K_F3 TO
RETURN .T.



FUNCTION when_ghalter()

  @ 24, 0
  @ 24,26 SAY "F3 = Pickliste Gelndehalter"
  SET KEY K_F3 TO pick_ghalter()

RETURN .T.



FUNCTION val_ghalter()
  SET KEY K_F3 TO
RETURN .T.



FUNCTION when_kontakt()

  @ 24, 0
  @ 24,25 SAY "F3 = Pickliste Kontaktpersonen"
  SET KEY K_F3 TO pick_kontakt()

RETURN .T.



FUNCTION val_kontakt()
  SET KEY K_F3 TO
RETURN .T.



FUNCTION when_breite()
  @ 24, 0
  @ 24,25 SAY "Koordinaten (nrdliche Breite)"
RETURN .T.



FUNCTION when_laenge()
  @ 24, 0
  @ 24,26 SAY "Koordinaten (stliche Lnge)"
RETURN .T.



FUNCTION val_min(d)
  LOCAL ret := .T.
  d*=100
  IF d%100 >= 60
    ret = .F.
    beep_fehler()
  ENDIF
RETURN ret



FUNCTION when_richt()
  @ 24, 0
  @ 24, 7 SAY "Startrichtung: Bereiche bitte im Uhrzeigersinn angeben, z.B. NW-NO"

  screen=SAVESCREEN(7,55,15,79)
  SET COLOR TO (BOXSTARTR)
  @  7, 55  CLEAR TO   15, 79
  @  7, 55  TO   15, 79
  @  7, 62  SAY "[Windrose]"
  SET COLOR TO (TXTSTARTR)
  @  8, 59  SAY "    NNW N NNO    "
  @  9, 59  SAY "  NW        NO  "
  @ 10, 59  SAY "WNW          ONO"
  @ 11, 59  SAY "W  O"
  @ 12, 59  SAY "WSW          OSO"
  @ 13, 59  SAY "  SW        SO  "
  @ 14, 59  SAY "    SSW S SSO    "
  SET COLOR TO (NORMAL)

RETURN .T.



FUNCTION val_richt(startr)
  LOCAL ret := .T.
  IF EMPTY(startr) .OR. (von(startr) <> 99 .AND. bis(startr) <> 99)
    RESTSCREEN(7,55,15,79,screen)
    clr_line24()
  ELSE
    ret = .F.
    beep_fehler()
  ENDIF
RETURN ret



FUNCTION when_art()
  @ 24, 0
  @ 24,10 SAY "Startart, z.B. H = Hang, R = Rampe, S = Schlepp, K = Klippe"
RETURN .T.



FUNCTION pick_ort()

  LOCAL satz := RECNO(), ord := INDEXORD()
  LOCAL screen := SAVESCREEN(4,5,20,74)
  LOCAL footline := SAVESCREEN(24,0,24,79)
  LOCAL spalten := {"LAND","PLZ","ORT","BREITE","LAENGE"}
  LOCAL maske := {"","","","@Z","@Z"}
  LOCAL spaltenkopf := {"Lkz","Plz","Ort","N","E"}

  del_keys()
  SET KEY K_F3 TO
  @ 24,12 SAY "Auswahl mit Cursortasten oder Anfangsbuchstabe + RETURN"
  SET COLOR TO (PCKORT)
  @ 4,5 TO 20,74

  p_land=land
  p_plz=plz
  p_ort=ort
  p_breite=breite
  p_laenge=laenge
  SET ORDER TO 5
  SET SOFTSEEK ON
  SEEK UPPER(p_ort + p_land + p_plz)
  IF !FOUND()
    GO TOP
  ENDIF
  DBEDIT(5,6,19,73,spalten,"a_ort",maske,spaltenkopf)

  SET SOFTSEEK OFF
  GO satz
  SET ORDER TO ord

  SET COLOR TO (NORMAL)
  RESTSCREEN(4,5,20,74,screen)
  RESTSCREEN(24,0,24,79,footline)

  REPLACE land   WITH p_land
  REPLACE plz    WITH p_plz
  REPLACE ort    WITH p_ort
  REPLACE breite WITH p_breite
  REPLACE laenge WITH p_laenge
  SET KEY K_F3 TO pick_ort()
  set_keys()

RETURN



FUNCTION a_ort(modus, spalte)

  LOCAL ret := 1

  DO CASE
    CASE modus=3   // Datenbank leer
      ret=0   // DBEDIT() verlassen
    CASE modus=4   // Ungltige Taste
      DO CASE
        CASE LASTKEY() = K_RETURN
          p_land=land
          p_plz=plz
          p_ort=ort
          IF EMPTY(p_breite)
            p_breite=breite
          ENDIF
          IF EMPTY(p_laenge)
            p_laenge=laenge
          ENDIF
          // Wenn gendert, Cursor ber "Land" und "Plz"
          // wieder auf "Ort", um Anzeige upzudaten:
          KEYBOARD(CHR(K_CTRL_HOME)+CHR(K_RETURN)+CHR(K_RETURN))
          ret=0    // DBEDIT() verlassen
        CASE LASTKEY() = K_ESC
          ret=0    // DBEDIT() verlassen
        OTHERWISE
          SET SOFTSEEK ON
          SEEK UPPER(CHR(LASTKEY()))
          SET SOFTSEEK OFF
      ENDCASE
  ENDCASE

RETURN ret



FUNCTION pick_ghalter()

  LOCAL satz := RECNO(), ord := INDEXORD()
  LOCAL screen := SAVESCREEN(4,7,20,72)
  LOCAL footline := SAVESCREEN(24,0,24,79)
  LOCAL spalten := {"GEL_HALTER"}

  del_keys()
  SET KEY K_F3 TO
  @ 24,12 SAY "Auswahl mit Cursortasten oder Anfangsbuchstabe + RETURN"
  SET COLOR TO (PCKGHALT)
  @ 4,7 TO 20,72

  p_ghalter=gel_halter
  p_kontakt=kontakt
  SET ORDER TO 3
  SEEK UPPER(p_ghalter)
  IF !FOUND()
    GO TOP
  ENDIF
  DBEDIT(5,8,19,71,spalten,"a_ghalter",,"Gelndehalter")

  GO satz
  SET ORDER TO ord

  SET COLOR TO (NORMAL)
  RESTSCREEN(4,7,20,72,screen)
  RESTSCREEN(24,0,24,79,footline)

  REPLACE gel_halter WITH p_ghalter
  REPLACE kontakt WITH p_kontakt
  SET KEY K_F3 TO pick_ghalter()
  set_keys()

RETURN



FUNCTION a_ghalter(modus, spalte)

  LOCAL ret := 1

  DO CASE
    CASE modus=3   // Datenbank leer
      ret=0   // DBEDIT() verlassen
    CASE modus=4   // Ungltige Taste
      DO CASE
        CASE LASTKEY() = K_RETURN
          p_ghalter=gel_halter
          IF EMPTY(p_kontakt)
            p_kontakt=kontakt
          ENDIF
          ret=0    // DBEDIT() verlassen
        CASE LASTKEY() = K_ESC
          ret=0    // DBEDIT() verlassen
        OTHERWISE
          SET SOFTSEEK ON
          SEEK UPPER(CHR(LASTKEY()))
          SET SOFTSEEK OFF
      ENDCASE
  ENDCASE

RETURN ret



FUNCTION pick_kontakt()

  LOCAL satz := RECNO(), ord := INDEXORD()
  LOCAL screen := SAVESCREEN(4,7,20,72)
  LOCAL footline := SAVESCREEN(24,0,24,79)
  LOCAL spalten := {"KONTAKT"}

  del_keys()
  SET KEY K_F3 TO
  @ 24,12 SAY "Auswahl mit Cursortasten oder Anfangsbuchstabe + RETURN"
  SET COLOR TO (PCKKONT)
  @ 4,7 TO 20,72

  p_kontakt=kontakt
  SET ORDER TO 4
  SEEK UPPER(kontakt)
  IF !FOUND()
    GO TOP
  ENDIF
  DBEDIT(5,8,19,71,spalten,"a_kontakt",,"Kontaktpersonen")

  GO satz
  SET ORDER TO ord

  SET COLOR TO (NORMAL)
  RESTSCREEN(4,7,20,72,screen)
  RESTSCREEN(24,0,24,79,footline)

  REPLACE kontakt WITH p_kontakt
  SET KEY K_F3 TO pick_kontakt()
  set_keys()

RETURN



FUNCTION a_kontakt(modus, spalte)

  LOCAL ret := 1

  DO CASE
    CASE modus=3   // Datenbank leer
      ret=0   // DBEDIT() verlassen
    CASE modus=4   // Ungltige Taste
      DO CASE
        CASE LASTKEY() = K_RETURN
          p_kontakt=kontakt
          ret=0    // DBEDIT() verlassen
        CASE LASTKEY() = K_ESC
          ret=0    // DBEDIT() verlassen
        OTHERWISE
          SET SOFTSEEK ON
          SEEK UPPER(CHR(LASTKEY()))
          SET SOFTSEEK OFF
      ENDCASE
  ENDCASE

RETURN ret



FUNCTION suchen()

  LOCAL GetList := {}, satz := RECNO(), wahl := 1
  LOCAL screen := SAVESCREEN(7,55,15,79)
  LOCAL l_land := SPACE(LEN(land)), l_plz := SPACE(LEN(plz)), l_ort := SPACE(LEN(ort))
  LOCAL l_gname := SPACE(LEN(gel_name))

  del_keys()

  DO CASE
    CASE INDEXORD()=1
      wahl=1
    CASE INDEXORD()=6
      wahl=2
    CASE INDEXORD()=2
      wahl=3
  ENDCASE

  SET COLOR TO (BOXSUCHEN)
  @  7,55 CLEAR TO 15,79
  @  7,55 TO 15,79 DOUBLE
  @  7,61 SAY         "[Suchen nach]"
  @  9,56 PROMPT "      Land/Plz/Ort     "
  @ 11,56 PROMPT "          Ort          "
  @ 13,56 PROMPT "      Gelndename      "
  MENU to wahl
  SET COLOR TO (NORMAL)
  RESTSCREEN(7,55,15,79,screen)

  IF LASTKEY() <> K_ESC

    DO CASE
      CASE wahl=1
        SET COLOR TO (SUCHEN)
        @ 2,16 GET l_land PICTURE "@! AAA" WHEN say_line() VALID clr_line24()
        @ 2,20 GET l_plz  PICTURE "99999"  WHEN say_line() VALID clr_line24()
        @ 2,26 GET l_ort                   WHEN say_line() VALID clr_line24()
        READ
        SET COLOR TO (NORMAL)

        SET ORDER TO 1    // Index: LAND + PLZ + ORT
        IF LASTKEY() <> K_ESC
          SET SOFTSEEK ON
          SEEK RTRIM(l_land + l_plz + l_ort)
          IF FOUND()
            CLEAR GETS
          ELSE
            beep_ngef()
            GO satz
          ENDIF
          SET SOFTSEEK OFF
        ELSE
          clr_line24()
        ENDIF
        KEYBOARD(CHR(K_CTRL_END))

      CASE wahl=2
        SET COLOR TO (SUCHEN)
        @ 2,26 GET l_ort                   WHEN say_line() VALID clr_line24()
        READ
        SET COLOR TO (NORMAL)

        SET ORDER TO 6    // Index: ORT
        IF LASTKEY() <> K_ESC
          SET SOFTSEEK ON
          SEEK TRIM(UPPER(l_ort))
          IF FOUND()
            CLEAR GETS
          ELSE
            beep_ngef()
            GO satz
          ENDIF
          SET SOFTSEEK OFF
        ELSE
          clr_line24()
        ENDIF
        KEYBOARD(CHR(K_CTRL_END))

      CASE wahl=3
        SET COLOR TO (SUCHEN)
        @ 3,16 GET l_gname                 WHEN say_line() VALID clr_line24()
        READ
        SET COLOR TO (NORMAL)

        SET ORDER TO 2    // Index: GEL_NAME
        IF LASTKEY() <> K_ESC
          SET SOFTSEEK ON
          SEEK TRIM(UPPER(l_gname))
          IF FOUND()
            CLEAR GETS
          ELSE
            beep_ngef()
            GO satz
          ENDIF
          SET SOFTSEEK OFF
        ELSE
          clr_line24()
        ENDIF
        KEYBOARD(CHR(K_CTRL_END))

    ENDCASE

  ENDIF

  set_keys()

RETURN



FUNCTION say_line()
  @ 24, 0
  @ 24,10 SAY "Esc: Nicht suchen, sondern nur Sortierreihenfolge festlegen"
RETURN .T.



FUNCTION clr_line24()
  @ 24, 0
RETURN .T.



FUNCTION clr_line2324()
  @ 23, 0
  @ 24, 0
RETURN .T.



FUNCTION neueing()
  APPEND BLANK
  KEYBOARD(CHR(K_CTRL_END))
RETURN



FUNCTION loeschen()

  LOCAL GetList := {}, eingabe := "N"
  LOCAL screen := SAVESCREEN(10,13,14,66)

  del_keys()

  SET COLOR TO (BOXLOESCH)
  @ 10,13 CLEAR TO 14,66
  @ 10,13 TO 14,66
  @ 12,17 SAY "Soll dieser Datensatz gelscht werden (J/N)?";
          GET eingabe PICTURE "!" VALID janein(eingabe); READ
  SET COLOR TO (NORMAL)
  RESTSCREEN(10,13,14,66,screen)

  IF eingabe = "J"
    delete
    KEYBOARD(CHR(K_PGDN))
  ENDIF

  set_keys()

RETURN



FUNCTION karte()

  LOCAL screen, key := 0

  IF land="D" .OR. land="A" .OR. land="CH" .OR. (!EMPTY(breite) .AND. !EMPTY(laenge))

    del_keys()
    SET CURSOR OFF
    screen=SAVESCREEN(0,0,24,79)
    @  0,0 CLEAR TO 24,79

    DO CASE

      CASE land="D"                    // Auswahl nach Lnder-Kennzeichen
        karte_d()
      CASE land="A"
        karte_a()
      CASE land="CH"
        karte_ch()

      CASE breite<=49 .AND. laenge>=13 // Auswahl nach Koordinaten
        karte_a()
      CASE breite>=47.20
        karte_d()
      CASE laenge>=9.30
        karte_a()
      OTHERWISE
        karte_ch()

    ENDCASE

    WHILE key <> K_ESC
      key = INKEY(0)
    ENDDO

    RESTSCREEN(0,0,24,79,screen)
    SET CURSOR ON
    set_keys()

  ENDIF

RETURN



FUNCTION karte_d()

  LOCAL x := INT(min2dec(laenge)*5-14+0.5)
  LOCAL y := INT(24-min2dec(breite)*3+141+0.49)

  @  0,  0 SAY "55 "
  @  1,  0 SAY "       Deutschland                    ܳ                   "
  @  2,  0 SAY "                                               "
  @  3,  0 SAY "54"
  @  4,  0 SAY "                                     "
  @  5,  0 SAY "                  HH                "
  @  6,  0 SAY "53HB"
  @  7,  0 SAY "                 B                "
  @  8,  0 SAY "                  HAMD۳               "
  @  9,  0 SAY "52BI"
  @ 10,  0 SAY "              DO               "
  @ 11,  0 SAY "              KSL              "
  @ 12,  0 SAY "51KEFDD"
  @ 13,  0 SAY "              FD                   "
  @ 14,  0 SAY "               KOF                      "
  @ 15,  0 SAY "50"
  @ 16,  0 SAY "               TRMAW                        "
  @ 17,  0 SAY "                N                       "
  @ 18,  0 SAY "49KAR"
  @ 19,  0 SAY "                      Sܳ                   "
  @ 20,  0 SAY "                     ULA                    "
  @ 21,  0 SAY "48FRM"
  @ 22,  0 SAY "                             Esc = Ende     "
  @ 23,  0 SAY "                                                       "
  @ 24,  0 SAY "      4   5   6   7   8   9  10  11  12  13  14  15  16  17  18  "

  IF x>=3 .AND. x<=79 .AND. y>=0 .AND. y<=23
    @ y, x SAY "*" COLOR STERNCHEN
  ENDIF

RETURN



FUNCTION karte_a()

  LOCAL x := INT(min2dec(laenge)*8-66+0.5)
  LOCAL y := INT(24-min2dec(breite)*5+223+0.49)

  @  0,  0 SAY "                                                                      "
  @  1,  0 SAY "         sterreich                                                    "
  @  2,  0 SAY "49"
  @  3,  0 SAY "                                               ܳ               "
  @  4,  0 SAY "                                             "
  @  5,  0 SAY "                                  Lܳ        "
  @  6,  0 SAY "                                 W        "
  @  7,  0 SAY "48"
  @  8,  0 SAY "                                  S        "
  @  9,  0 SAY "              ܳ                 "
  @ 10,  0 SAY "                       "
  @ 11,  0 SAY "          I            "
  @ 12,  0 SAY "47G"
  @ 13,  0 SAY "                                       "
  @ 14,  0 SAY "                                                     "
  @ 15,  0 SAY "                                                                "
  @ 16,  0 SAY "                                                                      "
  @ 17,  0 SAY "46"
  @ 18,  0 SAY "                                                                      "
  @ 19,  0 SAY "                                                                      "
  @ 20,  0 SAY "                                                          Esc = Ende   "
  @ 21,  0 SAY "                                                                      "
  @ 22,  0 SAY "45"
  @ 23,  0 SAY "                                                                      "
  @ 24,  0 SAY "      9     10     11     12     13     14     15     16     17     18"

  IF x>=3 .AND. x<=79 .AND. y>=0 .AND. y<=23
    @ y, x SAY "*" COLOR STERNCHEN
  ENDIF

RETURN



FUNCTION karte_ch()

  LOCAL x := INT(min2dec(laenge)*10-44+0.5)
  LOCAL y := INT(24-min2dec(breite)*6+268+0.49)

  @  0,  0 SAY "                                                                        "
  @  1,  0 SAY "            Schweiz                                                      "
  @  2,  0 SAY "                                                                        "
  @  3,  0 SAY "                                                                        "
  @  4,  0 SAY "48"
  @  5,  0 SAY "                                                                        "
  @  6,  0 SAY "                            BS                                       "
  @  7,  0 SAY "                                                   "
  @  8,  0 SAY "                       ZH                        "
  @  9,  0 SAY "                                                "
  @ 10,  0 SAY "47LU"
  @ 11,  0 SAY "                   BE                "
  @ 12,  0 SAY "                                 "
  @ 13,  0 SAY "                                 "
  @ 14,  0 SAY "                                        "
  @ 15,  0 SAY "               GE                                   "
  @ 16,  0 SAY "46"
  @ 17,  0 SAY "                                                                  "
  @ 18,  0 SAY "                                                                        "
  @ 19,  0 SAY "                                                                        "
  @ 20,  0 SAY "                                                        Esc = Ende       "
  @ 21,  0 SAY "                                                                        "
  @ 22,  0 SAY "45"
  @ 23,  0 SAY "                                                                        "
  @ 24,  0 SAY "      5        6        7        8        9       10       11       12  "

  IF x>=3 .AND. x<=79 .AND. y>=0 .AND. y<=23
    @ y, x SAY "*" COLOR STERNCHEN
  ENDIF

RETURN



FUNCTION filter()

  LOCAL wahl := IF(DBFILTER()="", 1, 2)

  SET COLOR TO (BOXFILTER)
  @  3, 14  CLEAR TO  21, 65
  @  3, 14  TO   21, 65

  @  3, 26  SAY "[Filterbedingung definieren]"
  @  5, 17  SAY "Land"
  @  6, 17  SAY "Plz                    -"
  @  7, 17  SAY "Ort"
  @  8, 17  SAY "Nrdliche Breite       -"
  @  9, 17  SAY "stliche Lnge         -"
  @ 11, 17  SAY "Im Umkreis von       km um      N /      E"
  @ 13, 17  SAY "Gelndename"
  @ 14, 17  SAY "Gelndehalter"
  @ 15, 17  SAY "Kontaktperson"
  @ 17, 17  SAY "Startrichtung        -"
  @ 18, 17  SAY "Startart"
  @ 19, 17  SAY "Hhendifferenz         -"

  SET COLOR TO (NORMAL)

  @  5, 34  GET  selekt->land      PICTURE "@! AAA"
  @  6, 34  GET  selekt->plz1      PICTURE "99999"
  @  6, 42  GET  selekt->plz2      PICTURE "99999"
  @  7, 34  GET  selekt->ort       PICTURE "@S29"
  @  8, 34  GET  selekt->breite1   PICTURE "@Z" VALID val_min(selekt->breite1)
  @  8, 42  GET  selekt->breite2   PICTURE "@Z" VALID val_min(selekt->breite2)
  @  9, 34  GET  selekt->laenge1   PICTURE "@Z" VALID val_min(selekt->laenge1)
  @  9, 42  GET  selekt->laenge2   PICTURE "@Z" VALID val_min(selekt->laenge2)
  @ 11, 34  GET  selekt->radius    PICTURE "@Z"
  @ 11, 44  GET  selekt->rbreite   PICTURE "@Z" VALID val_min(selekt->rbreite)
  @ 11, 53  GET  selekt->rlaenge   PICTURE "@Z" VALID val_min(selekt->rlaenge)
  @ 13, 34  GET  selekt->gname     PICTURE "@S29"
  @ 14, 34  GET  selekt->ghalter   PICTURE "@S29"
  @ 15, 34  GET  selekt->kontakt   PICTURE "@S29"
  @ 17, 34  GET  selekt->startr1   PICTURE "@!" VALID EMPTY(selekt->startr1) .OR. str2num(selekt->startr1)<>99
  @ 17, 40  GET  selekt->startr2   PICTURE "@!" VALID EMPTY(selekt->startr2) .OR. str2num(selekt->startr2)<>99
  @ 18, 34  GET  selekt->startart  PICTURE "!"
  @ 19, 34  GET  selekt->hdiff1    PICTURE "@Z"
  @ 19, 42  GET  selekt->hdiff2    PICTURE "@Z"

  READ

  IF UPDATED()     // Wenn Eingaben gemacht wurden, ist anzunehmen, da
    wahl=1         // der Benutzer das Filter aktivieren will.
  ENDIF

  SET COLOR TO (BOXAKTF)
  @  9, 21  CLEAR TO  15, 58
  @  9, 21  TO   15, 58 DOUBLE
  @ 11, 25  SAY "Filter ist jetzt "+IF(DBFILTER()="","aus","ein")+"geschaltet" COLOR TXTAKTF
  @ 13,25 PROMPT " Einschalten "
  @ 13,42 PROMPT " Ausschalten "
  MENU to wahl
  SET COLOR TO (NORMAL)

  IF wahl = 0      // Esc gedrckt: Filter so einstellen, wie er war ...
    wahl=IF(DBFILTER()="", 2, 1)
  ENDIF

  IF wahl = 1      // "Einschalten"
    SET COLOR TO (BOXWAITF)
    @ 10, 30 CLEAR TO 14, 49
    @ 10, 30 TO 14, 49
    @ 12, 34 SAY "Bitte warten" COLOR TXTWAITF
    SET COLOR TO (NORMAL)
    set_fbed()
    SET FILTER TO &filterbed
    GO TOP
  ELSE
    SET FILTER TO  // "Ausschalten"
    GO TOP
  ENDIF

RETURN



FUNCTION set_fbed()     // Filterbedingung erstellen

  filterbed = ""

  IF !EMPTY(selekt->land)
    filterbed = filterbed + "land=selekt->land"
  ENDIF

  IF !EMPTY(selekt->plz1)
    IF !EMPTY(filterbed)
      filterbed = filterbed + ".AND."
    ENDIF
    filterbed = filterbed + "plz>=selekt->plz1"
  ENDIF

  IF !EMPTY(selekt->plz2)
    IF !EMPTY(filterbed)
      filterbed = filterbed + ".AND."
    ENDIF
    filterbed = filterbed + "plz<=selekt->plz2"
  ENDIF

  IF !EMPTY(selekt->ort)
    IF !EMPTY(filterbed)
      filterbed = filterbed + ".AND."
    ENDIF
    filterbed = filterbed + "TRIM(UPPER(selekt->ort)) $ TRIM(UPPER(ort))"
  ENDIF

  IF !EMPTY(selekt->breite1)
    IF !EMPTY(filterbed)
      filterbed = filterbed + ".AND."
    ENDIF
    filterbed = filterbed + "!EMPTY(breite).AND.breite>=selekt->breite1"
  ENDIF

  IF !EMPTY(selekt->breite2)
    IF !EMPTY(filterbed)
      filterbed = filterbed + ".AND."
    ENDIF
    filterbed = filterbed + "!EMPTY(breite).AND.breite<=selekt->breite2"
  ENDIF

  IF !EMPTY(selekt->laenge1)
    IF !EMPTY(filterbed)
      filterbed = filterbed + ".AND."
    ENDIF
    filterbed = filterbed + "!EMPTY(laenge).AND.laenge>=selekt->laenge1"
  ENDIF

  IF !EMPTY(selekt->laenge2)
    IF !EMPTY(filterbed)
      filterbed = filterbed + ".AND."
    ENDIF
    filterbed = filterbed + "!EMPTY(laenge).AND.laenge<=selekt->laenge2"
  ENDIF

  IF !EMPTY(selekt->radius) .AND. !EMPTY(selekt->rbreite) .AND. !EMPTY(selekt->rlaenge)
    IF !EMPTY(filterbed)
      filterbed = filterbed + ".AND."
    ENDIF
    filterbed = filterbed + "sel_radius()"
  ENDIF

  IF !EMPTY(selekt->gname)
    IF !EMPTY(filterbed)
      filterbed = filterbed + ".AND."
    ENDIF
    filterbed = filterbed + "TRIM(UPPER(selekt->gname)) $ TRIM(UPPER(gel_name))"
  ENDIF

  IF !EMPTY(selekt->ghalter)
    IF !EMPTY(filterbed)
      filterbed = filterbed + ".AND."
    ENDIF
    filterbed = filterbed + "TRIM(UPPER(selekt->ghalter)) $ TRIM(UPPER(gel_halter))"
  ENDIF

  IF !EMPTY(selekt->kontakt)
    IF !EMPTY(filterbed)
      filterbed = filterbed + ".AND."
    ENDIF
    filterbed = filterbed + "TRIM(UPPER(selekt->kontakt)) $ TRIM(UPPER(kontakt))"
  ENDIF

  IF !EMPTY(selekt->startr1) .OR. !EMPTY(selekt->startr2) .OR. !EMPTY(selekt->startart) .OR. !EMPTY(selekt->hdiff1) .OR. !EMPTY(selekt->hdiff2)
    IF !EMPTY(filterbed)
      filterbed = filterbed + ".AND."
    ENDIF
    filterbed = filterbed + "sel_start()"
  ENDIF

RETURN



FUNCTION str2num(str)   // Wandelt Richtungs-String um in Wert
  LOCAL wert := 99
  str=TRIM(str)
  DO CASE
    CASE str="N"
      wert=0
    CASE str="NNO"
      wert=1
    CASE str="NO"
      wert=2
    CASE str="ONO"
      wert=3
    CASE str="O"
      wert=4
    CASE str="OSO"
      wert=5
    CASE str="SO"
      wert=6
    CASE str="SSO"
      wert=7
    CASE str="S"
      wert=8
    CASE str="SSW"
      wert=9
    CASE str="SW"
      wert=10
    CASE str="WSW"
      wert=11
    CASE str="W"
      wert=12
    CASE str="WNW"
      wert=13
    CASE str="NW"
      wert=14
    CASE str="NNW"
      wert=15
  ENDCASE
RETURN wert



FUNCTION min2dec(m)
RETURN INT(m)+(m-INT(m))*10/6



FUNCTION sel_radius()
RETURN !EMPTY(breite).AND.!EMPTY(laenge).AND.SQRT(((min2dec(breite)-min2dec(selekt->rbreite))*111)^2+((min2dec(laenge)-min2dec(selekt->rlaenge))*70.7)^2)<=selekt->radius



FUNCTION von(s)         // Ermittelt aus STARTRn-String den von-Wert
  LOCAL wert := 99
  n=AT("-",s)
  IF n>0
    wert=str2num(LEFT(s,n-1))
  ELSE
    wert=str2num(s)
  ENDIF
RETURN wert



FUNCTION bis(s)         // Ermittelt aus STARTRn-String den bis-Wert
  LOCAL wert := 99
  n=RAT("-",s)
  IF n>0
    wert=str2num(RIGHT(s,LEN(s)-n))
  ELSE
    wert=str2num(s)
  ENDIF
RETURN wert



FUNCTION sel_start()

  LOCAL svon := { von(startr1), von(startr2), von(startr3), von(startr4), von(startr5), von(startr6), str2num(selekt->startr1) }
  LOCAL sbis := { bis(startr1), bis(startr2), bis(startr3), bis(startr4), bis(startr5), bis(startr6), str2num(selekt->startr2) }

  LOCAL sart := { startart1,    startart2,    startart3,    startart4,    startart5,    startart6 }
  LOCAL shd  := { hdiff1,       hdiff2,       hdiff3,       hdiff4,       hdiff5,       hdiff6 }

  LOCAL anz_ok := 0 // Anzahl Startpltze, fr die die Selektion zutrifft
  LOCAL ret := .F. // .T., wenn mindestens 1 Startplatz der Selektion entspricht

  FOR i := 1 TO 7
    DO CASE             // Wenn NUR von- oder NUR bis-Wert fehlt, dann beide Werte gleichsetzen!
      CASE svon[i] <> 99 .AND. sbis[i] = 99
        sbis[i] = svon[i]
      CASE svon[i] = 99 .AND. sbis[i] <> 99
        svon[i] = sbis[i]
    ENDCASE
    IF svon[i] > sbis[i]     // ber Kreisanfang (0/360 Grad) hinweg?
      svon[i] -= 16
    ENDIF
  NEXT

  rvon = svon[7]        // Die ausgewhlte Startrichtung (ggf. gleichgesetzt)
  rbis = sbis[7]

  FOR startplatz := 1 TO 6

    start_ok := .T.    // OK-Flag fr einen Startplatz

    IF !EMPTY(selekt->startr1) .OR. !EMPTY(selekt->startr2)
      start_ok = .F.
      IF svon[startplatz] <> 99
        FOR r := rvon TO rbis    // Alle selektierten Startrichtungen in 1/16-Kreisumfang-Schritten
          FOR s := svon[startplatz] TO sbis[startplatz]
            IF MOD(r,16) = MOD(s,16)
              start_ok = .T.
            ENDIF
          NEXT
        NEXT
      ENDIF
    ENDIF

    IF !EMPTY(selekt->startart)
      IF EMPTY(sart[startplatz]) .OR. sart[startplatz] <> selekt->startart
        start_ok = .F.
      ENDIF
    ENDIF

    IF !EMPTY(selekt->hdiff1)
      IF EMPTY(shd[startplatz]) .OR. shd[startplatz] < selekt->hdiff1
        start_ok = .F.
      ENDIF
    ENDIF

    IF !EMPTY(selekt->hdiff2)
      IF EMPTY(shd[startplatz]) .OR. shd[startplatz] > selekt->hdiff2
        start_ok = .F.
      ENDIF
    ENDIF

    IF start_ok
      anz_ok ++
    ENDIF

  NEXT

  IF anz_ok > 0
    ret := .T.
  ENDIF

RETURN ret



FUNCTION hilfe()
  listfile("FLY.DOC")
RETURN



FUNCTION liste()

  LOCAL satz := RECNO()
  LOCAL screen
  LOCAL GetList := {}, datei := SPACE(80)
  LOCAL ausgabe := 0, OK := .T.

  SET COLOR TO (MNUDRUCK)
  @  7,21 CLEAR TO 17,58
  @  7,21 TO 17,58
  @  7,32 SAY "[Liste erstellen]"
  @  9,24 SAY "Wohin soll die Ausgabe erfolgen?" COLOR TXTDRUCK
  @ 11,24 PROMPT "           Bildschirm           "
  @ 13,24 PROMPT "             Drucker            "
  @ 15,24 PROMPT "              File              "
  MENU to ausgabe
  SET COLOR TO (NORMAL)

  IF LASTKEY()<>K_ESC
    DO CASE
      CASE ausgabe=1              // Bildschirm
        SET ALTERNATE TO FLY$$$.TMP
        SET ALTERNATE ON
      CASE ausgabe=2              // Drucker
        SET PRINTER ON
      CASE ausgabe=3              // File
        SET COLOR TO (BOXDATNAM)
        @ 11, 18  CLEAR TO  15, 61
        @ 11, 18  TO  15, 61
        @ 13, 22  SAY "Dateiname:" GET datei PICTURE "@!S25"; READ
        SET COLOR TO (NORMAL)
        IF LASTKEY() <> K_ESC .AND. !EMPTY(datei)
          SET ALTERNATE TO &datei
          SET ALTERNATE ON
        ELSE
          OK=.F.
        ENDIF
    ENDCASE
  ELSE
    OK=.F.
  ENDIF

  IF OK
    SET COLOR TO (BOXAUFBER)
    @ 10, 16  CLEAR TO  14, 63
    @ 10, 16  TO  14, 63
    SET COLOR TO (TXTAUFBER)
    @ 12, 20  SAY "Liste wird aufbereitet, bitte warten ..."
    SET COLOR TO (NORMAL)

    GO TOP
    SET CONSOLE OFF
    report()
    SET CONSOLE ON
    GO satz

    DO CASE
      CASE ausgabe=1              // Bildschirm
        SET ALTERNATE OFF
        CLOSE ALTERNATE
        screen=SAVESCREEN(0,0,24,79)
        listfile("FLY$$$.TMP")
        DELETE FILE FLY$$$.TMP
        RESTSCREEN(4,30,20,49,screen)
      CASE ausgabe=2              // Drucker
        SET PRINTER OFF
      CASE ausgabe=3              // File
        SET ALTERNATE OFF
        CLOSE ALTERNATE
    ENDCASE
  ENDIF

RETURN



FUNCTION report()

  LOCAL zeilen := 0

  DO WHILE !EOF()

//    XXX-99999 XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX 99.99N 99.99E  XXXXXXXX X 99999
//    XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  XXXXXXXX X 99999
//    XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  XXXXXXXX X 99999
//    XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX  XXXXXXXX X 99999
//                                                                    XXXXXXXX X 99999
//                                                                    XXXXXXXX X 99999
//    XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//    XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//    XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//    XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
//    XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

    ? PADR(TRIM(land)+IF(!EMPTY(land),"-","")+plz+" "+ort,48)+" "+ ;
      TRANSFORM(breite,"@Z 99.99")+IF(!EMPTY(breite),"N"," ")+" "+ ;
      TRANSFORM(laenge,"@Z 99.99")+IF(!EMPTY(breite),"E"," ")+"  "+ ;
                      startr1+" "+startart1+" "+TRANSFORM(hdiff1,"@Z 99999")
    zeilen++
    IF !EMPTY(gel_name) .OR. !EMPTY(startr2) .OR. !EMPTY(startart2) .OR. !EMPTY(hdiff2)
      ? gel_name+"  "+startr2+" "+startart2+" "+TRANSFORM(hdiff2,"@Z 99999")
      zeilen++
    ENDIF
    IF !EMPTY(gel_halter) .OR. !EMPTY(startr3) .OR. !EMPTY(startart3) .OR. !EMPTY(hdiff3)
      ? gel_halter+"  "+startr3+" "+startart3+" "+TRANSFORM(hdiff3,"@Z 99999")
      zeilen++
    ENDIF
    IF !EMPTY(kontakt) .OR. !EMPTY(startr4) .OR. !EMPTY(startart4) .OR. !EMPTY(hdiff4)
      ? kontakt +"  "+startr4+" "+startart4+" "+TRANSFORM(hdiff4,"@Z 99999")
      zeilen++
    ENDIF
    IF !EMPTY(startr5) .OR. !EMPTY(startart5) .OR. !EMPTY(hdiff5)
      ? SPACE(64)    +startr5+" "+startart5+" "+TRANSFORM(hdiff5,"@Z 99999")
      zeilen++
    ENDIF
    IF !EMPTY(startr6) .OR. !EMPTY(startart6) .OR. !EMPTY(hdiff6)
      ? SPACE(64)    +startr6+" "+startart6+" "+TRANSFORM(hdiff6,"@Z 99999")
      zeilen++
    ENDIF
    IF !EMPTY(bemerkung1)
      ? bemerkung1
      zeilen++
    ENDIF
    IF !EMPTY(bemerkung2)
      ? bemerkung2
      zeilen++
    ENDIF
    IF !EMPTY(bemerkung3)
      ? bemerkung3
      zeilen++
    ENDIF
    IF !EMPTY(bemerkung4)
      ? bemerkung4
      zeilen++
    ENDIF
    IF !EMPTY(bemerkung5)
      ? bemerkung5
      zeilen++
    ENDIF

    IF zeilen>50
      ?? CHR(12)
      zeilen=0
    ENDIF

    ?
    zeilen++

    SKIP
  ENDDO
  ?? CHR(12)
RETURN



FUNCTION listfile(datei)
  IF !FILE("LIST.COM")
    datei="LIST.COM"
  ENDIF
  IF FILE(datei)
    RUN(".\LIST.COM "+datei)
  ELSE
    SET COLOR TO (BOXDATERR)
    @  9,12 CLEAR TO 15,67
    @  9,12 TO 15,67
    @ 11,16 SAY "Sorry, die Datei "+datei+" ist nicht vorhanden!"
    @ 13,16 SAY "Weiter mit RETURN ..."
    SET COLOR TO (NORMAL)
    INKEY(0)
  ENDIF
RETURN
