/*****************************************************************************
*                                                                            *
* CURSES.H - Pseudo-Headerdatei zum Compilieren mit Turbo-C und ohne dCURSES *
*                                                                            *
* Programme, die ursprnglich fr UNIX geschrieben wurden und nur einige der *
* gebruchlichsten Curses-Funktionen benutzen, knnen mit etwas Glck auch   *
* ohne dCurses unter DOS zum Laufen gebracht werden, wenn diese Headerdatei  *
* eingebunden wird. Dies ist auch der Zweck, denn fr DOS gibt es weitaus    *
* bessere Bibliotheken zur Fensterverwaltung...                              *
*                                                                            *
* Auer stdscr wird nur maximal 1 zustzliches Fenster mit der Gre von     *
* stdscr (newwin(0,0,0,0)) untersttzt!                                      *
*                                                                            *
* (C) 1992 Stefan Bion                                                       *
*                                                                            *
*****************************************************************************/

#ifndef __CURSES_H
#define __CURSES_H

#include <stdio.h>
#include <stdarg.h>
#include <dos.h>
#include <conio.h>
#include <bios.h>

#define TRUE            1
#define FALSE           0

int A_NORMAL     = 0x07;
int A_BOLD       = 0x0F;
int A_STANDOUT   = 0x0F;
int A_UNDERLINE  = 0x08;
int A_BLINK      = 0x87;
int A_REVERSE    = 0x70;
int A_DIM        = 0x07;

char ACS_ULCORNER='';
char ACS_URCORNER='';
char ACS_HLINE   ='';
char ACS_LLCORNER='';
char ACS_LRCORNER='';
char ACS_VLINE   ='';

int LINES, COLS;

#define KEY_ENTER       10
#define KEY_ESC         27

#define KEY_MIN         0401           /* Tastendefinitionen: */
#define KEY_DOWN        0402           /* <CuDn> */
#define KEY_UP          0403           /* <CuUp> */
#define KEY_LEFT        0404           /* <CuLe> */
#define KEY_RIGHT       0405           /* <CuRi> */
#define KEY_HOME        0406           /* <Home> */
#define KEY_F0          0410
#define KEY_F(n)        (KEY_F0+(n))   /* <F1>...<F10> */
#define KEY_DC          0512           /* <DEL> */
#define KEY_IC          0513           /* <INS> */
#define KEY_SR          0520           /* <PgUp> */
#define KEY_PPAGE       0520           /* <PgUp> */
#define KEY_SF          0521           /* <PgDn> */
#define KEY_NPAGE       0521           /* <PgDn> */
#define KEY_BTAB        0541           /* <Sh-TAB> */
#define KEY_END         0550           /* <End> */
#define KEY_HELP        KEY_F(1)       /* <F1> */
#define KEY_MENU        KEY_F(10)      /* <F10> */
#define KEY_MAX         0777

typedef int WINDOW;                    /* Dummy-Typ WINDOW */
WINDOW *stdscr=NULL;                   /* Dummy-Fenster stdscr */

unsigned int vid_segment;              /* Segment des Video-Speichers */
unsigned int vid_attr;
unsigned int sav_attr;
unsigned int window_buf[2000];         /* Puffer fr Inhalt von "stdscr" */

void print(const char *f, ...)         /* Neue "printf"-Funktion: */
{                                      /* Alles nur, weil cprintf() "\n" */
  int i=0, i1=0;                       /* nicht in CR/LF bersetzt...    */
  char s[1000], s1[1000], c;
  va_list a;

  va_start(a,f);
  vsprintf(s,f,a);

  do
  {
    if(s[i]==10) s1[i1++]=13;
    c=s1[i1++]=s[i++];
  }
  while(c);

  i1=0; i=2*(wherex()-1)+160*(wherey()-1);
  while(s1[i1])
  {
    switch(s1[i1])
    {
      case 7:
      case 8:
      case 10:
      case 13:
        gotoxy((i-(i/160)*160)/2+1,i/160+1);
        cprintf("%c",s1[i1++]);
        i=2*(wherex()-1)+160*(wherey()-1);
        break;
      default:
        pokeb(vid_segment, i++, s1[i1++]);
        pokeb(vid_segment, i++, vid_attr);
    }
  }
  gotoxy((i-(i/160)*160)/2+1,i/160+1);
}

void raw(void) {}                      /* Dummy-Funktionen: */
void keypad(WINDOW *w, int bf) {}
void echo(void) {}
void noecho(void) {}
void refresh(void) {}
void wrefresh(WINDOW *w) {}
void touchwin(WINDOW *w) {}

#define curs_set(n)          _setcursortype((n)<<1)
#define getyx(w,y,x)         x=wherex()-1,y=wherey()-1
#define mvinch(y,x)          peek(vid_segment,160*(y)+2*(x))

#define erase                clrscr
#define endwin()             gotoxy(1,LINES-1)
#define getstr               gets
#define printw               print

#define addstr               print
#define waddstr(w,s)         print(s)
#define addch(c)             print("%c",(c))
#define waddch(w,c)          print("%c",(c))
#define echochar(c)          print("%c",(c))
#define attrset(a)           vid_attr=(a),textattr(a)
#define wattrset(w,a)        vid_attr=(a),textattr(a)
#define clrtoeol             clreol
#define wclrtoeol(w)         clreol()
#define move(y,x)            gotoxy(((x)+1),((y)+1))
#define wmove(w,x,y)         gotoxy(((x)+1),((y)+1))

#define mvaddch(y,x,c)       gotoxy(((x)+1),((y)+1)),print("%c",(c))
#define mvaddstr(y,x,s)      gotoxy(((x)+1),((y)+1)),print(s)
#define mvprintw(y,x,s,i)    gotoxy(((x)+1),((y)+1)),print((s),(i))

void initscr(void)
{
  vid_segment=(((peekb(0,0x410)>>4)&3)==3)?0xB000:0xB800;
  LINES=peekb(0,0x484)+1, COLS=peek(0,0x44A);
  sav_attr=peekb(vid_segment,2*COLS*LINES-1);
  attrset(A_NORMAL);
}

WINDOW *newwin(int dy, int dx, int y, int x)
{
  int i, v;
  WINDOW *w=NULL;
  for(i=0, v=0; i<2000; i++, v+=2) window_buf[i]=peek(vid_segment, v);
  clrscr(); return(w);
}

void delwin(WINDOW *w)
{
  int i, v;
  for(i=0, v=0; i<2000; i++, v+=2) poke(vid_segment, v, window_buf[i]);
}

int getch(void)
{
  int c=-1;

  struct KEY
  {
    unsigned char ascii;
    unsigned char scan;
  } key;

  unsigned int *k=&key.ascii;
  *k=bioskey(0);

  if(!(key.ascii))
  {
    switch(key.scan)
    {
      case 80: c=KEY_DOWN; break;
      case 72: c=KEY_UP; break;
      case 75: c=KEY_LEFT; break;
      case 77: c=KEY_RIGHT; break;
      case 71: c=KEY_HOME; break;
      case 59: c=KEY_F(1); break;
      case 60: c=KEY_F(2); break;
      case 61: c=KEY_F(3); break;
      case 62: c=KEY_F(4); break;
      case 63: c=KEY_F(5); break;
      case 64: c=KEY_F(6); break;
      case 65: c=KEY_F(7); break;
      case 66: c=KEY_F(8); break;
      case 67: c=KEY_F(9); break;
      case 68: c=KEY_F(10); break;
      case 83: c=KEY_DC; break;
      case 82: c=KEY_IC; break;
      case 73: c=KEY_SR; break;
      case 81: c=KEY_SF; break;
      case 15: c=KEY_BTAB; break;
      case 79: c=KEY_END; break;
    }
  }
  else c=key.ascii;
  return(c);
}

#endif
