#include <curses.h>
#include <stdio.h>
#include <stdlib.h>   
#include <signal.h>
#include <setjmp.h>

#define true 1
#define false 0

#define RO 0       /* Open-Modus: Read Only */
#define RW 1       /* Open-Modus: Read+Write */

typedef unsigned char BYTE;
typedef unsigned int  WORD;
typedef unsigned long DWORD;

extern int errno;
extern char *sys_errlist[];

jmp_buf jmpbuf;

FILE *fp;

BYTE   filename[81], filebuf[256], findbuf[81],
       findlen, openmode, patchmode, patched=false;

DWORD  filelen, startofs=0, bytes, findofs;
 
void abbruch(void)
{
  exit(0);
}

void weiter(void)
{
  longjmp(jmpbuf,0);
}

BYTE *skip_path(BYTE *f)
{
  BYTE *p=f+strlen(f);
  while(f<p && *(p-1)!='/') p--;
  return(p);
}

void print_screen(void)
{
  WORD i;

  erase();
  noecho();

  attrset(A_REVERSE);
  addstr("        *** Full Screen Hex File Editor V1.00  (C) 1992 Stefan Bion ***        \n");
  addstr("   Offset   00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F  0123456789ABCDEF  \n");
  move(18,0);
  addstr("      File:                               Mode: Read         Bytes:            \n");
  addstr("  Commands: F1-Offset   F2-Find   F3-Repeat Find   TAB-Hex/ASCII   ESC-Exit    \n");
  mvaddstr(18,12,skip_path(filename));
  mvaddstr(18,52,openmode?"+Write":" Only ");
  mvprintw(18,68,"%.8lX",filelen);
  attrset(A_NORMAL);
  move(2,12), patchmode='h';
}

DWORD flaenge(void)
{
  DWORD l,p;
  p=ftell(fp);
  fseek(fp,0,SEEK_END);
  l=ftell(fp);
  fseek(fp,p,SEEK_SET);
  return(l);
}

void write_file(void)
{
  fseek(fp,startofs,SEEK_SET);
  fwrite(filebuf,1,bytes,fp);
}

BYTE ask_yn(void)
{
  BYTE c;
  do c=toupper(getch()); while(c!='Y'&&c!='N'&&c!='\n'&&c!=27);
  return(c=='Y'||c=='\n');
}

void rewrite_file(void)
{
  WORD x,y;
  if(patched)
  {
    getyx(stdscr,y,x);
    move(20,0); addstr("Write patched Sector (y/n) ");
    if(ask_yn()) write_file();
    move(20,0); clrtoeol();
    move(y,x);
    patched=false;
  }
}

void read_file(void)
{
  WORD i;
  for(i=0;i<256;i++) *(filebuf+i)=0;
  fseek(fp,startofs,SEEK_SET);
  bytes=fread(filebuf,1,256,fp);
}
  
void print_file(void)
{
  BYTE b;
  WORD x,y,x1,y1;

  getyx(stdscr,y1,x1);
  curs_set(0);
  move(2,0);
  attrset(A_REVERSE);

  for(y=0;y<16;y++)
  {
    printw("  %.8lX ",startofs+(y<<4));
    attrset(A_NORMAL); addch(' ');
    for(x=0;x<16;x++) printw("%.2X ",filebuf[(y<<4)+x]);
    attrset(A_REVERSE); addch(' '); attrset(A_NORMAL);
    for(x=0;x<16;x++)
    {
      b=filebuf[(y<<4)+x];
      if(b<32||b>126) b='.';
      addch(b);
    }
    attrset(A_REVERSE); addstr("  \n");
  }
  attrset(A_NORMAL);
  curs_set(1);
  move(y1,x1);
}

void putcurs(WORD i)
{
  WORD y=i/16+2, x=i%16;
  if(patchmode=='h')
    move(y,x*3+12);
  else
    move(y,x+61);
}

void new_offset(void)
{
  BYTE *e,b[20];
  WORD x,y;
  DWORD o,s;

  getyx(stdscr,y,x);
  move(20,0); addstr("New Offset: ");
  echo(); getstr(b); noecho();
  move(20,0); clrtoeol();
  if(*b)
  {
    if((o=strtol(b,&e,16))<filelen)
    {
      if((s=(o>>8)<<8)!=startofs)
      {
        rewrite_file();
        startofs=s;
        read_file();
        print_file();
      }
      putcurs(o-s);
    }
    else move(y,x);
  }
  else move(y,x);
}

void switch_hex_ascii(void)
{
  WORD x,y;
  getyx(stdscr,y,x);

  if(patchmode=='h')
  {
    patchmode='a';
    x=(x-12)/3+61;
  }
  else
  {
    patchmode='h';
    x=(x-61)*3+12;
  }
  move(y,x);
}

BYTE page_up(void)
{
  BYTE b=0;
  if(startofs>=256)
  {
    rewrite_file();
    startofs-=256;
    read_file();
    print_file();
    b=1;
  }
  return(b);
}

BYTE page_dn(void)
{
  BYTE b=0;
  if(startofs+256<filelen)
  {
    rewrite_file();
    startofs+=256;
    read_file();
    print_file();
    b=1;
  }
  return(b);
}

BYTE cursor_up(void)
{
  BYTE b=0;
  WORD x,y;
  getyx(stdscr,y,x);

  if(y>2) y--, b=1;
  else
    if(page_up()) y=17, b=1;

  if(b) move(y,x);
  return(b);
}

BYTE cursor_dn(void)
{
  BYTE b=0;
  WORD x,y;
  getyx(stdscr,y,x);

  if(y<17) y++, b=1;
  else
    if(page_dn()) y=2, b=1;

  if(b) move(y,x);
  return(b);
}

void cursor_le(void)
{
  WORD x,y;
  getyx(stdscr,y,x);

  if(patchmode=='h')
  {
    if(!(x%3)) x--;
    {
      if(x>12) move(y,x-1);
      else
        if(cursor_up()) getyx(stdscr,y,x), move(y,58);
    }
  }
  else
  {
    if(x>61) move(y,x-1);
    else
      if(cursor_up()) getyx(stdscr,y,x), move(y,76);
  }
}

void cursor_ri(void)
{
  WORD x,y;
  getyx(stdscr,y,x);

  if(patchmode=='h')
  {
    if(!((x+2)%3)) x++;
    {
      if(x<58) move(y,x+1);
      else
        if(cursor_dn()) getyx(stdscr,y,x), move(y,12);
    }
  }
  else
  {
    if(x<76) move(y,x+1);
    else
      if(cursor_dn()) getyx(stdscr,y,x), move(y,61);
  }
}

void update(WORD i)
{
  BYTE b;
  WORD x,y,x1,y1;
  getyx(stdscr,y1,x1);
  curs_set(0);
  y=i/16+2, x=i%16;

  move(y,x+61);
  b=filebuf[i];
  if(b<32||b>126) b='.';
  addch(b);   

  move(y,x*3+12);
  printw("%.2X",filebuf[i]);

  move(y1,x1);
  curs_set(1);
}

void patch(BYTE b)
{
  BYTE *e,hex[3];
  WORD i,x,x1,y;
  getyx(stdscr,y,x);

  if(patchmode=='h')
  {
    b=toupper(b);
    if((b>='A'&&b<='F')||(b>='0'&&b<='9'))
    {
      i=((y-2)<<4)+(x-12)/3;
      x1=(i%16)*3+12;
      addch(b);
      hex[0]=mvinch(y,x1)&0xFF, hex[1]=mvinch(y,x1+1)&0xFF, hex[2]=0;
      b=strtol(hex,&e,16);
      filebuf[i]=b;
      move(y,x);
      update(i);          
      patched=true;
      cursor_ri();
    }
  }
  else
  {
    i=((y-2)<<4)+(x-61);
    filebuf[i]=b;
    update(i);          
    patched=true;
    cursor_ri();
  }
}

WORD getstring(BYTE *s)
{
  BYTE c, *e, ein[80];
  WORD i=0, j, k=0;

  echo(); getstr(ein); noecho();

  while(ein[i])
  {
    if(ein[i]=='\"')
    {
      for(i++; ein[i] && ein[i]!='\"'; *(s+k++)=ein[i++]);
      if(ein[i]) i++;
    }
    else
    {
      while(ein[i]==',') i++;
      if(ein[i] && ein[i]!='\"')
      {
        for(j=i; ein[i] && ein[i]!=',' && ein[i]!='\"'; i++);
        c=ein[i], ein[i]=0;
        *(s+k++)=strtol(ein+j,&e,16);
        ein[i]=c;
      } 
    }
  }
  return(k);
}

void get_findstr(void)
{                                                                          
  WORD x,y;
  getyx(stdscr,y,x);
  move(20,0); addstr("Find: ");
  findlen=getstring(findbuf);
  move(20,0); clrtoeol();
  move(y,x);
}

BYTE scan(void)
{
  DWORD j=findofs, j1;
  BYTE b=0, b1, i=0, byte[256], bufchg;

  fseek(fp, j, SEEK_SET);
  fread(byte, 1, 256, fp);

  do
  {
    bufchg=false;
    if(byte[b]==findbuf[i])
    {
      j1=j; b1=b;
      do
      {
        i++; j++; b++;
        if(!b)
        {
          fseek(fp, j, SEEK_SET);
          fread(byte, 1, 256, fp);
          bufchg=true;
        }
        if(i==findlen)
        {
          findofs=j1;
          return(true);
        }
        if(j==filelen) return(false);
      }
      while(byte[b]==findbuf[i]);
      i=0; j=j1; b=b1;
    }
    j++; b++;
    if(!b||bufchg)
    {
      fseek(fp, j, SEEK_SET);
      fread(byte, 1, 256, fp);
    }
  }
  while(j<filelen);
  return(false);
}

void find(void)
{
  WORD i,x,y;
  DWORD s;
  getyx(stdscr,y,x);
  attrset(A_BLINK);
  mvaddstr(20,0,"Searching...");
  attrset(A_NORMAL);
  refresh();

  i=(patchmode=='h')?(x-12)/3:(x-61);
  findofs=startofs+((y-2)<<4)+i+1;

  if(scan())
  {
    if((s=(findofs>>8)<<8)!=startofs)
    {
      rewrite_file();
      startofs=s;
      read_file();
      print_file();
    }
    mvaddstr(20,0,"Found       ");
    putcurs(findofs-s);
  }
  else
  {
    mvaddstr(20,0,"Not found   ");
    move(y,x);
  }
}  

void main(int argc, char *argv[])
{
  WORD b;
  signal(SIGINT,abbruch);

  if(argc!=2)
  {
    printf("FSHE V1.00 Full Screen Hex File Editor  (C) 1992 Stefan Bion\n");
    printf("File to edit: "); gets(filename); if(!filename[0]) abbruch();
  }
  else strcpy(filename, argv[1]);

  if((fp=fopen(filename,"r+b"))==NULL)
  { if((fp=fopen(filename,"rb"))==NULL)
    { printf("Error opening File %s: %s\n",filename,sys_errlist[errno]);
      exit(1);
    } else openmode=RO;
  } else openmode=RW;

  filelen=flaenge();
  initscr();
  keypad(stdscr,TRUE);

  setjmp(jmpbuf);
  signal(SIGINT,weiter);

  print_screen();
  startofs=0, patched=false;
  read_file(), print_file();

  for(;;)
  {
    switch(b=getch())
    {
      case KEY_PPAGE: page_up(); break;
      case KEY_NPAGE: page_dn(); break;
      case KEY_UP:    cursor_up(); break;
      case KEY_DOWN:  cursor_dn(); break;
      case KEY_LEFT:  cursor_le(); break;
      case KEY_RIGHT: cursor_ri(); break;
      case KEY_F(1):  new_offset(); break;
      case KEY_F(2):  get_findstr();
      case KEY_F(3):  if(findlen) find(); break;
      case 0x0009:    switch_hex_ascii(); break;
      case 0x001B:    rewrite_file(); fclose(fp); endwin(); exit(0); break;
      default:        patch(b); break;
    }
  }
}
