;**************************************************************************
;**                                                                      **
;**   CDIGIT.ASM (C) Redaktionsbro Everts & Hagedorn DOS International  **
;**   Angepat zum Einbinden in C-Programme von Stefan Bion.             **
;**                                                                      **
;**   Assembler-Routinen zum Ausgeben und Einlesen von Sounds mit dem    **
;**   dem DOS-Digitizer:                                                 **
;**                                                                      **
;**   void timer_init (void);                                            **
;**   void timer_reset (void);                                           **
;**   int getdport (void);                                               **
;**   void play (char far* block);                                       **
;**   void lplay (char far* block);                                      **
;**   void rep (char far* block);                                        **
;**   void fadeplay (char far* block);                                   **
;**   void listen (char far* block);                                     **
;**   int rec (char far* block);                                         **
;**                                                                      **
;**   Soll ein anderes als das Speichermodell SMALL verwendet werden,    **
;**   dann ist die untenstehende .MODEL-Anweisung entsprechend zu        **
;**   ndern. Dieses Assemblermodul mu mit TASM assembliert werden.     **
;**                                                                      **
;**************************************************************************

                   .model large

;--------------------------------------------------------------------------
; Dieses Makro liest ein Byte vom AD-Wandler ins AL-Register ein.
;--------------------------------------------------------------------------

INBYTE             macro
                   inc dx                   ; Oberes Halbbyte einlesen
                   in al,dx
                   shl al,1
                   mov ah,al
                   inc dx                   ; Multiplexer umschalten
                   mov al,0Eh
                   out dx,al
                   dec dx                   ; Unteres Halbbyte einlesen
                   in al,dx
                   shr al,1
                   shr al,1
                   shr al,1
                   and ax,0F00Fh            ; Halbbytes miteinander verknpfen
                   or ah,al

                   inc dx                   ; Multiplexer zurcksetzen und
                   mov al,0Dh               ; Startimpuls fr neue Umwandlung
                   out dx,al                ; geben
                   dec ax
                   out dx,al
                   dec dx
                   dec dx
                   mov al,ah
                   endm

;--------------------------------------------------------------------------
; Dieses Makro gibt das Byte in AL auf dem Digitizer aus.
;--------------------------------------------------------------------------

OUTBYTE            macro
                   out dx,al
                   endm

;==========================================================================

                   .code

;--------------------------------------------------------------------------
; Globale Variablen
;--------------------------------------------------------------------------

port               dw 0

;--------------------------------------------------------------------------
; Lokale Variablen fr die Funktionen _play, _lplay, _fadeplay, _rep,
; _listen, _rec
;--------------------------------------------------------------------------

adr1               equ [bp-22]              ; (nur fr _fadeplay)
adr2               equ [bp-18]              ; (nur fr _fadeplay)
oldint08           equ word ptr [bp-14]
oldint09           equ [bp-10]
mastermask         equ byte ptr [bp-6]
slavemask          equ byte ptr [bp-5]
abbruch            equ word ptr [bp-4]
continue           equ word ptr [bp-2]

;--------------------------------------------------------------------------
; Folgende Prozedur setzt die Interrupt-Vektoren
;--------------------------------------------------------------------------

einschalten        proc near

                   mov dx,03F2h             ; Diskettenmotoren abschalten
                   xor al,al
                   out dx,al

                   in al,21h                ; Interrupt-Masken retten
                   mov mastermask,al
                   in al,0A1h
                   mov slavemask,al

                   mov al,0FCh              ; Interrupts bis auf Timer und
                   out 21h,al               ; Keyboard aus
                   mov al,0FFh
                   out 0A1h,al

                   cli                      ; Interrupts sperren
                   cld                      ; Stringzugriffe in aufsteigender Reihenfolge
                   xor ax,ax                ; Adresse fr Vektorzugriff setzen
                   mov es,ax

                   xchg si,es:[08h*4]       ; Interrupt-Vektor 08h retten und neu setzen
                   mov oldint08,si
                   mov ax,cs
                   xchg ax,es:[08h*4+2]
                   mov oldint08+2,ax

                   xchg di,es:[09h*4]       ; Interrupt-Vektor 09h retten und neu setzen
                   mov word ptr oldint09,di
                   mov ax,cs
                   xchg ax,es:[09h*4+2]
                   mov word ptr oldint09+2,ax

;                  push cs
;                  pop ds
;
;                  mov ax,3508h             ; Interrupt-Vektor 08h retten
;                  int 21h
;                  mov oldint08,bx
;                  mov oldint08+2,es
;                  mov dx,si                ; und neu setzen
;                  mov ax,2508h
;                  int 21h
;
;                  mov ax,3509h             ; Interrupt-Vektor 08h retten
;                  int 21h
;                  mov word ptr oldint09,bx
;                  mov word ptr oldint09+2,es
;                  mov dx,di                ; und neu setzen
;                  mov ax,2509h
;                  int 21h

                   ret

einschalten        endp

;--------------------------------------------------------------------------
; Bei jedem Drcken oder Loslassen einer Taste wird der Interrupt 09h aufgerufen
;--------------------------------------------------------------------------

neuerint09:        mov ah,al                ; Scan-Code der Taste lesen
                   in al,60h
                   and al,al                ; Wurde die Taste gedrckt?
                   jns keypressed
                   cmp al,0E0h
                   jae keypressed

                   in al,61h                ; Wenn nicht, dann ignorieren;
                   or al,80h                ; Besttigung an Tastatur und
                   out 61h,al               ; Controller geben
                   and al,7Fh
                   out 61h,al
                   mov al,61h
                   out 20h,al
                   mov al,ah
                   add sp,6                 ; Flags und Rcksprungadresse vom
                   jmp continue             ; Stapel und weitermachen

keypressed:        call abschalten          ; Taste gedrckt: Interrupts wiederherstellen
                   add sp,2                 ; Abbruchadresse auf Stack
                   push abbruch
                   jmp dword ptr oldint09   ; Tastaturtreiber aufrufen

;--------------------------------------------------------------------------
; Folgende Prozedur setzt die verbogenen Interrupt-Vektoren
; wieder auf ihre ursprnglichen Werte
;--------------------------------------------------------------------------

abschalten         proc near

                   push di
                   push es

                   mov al,mastermask        ; Restliche Interrupts wieder zulassen
                   out 21h,al
                   mov al,slavemask
                   out 0A1h,al

                   push ss                  ; Interrupt-Vektoren wiederherstellen:
                   pop ds                   ; DS:SI := SS:oldint08
                   lea si,oldint08
                   xor ax,ax                ; ES:DI := Int-08h-Vektor in der
                   mov es,ax                ; Interruptvektor-Tabelle.
                   mov di,08h*4
                   cld
                   movsw                    ; Gesicherte Interruptvektoren
                   movsw                    ; zurckschreiben.
                   movsw
                   movsw

;                  mov dx,oldint08          ; Interrupt-Vektor 08h wiederherstellen
;                  mov ax,oldint08+2
;                  mov ds,ax
;                  mov ax,2508h
;                  int 21h
;
;                  mov dx,word ptr oldint09 ; Interrupt-Vektor 09h wiederherstellen:
;                  mov ax,word ptr oldint09+2
;                  mov ds,ax
;                  mov ax,2509h
;                  int 21h

                   pop es
                   pop di
                   ret

abschalten         endp

;--------------------------------------------------------------------------
; Folgende Prozedur initialisiert den System-Timer
;--------------------------------------------------------------------------

                   public _timer_init       ; void timer_init (void);

_timer_init        proc
                   push si
                   push di

                   mov al,24h               ; Highbyte des System-Timers auf Null
                   out 43h,al
                   xor al,al
                   out 40h,al
                   mov al,14h
                   out 43h,al

                   pop di
                   pop si
                   ret

_timer_init        endp

;--------------------------------------------------------------------------
; Folgende Prozedur setzt den Timer
; wieder auf seine ursprnglichen Werte
;--------------------------------------------------------------------------

                   public _timer_reset      ; void timer_reset (void);

_timer_reset       proc
                   push si
                   push di

                   mov al,36h               ; Ticker-Timer auf Normalwert
                   out 43h,al
                   xor al,al
                   out 40h,al
                   out 40h,al

                   pop di
                   pop si
                   ret

_timer_reset       endp

;**************************************************************************
;*                                                                        *
;*    Die folgenden Prozeduren sind die Schnittstellen zum C-Programm     *
;*                                                                        *
;**************************************************************************

;--------------------------------------------------------------------------
; Von C aufgerufen bestimmt die folgende Prozedur die parallele
; Schnittstelle, an die der Digitizer angeschlossen ist:
;--------------------------------------------------------------------------

                   public _getdport         ; void getdport (void);

_getdport          proc
                   push si
                   push di

                   xor cx,cx                ; Ab 0:408h stehen die Portadressen der
                   mov es,cx                ; vier parallelen Schnittstellen (oder 0)
                   mov bx,0408h

testport:          mov dx,es:[bx]
                   and dx,dx                ; Wenn keine Karte vorhanden, dann
                   je noport                ; Adresse bergehen
                   mov cx,dx
                   push cx
                   push dx

                   xor al,al                ; Datenport auf 0, falls ein angeschlossener
                   out dx,al                ; Drucker Select nicht interpretiert

                   inc dx                   ; Wenn Busy, dann kein Digitizer
                   in al,dx
                   shl al,1
                   jnc nichtda

                   cli                      ; Mit der Strobe-Leitung eine Wandlung
                   inc dx                   ; auslsen, dabei Select auf 0
                   mov al,05h
                   out dx,al
                   mov al,0Ch
                   out dx,al

                   dec dx                   ; Wenn kein Busy, dann ist gar nichts
                   in al,dx                 ; angschlossen
                   sti
                   shl al,1
                   cmc
                   jnc nichtda

                   mov cx,100               ; Wenn innerhalb einer bestimmten Zeit
                                            ; der Busy-Anschlu wieder gelscht
warten:            in al,dx                 ; wird, dann ist ein Digitizer vorhanden
                   shl al,1
                   jc nichtda
                   loop warten

nichtda:           pop dx
                   pop cx
                   jc dfound

noport:            inc bx                   ; Vier Ports sind zu berprfen
                   inc bx
                   cmp bx,0410h
                   jb testport
                   xor dx,dx                ; Kein Digitizer gefunden; DX := 0

dfound:            mov port,dx
                   and dx,dx                ; Wenn nicht gefunden, dann wird die
                   jne portok               ; hchste im System vorkomende
                   mov port,cx              ; Schnittstelle angenommen

portok:            mov ax,port              ; Gefundene Portadresse (oder 0)
                   pop di                   ; in AX zurckgeben
                   pop si
                   ret

_getdport          endp

;--------------------------------------------------------------------------
; Block abspielen (Digitizer)
;--------------------------------------------------------------------------

                   public _play             ; void play (char far* block);

_play              proc
                   arg adr:dword

                   push bp
                   mov bp,sp
                   sub sp,14                ; Platz fr lokale Variablen schaffen
                   push ds
                   push si
                   push di

                   mov si,offset playint08  ; Digitizer einschalten
                   mov di,offset neuerint09
                   mov abbruch,offset playexit
                   mov continue,offset playcont
                   call einschalten
                   mov dx,port

                   les di,adr               ; ES:DI := Adresse des Parameterblocks

                   mov al,es:[di+8]         ; Abspielgeschwindigkeit des Blocks
                   out 40h,al               ; in den Ticker-Timer schreiben.
                   mov si,es:[di]           ; AX:SI := Anfangsadresse
                   mov ax,es:[di+2]
                   mov cx,es:[di+4]         ; BX:CX := Endadresse + 1
                   mov bx,es:[di+6]

playwert:          mov ds,ax                ; Prfen, ob das Blockende erreicht wurde
                   cmp ax,bx
                   jne playnext
                   cmp si,cx
                   je playlast

playnext:          lodsb                    ; Nchsten Wert lesen und auf Interrupt
                                            ; warten
playcont:          sti
                   hlt

playint08:         OUTBYTE                  ; Wert ausgeben
                   add sp,6                 ; Rcksprungadresse und Flags vom Stack
                                            ; entfernen
                   mov al,60h               ; Interruptbesttigung an Controller
                   out 20h,al
                   mov ax,ds                ; Falls ntig, Segmentadresse weiterzhlen
                   and si,15                ; und nchsten Wert ausgeben
                   jne playwert
                   inc ax
                   jmp playwert

playlast:          call abschalten
                   sti

playexit:          pop di
                   pop si
                   pop ds
                   mov sp,bp                ; Platz fr lokale Variablen freigeben
                   pop bp
                   ret

_play              endp

;--------------------------------------------------------------------------
; Block abspielen (Lautsprecher)
;--------------------------------------------------------------------------

                   public _lplay            ; void lplay (char far* block);

_lplay             proc
                   arg adr:dword

                   push bp
                   mov bp,sp
                   sub sp,14                ; Platz fr lokale Variablen schaffen
                   push ds
                   push si
                   push di

                   mov si,offset lplayint08 ; Digitizer einschalten
                   mov di,offset neuerint09
                   mov abbruch,offset lplayexit
                   mov continue,offset lplaycont
                   call einschalten

                   Mov AL,66h               ; Refresh-Timer setzen
                   Out 43h,AL
                   Xor AL,AL
                   Out 41h,AL
                   Mov AL,56h
                   Out 43h,AL
                   Mov AL,54
                   Out 41h,AL
                   Mov AL,0B0h              ; Sound-Timer setzen
                   Out 43h,AL
                   Xor AL,AL
                   Out 42h,AL
                   Out 42h,AL
                   Mov AL,90h
                   Out 43h,AL
                   In AL,61h                ; Lautsprecher anschalten
                   Or AL,3
                   Out 61h,AL
                   Push CS
                   Pop ES

                   les di,adr               ; ES:DI := Adresse des Parameterblocks

                   mov al,es:[di+8]         ; Abspielgeschwindigkeit des Blocks
                   out 40h,al               ; in den Ticker-Timer schreiben.
                   out 41h,al
                   mov si,es:[di]           ; AX:SI := Anfangsadresse
                   mov ax,es:[di+2]
                   mov cx,es:[di+4]         ; BX:CX := Endadresse + 1
                   mov bx,es:[di+6]

lplaywert:         mov ds,ax                ; Prfen, ob das Blockende erreicht wurde
                   cmp ax,bx
                   jne lplaynext
                   cmp si,cx
                   je lplaylast

lplaynext:         lodsb                    ; Wert lesen und von 0 bis 255
                   Shr AL,1                 ; auf 1 bis 64 skalieren
                   Shr AL,1
                   Inc AX

lplaycont:         sti
                   hlt

lplayint08:        Out 42h,AL               ; Wert auf dem Lautsprecher ausgeben
                   add sp,6                 ; Rcksprungadresse und Flags vom Stack
                                            ; entfernen
                   mov al,60h               ; Interruptbesttigung an Controller
                   out 20h,al
                   mov ax,ds                ; Falls ntig, Segmentadresse weiterzhlen
                   and si,15                ; und nchsten Wert ausgeben
                   jne lplaywert
                   inc ax
                   jmp lplaywert

lplaylast:         call abschalten

                   In AL,61h                ; Lautsprecher abschalten
                   And AL,254
                   Out 61h,AL
                   Mov AL,76h               ; Refresh auf Normalwert
                   Out 43h,AL
                   Mov AL,18
                   Out 41h,AL
                   Xor AL,AL
                   Out 41h,AL

                   sti

lplayexit:         pop di
                   pop si
                   pop ds
                   mov sp,bp                ; Platz fr lokale Variablen freigeben
                   pop bp
                   ret

_lplay             endp

;--------------------------------------------------------------------------
; Block wiederholt abspielen (repetieren)
;--------------------------------------------------------------------------

                   public  _rep             ; void rep (char far* block);

_rep               proc
                   arg adr:dword

                   push bp
                   mov bp,sp
                   sub sp,14                ; Platz fr lokale Variablen schaffen
                   push ds
                   push si
                   push di

                   mov si,offset repint08   ; Digitizer einschalten
                   mov di,offset neuerint09
                   mov abbruch,offset repexit
                   mov continue,offset repcont
                   call einschalten
                   mov dx,port

                   les di,adr               ; ES:DI := Adresse des Parameterblocks

repblock:          mov al,es:[di+8]         ; Abspielgeschwindigkeit des Blocks
                   out 40h,al               ; in den Ticker-Timer schreiben.
repeat:            mov si,es:[di]           ; AX:SI := Anfangsadresse
                   mov ax,es:[di+2]
                   mov cx,es:[di+4]         ; BX:CX := Endadresse + 1
                   mov bx,es:[di+6]

repwert:           mov ds,ax                ; Prfen, ob das Blockende erreicht wurde
                   cmp ax,bx
                   jne repnext
                   cmp si,cx
                   je repeat

repnext:           lodsb                    ; Nchsten Wert lesen und auf Interrupt
                                            ; warten
repcont:           sti
                   hlt

repint08:          OUTBYTE                  ; Wert ausgeben
                   add sp,6                 ; Rcksprungadresse und Flags vom Stack
                                            ; entfernen
                   mov al,60h               ; Interruptbesttigung an Controller
                   out 20h,al
                   mov ax,ds                ; Falls ntig, Segmentadresse weiterzhlen
                   and si,15                ; und nchsten Wert ausgeben
                   jne repwert
                   inc ax
                   jmp repwert

repexit:           pop di
                   pop si
                   pop ds
                   mov sp,bp                ; Platz fr lokale Variablen freigeben
                   pop bp
                   ret

_rep               endp

;--------------------------------------------------------------------------
; Block berlagernd abspielen (Digitizer)
;--------------------------------------------------------------------------

                   public _fadeplay         ; void fadeplay (char far* block);

_fadeplay          proc
                   arg adr:dword

                   push bp
                   mov bp,sp
                   sub sp,22                ; Platz fr lokale Variablen schaffen
                   push ds
                   push si
                   push di

                   mov si,offset fplayint08 ; Digitizer einschalten
                   mov di,offset neuerint09
                   mov abbruch,offset fplayexit
                   mov continue,offset fplaycont
                   call einschalten
                   mov dx,port

                   les di,adr               ; ES:DI := Adresse des Parameterblocks

                   mov al,es:[di+8]         ; Abspielgeschwindigkeit des Blocks
                   out 40h,al               ; in den Ticker-Timer schreiben.

                   mov ax,es:[di]           ; Anfangsadresse 1
                   mov word ptr adr1,ax
                   mov ax,es:[di+2]
                   mov word ptr adr1+2,ax

                   mov ax,es:[di+4]         ; Anfangsadresse 2
                   mov word ptr adr2,ax
                   mov ax,es:[di+6]
                   mov word ptr adr2+2,ax

                   mov cx,es:[di+9]         ; CX := Lnge des Blocks
                   mov di,cx                ; (merken fr Funktion 'fade')

fplaywert:         lds si,adr2
                   lodsb                    ; Wert 2 lesen
                   mov ah,al                ; AH := Wert 2
                   and si,15
                   mov word ptr adr2,si
                   jne fplay1
                   inc word ptr adr2+2      ; Segmentadresse weiterzhlen

fplay1:            lds si,adr1
                   lodsb                    ; AL := Wert 1
                   and si,15
                   mov word ptr adr1,si
                   jne fplay2
                   inc word ptr adr1+2      ; Segmentadresse weiterzhlen

fplay2:            call fade                ; Werte umrechnen (fading)

fplaycont:         sti                      ; Auf Interrupt warten
                   hlt

fplayint08:        OUTBYTE                  ; Wert ausgeben
                   add sp,6                 ; Rcksprungadresse und Flags vom Stack
                                            ; entfernen
                   mov al,60h               ; Interruptbesttigung an Controller
                   out 20h,al
                   loop fplaywert           ; Prfen, ob das Blockende erreicht wurde

fplaylast:         call abschalten
                   sti

fplayexit:         pop di
                   pop si
                   pop ds
                   mov sp,bp                ; Platz fr lokale Variablen freigeben
                   pop bp
                   ret

_fadeplay          endp

;--------------------------------------------------------------------------
; Zuhren
;--------------------------------------------------------------------------

                   public _listen           ; void listen (char rate);

_listen            proc
                   arg adr:dword

                   push bp
                   mov bp,sp
                   sub sp,14                ; Platz fr lokale Variablen schaffen
                   push ds
                   push si
                   push di

                   mov si,offset listint08  ; Digitizer einschalten
                   mov di,offset neuerint09
                   mov abbruch,offset listexit
                   mov continue,offset listcont
                   call einschalten
                   mov dx,port

                   les di,adr               ; ES:DI := Adresse des Parameterblocks

                   mov al,es:[di+8]         ; Taktrate in den Ticker-Timer
                   out 40h,al               ; schreiben

listcont:          sti                      ; In einer Endlosschleife (Abbruch durch
                   hlt                      ; Tastendruck) Werte einlesen und sofort
                                            ; wieder ausgeben
listint08:         INBYTE
                   OUTBYTE
                   add sp,6                 ; Stack reinigen
                   mov al,60h               ; Besttigung an Controller
                   out 20h,al
                   jmp listcont

listexit:          pop di
                   pop si
                   pop ds
                   mov sp,bp                ; Platz fr lokale Variablen freigeben
                   pop bp
                   ret

_listen            endp

;--------------------------------------------------------------------------
; Aufnehmen
;--------------------------------------------------------------------------

                   public _rec              ; void rec (char far* block);

_rec               proc
                   arg adr:dword

                   push bp
                   mov bp,sp
                   sub sp,14                ; Platz fr lokale Variablen schaffen
                   push ds
                   push si
                   push di

                   mov si,offset recint08   ; Digitizer einschalten
                   mov di,offset neuerint09
                   mov abbruch,offset recexit
                   mov continue,offset reccont
                   call einschalten
                   mov dx,port

                   INBYTE                   ; Dummy-Lesevorgang, um den Wandler
                                            ; zu starten
                   lds si,adr               ; DS:SI := Adresse des Parameterblocks
                   lodsw                    ; ES:DI := Anfangsadresse
                   mov di,ax
                   lodsw
                   mov es,ax
                   lodsw                    ; BX:CX := Endadresse + 1
                   mov cx,ax
                   lodsw
                   mov bx,ax

                   lodsb                    ; Aufnahmetaktrate holen und in
                   out 40h,al               ; Ticker-Timer schreiben
                   mov si,es

recwert:           cmp si,bx                ; Auf Blockende prfen
                   jne reccont
                   cmp di,cx
                   je reclast

reccont:           sti                      ; Auf Ticker-Interrupt warten
                   hlt

recint08:          INBYTE                   ; Wert lesen und zur Kontrolle ausgeben
                   OUTBYTE
                   stosb                    ; Wert speichern
                   add sp,6                 ; Flags und Rcksprungadresse vom Stack
                                            ; entfernen
                   mov al,60h               ; Besttigung an Controller
                   out 20h,al
                   and di,15                ; Segmentanteil erhhen, falls erforderlich
                   jne recwert
                   inc si
                   mov es,si
                   jmp recwert

reclast:           call abschalten
                   sti

recexit:           mov ax,di                ; Adresse als Long-Wert zurckgeben
                   mov dx,es

                   pop di
                   pop si
                   pop ds
                   mov sp,bp                ; Platz fr lokale Variablen freigeben
                   pop bp
                   ret

_rec               endp

;--------------------------------------------------------------------------
; Fading-Werte errechnen
; Eingabe: AL = Wert 1, AH = Wert 2, DI = Blocklnge, CX = Zhler
; Ausgabe: AL = Gesamtwert
;--------------------------------------------------------------------------

fade               proc near

                   push dx

                   push ax                  ; (long) wert1 = wert1 * n / len
                   mov ah,0
                   sub ax,127
                   mov bx,di
                   sub bx,cx
                   imul bx
                   mov bx,di
                   idiv bx
                   add al,127
                   pop bx
                   mov ah,bh

                   push ax                  ; (long) wert2 = wert2 * (len-n) / len
                   mov al,ah
                   mov ah,0
                   sub ax,127
                   mov bx,cx
                   imul bx
                   mov bx,di
                   idiv bx
                   add al,127
                   mov ah,al
                   pop bx
                   mov al,bl

                   pop dx

                   sub al,127               ; Werte addieren
                   adc al,ah

                   ret

fade               endp

;--------------------------------------------------------------------------
; Peak-Wert ermitteln
;--------------------------------------------------------------------------

                   public _peakval          ; char peakval(char *a, int n)

_peakval           proc
                   arg a:dword, n:word

                   push bp
                   mov bp,sp

                   push ds
                   push si
                   push di

                   lds si,a
                   mov cx,n

                   mov ah,0                 ; Maximalwert

              pv0: lodsb                    ; Sample-Wert

                   sub al,128               ; Nullinie subtrahieren

                   cmp al,0                 ; Negative Halbwelle
                   jge pv2
                   neg al

              pv2: cmp al,ah                ; Spitzenwert
                   jbe pv3
                   mov ah,al

              pv3: or si,si                 ; Segment berschritten?
                   jnz pv1

                   mov bx,ds                ; Segment weiterschalten
                   add bx,1000h
                   mov ds,bx

              pv1: loop pv0                 ; Nchster Wert

                   mov al,ah                ; Maximalwert zurckgeben
                   mov ah,0

                   pop di
                   pop si
                   pop ds

                   mov sp,bp                ; Platz fr lokale Variablen freigeben
                   pop bp
                   ret

_peakval           endp

;==========================================================================

                   end
