;--------------------------------------------------------------------------
; Ermitteln der Checksumme: AX = Flag
;--------------------------------------------------------------------------
; Ermittelt die Checksumme des gestarteten Programms, d.h. die Quersumme
; aller Bytes modulo 65536. Die Routine kehrt nur zurck, wenn die tatsch-
; liche Checksumme mit der angegebenen bereinstimmt; ansonsten wird das
; Programm mit einer entsprechenden Meldung abgebrochen.
;
; Um die Checksumme zu ermitteln, wie folgt vorgehen:
;
; Aufruf der Routine mit AL = 1 (0 nur fr Testphase), das "NOP" durch
; "INT 3" ersetzen, das Programm assemblieren, und dann das Utility
; BRKPOINT.COM installieren (dieses zeigt bei Auftreten eines INT 3 die
; aktuellen Inhalte aller Register an). Nach Start des assemblierten
; Programms meldet sich BRKPOINT mit den Registerinhalten.
; Die Checksumme ergibt sich aus dem Inhalt des BX-Registers:
;
;   Checksumme = BX - [INT 3] + [NOP] = BX - 0CCh + 90h = BX - 3Ch
;
; Anschlieend das "INT 3" wieder durch "NOP" ersetzen, die errechnete
; Checksumme in den Sourcecode einsetzen und das Programm endgltig
; assemblieren.
;
; Eingabe: AL = Flag (0 = Prfung umgehen, sonst durchfhren)
;
; Das Modul GETPATH wird bentigt (EXTRN).
;--------------------------------------------------------------------------
checksum_txt       db 'Checksum Error!',13,10,'$'

checksum:          cmp al,0                 ; Wenn Flag gelscht, dann
                   if e ret                 ; Prfung umgehen.

                   push ax,bx,cx,dx,si

                   xor bx,bx                ; BX: Summe aller Bytes
                   xor ah,ah                ; AH: Mu 0 sein

                   lea si,...               ; 1.) Von ... bis SAA_COLORS:

; Bei Verwendung der SAA-Toolbox sind die Semikolons links zu entfernen !
;
;                  lea cx,saa_colors        ; Bei ... ist eine Adresse einzu-
;                  sub cx,si                ; setzen, von der an die Checksumme
;             m0:  lodsb                    ; berechnet werden soll (ggf. hinter
;                  add bx,ax                ; Stack und Setup-Variablen!).
;                  loop m0
;
;                  lea si,saa_colors        ; 2.) Von SAA_COLORS + 12
;                  add si,12                ;     bis File-Ende:

                   call getpath             ; Anzahl Bytes von SI bis
                   push ds                  ; Programmende ermitteln:
                   mov ax,3D00h             ; Datei zum Lesen ffnen.
                   mov dx,di
                   mov ds,es
                   int 21h
                   pop ds
                   jc abort
                   push bx                  ; Dateilnge ermitteln.
                   mov bx,ax
                   mov ax,4202h
                   xor cx,cx
                   xor dx,dx
                   int 21h
                   mov cx,ax                ; CX := Lnge der Datei
                   mov ah,3Eh               ; Datei schlieen.
                   int 21h
                   pop bx
                   add cx,100h              ; CX := Lnge + 100h - SI
                   sub cx,si

              m0:  lodsb                    ; Checksumme vin SI bis
                   add bx,ax                ; Programmende bliden.
                   loop m0

                   mov al,b chksum_lo       ; Dann die nachtrglich einzu-
                   sub bx,ax                ; tragende Checksumme abziehen.
                   mov al,b chksum_hi
                   sub bx,ax
                   nop                      ; (siehe Text oben)

                   db 81h,0FBh              ; CMP BX,iw
                   dw 00000h      ; <-------- (Nachtrglich einzutragende
chksum_lo          equ $-2                  ; Checksumme).
chksum_hi          equ $-1
                   je ckecksum_ok           ; Wenn ok, dann zurck.

abort:             lea dx,checksum_txt      ; Sonst: Meldung ausgeben und
                   mov ah,9                 ; Programm beenden.
                   int 21h
                   mov ax,4C01h
                   int 21h

ckecksum_ok:       pop si,dx,cx,bx,ax
                   ret

;--------------------------------------------------------------------------
