//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <registry.hpp>
#include "settings.h"
#include "main.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFormSettings *FormSettings;
//---------------------------------------------------------------------------
__fastcall TFormSettings::TFormSettings(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TFormSettings::FormShow(TObject *Sender)
{
  ActiveControl = ButtonOK;
  Left = Form1->Left + (Form1->Width - Width) / 2;
  Top = Form1->Top + (Form1->Height - Height) / 2;
}
//---------------------------------------------------------------------------
void __fastcall TFormSettings::ButtonSaveSettingsClick(TObject *Sender)
{
  Form1->SavePreferences();
}
//---------------------------------------------------------------------------

void __fastcall TFormSettings::ButtonCueWindowFontClick(TObject *Sender)
{
  FontDialog1->Font = EditSampleCueWindow->Font;
  if(!FontDialog1->Execute()) return;
  EditSampleCueWindow->Font = FontDialog1->Font;
}
//---------------------------------------------------------------------------

void __fastcall TFormSettings::ButtonCueWindowFGColorClick(TObject *Sender)
{
  ColorDialog1->Color = EditSampleCueWindow->Font->Color;
  if(!ColorDialog1->Execute()) return;
  EditSampleCueWindow->Font->Color = ColorDialog1->Color;
}
//---------------------------------------------------------------------------

void __fastcall TFormSettings::ButtonCueWindowBGColorClick(TObject *Sender)
{
  ColorDialog1->Color = EditSampleCueWindow->Color;
  if(!ColorDialog1->Execute()) return;
  EditSampleCueWindow->Color = ColorDialog1->Color;
}
//---------------------------------------------------------------------------

void __fastcall TFormSettings::ButtonCuePlayerFontClick(TObject *Sender)
{
  FontDialog1->Font = EditSampleCuePlayer->Font;
  if(!FontDialog1->Execute()) return;
  EditSampleCuePlayer->Font = FontDialog1->Font;
}
//---------------------------------------------------------------------------

void __fastcall TFormSettings::ButtonCuePlayerFGColorClick(TObject *Sender)
{
  ColorDialog1->Color = EditSampleCuePlayer->Font->Color;
  if(!ColorDialog1->Execute()) return;
  EditSampleCuePlayer->Font->Color = ColorDialog1->Color;
}
//---------------------------------------------------------------------------

void __fastcall TFormSettings::ButtonCuePlayerBGColorClick(TObject *Sender)
{
  ColorDialog1->Color = EditSampleCuePlayer->Color;
  if(!ColorDialog1->Execute()) return;
  EditSampleCuePlayer->Color = ColorDialog1->Color;
}
//---------------------------------------------------------------------------

void __fastcall TFormSettings::ButtonExtAppBrowseClick(TObject *Sender)
{
  OpenDialogExtApp->FileName = strExtAppPath[RadioGroupExtApp->ItemIndex];

  if(OpenDialogExtApp->FileName.IsEmpty())
  {
    TRegistry *pReg = new TRegistry;
    pReg->RootKey = HKEY_LOCAL_MACHINE;
    pReg->OpenKey("SOFTWARE\\Microsoft\\Windows\\CurrentVersion", false);
    OpenDialogExtApp->InitialDir = pReg->ReadString("ProgramFilesDir");
    delete pReg;
  }

  if(!OpenDialogExtApp->Execute()) return;

  bChange = true;

  strExtAppPath[RadioGroupExtApp->ItemIndex] = OpenDialogExtApp->FileName;
  EditExtAppPath->Text = strExtAppPath[RadioGroupExtApp->ItemIndex];

  strExtAppArgs[RadioGroupExtApp->ItemIndex] = "\"%s\"";
  EditExtAppArgs->Text = strExtAppArgs[RadioGroupExtApp->ItemIndex];

  strExtAppName[RadioGroupExtApp->ItemIndex] = ExtractFileName(EditExtAppPath->Text.SubString(1, EditExtAppPath->Text.Length() - ExtractFileExt(EditExtAppPath->Text).Length()));
  EditExtAppName->Text = strExtAppName[RadioGroupExtApp->ItemIndex];

  bChange = false;
}
//---------------------------------------------------------------------------

void __fastcall TFormSettings::FormActivate(TObject *Sender)
{
  bChange = true;

  EditExtAppPath->Text = strExtAppPath[RadioGroupExtApp->ItemIndex];
  EditExtAppArgs->Text = strExtAppArgs[RadioGroupExtApp->ItemIndex];
  EditExtAppName->Text = strExtAppName[RadioGroupExtApp->ItemIndex];

  bChange = false;
}
//---------------------------------------------------------------------------

void __fastcall TFormSettings::RadioGroupExtAppClick(TObject *Sender)
{
  bChange = true;

  EditExtAppPath->Text = strExtAppPath[RadioGroupExtApp->ItemIndex];
  EditExtAppArgs->Text = strExtAppArgs[RadioGroupExtApp->ItemIndex];
  EditExtAppName->Text = strExtAppName[RadioGroupExtApp->ItemIndex];

  bChange = false;
}
//---------------------------------------------------------------------------

void __fastcall TFormSettings::EditExtAppPathChange(TObject *Sender)
{
  if(bChange) return;

  strExtAppPath[RadioGroupExtApp->ItemIndex] = EditExtAppPath->Text;

  if(EditExtAppPath->Text.IsEmpty())
  {
    EditExtAppName->Text = "";
    strExtAppName[RadioGroupExtApp->ItemIndex] = EditExtAppName->Text;

    EditExtAppArgs->Text = "";
    strExtAppArgs[RadioGroupExtApp->ItemIndex] = EditExtAppArgs->Text;
  }
}
//---------------------------------------------------------------------------

void __fastcall TFormSettings::EditExtAppNameChange(TObject *Sender)
{
  if(bChange) return;

  strExtAppName[RadioGroupExtApp->ItemIndex] = EditExtAppName->Text;
}
//---------------------------------------------------------------------------

void __fastcall TFormSettings::EditExtAppArgsChange(TObject *Sender)
{
  strExtAppArgs[RadioGroupExtApp->ItemIndex] = EditExtAppArgs->Text;
}
//---------------------------------------------------------------------------

