//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "riff.h"

//---------------------------------------------------------------------------

void RIFFError(String strChunkName)
{
  Application->MessageBox(("Cannot find '" + strChunkName + "' chunk.").c_str(), "Error in RIFF file", MB_OK | MB_ICONERROR | MB_APPLMODAL);
}
//---------------------------------------------------------------------------

String FOURCCToString(DWORD dwFOURCC)
{
  String strFOURCC = "", strChar;

  for(int i = 0; i < 4; i++)
  {
    int nDigit = (dwFOURCC >> (8*i)) & 0xFF;
    strChar = "";
    strChar.sprintf("%c", (char)nDigit);
    strFOURCC += strChar;
  }
  return strFOURCC.TrimRight();
}
//---------------------------------------------------------------------------

DWORD StringToFOURCC(String strFOURCC)
{
  DWORD dwFOURCC = 0;
  strFOURCC += "    ";
  char* pszFOURCC = strFOURCC.c_str();

  for(int i = 3; i >= 0; i--)
  {
    dwFOURCC *= 0x100;
    dwFOURCC += pszFOURCC[i];
  }
  return dwFOURCC;
}
//---------------------------------------------------------------------------
// Diese Funktion entspricht im Wesentlichen mmioDescend(), jedoch mit folgenden Unterschieden:
// - Es werden auch Chunks mit ungerader Chunksize und fehlendem Padbyte gefunden.
// - Der Parameter uFlags entfllt; stattdessen ist pChunk->ckid zu fllen (wie bei Subchunks).

int FindChunk(FILE *fp, LPMMCKINFO pChunk, LPMMCKINFO pParentChunk)
{
  DWORD dwChunkId = pChunk->ckid;

  int nBytesToRead = 8;
  if(dwChunkId == StringToFOURCC("RIFF") || dwChunkId == StringToFOURCC("LIST")) nBytesToRead = 12;

  int nBytesMax = 0x7fffffff;
  if(pParentChunk) nBytesMax = pParentChunk->cksize + pParentChunk->dwDataOffset - ftell(fp);

  int nBytesReadSoFar = 0;

  do
  {
    if(nBytesReadSoFar + nBytesToRead > nBytesMax) return -1;
    int nBytesRead = fread(pChunk, 1, nBytesToRead, fp);
    if(nBytesRead != nBytesToRead) return -1;
    if((pChunk->ckid & 0xff) == 0)     // 1. Byte = Padbyte?
    {
      fseek(fp, 1 - nBytesToRead, SEEK_CUR);    // File-Pointer zurcksetzen + 1 Byte vor
      nBytesReadSoFar++;
      if(nBytesReadSoFar + nBytesToRead > nBytesMax) return -1;
      nBytesRead = fread(pChunk, 1, nBytesToRead, fp);  // nochmal lesen
      if(nBytesRead != nBytesToRead) return -1;
    }
    nBytesReadSoFar += nBytesRead;
    if(pChunk->ckid == dwChunkId)
    {
      pChunk->dwDataOffset = ftell(fp) + 8 - nBytesToRead;
      return 0;
    }
    if(pChunk->cksize <= 0) return -1; // unsinniger Wert?
    int nBytesToSkip = pChunk->cksize + 8 - nBytesToRead;
    if(nBytesReadSoFar + nBytesToSkip > nBytesMax) return -1;
    if(fseek(fp, nBytesToSkip, SEEK_CUR) != 0) return -1;
    nBytesReadSoFar += nBytesToSkip;
  }
  while(true);
}

// Diese Funktion entspricht im Wesentlichen mmioAscend(), jedoch mit folgenden Unterschieden:
// - Es knnen damit keine Chunks geschrieben werden (siehe mmioCreateChunk)

int SeekBehindChunk(FILE *fp, LPMMCKINFO pChunk)
{
  return fseek(fp, pChunk->cksize + pChunk->dwDataOffset - ftell(fp), SEEK_CUR);
}

//---------------------------------------------------------------------------
#pragma package(smart_init)

