//---------------------------------------------------------------------------
#ifndef mainH
#define mainH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <Menus.hpp>
#include <Dialogs.hpp>
//#include <mmsystem.h>   // fr WAVEFORMATEX usw. -> jetzt in riff.h!
#include "riff.h"       // RIFF file I/O
#include <mmreg.h>      // fr WAVE_FORMAT_IEEE_FLOAT etc.
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <shellapi.h>
#include "CSPIN.h"
#include <Menus.hpp>
#include <ExtCtrls.hpp>
#include <Buttons.hpp>
#include <Grids.hpp>
#include <ImgList.hpp>
//---------------------------------------------------------------------------
class TForm1 : public TForm
{
        typedef int (TForm1::*fcmp)(const void*, const void*);

__published:	// Von der IDE verwaltete Komponenten
    TMainMenu *MainMenu1;
    TMenuItem *MenuFile;
    TMenuItem *MenuEdit;
    TMenuItem *MenuHelp;
    TMenuItem *MenuOpen;
    TMenuItem *N1;
    TMenuItem *MenuExit;
    TMenuItem *MenuRead;
    TMenuItem *MenuWrite;
    TMenuItem *MenuAbout;
    TMenuItem *MenuCopy;
    TMenuItem *N2;
    TOpenDialog *OpenDialogWAV;
    TMenuItem *MenuLoad;
    TMenuItem *MenuSave;
    TMenuItem *N3;
    TStatusBar *StatusBar;
    TSaveDialog *SaveDialogCue;
    TOpenDialog *OpenDialogCue;
    TMenuItem *N4;
    TMenuItem *MenuShowTips;
    TMenuItem *MenuGotoWebsite;
    TMenuItem *MenuPreferences;
    TPanel *Panel1;
    TMenuItem *MenuPrint;
    TMenuItem *N9;
    TMenuItem *MenuOffset;
    TMenuItem *MenuSaveCueSheet;
    TSaveDialog *SaveDialogCueSheet;
    TBitBtn *ButtonOpen;
    TBitBtn *ButtonExit;
    TBitBtn *ButtonPrint;
    TBitBtn *ButtonCopy;
    TBitBtn *ButtonSaveCueSheet;
    TBitBtn *ButtonSave;
    TBitBtn *ButtonLoad;
    TBitBtn *ButtonWrite;
    TBitBtn *ButtonRead;
    TMenuItem *MenuDisplayFormat;
    TBitBtn *ButtonSaveTextFile;
    TMenuItem *MenuSaveTextFile;
    TSaveDialog *SaveDialogTextFile;
    TBitBtn *ButtonLoadCueSheet;
    TMenuItem *MenuLoadCueSheet;
    TMenuItem *N11;
    TOpenDialog *OpenDialogCueSheet;
    TMenuItem *MenuCopySel;
    TUpDown *UpDownPlay;
    TPanel *PanelPlay;
    TTrackBar *TrackBarPlay;
    TMenuItem *MenuGenCues;
    TPopupMenu *PopupMenuCuePlayer;
    TMenuItem *PopupMenuCuePlayer_AutoContinue;
    TMenuItem *PopupMenuCuePlayer_SkipCuePoints;
    TMenuItem *PopupMenuCuePlayer_PlayCuePoints;
    TMenuItem *PopupMenuCuePlayer_PrePostAudition;
    TMenuItem *N7;
    TMenuItem *PopupMenuCuePlayer_Preferences;
    TMenuItem *N12;
    TMenuItem *PopupMenuCuePlayer_Close;
    TMenuItem *PopupMenuCuePlayer_PlayCuePointsToEndOfFile;
    TMenuItem *PopupMenuCuePlayer_PlayCuePointsToNextCue;
    TMenuItem *PopupMenuCuePlayer_PlayCuePointsNotAtAll;
    TMenuItem *MenuSettings;
    TMenuItem *N5;
    TMenuItem *PopupMenuCuePlayer_DisplayTotalTime;
    TMenuItem *PopupMenuCuePlayer_DisplayRemainingTime;
    TSpeedButton *ButtonStop;
    TSpeedButton *ButtonPlay;
    TMenuItem *PopupMenuCuePlayer_RollBackOnReleasePause;
    TMenuItem *PopupMenuCuePlayer_PlayCueUnderCursor;
    TMenuItem *N6;
    TMenuItem *N8;
    TMenuItem *MenuEditor;
    TBitBtn *ButtonEditor;
    TPageControl *PageControlCueList;
    TTabSheet *TabSheetView;
    TTabSheet *TabSheetEdit;
    TRichEdit *RichEditCueList;
    TStringGrid *StringGrid;
    TPanel *Panel2;
    TEdit *EditCueLabel;
    TEdit *EditCueDescription;
    TEdit *EditCueBegin;
    TEdit *EditCueEnd;
    TEdit *EditCueLength;
    TLabel *Label3;
    TLabel *Label4;
    TLabel *Label5;
    TLabel *Label6;
    TButton *ButtonDeleteCue;
    TComboBox *ComboBoxCueType;
    TMenuItem *MenuDeleteCueList;
    TUpDown *UpDownCueBegin;
    TUpDown *UpDownCueEnd;
    TUpDown *UpDownCueLength;
    TPopupMenu *PopupMenuCueTimes;
    TMenuItem *PopupMenuCueTimes_1;
    TMenuItem *PopupMenuCueTimes_10;
    TMenuItem *PopupMenuCueTimes_100;
    TMenuItem *PopupMenuCueTimes_1000;
    TMenuItem *N13;
    TMenuItem *PopupMenuCueTimes_Samples;
    TMenuItem *PopupMenuCueTimes_Milliseconds;
    TMenuItem *PopupMenuCueTimes_Frames;
    TMenuItem *MenuStartStopPlaying;
    TButton *ButtonAddCue;
    TPopupMenu *PopupMenuStringGrid;
    TMenuItem *PopupMenuStringGrid_AddCue;
    TMenuItem *PopupMenuStringGrid_DeleteCue;
    TPopupMenu *PopupMenuExtApp;
    TMenuItem *PopupMenuExtApp1;
    TMenuItem *PopupMenuExtApp2;
    TMenuItem *PopupMenuExtApp3;
    TMenuItem *PopupMenuExtApp4;
    TMenuItem *PopupMenuExtApp5;
    TMenuItem *PopupMenuExtApp6;
    TMenuItem *PopupMenuExtApp7;
    TMenuItem *PopupMenuExtApp8;
    TMenuItem *PopupMenuExtApp9;
    TMenuItem *PopupMenuExtApp0;
    TMenuItem *N15;
    TMenuItem *PopupMenuExtApp_Configure;
    TMenuItem *MenuExtApp1;
    TMenuItem *MenuExtApp2;
    TMenuItem *MenuExtApp3;
    TMenuItem *MenuExtApp4;
    TMenuItem *MenuExtApp5;
    TMenuItem *MenuExtApp6;
    TMenuItem *MenuExtApp7;
    TMenuItem *MenuExtApp8;
    TMenuItem *MenuExtApp9;
    TMenuItem *MenuExtApp0;
    TMenuItem *N17;
    TMenuItem *MenuExtApp_Configure;
    TPopupMenu *PopupMenuViewWindow;
    TMenuItem *N16;
    TMenuItem *PopupMenuStringGrid_PlayCueNormal;
    TMenuItem *PopupMenuStringGrid_PlayCueExtended;
    TMenuItem *PopupMenuViewWindow_PlayCueNormal;
    TMenuItem *PopupMenuViewWindow_PlayCueExtended;
    TButton *ButtonDuplicateCue;
    TMenuItem *PopupMenuStringGrid_DuplicateCue;
    TMenuItem *N18;
    TMenuItem *PopupMenuStringGrid_SetCueBegin;
    TMenuItem *PopupMenuStringGrid_SetCueEnd;
    TMenuItem *Hidden1;
    TMenuItem *Addcue1;
    TButton *ButtonSetCueBegin;
    TButton *ButtonSetCueEnd;
    TMenuItem *Setbegin1;
    TMenuItem *Setend1;
    TMenuItem *Playcuenormal1;
    TMenuItem *Playcueextended1;
    TBitBtn *ButtonSaveAudacityLabels;
    TBitBtn *ButtonLoadAudacityLabels;
    TMenuItem *MenuLoadAudacityLabels;
    TMenuItem *MenuSaveAudacityLabels;
    TSaveDialog *SaveDialogTxt;
    TOpenDialog *OpenDialogTxt;
    TMenuItem *MenuImport;
    TMenuItem *MenuExport;
    TMenuItem *MenuDefineDisplayFormat;
    TImageList *ImageListIcons;
    void __fastcall ButtonOpenClick(TObject *Sender);
    void __fastcall MenuOpenClick(TObject *Sender);
    void __fastcall ButtonExitClick(TObject *Sender);
    void __fastcall MenuExitClick(TObject *Sender);
    void __fastcall ButtonCopyClick(TObject *Sender);
    void __fastcall MenuCopyClick(TObject *Sender);
    void __fastcall MenuAboutClick(TObject *Sender);
    void __fastcall ButtonReadClick(TObject *Sender);
    void __fastcall MenuReadClick(TObject *Sender);
    void __fastcall ButtonSaveClick(TObject *Sender);
    void __fastcall MenuSaveClick(TObject *Sender);
    void __fastcall ButtonLoadClick(TObject *Sender);
    void __fastcall MenuLoadClick(TObject *Sender);
    void __fastcall ButtonWriteClick(TObject *Sender);
    void __fastcall MenuWriteClick(TObject *Sender);
    void __fastcall FormCreate(TObject *Sender);
    void __fastcall MenuShowTipsClick(TObject *Sender);
    void __fastcall MenuGotoWebsiteClick(TObject *Sender);
    void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
    void __fastcall RichEditCueListMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y);
    void __fastcall ButtonPrintClick(TObject *Sender);
    void __fastcall MenuPrintClick(TObject *Sender);
    void __fastcall FormShow(TObject *Sender);
    void __fastcall MenuOffsetClick(TObject *Sender);
    void __fastcall ButtonSaveCueSheetClick(TObject *Sender);
    void __fastcall MenuSaveCueSheetClick(TObject *Sender);
    void __fastcall MenuDefineDisplayFormatClick(TObject *Sender);
    void __fastcall ButtonSaveTextFileClick(TObject *Sender);
    void __fastcall MenuSaveTextFileClick(TObject *Sender);
    void __fastcall ButtonLoadCueSheetClick(TObject *Sender);
    void __fastcall MenuLoadCueSheetClick(TObject *Sender);
    void __fastcall MenuCopySelClick(TObject *Sender);
    void __fastcall RichEditCueListSelectionChange(TObject *Sender);
    void __fastcall FormDestroy(TObject *Sender);
    void __fastcall UpDownPlayClick(TObject *Sender,
      TUDBtnType Button);
    void __fastcall ButtonPlayClick(TObject *Sender);
    void __fastcall ButtonStopClick(TObject *Sender);
    void __fastcall TrackBarPlayChange(TObject *Sender);
    void __fastcall MenuGenCuesClick(TObject *Sender);
    void __fastcall PopupMenuCuePlayer_AutoContinueClick(
      TObject *Sender);
    void __fastcall PopupMenuCuePlayer_SkipCuePointsClick(
      TObject *Sender);
    void __fastcall PopupMenuCuePlayer_PrePostAuditionClick(
      TObject *Sender);
    void __fastcall PopupMenuCuePlayer_PreferencesClick(
      TObject *Sender);
    void __fastcall PopupMenuCuePlayer_CloseClick(TObject *Sender);
    void __fastcall PopupMenuCuePlayer_PlayCuePointsToNextCueClick(
      TObject *Sender);
    void __fastcall PopupMenuCuePlayer_PlayCuePointsToEndOfFileClick(
      TObject *Sender);
    void __fastcall PopupMenuCuePlayer_PlayCuePointsNotAtAllClick(
      TObject *Sender);
    void __fastcall MenuSettingsClick(TObject *Sender);
    void __fastcall PopupMenuCuePlayer_DisplayTotalTimeClick(
      TObject *Sender);
    void __fastcall PopupMenuCuePlayer_DisplayRemainingTimeClick(
      TObject *Sender);
    void __fastcall PopupMenuCuePlayer_RollBackOnReleasePauseClick(TObject *Sender);
    void __fastcall PopupMenuCuePlayer_PlayCueUnderCursorClick(
      TObject *Sender);
    void __fastcall StringGridSelectCell(TObject *Sender, int ACol,
      int ARow, bool &CanSelect);
    void __fastcall ComboBoxCueTypeChange(TObject *Sender);
    void __fastcall EditCueLabelChange(TObject *Sender);
    void __fastcall EditCueDescriptionChange(TObject *Sender);
    void __fastcall EditCueDescriptionExit(TObject *Sender);
    void __fastcall EditCueLabelExit(TObject *Sender);
    void __fastcall ComboBoxCueTypeExit(TObject *Sender);
    void __fastcall StringGridDblClick(TObject *Sender);
    void __fastcall MenuDeleteCueListClick(TObject *Sender);
    void __fastcall UpDownCueBeginClick(TObject *Sender,
      TUDBtnType Button);
    void __fastcall UpDownCueEndClick(TObject *Sender,
      TUDBtnType Button);
    void __fastcall UpDownCueLengthClick(TObject *Sender,
      TUDBtnType Button);
    void __fastcall EditCueBeginExit(TObject *Sender);
    void __fastcall EditCueEndExit(TObject *Sender);
    void __fastcall EditCueLengthExit(TObject *Sender);
    void __fastcall PopupMenuCueTimes_1Click(TObject *Sender);
    void __fastcall PopupMenuCueTimes_10Click(TObject *Sender);
    void __fastcall PopupMenuCueTimes_100Click(TObject *Sender);
    void __fastcall PopupMenuCueTimes_1000Click(TObject *Sender);
    void __fastcall PopupMenuCueTimes_SamplesClick(TObject *Sender);
    void __fastcall PopupMenuCueTimes_MillisecondsClick(
      TObject *Sender);
    void __fastcall PopupMenuCueTimes_FramesClick(TObject *Sender);
    void __fastcall EditCueBeginKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift);
    void __fastcall EditCueLengthKeyDown(TObject *Sender, WORD &Key,
      TShiftState Shift);
    void __fastcall MenuStartStopPlayingClick(TObject *Sender);
    void __fastcall EditCueLabelEnter(TObject *Sender);
    void __fastcall EditCueDescriptionEnter(TObject *Sender);
    void __fastcall PopupMenuStringGrid_AddCueClick(TObject *Sender);
    void __fastcall PopupMenuStringGrid_DeleteCueClick(
      TObject *Sender);
    void __fastcall StringGridMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y);
    void __fastcall FormCloseQuery(TObject *Sender, bool &CanClose);
    void __fastcall PopupMenuExtApp_ConfigureClick(TObject *Sender);
    void __fastcall PopupMenuExtApp1Click(TObject *Sender);
    void __fastcall PopupMenuExtApp2Click(TObject *Sender);
    void __fastcall PopupMenuExtApp3Click(TObject *Sender);
    void __fastcall PopupMenuExtApp4Click(TObject *Sender);
    void __fastcall PopupMenuExtApp5Click(TObject *Sender);
    void __fastcall PopupMenuExtApp6Click(TObject *Sender);
    void __fastcall PopupMenuExtApp7Click(TObject *Sender);
    void __fastcall PopupMenuExtApp8Click(TObject *Sender);
    void __fastcall PopupMenuExtApp9Click(TObject *Sender);
    void __fastcall PopupMenuExtApp0Click(TObject *Sender);
    void __fastcall PopupMenuExtAppPopup(TObject *Sender);
    void __fastcall ButtonEditorClick(TObject *Sender);
    void __fastcall PopupMenuStringGrid_PlayCueNormalClick(
      TObject *Sender);
    void __fastcall PopupMenuStringGrid_PlayCueExtendedClick(
      TObject *Sender);
    void __fastcall PopupMenuViewWindow_PlayCueNormalClick(
      TObject *Sender);
    void __fastcall PopupMenuViewWindow_PlayCueExtendedClick(
      TObject *Sender);
    void __fastcall PopupMenuStringGrid_DuplicateCueClick(
      TObject *Sender);
    void __fastcall PopupMenuStringGrid_SetCueBeginClick(
      TObject *Sender);
    void __fastcall PopupMenuStringGrid_SetCueEndClick(
      TObject *Sender);
    void __fastcall MenuLoadAudacityLabelsClick(TObject *Sender);
    void __fastcall MenuSaveAudacityLabelsClick(TObject *Sender);
    void __fastcall ButtonLoadAudacityLabelsClick(TObject *Sender);
    void __fastcall ButtonSaveAudacityLabelsClick(TObject *Sender);
    void __fastcall MenuDisplayFormatPopup(TObject *Sender);

private:	// Anwenderdeklarationen

    // Allgemeine Variablen

    String strVersion;
    TFont *pFontCueList;
//    bool bShowTips;
    String strInitialCaption;
    bool bCueListChanged;

    int nSampleDisplay;                     // Im Display des Cue-Players angezeigtes Sample fr AddCue()
    int nSamplesPerSecDisplay;              // Fr Anzeige im Display des Cue-Players verwendete Sample-Rate

    #define DEFAULT_SAMPLERATE 44100

    // Cue-Details (unter dem StringGrid)
    bool bDisplayCueDetails;
    bool bCueBeginChanged;
    bool bCueLengthChanged;
    bool bCueTypeChanged;
    bool bCueLabelChanged;
    bool bCueDescriptionChanged;

    // Merkvariablen, die in der INI-Datei gespeichert werden

public: // Fr TFormDisplayFormat

    // Anzeigeformat
    String strFormatPoints;                 // Das aktuell ausgewhlte Anzeigeformat
    String strFormatRanges;
    String strFormatTime;
    String strFormatSeparator;
    String strFormatHeader;
    String strFormatSummary;
    bool bFormatHeaderEnabled;
    bool bFormatSummaryEnabled;
    int nFormatTimeLeadingDigitsHrs;
    int nFormatTimeFractionalDigitsHrs;
    int nFormatTimeLeadingDigitsMin;
    int nFormatTimeFractionalDigitsMin;
    int nFormatTimeLeadingDigitsSec;
    int nFormatTimeFractionalDigitsSec;
    int nFormatTimeLeadingDigitsFrm;
    int nFormatTimeFractionalDigitsFrm;
    int nFormatTimeLeadingDigitsSmp;
    int nFormatTimeFractionalDigitsSmp;

    struct DISPLAYFORMAT                    // Die Struktur fr die Liste verfgbarer Anzeigeformate
    {
      String strName;
      String strFormatPoints;
      String strFormatRanges;
      String strFormatTime;
      String strFormatSeparator;
      String strFormatHeader;
      String strFormatSummary;
      bool bFormatHeaderEnabled;
      bool bFormatSummaryEnabled;
      int nFormatTimeLeadingDigitsHrs;
      int nFormatTimeFractionalDigitsHrs;
      int nFormatTimeLeadingDigitsMin;
      int nFormatTimeFractionalDigitsMin;
      int nFormatTimeLeadingDigitsSec;
      int nFormatTimeFractionalDigitsSec;
      int nFormatTimeLeadingDigitsFrm;
      int nFormatTimeFractionalDigitsFrm;
      int nFormatTimeLeadingDigitsSmp;
      int nFormatTimeFractionalDigitsSmp;
    };

    enum { MAX_DISPLAYFORMATS = 100 };          // Die Maximalzahl anlegbarer Anzeigeformate
    DISPLAYFORMAT DisplayFormat[MAX_DISPLAYFORMATS];        // Die Liste verfgbarer Anzeigeformate
    int nNumberDisplayFormats;              // Die Anzahl angelegter Anzeigeformate

private: // Ab hier wieder private

    // Cue-Sheet
    bool bCueSheetAbsolutePath;
    bool bCueSheetIncludeCDText;
    bool bCueSheetUseCueLabelsAsTrackTitles;
    bool bCueSheetUseCueNotesAsTrackPerformer;
    bool bCueSheetIfCueNoteEmptyUseAlbumPerformer;
    bool bCueSheetInsertGaps;
    bool bCueSheetGapIsPreGap;
    String strCueSheetGapTime;
    bool bCueSheetGapOnlyExceptForFirstLastTrack;
    bool bCueSheetGapOnly;
    bool bCueSheetGapFirst;
    bool bCueSheetAddOffset;
    String strCueSheetOffsetTime;
    String strCueSheetIndex0Time;
    bool bCueSheetIndex0;
    String strBurnApplPath;
    String strBurnApplArguments;
    String strCueSheetCDFileName;
    String strCueSheetCDPerformer;
    String strCueSheetCDTitle;

    // Systemvariablen
    int nMaxCues;
    int nWaveBuffers;
    int nWaveBufferSize;

    int nMaxCuesNew;
    int nWaveBuffersNew;
    int nWaveBufferSizeNew;

    // Informationen zur ausgewhlten Audio-Datei

    String strAudioFileName;
    bool bAudioFileIsValid;
    int nAudioFileSamples;
    int nAudioFileSamplesPerSec;
    WAVEFORMATEX WaveFmt;

    // Variablen und Flags fr Play()

    int nPlayCue;
    WAVEFORMATEX WaveFmtPlay;
    int nPlayFileDataOffset;
    int nPlayBytesPerSample;
    int nPlaySamplesTotal;
    int nPlaySamplesPerSec;
    int nPlaySampleOffsetOrig;
    int nPlaySamplesOrig;
    int nPlaySampleOffset;
    int nPlaySamples;
    int nPlaySamplesDone;
    int nPlaySamplesRemaining;
    int nChangedPlaySampleOffset;
    int nChangedPlaySampleOffsetPrev;
    bool bPlaying;
    bool bPaused;
    bool bStopped;
    HWAVEOUT WaveHandle;
    #define NBUFFERS 2
    #define BUFSIZE 65536
//    WAVEHDR WaveHeader[NBUFFERS];   // Array von Wave-Header fr Double-Buffering
    WAVEHDR* WaveHeader;            // Array von Wave-Header fr Double-Buffering
//    char pWaveData[NBUFFERS][BUFSIZE];      // Pointer auf Wave-Daten
    char** pWaveData;               // Pointer auf Wave-Daten
    int iBuffer;                    // Index auf aktiven Wave-Header
    int nQueuedBuffers;
    FILE *fpWavFile;
    bool bAcceptTrackBarPlayChangeEvent;
    bool bAcceptUpDownPlayClickEvent;
    #define EXT_NONE        0x00000000L
    #define EXT_BEGIN       0x00000001L
    #define EXT_END         0x00000010L
    #define EXT_ALL         0x00000100L
    int nExtendCueTime;
    bool bEnableDisplayExtended;

    // Cue-List

    // Array fr Cues der Input-WAV-Datei
    struct CUEARRAY                 // ACHTUNG: Beim Erweitern dieser Struktur SortCueArray() anpassen!
    {
      int StartSample;              // Erstes Sample innerhalb der Wave-Daten
      int nSamples;                 // Anzahl Samples fr dieses Segment
      DWORD ID;                     // Nummer der Cue
      String Label;
      String Description;
      String Type;
    };

    #define MAXCUES 1000            // 1000 Cues sollten erst mal reichen...
//    CUEARRAY CueArray[MAXCUES];
    CUEARRAY* CueArray;
    int nCues;                      // Anzahl der vorhandenen Cues
    int nCueListSamplesPerSec;      // Samples pro Sekunde der CueList

    int nFilePointerCueSubchunk;    // Zeigt hinter die Wave-Daten
    int nDataChunkSizeDiff;         // Differenz der Gre des Data-Chunks der ursprnglichen
                                    // Wav-Datei gegenber der WavPack-Datei

    // Funktions-Deklarationen (private)

    void SelectAudioFile(String strFileName = "");
    void ReadCueListFromAudioFile(String strFileName);
    void WriteCueListToAudioFile(String strFileName);

    int ReadCueListFromRiffFile(String strFileName, int nCueArrayOffset, bool bDeleteCueListFromAudioFile = false);
    int WriteCueListToRiffFile(String strFileName, bool bDeleteCueListFromAudioFile = false);

    void Copy();
    void CopySel();
    void Display(bool bUpdate = false);
    String FormatTime(Extended fSec);
    String FormatTimeCueSheet(Extended fSec);
    void SaveCueListFile(bool bNonInteractive = false, String strFileName = "");
    void SaveCueSheet(bool bNonInteractive = false, String strCueSheetFileName = "");
    void SaveAudacityLabels(bool bNonInteractive = false, String strFileName = "");
    void LoadCueListFile(String strFileName = "");
    void LoadCueSheet(String FileName = "");
    void LoadAudacityLabels(String FileName = "");
    void ProcessFile(String strFileName, bool bSave = false);
    void __fastcall WmDropFiles(TWMDropFiles& Message);
    void LoadPreferences();
    void EnableControls();
    void SetStatusBarText(String strText);
    bool CueExists(int);
    void Drucken();
    void Help();
    void GotoWebsite();
    void AddTimeOffsetToAllCues();
    String CueArrayElementToSortString(CUEARRAY* pCueArrayElement);
    int CompareCueArrayElements(CUEARRAY* pElement1, CUEARRAY* pElement2);
    void SwapCueArrayElements(CUEARRAY* pElement1, CUEARRAY* pElement2);
    void SortCueArray();
    enum { MFS_HRS, MFS_MIN, MFS_SEC, MFS_FRM, MFS_SMP };
    char* MakeFormatString(int nFormatStringType, bool bFractional);
    bool CarryTimeString(String& strTime, int nMaxValue);
    void DefineDisplayFormat();
    void SaveTextFile(bool bNonInteractive = false, String strFileName = "");
    bool GetWavFileData(String strFileName, int& nSamples, int& nSamplesPerSec);
    bool VerifyCueIndex(int i);
    int CueSheetTimeStringToFrames(String strTemp);
    void SetCDPerformerAndTitleFromCDFileName();
    void RemoveNewLine(char *pszLine);
    bool TruncateFile(String strFileName, int nNewFileSize);
    void Play(int nCue);
    bool CanPlayFile();
    bool InitPlay();
    void QueuePlayBuffer(int nBuffer);
    void WaveOutError(DWORD nCode);
    void Start();
    void Pause();
    void Stop();
    void OnWaveOutDone(TMessage& msg);
    void DisplayPlay();
    void DisplayPlay(int nSampleOffset, int nSampleRate, int nSamples, int nSampleOffsetAbsolute, int nSamplesTotal);
    void GenerateCues();
    int GetPlaySamplesTrackBar();
    int GetPlaySamples();
    int GetPlaySamplesPerSec();
    int GetPlaySamplesTrackBarAbsolute();
    int GetPlaySamplesTotal();
    void Settings();
    void InitDeviceList();
    int GetCueAtCurrentCursorPosition();
    int GetOccurrences(String strString, String strPattern);
    void PlayCueUnderCursor(bool bPlay = true);
    void InitGrid();
    void DisplayCueDetails();
    String CueTypeToString(String strCueType);
    String CueStringToType(String strCueTypeString);
    void AddCue(int iCue);
    void DuplicateCue(int iCue);
    void DeleteCue(int iCue);
    void DeleteCueListFromAudioFile(String strAudioFileName);
    int GetSamplesIncrementCueTimes();
    void ChangeCueBegin(bool bIncrease);
    void ChangeCueLength(bool bIncrease);
    void ShowChangedCueTimes(int iCue);
    bool DiscardChanges();
    void StartExtApp();
    void SetExtApp(int nAppl);
    void InitExtAppMenuItems();
    String GetExtAppName(int nAppl);
    void SetCueBeginEnd(int iCue, int nMode);
    void SetDirtyFlag(bool nDirty = true);
    bool IsDirty();
    void __fastcall MenuDisplayFormatItemClick(TObject *Sender);
    void SelectDisplayFormat(int iDisplayFormat);
    bool SelectDisplayFormat(String strDisplayFormat);

public:		// Anwenderdeklarationen
    void SavePreferences();
    int GetIndexOfSelectedDisplayFormat();
    void GetVersionInfo(int& nMajor, int& nMinor, int& nRevision, int& nBuild);

    __fastcall TForm1(TComponent* Owner);
    BEGIN_MESSAGE_MAP
      MESSAGE_HANDLER(WM_DROPFILES, TWMDropFiles, WmDropFiles)
      MESSAGE_HANDLER(MM_WOM_DONE, TMessage, OnWaveOutDone)
    END_MESSAGE_MAP(TForm)
};
//---------------------------------------------------------------------------
extern PACKAGE TForm1 *Form1;
//---------------------------------------------------------------------------
#endif

