//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <inifiles.hpp>
#include <dir.h>      // fr chdir()
#include <winbase.h>    // fr API-Funktionen (hier: SetEndOfFile)
#include <registry.hpp>
#include <algorithm> // fr std::min()
#include "main.h"
#include "resource.h"
#include "about.h"
#include "prefix.h"
#include "offset.h"
#include "cuesheet.h"
#include "dispform.h"
#include "burncd.h"
#include "gencues.h"
#include "settings.h"

#define MAKE_DIVISIBLE(n, divisor) ((n / divisor) * divisor)

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  // Konstruktor der Formular-Klasse: Variablen initialisieren:

  int nMajor, nMinor, nRevision, nBuild;
  GetVersionInfo(nMajor, nMinor, nRevision, nBuild);
  strVersion.sprintf("%d.%d.%d", nMajor, nMinor, nRevision);
  String strCaption; strCaption.sprintf("CueListTool %d.%d.%d", nMajor, nMinor, nRevision);
  Caption = strCaption;

  nCues = 0;
  strAudioFileName = "";
  RichEditCueList->WordWrap = true;
  strInitialCaption = Caption;
  bAcceptTrackBarPlayChangeEvent = true;
  bAcceptUpDownPlayClickEvent = true;
  nSampleDisplay = -1;
  nSamplesPerSecDisplay = -1;

  // Men-Shortcuts, die nicht zur Entwurfszeit definiert werden knnen:
  MenuStartStopPlaying->ShortCut = ShortCut(Word(' '), TShiftState());
  MenuExtApp1->ShortCut = ShortCut(Word('1'), TShiftState() << ssAlt);
  MenuExtApp2->ShortCut = ShortCut(Word('2'), TShiftState() << ssAlt);
  MenuExtApp3->ShortCut = ShortCut(Word('3'), TShiftState() << ssAlt);
  MenuExtApp4->ShortCut = ShortCut(Word('4'), TShiftState() << ssAlt);
  MenuExtApp5->ShortCut = ShortCut(Word('5'), TShiftState() << ssAlt);
  MenuExtApp6->ShortCut = ShortCut(Word('6'), TShiftState() << ssAlt);
  MenuExtApp7->ShortCut = ShortCut(Word('7'), TShiftState() << ssAlt);
  MenuExtApp8->ShortCut = ShortCut(Word('8'), TShiftState() << ssAlt);
  MenuExtApp9->ShortCut = ShortCut(Word('9'), TShiftState() << ssAlt);
  MenuExtApp0->ShortCut = ShortCut(Word('0'), TShiftState() << ssAlt);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormShow(TObject *Sender)
{
  // Aktionen vor Anzeige des Formulars:
  // Formular-bezogene Initialisierungsroutinen ausfhren:

  InitDeviceList();
  LoadPreferences();
  InitGrid();

  CueArray = new CUEARRAY[nMaxCues];
  WaveHeader = new WAVEHDR[nWaveBuffers];
  pWaveData = new char*[nWaveBuffers];
  for(int iBuffer = 0; iBuffer < nWaveBuffers; iBuffer++) pWaveData[iBuffer] = new char[nWaveBufferSize];

  EnableControls();
  DragAcceptFiles(Handle, true);

  // Auswerten der Kommandozeilenparameter:
  bool bSave = false;
  bool bSaveText = false;
  bool bSetDisplayFormat = false;
  for(int i = 1; i <= ParamCount(); i++)
  {
    String strPar = LowerCase(ParamStr(i));

    if (bSetDisplayFormat)
    {
      SelectDisplayFormat(ParamStr(i));
      bSetDisplayFormat = false;
      continue;
    }
    else if (bSaveText)
    {
      SaveTextFile(true, ParamStr(i));
      bSaveText = false;
      continue;
    }

    if(strPar == "-x")
    {
      Close(); // Programm beenden
    }
    else if(strPar == "-r")
    {
      if(strAudioFileName != "")
        ReadCueListFromAudioFile(strAudioFileName);
    }
    else if(strPar == "-w")
    {
      if(strAudioFileName != "" && nCues > 0)
        WriteCueListToAudioFile(strAudioFileName);
    }
    else if(strPar == "-d")
    {
      bSetDisplayFormat = true;
    }
    else if(strPar == "-t")
    {
      bSaveText = true;
    }
    else if(strPar == "-i") // import
    {
      bSave = false;
    }
    else if(strPar == "-e") // export
    {
      if(nCues > 0)
        bSave = true;
    }
    else if(strPar == "-q") // save Cue Sheet (show "Save & Burn" dialog)
    {
      if(nCues > 0)
        SaveCueSheet();
    }
    else
    {
      // Verarbeiten des angegebenen Dateinamens:
      ProcessFile(ParamStr(i), bSave);
      bSave = false;
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormCloseQuery(TObject *Sender, bool &CanClose)
{
  // Evtl. vorgenommene nderungen verwerfen?
  CanClose = DiscardChanges();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
  if(FormSettings->CheckBoxAutosave->Checked) SavePreferences();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormDestroy(TObject *Sender)
{
  if(CueArray != NULL) delete[] CueArray;
  if(WaveHeader != NULL) delete[] WaveHeader;
  for(int iBuffer = 0; iBuffer < nWaveBuffers; iBuffer++) if(pWaveData[iBuffer] != NULL) delete[] pWaveData[iBuffer];
  if(pWaveData != NULL) delete[] pWaveData;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::WmDropFiles(TWMDropFiles& Message)
{
  HDROP hDrop = (HDROP)Message.Drop;
  int nFiles = DragQueryFile(hDrop, -1, NULL, NULL);

  char szFileName[256];
  for(int i = 0; i < nFiles; i++)
  {
    DragQueryFile(hDrop, i, szFileName, sizeof(szFileName));
    ProcessFile(szFileName);
  }
  DragFinish(hDrop);
}
//---------------------------------------------------------------------------

void TForm1::InitDeviceList()
{
  // Die Namen der Devices zur Wiedergabe in die Combo-Box schreiben:

  WAVEOUTCAPS wocaps;
  int nOutDevs = waveOutGetNumDevs();
  for(int iOutDev = 0; iOutDev < nOutDevs; iOutDev++)
  {
    if(waveOutGetDevCaps(iOutDev, &wocaps, sizeof(WAVEOUTCAPS)) == MMSYSERR_NOERROR)
    {
      FormSettings->ComboBoxWaveMapper->Items->Add(wocaps.szPname);
    }
  }

  // Die Device-ID, welche den Funktionen waveInOpen und waveOutOpen bergeben werden mu,
  // entspricht dann dem Wert ItemIndex der jeweiligen Combo-Box. Falls dort kein gltiger
  // Eintrag ausgewhlt ist, ist ItemIndex == -1. Dies entspricht zuflligerweise der
  // Konstanten WAVE_MAPPER (allerdings als UINT gecastet), so da den Open-Funktionen
  // direkt (UINT)ItemIndex als Device-ID bergeben werden kann.
}
//---------------------------------------------------------------------------

void TForm1::SavePreferences()
{
  String strIniPath = ExtractFilePath(Application->ExeName) + "cueltool.ini";
  TIniFile* pIniFile = new TIniFile(strIniPath);

  // Section [SETTINGS]

  // Systemvariablen
  pIniFile->WriteInteger("SETTINGS", "MaxCues", nMaxCuesNew);
  pIniFile->WriteInteger("SETTINGS", "WaveBuffers", nWaveBuffersNew);
  pIniFile->WriteInteger("SETTINGS", "WaveBufferSize", nWaveBufferSizeNew);
  pIniFile->WriteInteger("SETTINGS", "WaveMapper", FormSettings->ComboBoxWaveMapper->ItemIndex);

  // Allgemeine Optionen
  pIniFile->WriteString("SETTINGS", "Prefix", "\"" + FormSettings->EditPrefix->Text + "\"");
  pIniFile->WriteBool("SETTINGS", "UsePrefix", FormSettings->CheckBoxEnablePrefixes->Checked);
  pIniFile->WriteBool("SETTINGS", "DeleteDuplicateCues", FormSettings->CheckBoxEliminateDuplicateCues->Checked);
  pIniFile->WriteBool("SETTINGS", "RestWinPos", FormSettings->CheckBoxRestoreWindow->Checked);
  pIniFile->WriteBool("SETTINGS", "SaveOnExit", FormSettings->CheckBoxAutosave->Checked);

  // Programmfenster
  pIniFile->WriteInteger("SETTINGS", "WindowPosLeft", Form1->Left);
  pIniFile->WriteInteger("SETTINGS", "WindowPosTop", Form1->Top);
  pIniFile->WriteInteger("SETTINGS", "WindowWidth", Form1->Width);
  pIniFile->WriteInteger("SETTINGS", "WindowHeight", Form1->Height);
  pIniFile->WriteInteger("SETTINGS", "WindowState", Form1->WindowState);

  // Tabs
  pIniFile->WriteInteger("SETTINGS", "TabIndexCueList", PageControlCueList->ActivePageIndex);

  // Spalten des StringGrid
  pIniFile->WriteInteger("SETTINGS", "ColWidth0", StringGrid->ColWidths[0]);
  pIniFile->WriteInteger("SETTINGS", "ColWidth1", StringGrid->ColWidths[1]);
  pIniFile->WriteInteger("SETTINGS", "ColWidth2", StringGrid->ColWidths[2]);
  pIniFile->WriteInteger("SETTINGS", "ColWidth3", StringGrid->ColWidths[3]);
  pIniFile->WriteInteger("SETTINGS", "ColWidth4", StringGrid->ColWidths[4]);
  pIniFile->WriteInteger("SETTINGS", "ColWidth5", StringGrid->ColWidths[5]);
  pIniFile->WriteInteger("SETTINGS", "ColWidth6", StringGrid->ColWidths[6]);

  // Cue-Player
  pIniFile->WriteBool("SETTINGS", "CuePlayerAutoContinue", PopupMenuCuePlayer_AutoContinue->Checked);
//  pIniFile->WriteBool("SETTINGS", "CuePlayerSkipCuePoints", PopupMenuCuePlayer_SkipCuePoints->Checked);
  pIniFile->WriteInteger("SETTINGS", "CuePlayerPlayCuePoints", PopupMenuCuePlayer_PlayCuePointsToNextCue->Checked ? 1 : PopupMenuCuePlayer_PlayCuePointsToEndOfFile->Checked ? 2 : PopupMenuCuePlayer_PlayCuePointsNotAtAll->Checked ? 3 : 0);
  pIniFile->WriteBool("SETTINGS", "CuePlayerPrePostAudition", PopupMenuCuePlayer_PrePostAudition->Checked);
  pIniFile->WriteString("SETTINGS", "CuePlayerPreAuditionTime", FormSettings->EditExtendCuePlayTimeBegin->Text);
  pIniFile->WriteString("SETTINGS", "CuePlayerPostAuditionTime", FormSettings->EditExtendCuePlayTimeEnd->Text);
  pIniFile->WriteString("SETTINGS", "CuePlayerRollBackTime", FormSettings->EditRollBackTime->Text);
  pIniFile->WriteBool("SETTINGS", "CuePlayerDisplayTotalTime", PopupMenuCuePlayer_DisplayTotalTime->Checked);
  pIniFile->WriteBool("SETTINGS", "CuePlayerDisplayRemainingTime", PopupMenuCuePlayer_DisplayRemainingTime->Checked);
  pIniFile->WriteBool("SETTINGS", "CuePlayerRollBackOnReleasePause", PopupMenuCuePlayer_RollBackOnReleasePause->Checked);
  pIniFile->WriteInteger("SETTINGS", "CueTimesIncrement", PopupMenuCueTimes_1->Checked ? 1 : PopupMenuCueTimes_10->Checked ? 10 : PopupMenuCueTimes_100->Checked ? 100 : PopupMenuCueTimes_1000->Checked ? 1000 : 10);
  pIniFile->WriteString("SETTINGS", "CueTimesUnit", PopupMenuCueTimes_Samples->Checked ? "Samples" : PopupMenuCueTimes_Milliseconds->Checked ? "Milliseconds" : PopupMenuCueTimes_Frames->Checked ? "Frames" : "Milliseconds");

  // Anzeigeformat
  pIniFile->WriteString("SETTINGS", "Prefix", "\"" + FormSettings->EditPrefix->Text + "\"");
  pIniFile->WriteString("SETTINGS", "FormatPoints", "\"" + strFormatPoints + "\"");
  pIniFile->WriteString("SETTINGS", "FormatRanges", "\"" + strFormatRanges + "\"");
  pIniFile->WriteString("SETTINGS", "FormatTime", "\"" + strFormatTime + "\"");
  pIniFile->WriteString("SETTINGS", "FormatSeparator", "\"" + strFormatSeparator + "\"");
  pIniFile->WriteString("SETTINGS", "FormatHeader", "\"" + strFormatHeader + "\"");
  pIniFile->WriteString("SETTINGS", "FormatSummary", "\"" + strFormatSummary + "\"");
  pIniFile->WriteBool("SETTINGS", "FormatHeaderEnabled", bFormatHeaderEnabled);
  pIniFile->WriteBool("SETTINGS", "FormatSummaryEnabled", bFormatSummaryEnabled);
  pIniFile->WriteInteger("SETTINGS", "FormatTimeLeadingDigitsHrs", nFormatTimeLeadingDigitsHrs);
  pIniFile->WriteInteger("SETTINGS", "FormatTimeFractionalDigitsHrs", nFormatTimeFractionalDigitsHrs);
  pIniFile->WriteInteger("SETTINGS", "FormatTimeLeadingDigitsMin", nFormatTimeLeadingDigitsMin);
  pIniFile->WriteInteger("SETTINGS", "FormatTimeFractionalDigitsMin", nFormatTimeFractionalDigitsMin);
  pIniFile->WriteInteger("SETTINGS", "FormatTimeLeadingDigitsSec", nFormatTimeLeadingDigitsSec);
  pIniFile->WriteInteger("SETTINGS", "FormatTimeFractionalDigitsSec", nFormatTimeFractionalDigitsSec);
  pIniFile->WriteInteger("SETTINGS", "FormatTimeLeadingDigitsFrm", nFormatTimeLeadingDigitsFrm);
  pIniFile->WriteInteger("SETTINGS", "FormatTimeFractionalDigitsFrm", nFormatTimeFractionalDigitsFrm);
  pIniFile->WriteInteger("SETTINGS", "FormatTimeLeadingDigitsSmp", nFormatTimeLeadingDigitsSmp);
  pIniFile->WriteInteger("SETTINGS", "FormatTimeFractionalDigitsSmp", nFormatTimeFractionalDigitsSmp);

  String strSection;
  for(int iDisplayFormat = 0; iDisplayFormat < nNumberDisplayFormats; iDisplayFormat++)
  {
    strSection = "";
    strSection.sprintf("DISPLAYFORMAT%d", iDisplayFormat); // Section-String

    pIniFile->WriteString(strSection, "FormatName", "\"" + DisplayFormat[iDisplayFormat].strName + "\"");
    pIniFile->WriteString(strSection, "FormatPoints", "\"" + DisplayFormat[iDisplayFormat].strFormatPoints + "\"");
    pIniFile->WriteString(strSection, "FormatRanges", "\"" + DisplayFormat[iDisplayFormat].strFormatRanges + "\"");
    pIniFile->WriteString(strSection, "FormatTime", "\"" + DisplayFormat[iDisplayFormat].strFormatTime + "\"");
    pIniFile->WriteString(strSection, "FormatSeparator", "\"" + DisplayFormat[iDisplayFormat].strFormatSeparator + "\"");
    pIniFile->WriteString(strSection, "FormatHeader", "\"" + DisplayFormat[iDisplayFormat].strFormatHeader + "\"");
    pIniFile->WriteString(strSection, "FormatSummary", "\"" + DisplayFormat[iDisplayFormat].strFormatSummary + "\"");
    pIniFile->WriteBool(strSection, "FormatHeaderEnabled", DisplayFormat[iDisplayFormat].bFormatHeaderEnabled);
    pIniFile->WriteBool(strSection, "FormatSummaryEnabled", DisplayFormat[iDisplayFormat].bFormatSummaryEnabled);
    pIniFile->WriteInteger(strSection, "FormatTimeLeadingDigitsHrs", DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsHrs);
    pIniFile->WriteInteger(strSection, "FormatTimeFractionalDigitsHrs", DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsHrs);
    pIniFile->WriteInteger(strSection, "FormatTimeLeadingDigitsMin", DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsMin);
    pIniFile->WriteInteger(strSection, "FormatTimeFractionalDigitsMin", DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsMin);
    pIniFile->WriteInteger(strSection, "FormatTimeLeadingDigitsSec", DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsSec);
    pIniFile->WriteInteger(strSection, "FormatTimeFractionalDigitsSec", DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsSec);
    pIniFile->WriteInteger(strSection, "FormatTimeLeadingDigitsFrm", DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsFrm);
    pIniFile->WriteInteger(strSection, "FormatTimeFractionalDigitsFrm", DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsFrm);
    pIniFile->WriteInteger(strSection, "FormatTimeLeadingDigitsSmp", DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsSmp);
    pIniFile->WriteInteger(strSection, "FormatTimeFractionalDigitsSmp", DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsSmp);
  }
  // berflssige Sections lschen
  for(int iDisplayFormat = nNumberDisplayFormats; iDisplayFormat < MAX_DISPLAYFORMATS; iDisplayFormat++)
  {
    strSection = "";
    strSection.sprintf("DISPLAYFORMAT%d", iDisplayFormat); // Section-String
    String strFormatName = pIniFile->ReadString(strSection, "FormatName", "$$$INVALID$$$");
    if(DisplayFormat[nNumberDisplayFormats].strName != "$$$INVALID$$$")
    {
      try { pIniFile->EraseSection(strSection); } catch(...) {};
    }
  }

  // Cue-Sheet-Einstellungen
  pIniFile->WriteBool("SETTINGS", "CueSheetAbsolutePath", bCueSheetAbsolutePath);
  pIniFile->WriteBool("SETTINGS", "CueSheetIncludeCDText", bCueSheetIncludeCDText);
//  pIniFile->WriteBool("SETTINGS", "CueSheetUseCueLabelsAsTrackTitles", bCueSheetUseCueLabelsAsTrackTitles);
  pIniFile->WriteBool("SETTINGS", "CueSheetUseCueNotesAsTrackPerformer", bCueSheetUseCueNotesAsTrackPerformer);
  pIniFile->WriteBool("SETTINGS", "CueSheetIfCueNoteEmptyUseAlbumPerformer", bCueSheetIfCueNoteEmptyUseAlbumPerformer);
  pIniFile->WriteBool("SETTINGS", "CueSheetInsertGaps", bCueSheetInsertGaps);
  pIniFile->WriteBool("SETTINGS", "CueSheetGapIsPreGap", bCueSheetGapIsPreGap);
  pIniFile->WriteString("SETTINGS", "CueSheetGapTime", strCueSheetGapTime);
  pIniFile->WriteBool("SETTINGS", "CueSheetGapOnlyExceptForFirstLastTrack", bCueSheetGapOnlyExceptForFirstLastTrack);
  pIniFile->WriteBool("SETTINGS", "CueSheetGapOnly", bCueSheetGapOnly);
  pIniFile->WriteBool("SETTINGS", "CueSheetGapFirst", bCueSheetGapFirst);
  pIniFile->WriteBool("SETTINGS", "CueSheetAddOffset", bCueSheetAddOffset);
  pIniFile->WriteString("SETTINGS", "CueSheetOffsetTime", strCueSheetOffsetTime);
  pIniFile->WriteString("SETTINGS", "CueSheetIndex0Time", strCueSheetIndex0Time);
  pIniFile->WriteBool("SETTINGS", "CueSheetIndex0", bCueSheetIndex0);
  pIniFile->WriteString("SETTINGS", "BurnApplPath", "\"" + strBurnApplPath + "\"");
  pIniFile->WriteString("SETTINGS", "BurnApplArguments", "\"" + strBurnApplArguments + "\"");

  // Schriftarten und Farben

  pIniFile->WriteString("SETTINGS", "FontName", RichEditCueList->Font->Name);
  pIniFile->WriteBool("SETTINGS", "FontStyleBold", RichEditCueList->Font->Style.Contains(fsBold));
  pIniFile->WriteBool("SETTINGS", "FontStyleItalic", RichEditCueList->Font->Style.Contains(fsItalic));
  pIniFile->WriteBool("SETTINGS", "FontStyleUnderline", RichEditCueList->Font->Style.Contains(fsUnderline));
  pIniFile->WriteBool("SETTINGS", "FontStyleStrikeOut", RichEditCueList->Font->Style.Contains(fsStrikeOut));
  pIniFile->WriteInteger("SETTINGS", "FontSize", RichEditCueList->Font->Size);
  pIniFile->WriteInteger("SETTINGS", "FontColor", RichEditCueList->Font->Color);
  pIniFile->WriteInteger("SETTINGS", "FontCharset", RichEditCueList->Font->Charset);
  pIniFile->WriteInteger("SETTINGS", "BackgroundColor", RichEditCueList->Color);

  pIniFile->WriteString("SETTINGS", "CuePlayerFontName", PanelPlay->Font->Name);
  pIniFile->WriteBool("SETTINGS", "CuePlayerFontStyleBold", PanelPlay->Font->Style.Contains(fsBold));
  pIniFile->WriteBool("SETTINGS", "CuePlayerFontStyleItalic", PanelPlay->Font->Style.Contains(fsItalic));
  pIniFile->WriteBool("SETTINGS", "CuePlayerFontStyleUnderline", PanelPlay->Font->Style.Contains(fsUnderline));
  pIniFile->WriteBool("SETTINGS", "CuePlayerFontStyleStrikeOut", PanelPlay->Font->Style.Contains(fsStrikeOut));
  pIniFile->WriteInteger("SETTINGS", "CuePlayerFontSize", PanelPlay->Font->Size);
  pIniFile->WriteInteger("SETTINGS", "CuePlayerFontColor", PanelPlay->Font->Color);
  pIniFile->WriteInteger("SETTINGS", "CuePlayerFontCharset", PanelPlay->Font->Charset);
  pIniFile->WriteInteger("SETTINGS", "CuePlayerBackgroundColor", PanelPlay->Color);

  // Externe Applikationen
  pIniFile->WriteString("SETTINGS", "ExternalApplicationPath1", FormSettings->strExtAppPath[0]);
  pIniFile->WriteString("SETTINGS", "ExternalApplicationPath2", FormSettings->strExtAppPath[1]);
  pIniFile->WriteString("SETTINGS", "ExternalApplicationPath3", FormSettings->strExtAppPath[2]);
  pIniFile->WriteString("SETTINGS", "ExternalApplicationPath4", FormSettings->strExtAppPath[3]);
  pIniFile->WriteString("SETTINGS", "ExternalApplicationPath5", FormSettings->strExtAppPath[4]);
  pIniFile->WriteString("SETTINGS", "ExternalApplicationPath6", FormSettings->strExtAppPath[5]);
  pIniFile->WriteString("SETTINGS", "ExternalApplicationPath7", FormSettings->strExtAppPath[6]);
  pIniFile->WriteString("SETTINGS", "ExternalApplicationPath8", FormSettings->strExtAppPath[7]);
  pIniFile->WriteString("SETTINGS", "ExternalApplicationPath9", FormSettings->strExtAppPath[8]);
  pIniFile->WriteString("SETTINGS", "ExternalApplicationPath0", FormSettings->strExtAppPath[9]);

  pIniFile->WriteString("SETTINGS", "ExternalApplicationArgs1", "\"" + FormSettings->strExtAppArgs[0] + "\"");
  pIniFile->WriteString("SETTINGS", "ExternalApplicationArgs2", "\"" + FormSettings->strExtAppArgs[1] + "\"");
  pIniFile->WriteString("SETTINGS", "ExternalApplicationArgs3", "\"" + FormSettings->strExtAppArgs[2] + "\"");
  pIniFile->WriteString("SETTINGS", "ExternalApplicationArgs4", "\"" + FormSettings->strExtAppArgs[3] + "\"");
  pIniFile->WriteString("SETTINGS", "ExternalApplicationArgs5", "\"" + FormSettings->strExtAppArgs[4] + "\"");
  pIniFile->WriteString("SETTINGS", "ExternalApplicationArgs6", "\"" + FormSettings->strExtAppArgs[5] + "\"");
  pIniFile->WriteString("SETTINGS", "ExternalApplicationArgs7", "\"" + FormSettings->strExtAppArgs[6] + "\"");
  pIniFile->WriteString("SETTINGS", "ExternalApplicationArgs8", "\"" + FormSettings->strExtAppArgs[7] + "\"");
  pIniFile->WriteString("SETTINGS", "ExternalApplicationArgs9", "\"" + FormSettings->strExtAppArgs[8] + "\"");
  pIniFile->WriteString("SETTINGS", "ExternalApplicationArgs0", "\"" + FormSettings->strExtAppArgs[9] + "\"");

  pIniFile->WriteString("SETTINGS", "ExternalApplicationName1", FormSettings->strExtAppName[0]);
  pIniFile->WriteString("SETTINGS", "ExternalApplicationName2", FormSettings->strExtAppName[1]);
  pIniFile->WriteString("SETTINGS", "ExternalApplicationName3", FormSettings->strExtAppName[2]);
  pIniFile->WriteString("SETTINGS", "ExternalApplicationName4", FormSettings->strExtAppName[3]);
  pIniFile->WriteString("SETTINGS", "ExternalApplicationName5", FormSettings->strExtAppName[4]);
  pIniFile->WriteString("SETTINGS", "ExternalApplicationName6", FormSettings->strExtAppName[5]);
  pIniFile->WriteString("SETTINGS", "ExternalApplicationName7", FormSettings->strExtAppName[6]);
  pIniFile->WriteString("SETTINGS", "ExternalApplicationName8", FormSettings->strExtAppName[7]);
  pIniFile->WriteString("SETTINGS", "ExternalApplicationName9", FormSettings->strExtAppName[8]);
  pIniFile->WriteString("SETTINGS", "ExternalApplicationName0", FormSettings->strExtAppName[9]);

  pIniFile->WriteInteger("SETTINGS", "ExternalApplicationDefault", FormSettings->RadioGroupExtApp->ItemIndex);

  delete pIniFile;
}
//---------------------------------------------------------------------------

void TForm1::LoadPreferences()
{
  String strIniPath = ExtractFilePath(Application->ExeName) + "cueltool.ini";
  TIniFile* pIniFile = new TIniFile(strIniPath);

  // Section [SETTINGS]

  // Systemvariablen
  nMaxCues = nMaxCuesNew = pIniFile->ReadInteger("SETTINGS", "MaxCues", MAXCUES);
  nWaveBuffers = nWaveBuffersNew = pIniFile->ReadInteger("SETTINGS", "WaveBuffers", NBUFFERS);
  nWaveBufferSize = nWaveBufferSizeNew = pIniFile->ReadInteger("SETTINGS", "WaveBufferSize", BUFSIZE);
  FormSettings->ComboBoxWaveMapper->ItemIndex = pIniFile->ReadInteger("SETTINGS", "WaveMapper", 0);

  // Allgemeine Optionen
  FormSettings->EditPrefix->Text = pIniFile->ReadString("SETTINGS", "Prefix", "");
  FormSettings->CheckBoxEnablePrefixes->Checked = pIniFile->ReadBool("SETTINGS", "UsePrefix", FormSettings->CheckBoxEnablePrefixes->Checked);
  FormSettings->CheckBoxEliminateDuplicateCues->Checked = pIniFile->ReadBool("SETTINGS", "DeleteDuplicateCues", FormSettings->CheckBoxEliminateDuplicateCues->Checked);
  FormSettings->CheckBoxRestoreWindow->Checked = pIniFile->ReadBool("SETTINGS", "RestWinPos", FormSettings->CheckBoxRestoreWindow->Checked);
  FormSettings->CheckBoxAutosave->Checked = pIniFile->ReadBool("SETTINGS", "SaveOnExit", FormSettings->CheckBoxAutosave->Checked);

  // Programmfenster
  if(FormSettings->CheckBoxRestoreWindow->Checked)
  {
    Form1->Left = pIniFile->ReadInteger("SETTINGS", "WindowPosLeft", Form1->Left);
    Form1->Top = pIniFile->ReadInteger("SETTINGS", "WindowPosTop", Form1->Top);
    Form1->Width = pIniFile->ReadInteger("SETTINGS", "WindowWidth", Form1->Width);
    Form1->Height = pIniFile->ReadInteger("SETTINGS", "WindowHeight", Form1->Height);
    Form1->WindowState = (TWindowState)pIniFile->ReadInteger("SETTINGS", "WindowState", Form1->WindowState);
  }

  // Tabs
  PageControlCueList->ActivePageIndex = pIniFile->ReadInteger("SETTINGS", "TabIndexCueList", PageControlCueList->ActivePageIndex);

  // Spalten des StringGrid
  StringGrid->ColWidths[0] = pIniFile->ReadInteger("SETTINGS", "ColWidth0", StringGrid->ColWidths[0]);
  StringGrid->ColWidths[1] = pIniFile->ReadInteger("SETTINGS", "ColWidth1", StringGrid->ColWidths[1]);
  StringGrid->ColWidths[2] = pIniFile->ReadInteger("SETTINGS", "ColWidth2", StringGrid->ColWidths[2]);
  StringGrid->ColWidths[3] = pIniFile->ReadInteger("SETTINGS", "ColWidth3", StringGrid->ColWidths[3]);
  StringGrid->ColWidths[4] = pIniFile->ReadInteger("SETTINGS", "ColWidth4", StringGrid->ColWidths[4]);
  StringGrid->ColWidths[5] = pIniFile->ReadInteger("SETTINGS", "ColWidth5", StringGrid->ColWidths[5]);
  StringGrid->ColWidths[6] = pIniFile->ReadInteger("SETTINGS", "ColWidth6", StringGrid->ColWidths[6]);

  // Cue-Player
  PopupMenuCuePlayer_AutoContinue->Checked = pIniFile->ReadBool("SETTINGS", "CuePlayerAutoContinue", PopupMenuCuePlayer_AutoContinue->Checked);
//  PopupMenuCuePlayer_SkipCuePoints->Checked = pIniFile->ReadBool("SETTINGS", "CuePlayerSkipCuePoints", PopupMenuCuePlayer_SkipCuePoints->Checked);
  int nTemp = pIniFile->ReadInteger("SETTINGS", "CuePlayerPlayCuePoints", 1);
  if(nTemp == 1)      PopupMenuCuePlayer_PlayCuePointsToNextCue->Checked = true;
  else if(nTemp == 2) PopupMenuCuePlayer_PlayCuePointsToEndOfFile->Checked = true;
  else if(nTemp == 3) PopupMenuCuePlayer_PlayCuePointsNotAtAll->Checked = true;
  PopupMenuCuePlayer_PrePostAudition->Checked = pIniFile->ReadBool("SETTINGS", "CuePlayerPrePostAudition", PopupMenuCuePlayer_PrePostAudition->Checked);
  FormSettings->EditExtendCuePlayTimeBegin->Text = pIniFile->ReadString("SETTINGS", "CuePlayerPreAuditionTime", FormSettings->EditExtendCuePlayTimeBegin->Text);
  FormSettings->EditExtendCuePlayTimeEnd->Text = pIniFile->ReadString("SETTINGS", "CuePlayerPostAuditionTime", FormSettings->EditExtendCuePlayTimeEnd->Text);
  FormSettings->EditRollBackTime->Text = pIniFile->ReadString("SETTINGS", "CuePlayerRollBackTime", FormSettings->EditRollBackTime->Text);
  PopupMenuCuePlayer_DisplayTotalTime->Checked = pIniFile->ReadBool("SETTINGS", "CuePlayerDisplayTotalTime", PopupMenuCuePlayer_DisplayTotalTime->Checked);
  PopupMenuCuePlayer_DisplayRemainingTime->Checked = pIniFile->ReadBool("SETTINGS", "CuePlayerDisplayRemainingTime", PopupMenuCuePlayer_DisplayRemainingTime->Checked);
  PopupMenuCuePlayer_RollBackOnReleasePause->Checked = pIniFile->ReadBool("SETTINGS", "CuePlayerRollBackOnReleasePause", PopupMenuCuePlayer_RollBackOnReleasePause->Checked);
  nTemp = pIniFile->ReadInteger("SETTINGS", "CueTimesIncrement", 10);
  if(nTemp == 1)         PopupMenuCueTimes_1->Checked = true;
  else if(nTemp == 10)   PopupMenuCueTimes_10->Checked = true;
  else if(nTemp == 100)  PopupMenuCueTimes_100->Checked = true;
  else if(nTemp == 1000) PopupMenuCueTimes_1000->Checked = true;
  String strTemp = pIniFile->ReadString("SETTINGS", "CueTimesUnit", "Milliseconds");
  if(strTemp == "Samples")           PopupMenuCueTimes_Samples->Checked = true;
  else if(strTemp == "Milliseconds") PopupMenuCueTimes_Milliseconds->Checked = true;
  else if(strTemp == "Frames")       PopupMenuCueTimes_Frames->Checked = true;

  // Anzeigeformat
  // Der "Umweg" ber "INIT" ist erforderlich, weil sonst anhngende Leerzeichen beim Initialisieren mit den Default-Werten nicht bertragen werden.
  strFormatPoints = pIniFile->ReadString("SETTINGS", "FormatPoints", "INIT"); if(strFormatPoints == "INIT") strFormatPoints = FormDisplayFormat->GetDefaultFormatPoints();
  strFormatRanges = pIniFile->ReadString("SETTINGS", "FormatRanges", "INIT"); if(strFormatRanges == "INIT") strFormatRanges = FormDisplayFormat->GetDefaultFormatRanges();
  strFormatTime = pIniFile->ReadString("SETTINGS", "FormatTime", "INIT"); if(strFormatTime == "INIT") strFormatTime = FormDisplayFormat->GetDefaultFormatTime();
  strFormatSeparator = pIniFile->ReadString("SETTINGS", "FormatSeparator", "INIT"); if(strFormatSeparator == "INIT") strFormatSeparator = FormDisplayFormat->GetDefaultSeparator();
  strFormatHeader = pIniFile->ReadString("SETTINGS", "FormatHeader", "INIT"); if(strFormatHeader == "INIT") strFormatHeader = FormDisplayFormat->GetDefaultFormatHeader();
  strFormatSummary = pIniFile->ReadString("SETTINGS", "FormatSummary", "INIT"); if(strFormatSummary == "INIT") strFormatSummary = FormDisplayFormat->GetDefaultFormatSummary();
  bFormatHeaderEnabled = pIniFile->ReadBool("SETTINGS", "FormatHeaderEnabled", true);
  bFormatSummaryEnabled = pIniFile->ReadBool("SETTINGS", "FormatSummaryEnabled", true);
  nFormatTimeLeadingDigitsHrs = pIniFile->ReadInteger("SETTINGS", "FormatTimeLeadingDigitsHrs", 1);
  nFormatTimeFractionalDigitsHrs = pIniFile->ReadInteger("SETTINGS", "FormatTimeFractionalDigitsHrs", 10);
  nFormatTimeLeadingDigitsMin = pIniFile->ReadInteger("SETTINGS", "FormatTimeLeadingDigitsMin", 1);
  nFormatTimeFractionalDigitsMin = pIniFile->ReadInteger("SETTINGS", "FormatTimeFractionalDigitsMin", 4);
  nFormatTimeLeadingDigitsSec = pIniFile->ReadInteger("SETTINGS", "FormatTimeLeadingDigitsSec", 2);
  nFormatTimeFractionalDigitsSec = pIniFile->ReadInteger("SETTINGS", "FormatTimeFractionalDigitsSec", 3);
  nFormatTimeLeadingDigitsFrm = pIniFile->ReadInteger("SETTINGS", "FormatTimeLeadingDigitsFrm", 2);
  nFormatTimeFractionalDigitsFrm = pIniFile->ReadInteger("SETTINGS", "FormatTimeFractionalDigitsFrm", 0);
  nFormatTimeLeadingDigitsSmp = pIniFile->ReadInteger("SETTINGS", "FormatTimeLeadingDigitsSmp", 1);
  nFormatTimeFractionalDigitsSmp = pIniFile->ReadInteger("SETTINGS", "FormatTimeFractionalDigitsSmp", 0);

  String strSection;
  nNumberDisplayFormats = 0;
  for(int iDisplayFormat = 0; iDisplayFormat < MAX_DISPLAYFORMATS; iDisplayFormat++)
  {
    strSection = "";
    strSection.sprintf("DISPLAYFORMAT%d", iDisplayFormat); // Section-String
    DisplayFormat[nNumberDisplayFormats].strName = pIniFile->ReadString(strSection, "FormatName", "");
    if(DisplayFormat[nNumberDisplayFormats].strName.IsEmpty()) continue;   // Keine Section gefunden -> nchste probieren

    // Der "Umweg" ber "INIT" ist erforderlich, weil sonst anhngende Leerzeichen beim Initialisieren mit den Default-Werten nicht bertragen werden.
    DisplayFormat[nNumberDisplayFormats].strFormatPoints = pIniFile->ReadString(strSection, "FormatPoints", "INIT"); if(strFormatPoints == "INIT") DisplayFormat[nNumberDisplayFormats].strFormatPoints = FormDisplayFormat->GetDefaultFormatPoints();
    DisplayFormat[nNumberDisplayFormats].strFormatRanges = pIniFile->ReadString(strSection, "FormatRanges", "INIT"); if(strFormatRanges == "INIT") DisplayFormat[nNumberDisplayFormats].strFormatRanges = FormDisplayFormat->GetDefaultFormatRanges();
    DisplayFormat[nNumberDisplayFormats].strFormatTime = pIniFile->ReadString(strSection, "FormatTime", "INIT"); if(strFormatTime == "INIT") DisplayFormat[nNumberDisplayFormats].strFormatTime = FormDisplayFormat->GetDefaultFormatTime();
    DisplayFormat[nNumberDisplayFormats].strFormatSeparator = pIniFile->ReadString(strSection, "FormatSeparator", "INIT"); if(strFormatSeparator == "INIT") DisplayFormat[nNumberDisplayFormats].strFormatSeparator = FormDisplayFormat->GetDefaultSeparator();
    DisplayFormat[nNumberDisplayFormats].strFormatHeader = pIniFile->ReadString(strSection, "FormatHeader", "INIT"); if(strFormatHeader == "INIT") DisplayFormat[nNumberDisplayFormats].strFormatHeader = FormDisplayFormat->GetDefaultFormatHeader();
    DisplayFormat[nNumberDisplayFormats].strFormatSummary = pIniFile->ReadString(strSection, "FormatSummary", "INIT"); if(strFormatSummary == "INIT") DisplayFormat[nNumberDisplayFormats].strFormatSummary = FormDisplayFormat->GetDefaultFormatSummary();
    DisplayFormat[nNumberDisplayFormats].bFormatHeaderEnabled = pIniFile->ReadBool(strSection, "FormatHeaderEnabled", true);
    DisplayFormat[nNumberDisplayFormats].bFormatSummaryEnabled = pIniFile->ReadBool(strSection, "FormatSummaryEnabled", true);
    DisplayFormat[nNumberDisplayFormats].nFormatTimeLeadingDigitsHrs = pIniFile->ReadInteger(strSection, "FormatTimeLeadingDigitsHrs", 1);
    DisplayFormat[nNumberDisplayFormats].nFormatTimeFractionalDigitsHrs = pIniFile->ReadInteger(strSection, "FormatTimeFractionalDigitsHrs", 10);
    DisplayFormat[nNumberDisplayFormats].nFormatTimeLeadingDigitsMin = pIniFile->ReadInteger(strSection, "FormatTimeLeadingDigitsMin", 1);
    DisplayFormat[nNumberDisplayFormats].nFormatTimeFractionalDigitsMin = pIniFile->ReadInteger(strSection, "FormatTimeFractionalDigitsMin", 4);
    DisplayFormat[nNumberDisplayFormats].nFormatTimeLeadingDigitsSec = pIniFile->ReadInteger(strSection, "FormatTimeLeadingDigitsSec", 2);
    DisplayFormat[nNumberDisplayFormats].nFormatTimeFractionalDigitsSec = pIniFile->ReadInteger(strSection, "FormatTimeFractionalDigitsSec", 3);
    DisplayFormat[nNumberDisplayFormats].nFormatTimeLeadingDigitsFrm = pIniFile->ReadInteger(strSection, "FormatTimeLeadingDigitsFrm", 2);
    DisplayFormat[nNumberDisplayFormats].nFormatTimeFractionalDigitsFrm = pIniFile->ReadInteger(strSection, "FormatTimeFractionalDigitsFrm", 0);
    DisplayFormat[nNumberDisplayFormats].nFormatTimeLeadingDigitsSmp = pIniFile->ReadInteger(strSection, "FormatTimeLeadingDigitsSmp", 1);
    DisplayFormat[nNumberDisplayFormats].nFormatTimeFractionalDigitsSmp = pIniFile->ReadInteger(strSection, "FormatTimeFractionalDigitsSmp", 0);
    nNumberDisplayFormats++;
  }

  // Cue-Sheet-Einstellungen
  bCueSheetAbsolutePath = pIniFile->ReadBool("SETTINGS", "CueSheetAbsolutePath", false);
  bCueSheetIncludeCDText = pIniFile->ReadBool("SETTINGS", "CueSheetIncludeCDText", true);
//  bCueSheetUseCueLabelsAsTrackTitles = pIniFile->ReadBool("SETTINGS", "CueSheetUseCueLabelsAsTrackTitles", true);
  bCueSheetUseCueNotesAsTrackPerformer = pIniFile->ReadBool("SETTINGS", "CueSheetUseCueNotesAsTrackPerformer", true);
  bCueSheetIfCueNoteEmptyUseAlbumPerformer = pIniFile->ReadBool("SETTINGS", "CueSheetIfCueNoteEmptyUseAlbumPerformer", true);
  bCueSheetInsertGaps = pIniFile->ReadBool("SETTINGS", "CueSheetInsertGaps", false);
  bCueSheetGapIsPreGap = pIniFile->ReadBool("SETTINGS", "CueSheetGapIsPreGap", true);
  strCueSheetGapTime = pIniFile->ReadString("SETTINGS", "CueSheetGapTime", "2");
  bCueSheetGapOnlyExceptForFirstLastTrack = pIniFile->ReadBool("SETTINGS", "CueSheetGapOnlyExceptForFirstLastTrack", false);
  bCueSheetGapOnly = pIniFile->ReadBool("SETTINGS", "CueSheetGapOnly", true);
  bCueSheetGapFirst = pIniFile->ReadBool("SETTINGS", "CueSheetGapFirst", true);
  bCueSheetAddOffset = pIniFile->ReadBool("SETTINGS", "CueSheetAddOffset", false);
  strCueSheetOffsetTime = pIniFile->ReadString("SETTINGS", "CueSheetOffsetTime", "0");
  strCueSheetIndex0Time = pIniFile->ReadString("SETTINGS", "CueSheetIndex0Time", "10");
  bCueSheetIndex0 = pIniFile->ReadBool("SETTINGS", "CueSheetIndex0", true);
  strBurnApplPath = pIniFile->ReadString("SETTINGS", "BurnApplPath", "");
  strBurnApplArguments = pIniFile->ReadString("SETTINGS", "BurnApplArguments", FormBurn->GetDefaultBurnArgs());

  // Schriftarten und Farben

  TFontStyles styles;

  RichEditCueList->Font->Name = pIniFile->ReadString("SETTINGS", "FontName", "Arial");
  if(pIniFile->ReadBool("SETTINGS", "FontStyleBold", false)) styles << fsBold;
  if(pIniFile->ReadBool("SETTINGS", "FontStyleItalic", false)) styles << fsItalic;
  if(pIniFile->ReadBool("SETTINGS", "FontStyleUnderline", false)) styles << fsUnderline;
  if(pIniFile->ReadBool("SETTINGS", "FontStyleStrikeOut", false)) styles << fsStrikeOut;
  RichEditCueList->Font->Style = styles;
  RichEditCueList->Font->Size = pIniFile->ReadInteger("SETTINGS", "FontSize", 10);
  RichEditCueList->Font->Color = (TColor)pIniFile->ReadInteger("SETTINGS", "FontColor", (int)clNavy);
  RichEditCueList->Font->Charset = (TFontCharset)pIniFile->ReadInteger("SETTINGS", "FontCharset", (int)DEFAULT_CHARSET);
  RichEditCueList->Color = (TColor)pIniFile->ReadInteger("SETTINGS", "BackgroundColor", RichEditCueList->Color);

  PanelPlay->Font->Name = pIniFile->ReadString("SETTINGS", "CuePlayerFontName", "MS Sans Serif");
  if(pIniFile->ReadBool("SETTINGS", "CuePlayerFontStyleBold", false)) styles << fsBold;
  if(pIniFile->ReadBool("SETTINGS", "CuePlayerFontStyleItalic", false)) styles << fsItalic;
  if(pIniFile->ReadBool("SETTINGS", "CuePlayerFontStyleUnderline", false)) styles << fsUnderline;
  if(pIniFile->ReadBool("SETTINGS", "CuePlayerFontStyleStrikeOut", false)) styles << fsStrikeOut;
  PanelPlay->Font->Style = styles;
  PanelPlay->Font->Size = pIniFile->ReadInteger("SETTINGS", "CuePlayerFontSize", 8);
  PanelPlay->Font->Color = (TColor)pIniFile->ReadInteger("SETTINGS", "CuePlayerFontColor", (int)clLime);
  PanelPlay->Font->Charset = (TFontCharset)pIniFile->ReadInteger("SETTINGS", "CuePlayerFontCharset", (int)DEFAULT_CHARSET);
  PanelPlay->Color = (TColor)pIniFile->ReadInteger("SETTINGS", "CuePlayerBackgroundColor", PanelPlay->Color);

//  StringGrid->Color = RichEditCueList->Color;
//  StringGrid->Font->Color = RichEditCueList->Font->Color;

  // Externe Applikationen
  FormSettings->strExtAppPath[0] = pIniFile->ReadString("SETTINGS", "ExternalApplicationPath1", "");
  FormSettings->strExtAppPath[1] = pIniFile->ReadString("SETTINGS", "ExternalApplicationPath2", "");
  FormSettings->strExtAppPath[2] = pIniFile->ReadString("SETTINGS", "ExternalApplicationPath3", "");
  FormSettings->strExtAppPath[3] = pIniFile->ReadString("SETTINGS", "ExternalApplicationPath4", "");
  FormSettings->strExtAppPath[4] = pIniFile->ReadString("SETTINGS", "ExternalApplicationPath5", "");
  FormSettings->strExtAppPath[5] = pIniFile->ReadString("SETTINGS", "ExternalApplicationPath6", "");
  FormSettings->strExtAppPath[6] = pIniFile->ReadString("SETTINGS", "ExternalApplicationPath7", "");
  FormSettings->strExtAppPath[7] = pIniFile->ReadString("SETTINGS", "ExternalApplicationPath8", "");
  FormSettings->strExtAppPath[8] = pIniFile->ReadString("SETTINGS", "ExternalApplicationPath9", "");
  FormSettings->strExtAppPath[9] = pIniFile->ReadString("SETTINGS", "ExternalApplicationPath0", "");

  FormSettings->strExtAppArgs[0] = pIniFile->ReadString("SETTINGS", "ExternalApplicationArgs1", "");
  FormSettings->strExtAppArgs[1] = pIniFile->ReadString("SETTINGS", "ExternalApplicationArgs2", "");
  FormSettings->strExtAppArgs[2] = pIniFile->ReadString("SETTINGS", "ExternalApplicationArgs3", "");
  FormSettings->strExtAppArgs[3] = pIniFile->ReadString("SETTINGS", "ExternalApplicationArgs4", "");
  FormSettings->strExtAppArgs[4] = pIniFile->ReadString("SETTINGS", "ExternalApplicationArgs5", "");
  FormSettings->strExtAppArgs[5] = pIniFile->ReadString("SETTINGS", "ExternalApplicationArgs6", "");
  FormSettings->strExtAppArgs[6] = pIniFile->ReadString("SETTINGS", "ExternalApplicationArgs7", "");
  FormSettings->strExtAppArgs[7] = pIniFile->ReadString("SETTINGS", "ExternalApplicationArgs8", "");
  FormSettings->strExtAppArgs[8] = pIniFile->ReadString("SETTINGS", "ExternalApplicationArgs9", "");
  FormSettings->strExtAppArgs[9] = pIniFile->ReadString("SETTINGS", "ExternalApplicationArgs0", "");

  FormSettings->strExtAppName[0] = pIniFile->ReadString("SETTINGS", "ExternalApplicationName1", "");
  FormSettings->strExtAppName[1] = pIniFile->ReadString("SETTINGS", "ExternalApplicationName2", "");
  FormSettings->strExtAppName[2] = pIniFile->ReadString("SETTINGS", "ExternalApplicationName3", "");
  FormSettings->strExtAppName[3] = pIniFile->ReadString("SETTINGS", "ExternalApplicationName4", "");
  FormSettings->strExtAppName[4] = pIniFile->ReadString("SETTINGS", "ExternalApplicationName5", "");
  FormSettings->strExtAppName[5] = pIniFile->ReadString("SETTINGS", "ExternalApplicationName6", "");
  FormSettings->strExtAppName[6] = pIniFile->ReadString("SETTINGS", "ExternalApplicationName7", "");
  FormSettings->strExtAppName[7] = pIniFile->ReadString("SETTINGS", "ExternalApplicationName8", "");
  FormSettings->strExtAppName[8] = pIniFile->ReadString("SETTINGS", "ExternalApplicationName9", "");
  FormSettings->strExtAppName[9] = pIniFile->ReadString("SETTINGS", "ExternalApplicationName0", "");

  FormSettings->RadioGroupExtApp->ItemIndex = pIniFile->ReadInteger("SETTINGS", "ExternalApplicationDefault", 0);

  delete pIniFile;
}
//---------------------------------------------------------------------------

void TForm1::EnableControls()
{
  // Hotkeys, die inzwischen abgeschaltet worden sein knnten
  MenuStartStopPlaying->ShortCut = ShortCut(Word(' '), TShiftState());

  // Buttons und Meneintrge
  ButtonRead->Enabled = (strAudioFileName != "");
  MenuRead->Enabled = ButtonRead->Enabled;
  ButtonWrite->Enabled = (strAudioFileName != "" && nCues > 0);
  MenuWrite->Enabled = ButtonWrite->Enabled;
  ButtonSave->Enabled = (nCues > 0);
  MenuSave->Enabled = ButtonSave->Enabled;
  ButtonSaveCueSheet->Enabled = (nCues > 0);
  MenuSaveCueSheet->Enabled = ButtonSaveCueSheet->Enabled;
  ButtonSaveAudacityLabels->Enabled = (nCues > 0);
  MenuSaveAudacityLabels->Enabled = ButtonSaveAudacityLabels->Enabled;
  MenuOffset->Enabled = (nCues > 0);
  MenuCopySel->Enabled = (RichEditCueList->SelLength > 0);
  ButtonEditor->Enabled = (strAudioFileName != "");
  MenuEditor->Enabled = ButtonEditor->Enabled;
  MenuDeleteCueList->Enabled = (strAudioFileName != "");

  // Cue-Player-Buttons
  ButtonPlay->Enabled = (bAudioFileIsValid && CanPlayFile());
  ButtonPlay->Down = (bPlaying && bPaused);
  ButtonPlay->Hint = (bPlaying ? bPaused ? "Continue playing" : "Pause playing" : "Start playing");
  ButtonPlay->Glyph->LoadFromResourceID((int)HInstance, bPlaying ? IDB_PAUSE : IDB_PLAY);
  ButtonStop->Enabled = (bPlaying);
  UpDownPlay->Enabled = (nCues > 0);
  UpDownPlay->Max = (short)nCues;
  if(UpDownPlay->Position > nCues) UpDownPlay->Position = (short)nCues;
  TrackBarPlay->Enabled = (bAudioFileIsValid || nCues > 0 || bPlaying);
  DisplayPlay();

  // Wieder auf 0 setzen
  UpDownCueBegin->Position = 0;
  UpDownCueEnd->Position = 0;
  UpDownCueLength->Position = 0;


}
//---------------------------------------------------------------------------

void TForm1::SetStatusBarText(String strText)
{
  StatusBar->Panels->Items[1]->Text = strText;
}
//---------------------------------------------------------------------------

void TForm1::ProcessFile(String strFileName, bool bSave)
{
  String strPathName = ExtractFilePath(strFileName);

/*
    OpenDialogWAV->InitialDir = strPathName;
    OpenDialogCue->InitialDir = strPathName;
    SaveDialogCue->InitialDir = strPathName;
    SaveDialogCueSheet->InitialDir = strPathName;
    SaveDialogTextFile->InitialDir = strPathName;
    OpenDialogCueSheet->InitialDir = strPathName;
*/
  // Kein InitialDir setzen, da dann nicht mehr nderbar!
  chdir(strPathName.c_str()); // fr fopen() der Audio-Datei(en) in einem Cue-Sheet

  String strFileExt = LowerCase(ExtractFileExt(strFileName));

  if(strFileExt == ".wav")
  {
    SelectAudioFile(strFileName);
  }
  else if(strFileExt == ".wv")
  {
    SelectAudioFile(strFileName);
  }
  else if(strFileExt == ".clt")
  {
    if (bSave)
      SaveCueListFile(true, strFileName);    // true = Non-Interactive
    else
      LoadCueListFile(strFileName);
  }
  else if(strFileExt == ".cue")
  {
    if (bSave)
      SaveCueSheet(true, strFileName);    // true = Non-Interactive
    else
      LoadCueSheet(strFileName);
  }
  else if(strFileExt == ".txt")
  {
    if (bSave)
      SaveAudacityLabels(true, strFileName);       // true = Non-Interactive
    else
      LoadAudacityLabels(strFileName);
  }
}
//---------------------------------------------------------------------------

void TForm1::SelectAudioFile(String strFileName)
{
  if(strFileName != "")
    OpenDialogWAV->FileName = strFileName;
  else
    if(!OpenDialogWAV->Execute()) return;

  strAudioFileName = OpenDialogWAV->FileName;
  bAudioFileIsValid = GetWavFileData(strAudioFileName, nAudioFileSamples, nAudioFileSamplesPerSec);
  strCueSheetCDFileName = strAudioFileName;
  SetCDPerformerAndTitleFromCDFileName();
  SetStatusBarText("Audio file '" + ExtractFileName(strAudioFileName) + "' has been selected");
//  EnableControls(); // erfolgt schon in Display()
  Display();
}
//---------------------------------------------------------------------------

void TForm1::ReadCueListFromAudioFile(String strFileName)
{
  // Evtl. vorgenommene nderungen verwerfen?
  if(!DiscardChanges()) return;

  int nCuesRead;

  // Zur Zeit nur RIFF-Dateien implementiert (spter hier nach Dateitypen unterscheiden).
  if((nCuesRead = ReadCueListFromRiffFile(strFileName, 0)) != -1)
  {
    nCues = nCuesRead;
    SortCueArray();
    nCueListSamplesPerSec = WaveFmt.nSamplesPerSec;
    SetStatusBarText(IntToStr(nCues) + " Cues have been loaded from '" + ExtractFileName(strFileName) + "'");
  }
  Display();
}
//---------------------------------------------------------------------------

void TForm1::WriteCueListToAudioFile(String strFileName)
{
  int nCuesWritten;

  // Zur Zeit nur RIFF-Dateien implementiert (spter hier nach Dateitypen unterscheiden).
  if((nCuesWritten = WriteCueListToRiffFile(strFileName)) != -1)
  {
    SetStatusBarText(IntToStr(nCuesWritten) + " Cues (" + IntToStr(nCues) + " new + " + IntToStr(nCuesWritten - nCues) + " existing) have been written to '" + ExtractFileName(strFileName) + "'");
    SetDirtyFlag(false);
  }
}
//---------------------------------------------------------------------------

void TForm1::DeleteCueListFromAudioFile(String strFileName)
{
  if(MessageBox(Handle, "Are you sure you want to delete the Cue List from the selected WAV file?", "Warning", MB_YESNO|MB_ICONWARNING|MB_APPLMODAL) != IDYES) return;

  int nCuesDeleted;

  // Zur Zeit nur RIFF-Dateien implementiert (spter hier nach Dateitypen unterscheiden).
  if((nCuesDeleted = WriteCueListToRiffFile(strFileName, true)) != -1)
  {
    SetStatusBarText(IntToStr(nCuesDeleted) + " Cues have been deleted from '" + ExtractFileName(strFileName) + "'");
  }
}
//---------------------------------------------------------------------------

int TForm1::ReadCueListFromRiffFile(String strFileName, int nCueArrayOffset, bool bDeleteCueListFromAudioFile/* = false*/)
{
  MMCKINFO RiffChunkInfo; // RIFF-Chunk
  MMCKINFO FormatChunkInfo; // Format-Subchunk (Wave-Parameter)
  MMCKINFO DataChunkInfo; // Data-Subchunk (Wave-Audio-Daten)
  MMCKINFO CueChunkInfo; // Cue-Subchunk (Startsample)
  MMCKINFO ListChunkInfo; // LIST-Chunk
  MMCKINFO LtxtChunkInfo; // Cue-Lnge
  MMCKINFO LablChunkInfo; // Cue-Label
  MMCKINFO NoteChunkInfo; // Cue-Description
  CUEPOINT CuePoint;
  CUELABELTEXTCHUNK CueLtxtChunk;
  CUETEXTCHUNK CueTextChunk;
  String strMsg;

  FILE *fp = fopen(strFileName.c_str(), "rb");
  if(!fp)
  {
    strMsg = "";
    strMsg.sprintf("Can't open WAV file '%s' for reading.", strFileName.c_str());
    MessageBox(Handle, strMsg.c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
    return -1;
  }

  // Find the RIFF chunk.
  memset(&RiffChunkInfo, 0, sizeof(MMCKINFO));
  RiffChunkInfo.ckid = StringToFOURCC("RIFF");
  if(FindChunk(fp, &RiffChunkInfo, NULL))
  {
    fclose(fp);
    RIFFError("RIFF");
    return -1;
  }

  // Descend into the format chunk.
  memset(&FormatChunkInfo, 0, sizeof(MMCKINFO));
  FormatChunkInfo.ckid = StringToFOURCC("fmt");
  if(FindChunk(fp, &FormatChunkInfo, &RiffChunkInfo))
  {
    fclose(fp);
    RIFFError("fmt");
    return -1;
  }

  // Read the wave format.
  memset(&WaveFmt, 0, sizeof(WAVEFORMATEX));
  int nBytesToRead = sizeof(WAVEFORMATEX) < FormatChunkInfo.cksize ? sizeof(WAVEFORMATEX) : FormatChunkInfo.cksize;
  fread((char*)&WaveFmt, 1, nBytesToRead, fp);

  if(WaveFmt.wFormatTag != WAVE_FORMAT_PCM && WaveFmt.wFormatTag != WAVE_FORMAT_IEEE_FLOAT)
  {
    fclose(fp);
    MessageBox(Handle, "This WAV file is not a standard Windows PCM or IEEE754 32-bit/64-bit (MSVC++ float/double) file.", "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
    return -1;
  }

  // Ascend out of the format chunk.
  if(SeekBehindChunk(fp, &FormatChunkInfo))
  {
    fclose(fp);
    RIFFError("fmt");
    return -1;
  }

  // Descend into the data chunk.
  memset(&DataChunkInfo, 0, sizeof(MMCKINFO));
  DataChunkInfo.ckid = StringToFOURCC("data");
  if(FindChunk(fp, &DataChunkInfo, &RiffChunkInfo))
  {
    fclose(fp);
    RIFFError("data");
    return -1;
  }

  // Set the file pointer behind the data.
//  fseek(fp, DataChunkInfo.cksize, SEEK_CUR);
//  nFilePointerCueSubchunk = ftell(fp);
  // Neu: DataChunkInfo.cksize neu berechnen, damit auch WavPack-Dateien gelesen werden knnen:
  int nCurrentFilePos = ftell(fp);
  fseek(fp, 0, SEEK_END);
  int nFileSize = ftell(fp);
  nDataChunkSizeDiff = DataChunkInfo.cksize;
  DataChunkInfo.cksize = nFileSize + DataChunkInfo.cksize - RiffChunkInfo.cksize - 8;
  nDataChunkSizeDiff -= DataChunkInfo.cksize;
  fseek(fp, nCurrentFilePos + DataChunkInfo.cksize, SEEK_SET);
  nFilePointerCueSubchunk = ftell(fp);

  // Falls die WAV-Datei eine Cue-List enthlt, dann diese ins Array lesen:
  int nCuesInFile = 0;

  do // "Pseudo"-Schleife, um im Fehlerfalle mit 'break' hinter die Schleife zu springen. ;-)
  {
    // Ascend out of the data chunk.
    if(SeekBehindChunk(fp, &DataChunkInfo)) break;

    // Descend into the cue chunk.
    memset(&CueChunkInfo, 0, sizeof(MMCKINFO));
    CueChunkInfo.ckid = StringToFOURCC("cue");
    if(FindChunk(fp, &CueChunkInfo, &RiffChunkInfo)) break;

    // Anzahl Cue-Positions nach nCuesInFile lesen
    fread((char*)&nCuesInFile, sizeof(DWORD), 1, fp); // Anzahl Cuepoints
    if(nCuesInFile == 0) break; // Keine Cues gefunden

    // Wenn die Cue-List aus der WAV-Datei gelscht werden soll, dann nur die Anzahl der Cues zurckgeben.
    if(bDeleteCueListFromAudioFile) break; //

    if(sizeof(DWORD) + nCuesInFile * sizeof(CUEPOINT) != CueChunkInfo.cksize)
    {
      MessageBox(Handle, "Number of found Cue points doesn't match size of cue chunk.", "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
      break;
    }

    if(nCueArrayOffset > 0 && nCuesInFile + nCueArrayOffset > nMaxCues)
    {
      strMsg = "";
      strMsg.sprintf("Maximum number of Cue points (%d) exceeded by %d - can't proceed!", nMaxCues, nCuesInFile + nCueArrayOffset - nMaxCues);
      MessageBox(Handle, strMsg.c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
      fclose(fp);
      return -1;
    }

    int iCueRead;
    for(iCueRead = 0; iCueRead < nCuesInFile && iCueRead < nMaxCues - nCueArrayOffset; iCueRead++)
    {
      memset(&CuePoint, 0, sizeof(CUEPOINT));
      fread((char*)&CuePoint, sizeof(CUEPOINT), 1, fp); // Cuepoints in Struktur einlesen
      CueArray[iCueRead + nCueArrayOffset].StartSample = CuePoint.dwSampleOffset;
      CueArray[iCueRead + nCueArrayOffset].ID = CuePoint.dwIdentifier;
      CueArray[iCueRead + nCueArrayOffset].nSamples = 0;
      CueArray[iCueRead + nCueArrayOffset].Label = "";
      CueArray[iCueRead + nCueArrayOffset].Description = "";
      CueArray[iCueRead + nCueArrayOffset].Type = "";
    }

    if(iCueRead < nCuesInFile)
    {
      strMsg = "";
      strMsg.sprintf("Only %d of %d Cue points could be read.", iCueRead, nCuesInFile);
      MessageBox(Handle, strMsg.c_str(), "Warning", MB_OK|MB_ICONINFORMATION|MB_APPLMODAL);
      nCuesInFile = iCueRead;
    }

    // Ascend out of the cue chunk.
    if(SeekBehindChunk(fp, &CueChunkInfo)) break;

    // Find the LIST chunk.
    memset(&ListChunkInfo, 0, sizeof(MMCKINFO));
    ListChunkInfo.ckid = StringToFOURCC("LIST");
    if(FindChunk(fp, &ListChunkInfo, NULL))
    {
      nCuesInFile = 0;
      break;
    }

    do // Cue-Lngen lesen:
    {
      // Descend into the ltxt chunk.
      memset(&LtxtChunkInfo, 0, sizeof(MMCKINFO));
      LtxtChunkInfo.ckid = StringToFOURCC("ltxt");
      if(FindChunk(fp, &LtxtChunkInfo, &ListChunkInfo)) break;

      memset(&CueLtxtChunk, 0, sizeof(CUELABELTEXTCHUNK));
      fread((char*)&CueLtxtChunk + 8, LtxtChunkInfo.cksize, 1, fp);

      for(int iCue = 0; iCue < nCuesInFile; iCue++)
      {
        if(CueArray[iCue + nCueArrayOffset].ID > 0 && CueArray[iCue + nCueArrayOffset].ID == CueLtxtChunk.dwIdentifier)
        {
          CueArray[iCue + nCueArrayOffset].nSamples = CueLtxtChunk.dwSampleLength;
          CueArray[iCue + nCueArrayOffset].Type = FOURCCToString(CueLtxtChunk.dwPurpose);
          if(CueArray[iCue + nCueArrayOffset].Type.IsEmpty()) CueArray[iCue + nCueArrayOffset].Type = "rgn";
          break;
        }
      }
      // Ascend out of the ltxt chunk.
      if(SeekBehindChunk(fp, &LtxtChunkInfo)) break;
    }
    while(true);

    fseek(fp, ListChunkInfo.dwDataOffset + 4, SEEK_SET); // Zum Beginn des List-Chunks!

    do // Cue-Labels lesen:
    {
      // Descend into the labl chunk.
      memset(&LablChunkInfo, 0, sizeof(MMCKINFO));
      LablChunkInfo.ckid = StringToFOURCC("labl");
      if(FindChunk(fp, &LablChunkInfo, &ListChunkInfo)) break;

      memset(&CueTextChunk, 0, sizeof(CUETEXTCHUNK));
      fread((char*)&CueTextChunk + 8, LablChunkInfo.cksize, 1, fp);

      for(int iCue = 0; iCue < nCuesInFile; iCue++)
      {
        if(CueArray[iCue + nCueArrayOffset].ID > 0 && CueArray[iCue + nCueArrayOffset].ID == CueTextChunk.dwIdentifier)
        {
          CueArray[iCue + nCueArrayOffset].Label = CueTextChunk.szText;
          break;
        }
      }
      // Ascend out of the labl chunk.
      if(SeekBehindChunk(fp, &LablChunkInfo)) break;
    }
    while(true);

    fseek(fp, ListChunkInfo.dwDataOffset + 4, SEEK_SET); // Zum Beginn des List-Chunks!

    do // Cue-Descriptions lesen:
    {
      // Descend into the note chunk.
      memset(&NoteChunkInfo, 0, sizeof(MMCKINFO));
      NoteChunkInfo.ckid = StringToFOURCC("note");
      if(FindChunk(fp, &NoteChunkInfo, &ListChunkInfo)) break;

      memset(&CueTextChunk, 0, sizeof(CUETEXTCHUNK));
      fread((char*)&CueTextChunk + 8, NoteChunkInfo.cksize, 1, fp);

      for(int iCue = 0; iCue < nCuesInFile; iCue++)
      {
        if(CueArray[iCue + nCueArrayOffset].ID > 0 && CueArray[iCue + nCueArrayOffset].ID == CueTextChunk.dwIdentifier)
        {
          CueArray[iCue + nCueArrayOffset].Description = CueTextChunk.szText;
          break;
        }
      }
      // Ascend out of the note chunk.
      if(SeekBehindChunk(fp, &NoteChunkInfo)) break;
    }
    while(true);
  }
  while(false); // "Schleife" nur einmal durchlaufen

  // Close the file
  fclose(fp);

  // Wenn die Cue-List aus der WAV-Datei gelscht werden soll, dann nur die Anzahl der Cues zurckgeben.
  if(bDeleteCueListFromAudioFile) return nCuesInFile;

  // Prefix vor Cue-Label setzen
  if(FormSettings->CheckBoxEnablePrefixes->Checked && FormSettings->EditPrefix->Text != "")
    for(int iCue = 0; iCue < nCuesInFile; iCue++)
      if(CueArray[iCue + nCueArrayOffset].Label.SubString(1, 1) != "<")
        CueArray[iCue + nCueArrayOffset].Label = "<" + FormSettings->EditPrefix->Text + "> " + CueArray[iCue + nCueArrayOffset].Label;

  // Duplikate aus dem CueListArray entfernen
  for(int iCue = 0; iCue < nCuesInFile; iCue++)
  {
    if(CueExists(iCue + nCueArrayOffset))
    {
      // alle Cues im Array um 1 Position nach links verschieben:
      for(int iCueToMove = iCue; iCueToMove < nCuesInFile - 1; iCueToMove++)
      {
        CueArray[iCueToMove + nCueArrayOffset].StartSample = CueArray[iCueToMove + 1 + nCueArrayOffset].StartSample;
        CueArray[iCueToMove + nCueArrayOffset].nSamples    = CueArray[iCueToMove + 1 + nCueArrayOffset].nSamples;
        CueArray[iCueToMove + nCueArrayOffset].Label       = CueArray[iCueToMove + 1 + nCueArrayOffset].Label;
        CueArray[iCueToMove + nCueArrayOffset].Description = CueArray[iCueToMove + 1 + nCueArrayOffset].Description;
        CueArray[iCueToMove + nCueArrayOffset].Type        = CueArray[iCueToMove + 1 + nCueArrayOffset].Type;
      }
      nCuesInFile--, iCue--;
    }
  }

  return nCuesInFile;
}
//---------------------------------------------------------------------------

bool TForm1::CueExists(int iCueArrayIndex)
{
  if(!FormSettings->CheckBoxEliminateDuplicateCues->Checked) return false;

  int     StartSample   = CueArray[iCueArrayIndex].StartSample;
  int     nSamples      = CueArray[iCueArrayIndex].nSamples;
  String  Label         = CueArray[iCueArrayIndex].Label;
  String  Description   = CueArray[iCueArrayIndex].Description;
  String  Type          = CueArray[iCueArrayIndex].Type;

  for(int iCue = 0; iCue < iCueArrayIndex; iCue++)
  {
    if(
      CueArray[iCue].StartSample == StartSample &&
      CueArray[iCue].nSamples    == nSamples &&
      CueArray[iCue].Label       == Label &&
      CueArray[iCue].Description == Description &&
      CueArray[iCue].Type        == Type
    ) return true;
  }
  return false;
}
//---------------------------------------------------------------------------
// Funktionen zum Sortieren des Cue-Arrays:

String TForm1::CueArrayElementToSortString(CUEARRAY* pCueArrayElement)
{
  String strTemp;

  strTemp.sprintf
  (
    "%010d%010d%s%s%s",
    pCueArrayElement->StartSample,
    pCueArrayElement->nSamples,
    pCueArrayElement->Label.c_str(),
    pCueArrayElement->Description.c_str(),
    pCueArrayElement->Type.c_str()
  );

  return strTemp;
}

int TForm1::CompareCueArrayElements(CUEARRAY* pElement1, CUEARRAY* pElement2)
{
  String strElement1 = CueArrayElementToSortString(pElement1);
  String strElement2 = CueArrayElementToSortString(pElement2);
  return strElement1.AnsiCompare(strElement2);
}

void TForm1::SwapCueArrayElements(CUEARRAY* pElement1, CUEARRAY* pElement2)
{
  CUEARRAY tmpCueArrayElement;

  tmpCueArrayElement.StartSample = pElement1->StartSample;
  tmpCueArrayElement.nSamples    = pElement1->nSamples;
  tmpCueArrayElement.ID          = pElement1->ID;
  tmpCueArrayElement.Label       = pElement1->Label;
  tmpCueArrayElement.Description = pElement1->Description;
  tmpCueArrayElement.Type        = pElement1->Type;

  pElement1->StartSample         = pElement2->StartSample;
  pElement1->nSamples            = pElement2->nSamples;
  pElement1->ID                  = pElement2->ID;
  pElement1->Label               = pElement2->Label;
  pElement1->Description         = pElement2->Description;
  pElement1->Type                = pElement2->Type;

  pElement2->StartSample         = tmpCueArrayElement.StartSample;
  pElement2->nSamples            = tmpCueArrayElement.nSamples;
  pElement2->ID                  = tmpCueArrayElement.ID;
  pElement2->Label               = tmpCueArrayElement.Label;
  pElement2->Description         = tmpCueArrayElement.Description;
  pElement2->Type                = tmpCueArrayElement.Type;
}

void TForm1::SortCueArray()
{
  if(nCues < 2) return;

  SetStatusBarText("Sorting the cue list, please wait...");

  Screen->Cursor = crHourGlass;

  // Bubblesort
  for(int iEnde = nCues - 1; iEnde >= 0 ; iEnde--)
  {
    Application->ProcessMessages(); // Damit die Wiedergabe nicht stoppt...
    for(int iElement = 0; iElement < iEnde; iElement++)
    {
      if(CompareCueArrayElements(&CueArray[iElement], &CueArray[iElement + 1]) > 0)
      {
        SwapCueArrayElements(&CueArray[iElement], &CueArray[iElement + 1]);
      }
    }
  }
  Screen->Cursor = crDefault;
}
//---------------------------------------------------------------------------

int TForm1::WriteCueListToRiffFile(String strFileName, bool bDeleteCueListFromAudioFile/* = false*/)
{
  FILE *fp;
  String strMsg;
  MMCKINFO ListChunkInfo;
  CUECHUNK CueChunkInfo;
  CUEPOINT CuePointInfo;
  CUELABELTEXTCHUNK CueLabelTextChunkInfo;
  CUETEXTCHUNK CueTextChunkInfo;
  char szCueText[sizeof(CueTextChunkInfo.szText)];
  int nCueTextLength;
  int nCuesGesamt, nCuesDeleted, nWavFileSamplesPerSec;

  if(bDeleteCueListFromAudioFile)
  {
    nCuesDeleted = ReadCueListFromRiffFile(strFileName, nCues, true);
    if(nCuesDeleted == -1) return -1;   // Fehler aufgetreten
    if(nCuesDeleted == 0) return 0;     // Keine Cues zu lschen
    nCuesGesamt = 0;
  }
  else
  {
    if(nCues == 0) return -1;
    nCuesGesamt = ReadCueListFromRiffFile(strFileName, nCues);
    if(nCuesGesamt == -1) return -1;
    nCuesGesamt += nCues;
  }

  nWavFileSamplesPerSec = WaveFmt.nSamplesPerSec;

  if((fp = fopen(strFileName.c_str(), "r+b")) == NULL)
  {
    strMsg = "";
    strMsg.sprintf("Can't open WAV file '%s' for writing.", strFileName.c_str());
    MessageBox(Handle, strMsg.c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
    return -1;
  }

  if(fseek(fp, nFilePointerCueSubchunk, SEEK_SET) != 0)
  {
    strMsg = "";
    strMsg.sprintf("Can't seek to 'cue' subchunk in WAV file '%s'.", strFileName.c_str());
    MessageBox(Handle, strMsg.c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
    return -1;
  }

  strMsg = "";
  strMsg.sprintf("Can't write to wav file '%s'.", strFileName.c_str());

  // Cue-Subchunk (CUECHUNK) schreiben ("cue")

  CueChunkInfo.chunkID = StringToFOURCC("cue");
  CueChunkInfo.chunkSize = 4 + nCuesGesamt * sizeof(CUEPOINT);
  CueChunkInfo.dwCuePoints = nCuesGesamt;

  if(!fwrite(&CueChunkInfo, sizeof(CUECHUNK), 1, fp))
  {
    fclose(fp);
    MessageBox(Handle, strMsg.c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
    return -1;
  }

  // Cue-Position-Strukturen (CUEPOINT) schreiben ("data")

  for(int iCue = 0; iCue < nCuesGesamt; iCue++)
  {
    int nSample = CueArray[iCue].StartSample;
    // Samplerate nur anpassen, wenn tatschlich unterschiedlich,
    // jedoch nicht fr die Cues im CueArray hinter nCues!
    if(iCue < nCues && nWavFileSamplesPerSec != nCueListSamplesPerSec)
      nSample = (int)((hyper)nSample * nWavFileSamplesPerSec / nCueListSamplesPerSec);

    CuePointInfo.dwIdentifier = iCue + 1;
    CuePointInfo.dwPosition = nSample;
    CuePointInfo.fccChunk = StringToFOURCC("data");
    CuePointInfo.dwChunkStart = 0;
    CuePointInfo.dwBlockStart = 0;
    CuePointInfo.dwSampleOffset = nSample;

    if(!fwrite(&CuePointInfo, sizeof(CUEPOINT), 1, fp))
    {
      fclose(fp);
      MessageBox(Handle, strMsg.c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
      return -1;
    }
  }

  // LIST-Chunk schreiben (cksize noch uninitialisiert!)

  int nListPos = ftell(fp);
  ListChunkInfo.ckid = StringToFOURCC("LIST");
  ListChunkInfo.fccType = StringToFOURCC("adtl");

  if(!fwrite(&ListChunkInfo, 12, 1, fp))
  {
    fclose(fp);
    MessageBox(Handle, strMsg.c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
    return -1;
  }

  // Fr jede Cue die Chunks fr Cue-Lnge, -Label und Description schreiben

  int nListSize = 4; // fccType
  for(int iCue = 0; iCue < nCuesGesamt; iCue++)
  {
    // CUELABELTEXTCHUNK ("ltxt")

    int nSample = CueArray[iCue].nSamples;
    // Samplerate nur anpassen, wenn tatschlich unterschiedlich,
    // jedoch nicht fr die Cues im CueArray hinter nCues!
    if(iCue < nCues && nWavFileSamplesPerSec != nCueListSamplesPerSec)
      nSample = (int)((hyper)nSample * nWavFileSamplesPerSec / nCueListSamplesPerSec);

    CueLabelTextChunkInfo.chunkID = StringToFOURCC("ltxt");
    CueLabelTextChunkInfo.chunkSize = 20;
    CueLabelTextChunkInfo.dwIdentifier = iCue + 1;
    CueLabelTextChunkInfo.dwSampleLength = nSample;
    CueLabelTextChunkInfo.dwPurpose = StringToFOURCC(CueArray[iCue].Type.c_str());
    CueLabelTextChunkInfo.dw1 = 0;
    CueLabelTextChunkInfo.dw2 = 0;

    if(!fwrite(&CueLabelTextChunkInfo, sizeof(CUELABELTEXTCHUNK), 1, fp))
    {
      fclose(fp);
      MessageBox(Handle, strMsg.c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
      return -1;
    }

    nListSize += sizeof(CUELABELTEXTCHUNK);

    // CUETEXTCHUNK ("labl")

    memset(&CueTextChunkInfo, 0, sizeof(CUETEXTCHUNK));

    if(CueArray[iCue].Label == "") // Falls Label fehlt, ein Standard-Label erzeugen!
    {
      sprintf(szCueText, "Cue %d", iCue + 1);
    }
    else
    {
      strncpy(szCueText, CueArray[iCue].Label.c_str(), sizeof(szCueText));
      szCueText[sizeof(szCueText) - 1] = 0;
    }

    nCueTextLength = strlen(szCueText) + 1; // Lnge incl. abschlieender 0
    if(nCueTextLength % 2) nCueTextLength++; // falls ungerade, mit einer weiteren 0 auffllen

    CueTextChunkInfo.chunkID = StringToFOURCC("labl");
    CueTextChunkInfo.chunkSize = 4 + nCueTextLength;
    CueTextChunkInfo.dwIdentifier = iCue + 1;
    strcpy(CueTextChunkInfo.szText, szCueText);

    if(!fwrite(&CueTextChunkInfo, 12 + nCueTextLength, 1, fp))
    {
      fclose(fp);
      MessageBox(Handle, strMsg.c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
      return -1;
    }

    nListSize += (12 + nCueTextLength);

    // CUETEXTCHUNK ("note")

    memset(&CueTextChunkInfo, 0, sizeof(CUETEXTCHUNK));

    if(CueArray[iCue].Description != "") // Description nur abspeichern, wenn vorhanden!
    {
      strncpy(szCueText, CueArray[iCue].Description.c_str(), sizeof(szCueText));
      nCueTextLength = strlen(szCueText) + 1; // Lnge incl. abschlieender 0
      if(nCueTextLength % 2) nCueTextLength++; // falls ungerade, mit einer weiteren 0 auffllen

      CueTextChunkInfo.chunkID = StringToFOURCC("note");
      CueTextChunkInfo.chunkSize = 4 + nCueTextLength;
      CueTextChunkInfo.dwIdentifier = iCue + 1;
      strncpy(CueTextChunkInfo.szText, szCueText, nCueTextLength);

      if(!fwrite(&CueTextChunkInfo, 12 + nCueTextLength, 1, fp))
      {
        fclose(fp);
        MessageBox(Handle, strMsg.c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
        return -1;
      }

      nListSize += (12 + nCueTextLength);
    }
  }

  // Neues Dateiende. Dieses kann vor dem alten Dateiende liegen, falls weniger Extra-Daten
  // geschrieben wurden, als zuvor in der Datei enthalten waren. Daher mu nach dem Schlieen
  // die Datei "gestutzt" werden (s.u.).
  int nLogicalFileSize = ftell(fp);

  // cksize im RIFF-Chunk aktualisieren
  int nRiffSize = nLogicalFileSize - 8 + nDataChunkSizeDiff;
  if(fseek(fp, 4, SEEK_SET))
  {
    fclose(fp);
    MessageBox(Handle, strMsg.c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
    return -1;
  }
  if(!fwrite(&nRiffSize, 4, 1, fp))
  {
    fclose(fp);
    MessageBox(Handle, strMsg.c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
    return -1;
  }

  // cksize im LIST-Chunk aktualisieren
  if(fseek(fp, nListPos + 4, SEEK_SET))
  {
    fclose(fp);
    MessageBox(Handle, strMsg.c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
    return -1;
  }
  if(!fwrite(&nListSize, 4, 1, fp))
  {
    fclose(fp);
    MessageBox(Handle, strMsg.c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
    return -1;
  }

  fseek(fp, 0, SEEK_END);
  int nPhysicalFileSize = ftell(fp);

  fclose(fp);

  // Falls weniger Extra-Informationen in die Datei geschrieben wurden, als vorher
  // schon enthalten waren, dann ist die Datei jetzt zu lang. Der "Rest" mu daher
  // abgeschnitten werden:

  if(nLogicalFileSize < nPhysicalFileSize)
    TruncateFile(strFileName, nLogicalFileSize);

  if(bDeleteCueListFromAudioFile) nCuesGesamt = nCuesDeleted;

  return nCuesGesamt;
}
//---------------------------------------------------------------------------

bool TForm1::TruncateFile(String strFileName, int nNewFileSize)
{
  bool bSuccess = false;
  HANDLE hFile = CreateFile(strFileName.c_str(), GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
  if(hFile != INVALID_HANDLE_VALUE)
  {
    if(SetFilePointer(hFile, nNewFileSize, NULL, FILE_BEGIN) != 0xFFFFFFFF)
    {
      bSuccess = (SetEndOfFile(hFile) != 0);
    }
    CloseHandle(hFile);
  }
  if(!bSuccess)
  {
    String strMsg;
    strMsg.sprintf("Failed to truncate file '%s' to the correct size.", strFileName.c_str());
    MessageBox(Handle, strMsg.c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
  }
  return bSuccess;
/*
  String strTempFileName = strFileName + ".$$$CLTTEMP$$$";
  FILE *in, *out;
  char sBuffer[64 * 1024];
  String strMsg;

  if((in = fopen(strFileName.c_str(), "rb")) == NULL)
  {
    strMsg = "";
    strMsg.sprintf("Can't open source file '%s' for reading.", strFileName.c_str());
    MessageBox(Handle, strMsg.c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
    return false;
  }

  if((out = fopen(strTempFileName.c_str(), "wb")) == NULL)
  {
    fclose(out);

    strMsg = "";
    strMsg.sprintf("Can't open temporary file '%s' for writing.", strTempFileName.c_str());
    MessageBox(Handle, strMsg.c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
    return false;
  }

  int nRemainingBytes = nNewFileSize;
  int nBytesToRead;
  int nReadBytes;
  int nWrittenBytes;
  int nPercent;
  String strProgressBar;

  Screen->Cursor = crHourGlass;

  while(nRemainingBytes > 0)
  {
    nPercent = (int)((hyper)100 * (nNewFileSize - nRemainingBytes) / nNewFileSize);
    strMsg = "";
    strMsg.sprintf("%d%% - Truncating file '%s'...", (int)nPercent, ExtractFileName(strFileName).c_str());
    SetStatusBarText(strMsg.c_str());
    Update();
//    Application->ProcessMessages();   -> Wenn das, dann auch Controls disablen!

    nBytesToRead = min((int)sizeof(sBuffer), nRemainingBytes);
    nReadBytes = fread(sBuffer, 1, nBytesToRead, in);

    if(nReadBytes != nBytesToRead)
    {
      Screen->Cursor = crDefault;
      fclose(in);
      fclose(out);
      unlink(strTempFileName.c_str());

      strMsg = "";
      strMsg.sprintf("Can't read source file '%s'.", strFileName.c_str());
      MessageBox(Handle, strMsg.c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
      return false;
    }

    nWrittenBytes = fwrite(sBuffer, 1, nReadBytes, out);

    if(nWrittenBytes != nReadBytes)
    {
      Screen->Cursor = crDefault;
      fclose(in);
      fclose(out);
      unlink(strTempFileName.c_str());

      strMsg = "";
      strMsg.sprintf("Can't write to temporary file '%s'.", strTempFileName.c_str());
      MessageBox(Handle, strMsg.c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
      return false;
    }

    nRemainingBytes -= nWrittenBytes;
  }

  Screen->Cursor = crDefault;
  fclose(in);
  fclose(out);

  unlink(strFileName.c_str());

  if(rename(strTempFileName.c_str(), strFileName.c_str()) != 0)
  {
    strMsg = "";
    strMsg.sprintf(
      "Can't rename temporary file '%s'\n"
      "to original file name '%s'.\n"
      "Please rename the file manually!",
      strTempFileName.c_str(), strFileName.c_str());
    MessageBox(Handle, strMsg.c_str(), "Warnung", MB_OK|MB_ICONWARNING|MB_APPLMODAL);
    return true; // Trotzdem OK zurckgeben, da die neue Datei ja existiert.
  }

  return true;
*/
}
//---------------------------------------------------------------------------

void TForm1::InitGrid()
{
  // Header
  StringGrid->Cells[0][0] = "#";
  StringGrid->Cells[1][0] = "Type";
  StringGrid->Cells[2][0] = "Begin";
  StringGrid->Cells[3][0] = "End";
  StringGrid->Cells[4][0] = "Length";
  StringGrid->Cells[5][0] = "Label";
  StringGrid->Cells[6][0] = "Note";

  StringGrid->FixedRows = 1;    // Header

  if(nCues == 0)
  {
    // 1 leere Zeile, damit Selection nicht auf Header steht!
    StringGrid->Cells[0][1] = "";
    StringGrid->Cells[1][1] = "";
    StringGrid->Cells[2][1] = "";
    StringGrid->Cells[3][1] = "";
    StringGrid->Cells[4][1] = "";
    StringGrid->Cells[5][1] = "";
    StringGrid->Cells[6][1] = "";

    StringGrid->RowCount = 2;
    StringGrid->Row = 1;
    StringGrid->TopRow = 1;

    DisplayCueDetails();
  }
}
//---------------------------------------------------------------------------

void TForm1::DisplayCueDetails()
{
  bDisplayCueDetails = true;

  ComboBoxCueType->Text = StringGrid->Cells[1][StringGrid->Row];
  EditCueBegin->Text = StringGrid->Cells[2][StringGrid->Row];
  EditCueEnd->Text = StringGrid->Cells[3][StringGrid->Row];
  EditCueLength->Text = StringGrid->Cells[4][StringGrid->Row];
  EditCueLabel->Text = StringGrid->Cells[5][StringGrid->Row];
  EditCueDescription->Text = StringGrid->Cells[6][StringGrid->Row];

  int iCue = StringGrid->Row - 1;
  if(nCues > 0 && iCue >= 0 && iCue < nCues)
  {
    ComboBoxCueType->Enabled = true;
    EditCueBegin->Enabled = true;
    EditCueEnd->Enabled = true;
    EditCueLength->Enabled = true;
    EditCueLabel->Enabled = true;
    EditCueDescription->Enabled = true;
    UpDownCueBegin->Enabled = true;
    UpDownCueEnd->Enabled = true;
    UpDownCueLength->Enabled = true;
    ButtonSetCueBegin->Enabled = bAudioFileIsValid;
    ButtonSetCueEnd->Enabled = bAudioFileIsValid;
    ButtonAddCue->Enabled = true;
    ButtonDuplicateCue->Enabled = true;
    ButtonDeleteCue->Enabled = true;

    ComboBoxCueType->Color = clWindow;
    EditCueBegin->Color = clBtnFace;
    EditCueEnd->Color = clBtnFace;
    EditCueLength->Color = clBtnFace;
    EditCueLabel->Color = clWindow;
    EditCueDescription->Color = clWindow;

    PopupMenuStringGrid_PlayCueNormal->Enabled = ButtonPlay->Enabled;
    PopupMenuStringGrid_PlayCueExtended->Enabled = ButtonPlay->Enabled;
  }
  else
  {
    ComboBoxCueType->Enabled = false;
    EditCueBegin->Enabled = false;
    EditCueEnd->Enabled = false;
    EditCueLength->Enabled = false;
    EditCueLabel->Enabled = false;
    EditCueDescription->Enabled = false;
    UpDownCueBegin->Enabled = false;
    UpDownCueEnd->Enabled = false;
    UpDownCueLength->Enabled = false;
    ButtonSetCueBegin->Enabled = false;
    ButtonSetCueEnd->Enabled = false;
    ButtonAddCue->Enabled = true;
    ButtonDuplicateCue->Enabled = false;
    ButtonDeleteCue->Enabled = false;

    ComboBoxCueType->Color = clBtnFace;
    EditCueBegin->Color = clBtnFace;
    EditCueEnd->Color = clBtnFace;
    EditCueLength->Color = clBtnFace;
    EditCueLabel->Color = clBtnFace;
    EditCueDescription->Color = clBtnFace;

    PopupMenuStringGrid_PlayCueNormal->Enabled = false;
    PopupMenuStringGrid_PlayCueExtended->Enabled = false;
  }

  PopupMenuStringGrid_SetCueBegin->Enabled = ButtonSetCueBegin->Enabled;
  PopupMenuStringGrid_SetCueEnd->Enabled = ButtonSetCueEnd->Enabled;
  PopupMenuStringGrid_AddCue->Enabled = ButtonAddCue->Enabled;
  PopupMenuStringGrid_DuplicateCue->Enabled = ButtonDuplicateCue->Enabled;
  PopupMenuStringGrid_DeleteCue->Enabled = ButtonDeleteCue->Enabled;

  bDisplayCueDetails = false;
}
//---------------------------------------------------------------------------

String TForm1::CueTypeToString(String strCueType)
{
  String strCueTypeString = "";

  if(strCueType == "rgn")
    strCueTypeString = "Basic";
  else if(strCueType == "beat")
    strCueTypeString = "Beat";
  else if(strCueType == "trak")
    strCueTypeString = "Track";
  else if(strCueType == "indx")
    strCueTypeString = "Index";

  return strCueTypeString;
}
//---------------------------------------------------------------------------

String TForm1::CueStringToType(String strCueTypeString)
{
  String strCueType = "rgn";

  if(strCueTypeString == "Basic")
    strCueType = "rgn";
  else if(strCueTypeString == "Beat")
    strCueType = "beat";
  else if(strCueTypeString == "Track")
    strCueType = "trak";
  else if(strCueTypeString == "Index")
    strCueType = "indx";

  return strCueType;
}
//---------------------------------------------------------------------------

void TForm1::Display(bool bUpdate/* = false*/)
{
  String strTemp;

  // Titelzeile
  SetDirtyFlag(IsDirty());

  // StringGrid
  int nRow = StringGrid->Row;
  int nTopRow = StringGrid->TopRow;
  InitGrid();

  // Statistische Angaben
  int nCueRanges = 0;
  int nCuePoints = 0;
  int nSamplesCueRanges = 0;

  // Statuszeile setzen
  strTemp = "";
  strTemp.sprintf("%d Cues loaded", nCues);
  StatusBar->Panels->Items[0]->Text = strTemp;

  // Temporre Stringliste
  TStringList* pStringListTemp = new TStringList();

  String strCue, strBegin, strEnd, strLength, strLabel, strNote, strType;
  for(int iCue = 0; iCue < nCues; iCue++)
  {
    // Strings ermitteln
    strCue = ""; strCue.sprintf("%d", iCue + 1);
    strBegin = FormatTime((Extended)CueArray[iCue].StartSample / nCueListSamplesPerSec);
    strEnd = FormatTime((Extended)(CueArray[iCue].StartSample + CueArray[iCue].nSamples) / nCueListSamplesPerSec);
    strLength = FormatTime((Extended)CueArray[iCue].nSamples / nCueListSamplesPerSec);
    strLabel = CueArray[iCue].Label;
    strNote = CueArray[iCue].Description;
    strType = CueTypeToString(CueArray[iCue].Type);
    if(strType.IsEmpty()) strType = "unknown: " + CueArray[iCue].Type;

    // Ins StringGrid eintragen
    StringGrid->Cells[0][iCue + 1] = strCue;
    StringGrid->Cells[1][iCue + 1] = strType;
    StringGrid->Cells[2][iCue + 1] = strBegin;
    StringGrid->Cells[3][iCue + 1] = (CueArray[iCue].nSamples > 0 ? strEnd : String(""));
    StringGrid->Cells[4][iCue + 1] = (CueArray[iCue].nSamples > 0 ? strLength : String(""));
    StringGrid->Cells[5][iCue + 1] = strLabel;
    StringGrid->Cells[6][iCue + 1] = strNote;

    StringGrid->RowCount = iCue + 2;

    // Frs Display:
    if(CueArray[iCue].nSamples > 0)
    {
      nCueRanges++;

      // Anzahl Samples aufaddieren
      nSamplesCueRanges += CueArray[iCue].nSamples;

      // Pattern-String setzen
      strTemp = strFormatRanges;
    }
    else
    {
      nCuePoints++;

      // Pattern-String setzen
      strTemp = strFormatPoints;
    }

    // Platzhalter durch ermittelte Strings ersetzen
    strTemp = StringReplace(strTemp, "%cue", strCue, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
    strTemp = StringReplace(strTemp, "%begin", strBegin, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
    strTemp = StringReplace(strTemp, "%end", strEnd, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
    strTemp = StringReplace(strTemp, "%length", strLength, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
    strTemp = StringReplace(strTemp, "%label", strLabel, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
    strTemp = StringReplace(strTemp, "%note", strNote, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
    strTemp = StringReplace(strTemp, "%type", strType, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
    strTemp = StringReplace(strTemp, "%sep", strNote.IsEmpty() ? (String)"" : strFormatSeparator, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
    strTemp = StringReplace(strTemp, "%nl", "\n", TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
    strTemp = StringReplace(strTemp, "%tab", "\t", TReplaceFlags() << rfReplaceAll << rfIgnoreCase);

    // Zur StringList hinzufgen
    pStringListTemp->Add(strTemp);
  }

  // StringGrid
  if(bUpdate)
  {
    if(StringGrid->RowCount <= nRow) nRow = StringGrid->RowCount - 1;
    if(nRow < nTopRow) nTopRow = nRow;
    StringGrid->Row = nRow;
    StringGrid->TopRow = nTopRow;
  }
  DisplayCueDetails();

  // Header- und Summary-Zeilen
  if(nCues > 0)
  {
    // Strings ermitteln
    String strNumberOfAllCues; strNumberOfAllCues.sprintf("%d", nCues);
    String strNumberOfCueRanges; strNumberOfCueRanges.sprintf("%d", nCueRanges);
    String strNumberOfCuePoints; strNumberOfCuePoints.sprintf("%d", nCuePoints);
    String strTotalTimeOfCueRanges = FormatTime((Extended)nSamplesCueRanges / nCueListSamplesPerSec);
    String strFileName = ExtractFileName(strCueSheetCDFileName);
    String strPerformer = strCueSheetCDPerformer;
    String strAlbumTitle = strCueSheetCDTitle;

    // Falls Option aktiviert, die Header-Zeile anzeigen
    if(bFormatHeaderEnabled)
    {
      // Pattern-String setzen
      strTemp = strFormatHeader;

      // Platzhalter durch ermittelte Strings ersetzen
      strTemp = StringReplace(strTemp, "%cues", strNumberOfAllCues, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
      strTemp = StringReplace(strTemp, "%ranges", strNumberOfCueRanges, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
      strTemp = StringReplace(strTemp, "%points", strNumberOfCuePoints, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
      strTemp = StringReplace(strTemp, "%time", strTotalTimeOfCueRanges, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
      strTemp = StringReplace(strTemp, "%file", strFileName, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
      strTemp = StringReplace(strTemp, "%perf", strPerformer, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
      strTemp = StringReplace(strTemp, "%title", strAlbumTitle, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
      strTemp = StringReplace(strTemp, "%nl", "\n", TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
      strTemp = StringReplace(strTemp, "%tab", "\t", TReplaceFlags() << rfReplaceAll << rfIgnoreCase);

      // An den Anfang der StringList einfgen
      pStringListTemp->Insert(0, strTemp);
    }

    // Falls Option aktiviert, die Summary-Zeile anzeigen
    if(bFormatSummaryEnabled)
    {
      // Pattern-String setzen
      strTemp = strFormatSummary;

      // Platzhalter durch ermittelte Strings ersetzen
      strTemp = StringReplace(strTemp, "%cues", strNumberOfAllCues, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
      strTemp = StringReplace(strTemp, "%ranges", strNumberOfCueRanges, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
      strTemp = StringReplace(strTemp, "%points", strNumberOfCuePoints, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
      strTemp = StringReplace(strTemp, "%time", strTotalTimeOfCueRanges, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
      strTemp = StringReplace(strTemp, "%file", strFileName, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
      strTemp = StringReplace(strTemp, "%perf", strPerformer, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
      strTemp = StringReplace(strTemp, "%title", strAlbumTitle, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
      strTemp = StringReplace(strTemp, "%nl", "\n", TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
      strTemp = StringReplace(strTemp, "%tab", "\t", TReplaceFlags() << rfReplaceAll << rfIgnoreCase);

      // Zur StringList hinzufgen
      pStringListTemp->Add(strTemp);
    }
  }

  // Inhalt der Stringliste im Edit-Fenster anzeigen
  RichEditCueList->Clear();
  RichEditCueList->Text = pStringListTemp->Text;
  RichEditCueList->WordWrap = false;
//  RichEditCueList->Modified = false;
  RichEditCueList->ReadOnly = true;


  delete pStringListTemp;
  EnableControls();
}
//---------------------------------------------------------------------------

char* TForm1::MakeFormatString(int nFormatStringType, bool bFractional)
{
  static String strResult;
  strResult = "";

  int nLeadingDigits, nFractionalDigits;
  switch(nFormatStringType)
  {
  case MFS_HRS:
    nLeadingDigits = nFormatTimeLeadingDigitsHrs;
    nFractionalDigits = nFormatTimeFractionalDigitsHrs;
    break;
  case MFS_MIN:
    nLeadingDigits = nFormatTimeLeadingDigitsMin;
    nFractionalDigits = nFormatTimeFractionalDigitsMin;
    break;
  case MFS_SEC:
    nLeadingDigits = nFormatTimeLeadingDigitsSec;
    nFractionalDigits = nFormatTimeFractionalDigitsSec;
    break;
  case MFS_FRM:
    nLeadingDigits = nFormatTimeLeadingDigitsFrm;
    nFractionalDigits = nFormatTimeFractionalDigitsFrm;
    break;
  case MFS_SMP:
    nLeadingDigits = nFormatTimeLeadingDigitsSmp;
    nFractionalDigits = nFormatTimeFractionalDigitsSmp;
    break;
  }

  if(bFractional)
  {
    if(nFractionalDigits == 0)
    {
      strResult.sprintf("%%0%d.0Lf", nLeadingDigits);
    }
    else
    {
      strResult.sprintf("%%0%d.%dLf", nLeadingDigits + 1 + nFractionalDigits, nFractionalDigits);
    }
  }
  else
  {
    strResult.sprintf("%%0%dd", nLeadingDigits);
  }

  return strResult.c_str();
}

bool TForm1::CarryTimeString(String& strTime, int nMaxValue)
{
  int nPosDot = strTime.Pos(".");
  String strTimeIntValue = (nPosDot == 0 ? strTime : strTime.SubString(1, nPosDot - 1));
  String strTimeFracValue = (nPosDot == 0 ? String("") : strTime.SubString(nPosDot, strTime.Length() - (nPosDot - 1)));
  int nTimeIntValue;
  try { nTimeIntValue = StrToInt(strTimeIntValue); } catch(...) { return false; }
  if(nTimeIntValue < nMaxValue) return false;
  strTimeIntValue = AnsiString::StringOfChar('0', strTimeIntValue.Length());
  strTime = strTimeIntValue + strTimeFracValue;
  return true;
}

String TForm1::FormatTime(Extended fSec)
{
  static String strResult;
  String strHrs, strMin, strSec, strFrm, strSmp;

  // Die mglichen Werte errechnen
  Extended fHrsTotal = fSec / 3600;
  Extended fMinTotal = fSec / 60;
  Extended fSecTotal = fSec;
  Extended fFrmTotal = fSec * 75;
  Extended fSmpTotal = fSec * (bAudioFileIsValid ? nAudioFileSamplesPerSec : nCueListSamplesPerSec);

  Extended fMinWithoutHrs = fMinTotal - (int)fHrsTotal * 60;
  Extended fSecWithoutMin = fSecTotal - (int)fMinTotal * 60;
  Extended fSecWithoutHrs = fSecTotal - (int)fHrsTotal * 3600;
  Extended fFrmWithoutSec = fFrmTotal - (int)fSecTotal * 75;
  Extended fFrmWithoutMin = fFrmTotal - (int)fMinTotal * 60 * 75;
  Extended fFrmWithoutHrs = fFrmTotal - (int)fHrsTotal * 3600 * 75;

  // Ermitteln, welche Platzhalter existieren
  strResult = strFormatTime;
  bool bHrsExist = (strResult.Pos("%h") != 0 || strResult.Pos("%H") != 0);
  bool bMinExist = (strResult.Pos("%m") != 0 || strResult.Pos("%M") != 0);
  bool bSecExist = (strResult.Pos("%s") != 0 || strResult.Pos("%S") != 0);
  bool bFrmExist = (strResult.Pos("%f") != 0 || strResult.Pos("%F") != 0);
  bool bSmpExist = (strResult.Pos("%p") != 0 || strResult.Pos("%P") != 0);

  // bertrag beachten, der ggf. durch Aufrundung durch sprintf() entsteht.
  // Dann die jeweils hherwertigere Stelle entsprechend erhhen.
  bool bCarry = false;

  // Frames
  if(bFrmExist)
  {
    // Frames mit angeg. Anzahl Nachkommastellen ausgeben
    if(bSecExist)
    {
      // Frames zweistellig und abzglich der Sekunden ausgeben
      strFrm.sprintf(MakeFormatString(MFS_FRM, true), fFrmWithoutSec);
      bCarry = CarryTimeString(strFrm, 75);
    }
    else if(bMinExist)
    {
      // Frames zweistellig und abzglich der Minuten ausgeben
      strFrm.sprintf(MakeFormatString(MFS_FRM, true), fFrmWithoutMin);
      bCarry = CarryTimeString(strFrm, 60 * 75);
    }
    else if(bHrsExist)
    {
      // Frames zweistellig und abzglich der Stunden ausgeben
      strFrm.sprintf(MakeFormatString(MFS_FRM, true), fFrmWithoutHrs);
      bCarry = CarryTimeString(strFrm, 60 * 60 * 75);
    }
    else
    {
      // Frames mit angeg. Anzahl fhrender Nullen ausgeben
      strFrm.sprintf(MakeFormatString(MFS_FRM, true), fFrmTotal);
    }
  }

  // Sekunden
  if(bSecExist)
  {
    // bertrag bercksichtigen
    if(bCarry) fSecTotal++, fSecWithoutMin++, fSecWithoutHrs++, bCarry = false;

    if(bFrmExist)
    {
      // Sekunden ohne Nachkommastellen ausgeben
      if(bMinExist)
      {
        // Sekunden zweistellig und abzglich der Minuten ausgeben
        strSec.sprintf(MakeFormatString(MFS_SEC, false), (int)fSecWithoutMin);
        bCarry = CarryTimeString(strSec, 60);
      }
      else if(bHrsExist)
      {
        // Sekunden zweistellig und abzglich der Stunden ausgeben
        strSec.sprintf(MakeFormatString(MFS_SEC, false), (int)fSecWithoutHrs);
        bCarry = CarryTimeString(strSec, 60 * 60);
      }
      else
      {
        // Sekunden mit angeg. Anzahl fhrender Nullen ausgeben
        strSec.sprintf(MakeFormatString(MFS_SEC, false), (int)fSecTotal);
      }
    }
    else
    {
      // Sekunden mit Nachkommastellen ausgeben
      if(bMinExist)
      {
        // Sekunden zweistellig und abzglich der Minuten ausgeben
        strSec.sprintf(MakeFormatString(MFS_SEC, true), fSecWithoutMin);
        bCarry = CarryTimeString(strSec, 60);
      }
      else if(bHrsExist)
      {
        // Sekunden zweistellig und abzglich der Stunden ausgeben
        strSec.sprintf(MakeFormatString(MFS_SEC, true), fSecWithoutHrs);
        bCarry = CarryTimeString(strSec, 60 * 60);
      }
      else
      {
        // Sekunden mit angeg. Anzahl fhrender Nullen ausgeben
        strSec.sprintf(MakeFormatString(MFS_SEC, true), fSecTotal);
      }
    }
  }

  // Minuten
  if(bMinExist)
  {
    // bertrag bercksichtigen
    if(bCarry) fMinTotal++, fMinWithoutHrs++, bCarry = false;

    if(bSecExist || bFrmExist)
    {
      // Minuten ohne Nachkommastellen ausgeben
      if(bHrsExist)
      {
        // Minuten zweistellig und abzglich der Stunden ausgeben
        strMin.sprintf(MakeFormatString(MFS_MIN, false), (int)fMinWithoutHrs);
        bCarry = CarryTimeString(strMin, 60);
      }
      else
      {
        // Minuten mit angeg. Anzahl fhrender Nullen ausgeben
        strMin.sprintf(MakeFormatString(MFS_MIN, false), (int)fMinTotal);
      }
    }
    else
    {
      // Minuten mit Nachkommastellen ausgeben
      if(bHrsExist)
      {
        // Minuten zweistellig und abzglich der Stunden ausgeben
        strMin.sprintf(MakeFormatString(MFS_MIN, true), fMinWithoutHrs);
        bCarry = CarryTimeString(strMin, 60);
      }
      else
      {
        // Minuten mit angeg. Anzahl fhrender Nullen ausgeben
        strMin.sprintf(MakeFormatString(MFS_MIN, true), fMinTotal);
      }
    }
  }

  // Stunden
  if(bHrsExist)
  {
    // bertrag bercksichtigen
    if(bCarry) fHrsTotal++;     // (keine weitere Auswertung des Carry-Flags)

    if(bMinExist || bSecExist || bFrmExist)
    {
      // Stunden mit angeg. Anzahl fhrender Nullen, aber ohne Nachkommastellen ausgeben
      strHrs.sprintf(MakeFormatString(MFS_HRS, false), (int)fHrsTotal);
    }
    else
    {
      // Stunden mit angeg. Anzahl fhrender Nullen und Nachkommastellen ausgeben
      strHrs.sprintf(MakeFormatString(MFS_HRS, true), fHrsTotal);
    }
  }

  // Samples
  if(bSmpExist)
  {
    // Samples mit angeg. Anzahl fhrender Nullen ausgeben
    strSmp.sprintf(MakeFormatString(MFS_SMP, true), fSmpTotal);
  }

  // Platzhalter durch ermittelte Strings ersetzen
  strResult = StringReplace(strResult, "%h", strHrs, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
  strResult = StringReplace(strResult, "%m", strMin, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
  strResult = StringReplace(strResult, "%s", strSec, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
  strResult = StringReplace(strResult, "%f", strFrm, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);
  strResult = StringReplace(strResult, "%p", strSmp, TReplaceFlags() << rfReplaceAll << rfIgnoreCase);

  return strResult;
}
//---------------------------------------------------------------------------

String TForm1::FormatTimeCueSheet(Extended fSec)
{
  static String strTemp;
  strTemp = "";

  int nMin = fSec / 60;
  int nSec = fSec - nMin * 60;
  int nFrm = (fSec - (int)fSec) * 75 + 0.5;

  if(nFrm > 74)
  {
    nFrm = 0;
    nSec++;
    if(nSec > 59)
    {
      nSec = 0;
      nMin++;
    }
  }

  strTemp.sprintf("%02d:%02d:%02d", nMin, nSec, nFrm);

  return strTemp;
}
//---------------------------------------------------------------------------

void TForm1::SaveCueListFile(bool bNonInteractive, String strFileName)
{
  if(nCues == 0) return;

  if(!bNonInteractive)
  {
    strFileName = ExtractFileName(strAudioFileName);
    if(strFileName.IsEmpty()) strFileName = ExtractFileName(OpenDialogCue->FileName);
    strFileName = ExtractFileName(strFileName.SubString(1, strFileName.Length() - ExtractFileExt(strFileName).Length()));
    SaveDialogCue->FileName = strFileName;
    if(!SaveDialogCue->Execute()) return;
    strFileName = SaveDialogCue->FileName;
  }

  TMemIniFile* pIniFile = new TMemIniFile(strFileName);

  pIniFile->WriteString("CueListTool", "Version", strVersion);
  pIniFile->WriteString("CueListTool", "Prefix", FormSettings->EditPrefix->Text);
  pIniFile->WriteInteger("CueListTool", "SamplesPerSecond", nCueListSamplesPerSec);

  int iCue;
  for(iCue = 0; iCue < nCues; iCue++)
  {
    String strSection; strSection.sprintf("Cue %d", iCue + 1);

    pIniFile->WriteInteger(strSection, "SampleOffset",           CueArray[iCue].StartSample       );
    pIniFile->WriteInteger(strSection, "NumberOfSamples",        CueArray[iCue].nSamples          );
    pIniFile->WriteString (strSection, "Label",           "\"" + CueArray[iCue].Label       + "\"");
    pIniFile->WriteString (strSection, "Description",     "\"" + CueArray[iCue].Description + "\"");
    pIniFile->WriteString (strSection, "Type",                   CueArray[iCue].Type              );
  }

  pIniFile->UpdateFile();
  delete pIniFile;

  SetDirtyFlag(false);
  SetStatusBarText(IntToStr(iCue) + " Cues have been written to '" + ExtractFileName(strFileName) + "'");
}
//---------------------------------------------------------------------------

void TForm1::SaveAudacityLabels(bool bNonInteractive, String strFileName)
{
  if(nCues == 0) return;

  if(!bNonInteractive)
  {
    strFileName = ExtractFileName(strAudioFileName);
    if(strFileName.IsEmpty()) strFileName = ExtractFileName(OpenDialogCue->FileName);
    strFileName = ExtractFileName(strFileName.SubString(1, strFileName.Length() - ExtractFileExt(strFileName).Length()));
    SaveDialogTxt->FileName = strFileName;
    if(!SaveDialogTxt->Execute()) return;
    strFileName = SaveDialogTxt->FileName;
  }

  FILE *fp;
  // (die Abfrage, ob eine existierende Datei berschrieben werden soll, erfolgt im Save-Dialog)
  while((fp=fopen(strFileName.c_str(), "wt")) == NULL)
  {
    String strTemp;
    strTemp.sprintf("Can't open Audacity Label file '%s' for writing.", strFileName.c_str());
    if(MessageBox(Handle, strTemp.c_str(), "Error", MB_RETRYCANCEL|MB_ICONERROR|MB_APPLMODAL) != IDRETRY) return;
  }

  int iCue;
  for(iCue = 0; iCue < nCues; iCue++)
  {
    Extended fStartTime = (Extended)CueArray[iCue].StartSample / nCueListSamplesPerSec;
    Extended fEndTime = ((Extended)CueArray[iCue].StartSample + (Extended)CueArray[iCue].nSamples) / nCueListSamplesPerSec;

    String strLabel = CueArray[iCue].Label;
//    if (!CueArray[iCue].Description.IsEmpty())
//      strLabel += " (" + CueArray[iCue].Description + ")";

    if(fprintf(fp, "%.6Lf\t%.6Lf\t%s\n", fStartTime, fEndTime, strLabel.c_str()) == EOF)
//    if(fprintf(fp, "%.20Lf\t%.20Lf\t%s\n", fStartTime, fEndTime, strLabel.c_str()) == EOF)
    {
      MessageBox(Handle, ("Error writing to file '" + strFileName + "'.").c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
      break;
    }
  }

  SetDirtyFlag(false);
  SetStatusBarText(IntToStr(iCue) + " Cues have been written to '" + ExtractFileName(strFileName) + "'");
  fclose(fp);
}
//---------------------------------------------------------------------------

void TForm1::SaveCueSheet(bool bNonInteractive, String strCueSheetFileName)
{
  if(nCues == 0) return;

  String strFileTag;

  String strFileExt = ExtractFileExt(strCueSheetCDFileName);
  if(strFileExt != ".wav" && strFileExt != ".wv") strFileExt = ".wav";

  if(bNonInteractive)
  {
    if(strCueSheetFileName.IsEmpty())
      strCueSheetFileName = strCueSheetCDFileName;

    if(strCueSheetFileName.IsEmpty())
    {
      // Wenn kein Dateiname fr das Cue-Sheet ermittelt werden konnte,
      // dann doch den Save-Dialog ffnen:
      bNonInteractive = false;
    }
    else
    {
      strCueSheetFileName = strCueSheetFileName.SubString(1, strCueSheetFileName.Length() - ExtractFileExt(strCueSheetFileName).Length()) + ".cue";
      strCueSheetCDFileName = strCueSheetCDFileName.SubString(1, strCueSheetCDFileName.Length() - ExtractFileExt(strCueSheetCDFileName).Length()) + strFileExt;
      strFileTag = ExtractFileExt(strCueSheetCDFileName).LowerCase() == ".mp3" ? "MP3" : "WAVE";
      SaveDialogCueSheet->FileName = strCueSheetFileName;
    }
  }

  if(!bNonInteractive)
  {
    // Dialog zum Eingeben der Parameter fr das Cue-Sheet initialisieren

    FormSaveCueSheet->CheckBoxAbsolutePath->Checked = bCueSheetAbsolutePath;
    FormSaveCueSheet->CheckBoxIncludeCDText->Checked = bCueSheetIncludeCDText;
  //  FormSaveCueSheet->CheckBoxUseCueLabelsAsTrackTitles->Checked = bCueSheetUseCueLabelsAsTrackTitles;
    FormSaveCueSheet->CheckBoxUseCueNotesAsTrackPerformer->Checked = bCueSheetUseCueNotesAsTrackPerformer;
    FormSaveCueSheet->CheckBoxIfCueNoteEmptyUseAlbumPerformer->Checked = bCueSheetIfCueNoteEmptyUseAlbumPerformer;

    FormSaveCueSheet->CheckBoxInsertGaps->Checked = bCueSheetInsertGaps;
    if(bCueSheetGapIsPreGap)
      FormSaveCueSheet->RadioButtonPreGap->Checked = true;
    else
      FormSaveCueSheet->RadioButtonPostGap->Checked = true;
    FormSaveCueSheet->EditGapTime->Text = strCueSheetGapTime;
    FormSaveCueSheet->CheckBoxGapOnlyExceptForFirstLastTrack->Checked = bCueSheetGapOnlyExceptForFirstLastTrack;
    if(bCueSheetGapOnly)
      FormSaveCueSheet->RadioButtonGapOnly->Checked = true;
    else
      FormSaveCueSheet->RadioButtonGapExcept->Checked = true;
    if(bCueSheetGapFirst)
      FormSaveCueSheet->RadioButtonGapFirst->Checked = true;
    else
      FormSaveCueSheet->RadioButtonGapLast->Checked = true;
    FormSaveCueSheet->CheckBoxAddOffset->Checked = bCueSheetAddOffset;
    FormSaveCueSheet->EditOffsetTime->Text = strCueSheetOffsetTime;
    FormSaveCueSheet->EditIndex0Time->Text = strCueSheetIndex0Time;
    FormSaveCueSheet->CheckBoxIndex0->Checked = bCueSheetIndex0;

    FormSaveCueSheet->SetAudioFileName(strCueSheetCDFileName.SubString(1, strCueSheetCDFileName.Length() - ExtractFileExt(strCueSheetCDFileName).Length()) + strFileExt);
    FormSaveCueSheet->EditPerformer->Text = strCueSheetCDPerformer;
    FormSaveCueSheet->EditTitle->Text = strCueSheetCDTitle;

    if(FormSaveCueSheet->EditGapTime->Text.IsEmpty()) FormSaveCueSheet->EditGapTime->Text = FloatToStr(0);
    if(FormSaveCueSheet->EditOffsetTime->Text.IsEmpty()) FormSaveCueSheet->EditOffsetTime->Text = FloatToStr(0);
    if(FormSaveCueSheet->EditIndex0Time->Text.IsEmpty()) FormSaveCueSheet->EditIndex0Time->Text = FloatToStr(10);

    // Dialog aufrufen
    if(FormSaveCueSheet->ShowModal() != mrOk) return;

    // Parameter aus Dialog holen

    bCueSheetAbsolutePath = FormSaveCueSheet->CheckBoxAbsolutePath->Checked;
    bCueSheetIncludeCDText = FormSaveCueSheet->CheckBoxIncludeCDText->Checked;
  //  bCueSheetUseCueLabelsAsTrackTitles = FormSaveCueSheet->CheckBoxUseCueLabelsAsTrackTitles->Checked;
    bCueSheetUseCueNotesAsTrackPerformer = FormSaveCueSheet->CheckBoxUseCueNotesAsTrackPerformer->Checked;
    bCueSheetIfCueNoteEmptyUseAlbumPerformer = FormSaveCueSheet->CheckBoxIfCueNoteEmptyUseAlbumPerformer->Checked;

    bCueSheetInsertGaps = FormSaveCueSheet->CheckBoxInsertGaps->Checked;
    bCueSheetGapIsPreGap = FormSaveCueSheet->RadioButtonPreGap->Checked;
    strCueSheetGapTime = FormSaveCueSheet->EditGapTime->Text;
    bCueSheetGapOnlyExceptForFirstLastTrack = FormSaveCueSheet->CheckBoxGapOnlyExceptForFirstLastTrack->Checked;
    bCueSheetGapOnly = FormSaveCueSheet->RadioButtonGapOnly->Checked;
    bCueSheetGapFirst = FormSaveCueSheet->RadioButtonGapFirst->Checked;
    bCueSheetAddOffset = FormSaveCueSheet->CheckBoxAddOffset->Checked;
    strCueSheetOffsetTime = FormSaveCueSheet->EditOffsetTime->Text;
    strCueSheetIndex0Time = FormSaveCueSheet->EditIndex0Time->Text;
    bCueSheetIndex0 = FormSaveCueSheet->CheckBoxIndex0->Checked;

    strCueSheetCDFileName = FormSaveCueSheet->GetAudioFileName();
    strCueSheetFileName = strCueSheetCDFileName.SubString(1, strCueSheetCDFileName.Length() - ExtractFileExt(strCueSheetCDFileName).Length());
    strFileTag = FormSaveCueSheet->ComboBoxFileTag->Text;
    strCueSheetCDPerformer = FormSaveCueSheet->EditPerformer->Text.Trim();
    strCueSheetCDTitle = FormSaveCueSheet->EditTitle->Text.Trim();

  //  if(!strCueSheetCDPerformer.IsEmpty() && !strCueSheetCDTitle.IsEmpty()) strCueSheetFileName.sprintf("%s - %s", strCueSheetCDPerformer, strCueSheetCDTitle);
  //  else if(!strCueSheetCDPerformer.IsEmpty()) strCueSheetFileName = strCueSheetCDPerformer;
  //  else if(!strCueSheetCDTitle.IsEmpty()) strCueSheetFileName = strCueSheetCDTitle;

    // Speichern-Dialog aufrufen
    SaveDialogCueSheet->FileName = strCueSheetFileName;
    if(!SaveDialogCueSheet->Execute()) return;
  }

  Extended fGapTime; try { fGapTime = StrToFloat(strCueSheetGapTime); } catch(...) { }
  Extended fOffsetTime; try { fOffsetTime = StrToFloat(strCueSheetOffsetTime); } catch(...) { }
  Extended fIndex0Time; try { fIndex0Time = StrToFloat(strCueSheetIndex0Time); } catch(...) { }

  TStringList* pStringListCueSheet = new TStringList();
  String strTemp;

  pStringListCueSheet->Add("REM Created by CueListTool");

  // CD-Text fr Header
  if(bCueSheetIncludeCDText)
  {
    if(!strCueSheetCDPerformer.IsEmpty()) pStringListCueSheet->Add("PERFORMER \"" + strCueSheetCDPerformer + "\"");
    if(!strCueSheetCDTitle.IsEmpty()) pStringListCueSheet->Add("TITLE \"" + strCueSheetCDTitle + "\"");
  }
  pStringListCueSheet->Add("FILE \"" + (bCueSheetAbsolutePath ? strCueSheetCDFileName : ExtractFileName(strCueSheetCDFileName)) + "\" " + strFileTag);

  int nTrackNr = 0;
  int nIndexNr = 1;

  int nLastIndexCueStringCount = 0;
  int nLastIndexCueStartSample = 0;

  int iCue;     // (wird auch auerhalb der 2. for-Schleife bentigt, darum hier deklariert)

  // Tracks zhlen
  int nTracks = 0;
  for(iCue = 0; iCue < nCues; iCue++)
    if(CueArray[iCue].Type != "indx") nTracks++;

  bool bGap = false;

  // Tracks schreiben
  for(iCue = 0; iCue < nCues; iCue++)
  {
    bool bIndex = (CueArray[iCue].Type == "indx") && iCue != 0;       // Die erste Cue darf kein Index sein!

    if(bIndex)
    {
      nIndexNr++;
    }
    else
    {
      nIndexNr = 1;
      nTrackNr++;

      // POSTGAP *nach* INDEX und *vor* neuem TRACK schreiben
      if(bGap && !bCueSheetGapIsPreGap)
      {
         pStringListCueSheet->Add("    POSTGAP " + FormatTimeCueSheet(fGapTime));
         bGap = false;
      }

      // neuer Track
      strTemp = "";
      strTemp.sprintf("  TRACK %02d AUDIO", nTrackNr);
      pStringListCueSheet->Add(strTemp);

      // CD-Text fr Track
      if(bCueSheetIncludeCDText)
      {
        // (ggf. alle `" durch `' ersetzen!)
        String strTrackTitle = CueArray[iCue].Label;
        if(!strTrackTitle.IsEmpty()) pStringListCueSheet->Add("    TITLE \"" + strTrackTitle + "\"");

        String strTrackPerformer = strCueSheetCDPerformer;
        if(bCueSheetUseCueNotesAsTrackPerformer)
        {
          strTrackPerformer = CueArray[iCue].Description;
          if(strTrackPerformer.IsEmpty() && bCueSheetIfCueNoteEmptyUseAlbumPerformer) strTrackPerformer = strCueSheetCDPerformer;
        }
        if(!strTrackPerformer.IsEmpty()) pStringListCueSheet->Add("    PERFORMER \"" + strTrackPerformer + "\"");
      }

      // Gaps bestimmen
      if(bCueSheetInsertGaps && fGapTime != 0)
      {
        bGap = true;

        if(bCueSheetGapOnlyExceptForFirstLastTrack)
        {
          if(nTrackNr == 1)
          {
            bGap = (bCueSheetGapOnly == bCueSheetGapFirst);
          }
          else if(nTrackNr == nTracks)
          {
            bGap = (bCueSheetGapOnly != bCueSheetGapFirst);
          }
          else
          {
            bGap = (!bCueSheetGapOnly && bCueSheetGapFirst) || (!bCueSheetGapOnly && !bCueSheetGapFirst);
          }
        }
      }

      // PREGAP *vor* INDEX schreiben
      if(bGap && bCueSheetGapIsPreGap)
      {
         pStringListCueSheet->Add("    PREGAP " + FormatTimeCueSheet(fGapTime));
         bGap = false;
      }
    }

    // Neuer Index
    if(nIndexNr == 1)
    {
      if(bCueSheetIndex0 && nLastIndexCueStringCount > 0 && nLastIndexCueStartSample > 0)
      {
        Extended fTimeDelta = (Extended)(CueArray[iCue].StartSample - nLastIndexCueStartSample) / nCueListSamplesPerSec;
        if(fTimeDelta > 0 && fTimeDelta <= fIndex0Time)
        {
          // letzten gemerkten "INDEX nn" an die aktuelle Stelle verschieben
          strTemp = pStringListCueSheet->Strings[nLastIndexCueStringCount];
          pStringListCueSheet->Delete(nLastIndexCueStringCount);
          strTemp.Delete(11, 2);        // aus "    INDEX nn ..." mach "    INDEX 00 ..."
          strTemp.Insert("00", 11);
          pStringListCueSheet->Add(strTemp);
        }
      }
      nLastIndexCueStringCount = 0;
      nLastIndexCueStartSample = 0;
    }
    else
    {
      nLastIndexCueStringCount = pStringListCueSheet->Count;      // Zeile des INDEX im Cue-Sheet merken
      nLastIndexCueStartSample = CueArray[iCue].StartSample;      // Start-Sample des INDEX merken
    }

    strTemp = "";
    strTemp.sprintf("    INDEX %02d %s", nIndexNr, FormatTimeCueSheet((Extended)CueArray[iCue].StartSample / nCueListSamplesPerSec + (bCueSheetAddOffset && fOffsetTime != 0 ? fOffsetTime : 0)).c_str());
    pStringListCueSheet->Add(strTemp);
  }

  // POSTGAP *nach* INDEX und *vor* neuem TRACK schreiben
  if(bGap && !bCueSheetGapIsPreGap)
  {
     pStringListCueSheet->Add("    POSTGAP " + FormatTimeCueSheet(fGapTime));
  }

  pStringListCueSheet->SaveToFile(SaveDialogCueSheet->FileName);
  delete pStringListCueSheet;

  SetDirtyFlag(false);
  SetStatusBarText(IntToStr(iCue) + " Cues have been written to '" + ExtractFileName(SaveDialogCueSheet->FileName) + "'");

  if(FormSaveCueSheet->bSaveAndBurn)
  {
    FormBurn->EditPath->Text = strBurnApplPath;
    FormBurn->EditArguments->Text = strBurnApplArguments;
    if(FormBurn->ShowModal() != IDOK) return;
    strBurnApplPath = FormBurn->EditPath->Text;
    strBurnApplArguments = FormBurn->EditArguments->Text;
    String strTemp;
    strTemp.sprintf(strBurnApplArguments.c_str(), SaveDialogCueSheet->FileName.c_str());
    ShellExecute(Handle, "open", strBurnApplPath.c_str(), strTemp.c_str(), NULL, SW_SHOWNORMAL);
  }
}
//---------------------------------------------------------------------------

void TForm1::RemoveNewLine(char *pszLine)
{
  if(strlen(pszLine)>0) if(pszLine[strlen(pszLine)-1]=='\n') pszLine[strlen(pszLine)-1]=0;
}

void TForm1::LoadCueListFile(String strFileName)
{
  String strCueListFilePrefix = "";
  static String strSaveCueListFilePrefix = FormSettings->EditPrefix->Text;
  int nSampleRate;

  OpenDialogCue->FileName = strFileName;
  if(strFileName == "") if(!OpenDialogCue->Execute()) return;

  // Evtl. vorgenommene nderungen verwerfen?
  if(!DiscardChanges()) return;

  // for new CLT format
  TIniFile* pIniFile = new TIniFile(OpenDialogCue->FileName);

  // for old CLT format
  FILE *fp = NULL;
  char szLine[256];

  // try to read new CLT format
  String strIniVersion = pIniFile->ReadString("CueListTool", "Version", "");
  if (!strIniVersion.IsEmpty())
  {
    // file has new CLT format
    strCueListFilePrefix = pIniFile->ReadString("CueListTool", "Prefix", "").TrimLeft();
    nSampleRate = pIniFile->ReadInteger("CueListTool", "SamplesPerSecond", 0);
  }
  else
  {
    // try to read old CLT format
    while((fp = fopen(OpenDialogCue->FileName.c_str(), "rt")) == NULL)
    {
      String strTemp;
      strTemp.sprintf("Can't open Cue List file '%s' for reading.", OpenDialogCue->FileName.c_str());
      if(MessageBox(Handle, strTemp.c_str(), "Error", MB_RETRYCANCEL|MB_ICONERROR|MB_APPLMODAL) != IDRETRY) return;
    }

    fgets(szLine, sizeof(szLine), fp);
    if(strncmp(szLine + 1, " CueListTool 1.3 file", 21) != 0)
    {
      fclose(fp);
      MessageBox(Handle, "Invalid Cue List file.", "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
      return;
    }

    fgets(szLine, sizeof(szLine), fp);
    RemoveNewLine(szLine);
    if(strncmp(szLine, "Prefix=", 7)==0)
    {
      strCueListFilePrefix = szLine + 7;
      fgets(szLine, sizeof(szLine), fp);
    }

    sscanf(szLine, "%d", &nSampleRate);
  }

  if(nSampleRate <= 0)
  {
    if(fp != NULL) fclose(fp);
    MessageBox(Handle, "Invalid Cue List file.", "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
    return;
  }

  bool bBreak = false;
  while(FormSettings->CheckBoxEnablePrefixes->Checked && strCueListFilePrefix == "" && !bBreak)
  {
    switch(MessageBox(Handle,
      "You have chosen to use prefixes in the Preferences\n"
      "menu, but this Cue List file has no owner prefix.\n"
      "Do you wish to enter a prefix for this Cue List file?",
      "CueListTool", MB_YESNOCANCEL|MB_ICONQUESTION|MB_APPLMODAL))
    {
      case IDYES:
        FormPrefix->EditPrefix->Text = strSaveCueListFilePrefix;
        if(FormPrefix->ShowModal() != mrOk)
        {
          if(fp != NULL) fclose(fp);
          return;
        }
        strCueListFilePrefix = FormPrefix->EditPrefix->Text;
        strSaveCueListFilePrefix = strCueListFilePrefix;
        break;

      case IDNO:
        bBreak = true;
        break;

      case IDCANCEL:
        if(fp != NULL) fclose(fp);
        return;
    }
  }

  int iCue = 0;
  if(fp == NULL)
  {
    // new CLT format
    TStringList *pLstStrSections = new TStringList;
    pIniFile->ReadSections(pLstStrSections);
    for (int i = 0; i < pLstStrSections->Count; i++)
    {
      String strSection = pLstStrSections->Strings[i];
      if(strSection.SubString(1, 4) == "Cue ")
      {
        if(!VerifyCueIndex(iCue)) break;

        CueArray[iCue].StartSample = pIniFile->ReadInteger(strSection, "SampleOffset", 0);
        CueArray[iCue].nSamples    = pIniFile->ReadInteger(strSection, "NumberOfSamples", 0);
        CueArray[iCue].Label       = pIniFile->ReadString (strSection, "Label", "");
        CueArray[iCue].Description = pIniFile->ReadString (strSection, "Description", "");
        CueArray[iCue].Type        = pIniFile->ReadString (strSection, "Type", "rgn");

        if(FormSettings->CheckBoxEnablePrefixes->Checked && strCueListFilePrefix != "" && CueArray[iCue].Label.SubString(1, 1) != "<")
          CueArray[iCue].Label = "<" + strCueListFilePrefix + "> " + CueArray[iCue].Label;

        if(!CueExists(iCue)) iCue++;  // Duplikate vermeiden
      }
    }
    delete pLstStrSections;
  }
  else
  {
    // old CLT format
    while(fgets(szLine, sizeof(szLine), fp) != NULL)
    {
      if(!VerifyCueIndex(iCue)) break;

      RemoveNewLine(szLine);
      if(sscanf(szLine, "%d", &CueArray[iCue].StartSample) != 1) CueArray[iCue].StartSample = 0;

      if(fgets(szLine, sizeof(szLine), fp) == NULL) break;
      RemoveNewLine(szLine);
      if(sscanf(szLine, "%d", &CueArray[iCue].nSamples) != 1) CueArray[iCue].nSamples = 0;

      if(fgets(szLine, sizeof(szLine), fp) == NULL) break;
      RemoveNewLine(szLine);
      CueArray[iCue].Label = "";
      if(FormSettings->CheckBoxEnablePrefixes->Checked && strCueListFilePrefix != "")
        if(szLine[0] != '<') CueArray[iCue].Label = "<" + strCueListFilePrefix + "> ";
      CueArray[iCue].Label += szLine;

      if(fgets(szLine, sizeof(szLine), fp) == NULL) break;
      RemoveNewLine(szLine);
      CueArray[iCue].Description = szLine;

      if(fgets(szLine, sizeof(szLine), fp) == NULL) break;
      RemoveNewLine(szLine);
      CueArray[iCue].Type = szLine;
      if(CueArray[iCue].Type.IsEmpty()) CueArray[iCue].Type = "rgn";

      if(!CueExists(iCue)) iCue++;  // Duplikate vermeiden
    }
    fclose(fp);
  }

  strCueSheetCDFileName = OpenDialogCue->FileName;
  SetCDPerformerAndTitleFromCDFileName();

  nCues = iCue;
  SortCueArray();
  nCueListSamplesPerSec = nSampleRate;
  SetStatusBarText(IntToStr(nCues) + " Cues have been loaded from '" + ExtractFileName(OpenDialogCue->FileName) + "'");
  Display();
}
//---------------------------------------------------------------------------

void TForm1::LoadCueSheet(String strFileName)
{
  OpenDialogCueSheet->FileName = strFileName;
  if(strFileName == "") if(!OpenDialogCueSheet->Execute()) return;

  // Evtl. vorgenommene nderungen verwerfen?
  if(!DiscardChanges()) return;

  int nSampleRateCues = DEFAULT_SAMPLERATE;

  // Cue-Sheet zum Lesen ffnen

  FILE *fp;
  while((fp = fopen(OpenDialogCueSheet->FileName.c_str(), "rt")) == NULL)
  {
    String strTemp;
    strTemp.sprintf("Can't open Cue Sheet '%s' for reading.", OpenDialogCueSheet->FileName.c_str());
    if(MessageBox(Handle, strTemp.c_str(), "Error", MB_RETRYCANCEL|MB_ICONERROR|MB_APPLMODAL) != IDRETRY) return;
  }

  // Cue-Sheet zeilenweise lesen und parsen

  String strLine, strToken, strTemp;
  String strCDFileName, strCDPerformer, strCDTitle;
  int iCue = 0, nLine = 0, nErrorLine = 0, nLastTrackCue = -1;
  bool bTrackExists = false, bFileExists = false;
  int nSamplesFile = 0, nSamplesRateFile = 0;
  bool bFileDataOK = false;
  hyper nOffsetSamples = 0;

  char szLine[256];
  while(fgets(szLine, sizeof(szLine), fp) != NULL)
  {
    nLine++;

    RemoveNewLine(szLine);
    strLine = szLine;
    strLine = strLine.Trim();

    // TRACK: Neuer Track
    strToken = "TRACK";
    if(strLine.UpperCase().SubString(1, strToken.Length()) == strToken)
    {
      if(bTrackExists)  // Wenn bereits Tracks existieren, dann Index auf nchsten Track!
      {
        if(!CueExists(iCue)) iCue++;  // Duplikate vermeiden
      }

      if(!VerifyCueIndex(iCue))
      {
        iCue--;
        break;
      }

      // Neue Cue initialisieren
      CueArray[iCue].StartSample = 0;
      CueArray[iCue].nSamples = 0;
      CueArray[iCue].Label = "", CueArray[iCue].Label.sprintf("Track %02d", iCue + 1);   // Track-Titel
      CueArray[iCue].Description = strCDPerformer;                                 // Track-Performer
      CueArray[iCue].Type = "trak";

      bTrackExists = true;
      continue;
    }

    // PERFORMER: wenn noch kein TRACK, dann merken als "CD Performer", sonst merken als "Track Performer"
    strToken = "PERFORMER";
    if(strLine.UpperCase().SubString(1, strToken.Length()) == strToken)
    {
      strTemp = strLine.SubString(strToken.Length() + 1, strLine.Length() - strToken.Length());
      strTemp = StringReplace(strTemp, "\"", "", TReplaceFlags() << rfReplaceAll).Trim();
      if(bTrackExists)
        CueArray[iCue].Description = strTemp;
      else
        strCDPerformer = strTemp;
      continue;
    }

    // TITLE: wenn noch kein TRACK, dann merken als "CD Title", sonst merken als "Track Title"
    strToken = "TITLE";
    if(strLine.UpperCase().SubString(1, strToken.Length()) == strToken)
    {
      strTemp = strLine.SubString(strToken.Length() + 1, strLine.Length() - strToken.Length());
      strTemp = StringReplace(strTemp, "\"", "", TReplaceFlags() << rfReplaceAll).Trim();
      if(bTrackExists)
        CueArray[iCue].Label = strTemp;
      else
        strCDTitle = strTemp;
      continue;
    }

    // FILE
    strToken = "FILE";
    if(strLine.UpperCase().SubString(1, strToken.Length()) == strToken)
    {
      int nPos1 = strLine.Pos("\"");
      if(nPos1 == 0 || nPos1 == strLine.Length())
      {
        nErrorLine = nLine;
        break;
      }
      nPos1++;
      int nPos2 = strLine.SubString(nPos1, strLine.Length() - nPos1 + 1).Pos("\"");
      if(nPos2 == 0)
      {
        nErrorLine = nLine;
        break;
      }
      nPos2--;
      strTemp = strLine.SubString(nPos1, nPos2);
      if(bFileExists)
      {
        if(bFileDataOK)
        {
          // Lnge der letzten Datei zum Offset fr die folgenden Zeitangaben addieren
          nOffsetSamples += ((hyper)nSamplesFile * nSampleRateCues) / nSamplesRateFile;
          bFileDataOK = GetWavFileData(strTemp, nSamplesFile, nSamplesRateFile);
        }
        if(!bFileDataOK)
        {
          MessageBox(Handle,
            "Cue Sheet must not contain more than 1 audio file,\n"
            "or all audio files must exist and be readable and valid!",
            "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
          nErrorLine = -1;
          break;
        }
      }
      else
      {
        strCDFileName = strTemp;
        bFileExists = true;
        bFileDataOK = GetWavFileData(strTemp, nSamplesFile, nSamplesRateFile);
        if(bFileDataOK) nSampleRateCues = nSamplesRateFile;
      }
      continue;
    }

    // INDEX 01: Neue Track-Cue
    strToken = "INDEX 01";
    if(strLine.UpperCase().SubString(1, strToken.Length()) == strToken)
    {
      strTemp = strLine.SubString(strToken.Length() + 1, strLine.Length() - strToken.Length()).Trim();
      int nFrames = CueSheetTimeStringToFrames(strTemp);
      if(nFrames == -1)
      {
        nErrorLine = nLine;
        break;
      }
      CueArray[iCue].StartSample = (int)(nOffsetSamples + (hyper)nFrames * nSampleRateCues / 75); // ggf. Rundungsfehler!

      // Anzahl Samples des letzten Track-Indexes berechnen
      if(nLastTrackCue != -1) CueArray[nLastTrackCue].nSamples = CueArray[iCue].StartSample - CueArray[nLastTrackCue].StartSample;
      nLastTrackCue = iCue;
      continue;
    }

    // INDEX 00: Neue Index-Cue
    strToken = "INDEX 00";
    if(strLine.UpperCase().SubString(1, strToken.Length()) == strToken)
    {
      strTemp = strLine.SubString(strToken.Length() + 1, strLine.Length() - strToken.Length()).Trim();
      int nFrames = CueSheetTimeStringToFrames(strTemp);
      if(nFrames == -1)
      {
        nErrorLine = nLine;
        break;
      }

      if(!CueExists(iCue)) iCue++;  // Duplikate vermeiden

      if(!VerifyCueIndex(iCue))
      {
        iCue--;
        break;
      }

      // Letzte Cue um eins nach hinten schieben, um Platz fr die Index-Cue zu bekommen
      CueArray[iCue].StartSample = CueArray[iCue - 1].StartSample;
      CueArray[iCue].nSamples = CueArray[iCue - 1].nSamples;
      CueArray[iCue].Label = CueArray[iCue - 1].Label;
      CueArray[iCue].Description = CueArray[iCue - 1].Description;
      CueArray[iCue].Type = CueArray[iCue - 1].Type;

      // Neue Cue initialisieren
      CueArray[iCue - 1].StartSample = (int)(nOffsetSamples + (hyper)nFrames * nSampleRateCues / 75); // ggf. Rundungsfehler!
      CueArray[iCue - 1].nSamples = 0;
      CueArray[iCue - 1].Label = "Track index";
      CueArray[iCue - 1].Description = "";
      CueArray[iCue - 1].Type = "indx";
      continue;
    }

    // INDEX 02...n: Neue Index-Cue
    strToken = "INDEX";
    if(strLine.UpperCase().SubString(1, strToken.Length()) == strToken)
    {
      strTemp = strLine.SubString(strToken.Length() + 3 + 1, strLine.Length() - strToken.Length() - 3).Trim();
      int nFrames = CueSheetTimeStringToFrames(strTemp);
      if(nFrames == -1)
      {
        nErrorLine = nLine;
        break;
      }

      if(!CueExists(iCue)) iCue++;  // Duplikate vermeiden

      if(!VerifyCueIndex(iCue))
      {
        iCue--;
        break;
      }

      // Neue Cue initialisieren
      CueArray[iCue].StartSample = (int)(nOffsetSamples + (hyper)nFrames * nSampleRateCues / 75); // ggf. Rundungsfehler!
      CueArray[iCue].nSamples = 0;
      CueArray[iCue].Label = "Track index";
      CueArray[iCue].Description = "";
      CueArray[iCue].Type = "indx";
      continue;
    }
  }
  fclose(fp);

  if(nErrorLine == 0)
  {
    if(bTrackExists)
    {
      if(bFileDataOK)
      {
        // Lnge der letzten Datei zum Offset fr die folgenden Zeitangaben addieren
        nOffsetSamples += ((hyper)nSamplesFile * nSampleRateCues) / nSamplesRateFile;

        // Anzahl Samples des letzten Track-Indexes berechnen
//        CueArray[iCue].nSamples = (int)nOffsetSamples - CueArray[iCue].StartSample; <- Bug!
        if(nLastTrackCue != -1) CueArray[nLastTrackCue].nSamples = (int)nOffsetSamples - CueArray[nLastTrackCue].StartSample;

      }
      else
      {
        // Alle Sample-Lngen wieder auf 0 setzen, da ohne Audio-Datei die Lnge des letzten Tracks
        // sowieso nicht berechnet werden kann (wenn schon Track-Lngen, dann auch fr alle Tracks!)
        for(int i = 0; i <= iCue; i++)    // (iCue zeigt noch auf die letzte Cue im Array)
          CueArray[i].nSamples = 0;
      }

      // Korrektur: Index + 1 = Anzahl Cues
      if(!CueExists(iCue)) iCue++; // Duplikate vermeiden

      nCueListSamplesPerSec = nSampleRateCues;
    }
    strCueSheetCDFileName = OpenDialogCueSheet->FileName;
    SetCDPerformerAndTitleFromCDFileName();
    if(!strCDFileName.IsEmpty()) strCueSheetCDFileName = strCDFileName;
    if(!strCDPerformer.IsEmpty()) strCueSheetCDPerformer = strCDPerformer;
    if(!strCDTitle.IsEmpty()) strCueSheetCDTitle = strCDTitle;
  }
  else
  {
    if(nErrorLine != -1)
    {
      String strTemp;
      strTemp.sprintf("Syntax error in line %d of Cue Sheet\n'%s'!", nErrorLine, OpenDialogCueSheet->FileName.c_str());
      MessageBox(Handle, strTemp.c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
    }
    iCue = 0;
  }

  nCues = iCue;
  SortCueArray();
  SetStatusBarText(IntToStr(nCues) + " Cues have been loaded from '" + ExtractFileName(OpenDialogCueSheet->FileName) + "'");
  Display();
}
//---------------------------------------------------------------------------

void TForm1::LoadAudacityLabels(String strFileName)
{
  OpenDialogTxt->FileName = strFileName;
  if(strFileName == "") if(!OpenDialogTxt->Execute()) return;

  // Evtl. vorgenommene nderungen verwerfen?
  if(!DiscardChanges()) return;

  int nSampleRateCues = DEFAULT_SAMPLERATE;

  // Textdatei zum Lesen ffnen

  FILE *fp;
  while((fp = fopen(OpenDialogTxt->FileName.c_str(), "rt")) == NULL)
  {
    String strTemp;
    strTemp.sprintf("Can't open Audacity Labels file '%s' for reading.", OpenDialogTxt->FileName.c_str());
    if(MessageBox(Handle, strTemp.c_str(), "Error", MB_RETRYCANCEL|MB_ICONERROR|MB_APPLMODAL) != IDRETRY) return;
  }

  // Textdatei zeilenweise lesen und parsen

  int iCue = 0, nLine = 0;
  char szLine[256];
  while(fgets(szLine, sizeof(szLine), fp) != NULL)
  {
    nLine++;
    if(!isdigit(szLine[0])) continue; // ignore lines which don't start with a decimal number
    if(!VerifyCueIndex(iCue)) break;

    //RemoveNewLine(szLine);

    char* szStart = new char[strlen(szLine) + 1]; strcpy(szStart, "");
    char* szEnd   = new char[strlen(szLine) + 1]; strcpy(szEnd, "");
    char* szLabel = new char[strlen(szLine) + 1]; strcpy(szLabel, "");

    //int n = sscanf(szLine, "%s %s %s", szStart, szEnd, szLabel);
    int n = sscanf(szLine, "%s %s %[^\n]%*c", szStart, szEnd, szLabel);

    DecimalSeparator = '.'; // VCL-globale Variable fr StrToFloat()
    Extended fStart; try { fStart = StrToFloat(szStart); } catch(...) { fStart = -1; }
    Extended fEnd;   try { fEnd   = StrToFloat(szEnd); }   catch(...) { fEnd = -1; }

    String strLabel = Utf8ToAnsi(szLabel);
    if (strLabel.IsEmpty()) strLabel = szLabel;
    if (strLabel.IsEmpty()) strLabel.sprintf("Cue %d", iCue + 1);

    delete[] szStart;
    delete[] szEnd;
    delete[] szLabel;

    if (n < 2 || fStart < 0.0 || fEnd < fStart)
    {
      fclose(fp);
      String strTemp;
      strTemp.sprintf("Error in line %d of Audacity Labels file.", nLine);
      MessageBox(Handle, strTemp.c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
      return;
    }

    // Neue Cue initialisieren
    CueArray[iCue].StartSample = fStart * nSampleRateCues + 0.5;
    CueArray[iCue].nSamples = (fEnd - fStart) * nSampleRateCues + 0.5;
    CueArray[iCue].Label = strLabel;
    CueArray[iCue].Description = "";
    CueArray[iCue].Type = "trak";

    iCue++;
  }
  fclose(fp);

  nCues = iCue;
  nCueListSamplesPerSec = nSampleRateCues;

  SortCueArray();
  SetStatusBarText(IntToStr(nCues) + " Cues have been loaded from '" + ExtractFileName(OpenDialogTxt->FileName) + "'");
  Display();
}
//---------------------------------------------------------------------------

bool TForm1::GetWavFileData(String strFileName, int& nSamples, int& nSamplesPerSec)
{
  bool nSuccess = false;
  FILE *fp;
  bool bFileOpen = false;
  MMCKINFO RiffChunkInfo; // RIFF-Chunk
  MMCKINFO FormatChunkInfo; // Format-Subchunk (Wave-Parameter)
  MMCKINFO DataChunkInfo; // Data-Subchunk (Wave-Audio-Daten)
  WAVEFORMATEX WaveFmt;

  nSamples = 0;
  nSamplesPerSec = 0;

  do
  {
    fp = fopen(strFileName.c_str(), "rb");
    if(fp == NULL) break;
    bFileOpen = true;

    // Find the RIFF chunk.
    memset(&RiffChunkInfo, 0, sizeof(MMCKINFO));
    RiffChunkInfo.ckid = StringToFOURCC("RIFF");
    if(FindChunk(fp, &RiffChunkInfo, NULL)) break;

    // Descend into the format chunk.
    memset(&FormatChunkInfo, 0, sizeof(MMCKINFO));
    FormatChunkInfo.ckid = StringToFOURCC("fmt");
    if(FindChunk(fp, &FormatChunkInfo, &RiffChunkInfo)) break;

    // Read the wave format.
    memset(&WaveFmt, 0, sizeof(WAVEFORMATEX));
    int nBytesToRead = sizeof(WAVEFORMATEX) < FormatChunkInfo.cksize ? sizeof(WAVEFORMATEX) : FormatChunkInfo.cksize;
    fread((char*)&WaveFmt, 1, nBytesToRead, fp);
    if(WaveFmt.wFormatTag != WAVE_FORMAT_PCM && WaveFmt.wFormatTag != WAVE_FORMAT_IEEE_FLOAT) break;

    // Ascend out of the format chunk.
    if(SeekBehindChunk(fp, &FormatChunkInfo)) break;

    // Descend into the data chunk.
    memset(&DataChunkInfo, 0, sizeof(MMCKINFO));
    DataChunkInfo.ckid = StringToFOURCC("data");
    if(FindChunk(fp, &DataChunkInfo, &RiffChunkInfo)) break;

    int nBytesPerSample = (WaveFmt.wBitsPerSample / 8) * WaveFmt.nChannels;
    if(nBytesPerSample > 0) nSamples = DataChunkInfo.cksize / nBytesPerSample;
    nSamplesPerSec = WaveFmt.nSamplesPerSec;

    nSuccess = (nSamples > 0 && nSamplesPerSec > 0);
  }
  while(false);

  if(bFileOpen) fclose(fp);;

  return nSuccess;
}
//---------------------------------------------------------------------------

bool TForm1::VerifyCueIndex(int iCue)
{
  bool bOK = true;

  if(iCue >= nMaxCues)
  {
    String strTemp;
    strTemp.sprintf("Maximum number of Cues (%d) reached - can't proceed!", nMaxCues);
    MessageBox(Handle, strTemp.c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
    bOK = false;
  }
  return bOK;
}
//---------------------------------------------------------------------------

int TForm1::CueSheetTimeStringToFrames(String strTimeString)
{
  int nFrames = -1;

  String strTemp = StringReplace(strTimeString, ":", " ", TReplaceFlags() << rfReplaceAll);

  char *szMin = new char[strTemp.Length() + 1];
  char *szSec = new char[strTemp.Length() + 1];
  char *szFrm = new char[strTemp.Length() + 1];

  int nAnzahl = sscanf(strTemp.c_str(), "%s %s %s", szMin, szSec, szFrm);

  int nMin = 0, nSec = 0, nFrm = 0;

  do
  {
    if(nAnzahl >= 3)
    {
      try { nMin = StrToInt(szMin); }
      catch(...) { break; }
    }
    if(nAnzahl >= 2)
    {
      try { nSec = StrToInt(szSec); }
      catch(...) { break; }
    }
    if(nAnzahl >= 1)
    {
      try { nFrm = StrToInt(szFrm); }
      catch(...) { break; }
    }
    nFrames = nFrm + nSec * 75 + nMin * 60 * 75;
  }
  while(false);

  delete[] szMin;
  delete[] szSec;
  delete[] szFrm;

  return nFrames;
}
//---------------------------------------------------------------------------

void TForm1::Help()
{
  String strManFileName = ExtractFilePath(Application->ExeName) + "manual.chm";
  ShellExecute(Handle, "open", strManFileName.c_str(), NULL, NULL, SW_SHOWNORMAL);
}
//---------------------------------------------------------------------------

void TForm1::GotoWebsite()
{
  ShellExecute(Handle, "open", "http://www.StefanBion.de/cueltool/", NULL, NULL, SW_SHOWNORMAL);
}
//---------------------------------------------------------------------------

void TForm1::GenerateCues()
{
  // Evtl. vorgenommene nderungen verwerfen?
  if(!DiscardChanges()) return;

  FormGenCues->nSamples = 0;
  FormGenCues->nSamplesPerSec = 0;

  int nFileSamplesPerSec = 0;

  // Sample-Parameter einer evtl. ausgewhlten WAV-Datei ermitteln und an Dialog-Klasse bergeben
  if(bAudioFileIsValid)
  {
    FormGenCues->nSamples = nAudioFileSamples;
    FormGenCues->nSamplesPerSec = nAudioFileSamplesPerSec;
  }

  // Dialog aufrufen
  if(FormGenCues->ShowModal() != mrOk) return;

  // Error-Flag - wird gesetzt, wenn ein Fehler auftritt
  bool bError = false;

  // Daten aus Dialog holen
  Extended fDistance; try { fDistance = StrToFloat(FormGenCues->EditDistance->Text); } catch(...) { bError = true; }
  Extended fFirstCue; try { fFirstCue = StrToFloat(FormGenCues->EditFirstCue->Text); } catch(...) { bError = true; }
  bool bNumberNotEndTime = FormGenCues->RadioButtonHowManyCues->Checked;
  int nHowManyCues = 0; if(bNumberNotEndTime) try { nHowManyCues = StrToInt(FormGenCues->EditHowManyCues->Text); } catch(...) { bError = true; }
  Extended fLastCueAt = 0; if(!bNumberNotEndTime) try { fLastCueAt = StrToFloat(FormGenCues->EditLastCueAt->Text); } catch(...) { bError = true; }
  String strCueLabels = FormGenCues->EditCueLabels->Text;
  int nStartNumber = 0; try { nStartNumber = StrToInt(FormGenCues->EditStartNumber->Text); } catch(...) { bError = true; }
  String strCueType = FormGenCues->ComboBoxCueType->Text;

  // Cue-Typ
  strCueType = CueStringToType(strCueType);

  // Sample-Rate
  if(nCueListSamplesPerSec == 0) nCueListSamplesPerSec = nFileSamplesPerSec;
  if(nCueListSamplesPerSec == 0) nCueListSamplesPerSec = DEFAULT_SAMPLERATE;
  if(nFileSamplesPerSec == 0) nFileSamplesPerSec = nCueListSamplesPerSec;

  // Zeiten umrechnen in Samples
  int nSamplesDistance = fDistance * nFileSamplesPerSec; if(nSamplesDistance == 0) bError = true;
  int nSamplesFirstCue = fFirstCue * nFileSamplesPerSec;
  int nSamplesLastCue = fLastCueAt * nFileSamplesPerSec;

  // Falls ausgewhlt, Ende-Zeit in Anzahl Cues umrechnen
  if(!bNumberNotEndTime)
  {
    if(nSamplesFirstCue + (FormGenCues->RadioButtonRanges->Checked ? 1 : 0) * nSamplesDistance > nSamplesLastCue) bError = true;
    else nHowManyCues = (nSamplesLastCue - nSamplesFirstCue - (FormGenCues->RadioButtonRanges->Checked ? 1 : 0) * nSamplesDistance) / nSamplesDistance + 1;
  }

  // Anzahl Cues darf nicht 0 sein
  if(nHowManyCues == 0) bError = true;

  // Falls bisher Fehler aufgetreten sind, Meldung ausgeben und tsch:
  if(bError)
  {
    MessageBox(Handle, "Invalid number(s) entered in dialog.", "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
    return;
  }

  // Alte Cues "berschreiben":
  nCues = 0;    // Wenn die Autocues hinzukommen sollen, einfach diese Zeile auskommentieren!

  // Nun endlich die Cues erzeugen:
  int iCue;
  for(iCue = 0; iCue < nHowManyCues && VerifyCueIndex(nCues + iCue); iCue++)
  {
    String strLabel;
    strLabel.sprintf(strCueLabels.c_str(), iCue + nStartNumber);

    int nCueStartSample = nSamplesFirstCue + iCue * nSamplesDistance;

    if(nFileSamplesPerSec != nCueListSamplesPerSec)
      nCueStartSample = (int)((hyper)nCueStartSample * nCueListSamplesPerSec / nFileSamplesPerSec);

    int nCueSamples = 0;
    if(FormGenCues->RadioButtonRanges->Checked)
    {
      nCueSamples = nSamplesDistance;

      if(nFileSamplesPerSec != nCueListSamplesPerSec)
        nCueSamples = (int)((hyper)nCueSamples * nCueListSamplesPerSec / nFileSamplesPerSec);
    }

    CueArray[nCues + iCue].StartSample = nCueStartSample;
    CueArray[nCues + iCue].nSamples = nCueSamples;
    CueArray[nCues + iCue].Label = strLabel;
    CueArray[nCues + iCue].Description = "";
    CueArray[nCues + iCue].Type = strCueType;
  }

  nCues += iCue;
  SortCueArray();
  SetStatusBarText(IntToStr(iCue) + " Cues have been generated");
  Display();
}
//---------------------------------------------------------------------------

void TForm1::AddTimeOffsetToAllCues()
{
  if(nCues == 0) return;

  int Offset = 0;

  if(FormOffset->ShowModal() != mrOk) return;

  if(FormOffset->RadioGroupOffset->ItemIndex == 1)
  {
    Offset = StrToInt(FormOffset->EditOffset->Text);
  }
  else
  {
    Extended TimeOffset = StrToFloat(FormOffset->EditOffset->Text);
    if(TimeOffset != 0) Offset = TimeOffset * nCueListSamplesPerSec;
  }

  if(Offset == 0) return;

  for(int iCue = 0; iCue < nCues; iCue++)
  {
    CueArray[iCue].StartSample += Offset;
  }

  SetStatusBarText("Offset of " + IntToStr(Offset) + " samples has been added to " + IntToStr(nCues) + " Cues");
  Display();
}
//---------------------------------------------------------------------------

void TForm1::SetCDPerformerAndTitleFromCDFileName()
{
  String strFileName = ExtractFileName(strCueSheetCDFileName.SubString(1, strCueSheetCDFileName.Length() - ExtractFileExt(strCueSheetCDFileName).Length()));

  if(!strFileName.IsEmpty())
  {
    int nPos = strFileName.Pos("-");
    if(nPos != 0)
    {
      strCueSheetCDTitle = strFileName.SubString(nPos + 1, strFileName.Length() - nPos).Trim();
      strCueSheetCDPerformer = strFileName.SubString(1, nPos - 1).Trim();
    }
    else
    {
      strCueSheetCDTitle = strFileName;
      strCueSheetCDPerformer = "";
    }
  }
}
//---------------------------------------------------------------------------

void TForm1::DefineDisplayFormat()
{
  FormDisplayFormat->EditFormatPoints->Text = strFormatPoints;
  FormDisplayFormat->EditFormatRanges->Text = strFormatRanges;
  FormDisplayFormat->EditFormatTime->Text = strFormatTime;
  FormDisplayFormat->EditSeparator->Text = strFormatSeparator;
  FormDisplayFormat->EditFormatHeader->Text = strFormatHeader;
  FormDisplayFormat->EditFormatSummary->Text = strFormatSummary;
  FormDisplayFormat->CheckBoxHeader->Checked = bFormatHeaderEnabled;
  FormDisplayFormat->CheckBoxSummary->Checked = bFormatSummaryEnabled;
  FormDisplayFormat->CSpinEditLeadingDigitsHrs->Value = nFormatTimeLeadingDigitsHrs;
  FormDisplayFormat->CSpinEditFractionalDigitsHrs->Value = nFormatTimeFractionalDigitsHrs;
  FormDisplayFormat->CSpinEditLeadingDigitsMin->Value = nFormatTimeLeadingDigitsMin;
  FormDisplayFormat->CSpinEditFractionalDigitsMin->Value = nFormatTimeFractionalDigitsMin;
  FormDisplayFormat->CSpinEditLeadingDigitsSec->Value = nFormatTimeLeadingDigitsSec;
  FormDisplayFormat->CSpinEditFractionalDigitsSec->Value = nFormatTimeFractionalDigitsSec;
  FormDisplayFormat->CSpinEditLeadingDigitsFrm->Value = nFormatTimeLeadingDigitsFrm;
  FormDisplayFormat->CSpinEditFractionalDigitsFrm->Value = nFormatTimeFractionalDigitsFrm;
  FormDisplayFormat->CSpinEditLeadingDigitsSmp->Value = nFormatTimeLeadingDigitsSmp;
  FormDisplayFormat->CSpinEditFractionalDigitsSmp->Value = nFormatTimeFractionalDigitsSmp;

  if(FormDisplayFormat->ShowModal() != mrOk) return;

  strFormatPoints = FormDisplayFormat->EditFormatPoints->Text;
  strFormatRanges = FormDisplayFormat->EditFormatRanges->Text;
  strFormatTime = FormDisplayFormat->EditFormatTime->Text;
  strFormatSeparator = FormDisplayFormat->EditSeparator->Text;
  strFormatHeader = FormDisplayFormat->EditFormatHeader->Text;
  strFormatSummary = FormDisplayFormat->EditFormatSummary->Text;
  bFormatHeaderEnabled = FormDisplayFormat->CheckBoxHeader->Checked;
  bFormatSummaryEnabled = FormDisplayFormat->CheckBoxSummary->Checked;
  nFormatTimeLeadingDigitsHrs = FormDisplayFormat->CSpinEditLeadingDigitsHrs->Value;
  nFormatTimeFractionalDigitsHrs = FormDisplayFormat->CSpinEditFractionalDigitsHrs->Value;
  nFormatTimeLeadingDigitsMin = FormDisplayFormat->CSpinEditLeadingDigitsMin->Value;
  nFormatTimeFractionalDigitsMin = FormDisplayFormat->CSpinEditFractionalDigitsMin->Value;
  nFormatTimeLeadingDigitsSec = FormDisplayFormat->CSpinEditLeadingDigitsSec->Value;
  nFormatTimeFractionalDigitsSec = FormDisplayFormat->CSpinEditFractionalDigitsSec->Value;
  nFormatTimeLeadingDigitsFrm = FormDisplayFormat->CSpinEditLeadingDigitsFrm->Value;
  nFormatTimeFractionalDigitsFrm = FormDisplayFormat->CSpinEditFractionalDigitsFrm->Value;
  nFormatTimeLeadingDigitsSmp = FormDisplayFormat->CSpinEditLeadingDigitsSmp->Value;
  nFormatTimeFractionalDigitsSmp = FormDisplayFormat->CSpinEditFractionalDigitsSmp->Value;

  Display();
}
//---------------------------------------------------------------------------

bool TForm1::SelectDisplayFormat(String strDisplayFormat)
{
  for(int iDisplayFormat = 0; iDisplayFormat < Form1->nNumberDisplayFormats; iDisplayFormat++)
  {
    if(DisplayFormat[iDisplayFormat].strName == strDisplayFormat)
    {
      SelectDisplayFormat(iDisplayFormat);
      return true;
    }
  }
  return false;
}
//---------------------------------------------------------------------------

void TForm1::SelectDisplayFormat(int iDisplayFormat)
{
  strFormatPoints = DisplayFormat[iDisplayFormat].strFormatPoints;
  strFormatRanges = DisplayFormat[iDisplayFormat].strFormatRanges;
  strFormatTime = DisplayFormat[iDisplayFormat].strFormatTime;
  strFormatSeparator = DisplayFormat[iDisplayFormat].strFormatSeparator;
  strFormatHeader = DisplayFormat[iDisplayFormat].strFormatHeader;
  strFormatSummary = DisplayFormat[iDisplayFormat].strFormatSummary;
  bFormatHeaderEnabled = DisplayFormat[iDisplayFormat].bFormatHeaderEnabled;
  bFormatSummaryEnabled = DisplayFormat[iDisplayFormat].bFormatSummaryEnabled;
  nFormatTimeLeadingDigitsHrs = DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsHrs;
  nFormatTimeFractionalDigitsHrs = DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsHrs;
  nFormatTimeLeadingDigitsMin = DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsMin;
  nFormatTimeFractionalDigitsMin = DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsMin;
  nFormatTimeLeadingDigitsSec = DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsSec;
  nFormatTimeFractionalDigitsSec = DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsSec;
  nFormatTimeLeadingDigitsFrm = DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsFrm;
  nFormatTimeFractionalDigitsFrm = DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsFrm;
  nFormatTimeLeadingDigitsSmp = DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsSmp;
  nFormatTimeFractionalDigitsSmp = DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsSmp;

  Display();
}
//---------------------------------------------------------------------------

int TForm1::GetIndexOfSelectedDisplayFormat()
{
  for(int iDisplayFormat = 0; iDisplayFormat < nNumberDisplayFormats; iDisplayFormat++)
  {
    if
    (
      DisplayFormat[iDisplayFormat].strFormatPoints == strFormatPoints &&
      DisplayFormat[iDisplayFormat].strFormatRanges == strFormatRanges &&
      DisplayFormat[iDisplayFormat].strFormatTime == strFormatTime &&
      DisplayFormat[iDisplayFormat].strFormatSeparator == strFormatSeparator &&
      DisplayFormat[iDisplayFormat].strFormatHeader == strFormatHeader &&
      DisplayFormat[iDisplayFormat].strFormatSummary == strFormatSummary &&
      DisplayFormat[iDisplayFormat].bFormatHeaderEnabled == bFormatHeaderEnabled &&
      DisplayFormat[iDisplayFormat].bFormatSummaryEnabled == bFormatSummaryEnabled &&
      DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsHrs == nFormatTimeLeadingDigitsHrs &&
      DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsHrs == nFormatTimeFractionalDigitsHrs &&
      DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsMin == nFormatTimeLeadingDigitsMin &&
      DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsMin == nFormatTimeFractionalDigitsMin &&
      DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsSec == nFormatTimeLeadingDigitsSec &&
      DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsSec == nFormatTimeFractionalDigitsSec &&
      DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsFrm == nFormatTimeLeadingDigitsFrm &&
      DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsFrm == nFormatTimeFractionalDigitsFrm &&
      DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsSmp == nFormatTimeLeadingDigitsSmp &&
      DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsSmp == nFormatTimeFractionalDigitsSmp
    )
    {
      return iDisplayFormat;
    }
  }
  return -1;
}
//---------------------------------------------------------------------------
// Routinen zur Wave-Wiedergabe
//---------------------------------------------------------------------------

bool TForm1::CanPlayFile()
{
  // berprfen, ob der Dateityp theoretisch abgespielt werden kann

  String strFileName = strAudioFileName;
  if(strFileName.IsEmpty()) return false;

  String strExt = LowerCase(ExtractFileExt(strFileName));
  if(strExt != ".wav") return false;

  return true;
}

bool TForm1::InitPlay()
{
  // Start-Position und Lnge der Wiedergabe ermitteln:
  if(nPlayCue < 0)
  {
    nPlaySampleOffset = nPlaySampleOffsetOrig = 0;
    nPlaySamples = nPlaySamplesOrig = nPlaySamplesTotal;
  }
  else if(nPlayCue < nCues)
  {
    nPlaySampleOffset = CueArray[nPlayCue].StartSample;
    nPlaySamples = CueArray[nPlayCue].nSamples;

    // Fr Cue-Points die Lnge berechnen
    if(nPlaySamples == 0 && PopupMenuCuePlayer_PlayCuePointsToNextCue->Checked && nPlayCue + 1 < nCues)
      nPlaySamples = CueArray[nPlayCue + 1].StartSample - nPlaySampleOffset;

    // Korrektur der Sample-Werte, falls unterschiedliche Samplerate in WAV-Datei und Cue-List:
    if(nPlaySamplesPerSec != nCueListSamplesPerSec)
    {
      nPlaySampleOffset = (int)((hyper)nPlaySampleOffset * nPlaySamplesPerSec / nCueListSamplesPerSec);
      nPlaySamples = (int)((hyper)nPlaySamples * nPlaySamplesPerSec / nCueListSamplesPerSec);
    }

    // Fr Cue-Points die Lnge berechnen
    if(nPlaySamples == 0 && !PopupMenuCuePlayer_PlayCuePointsNotAtAll->Checked)
      nPlaySamples = nPlaySamplesTotal - nPlaySampleOffset;

    // Originalwerte merken (ohne Erweiterung der Cue-Abspielzeit)
    nPlaySampleOffsetOrig = nPlaySampleOffset;
    nPlaySamplesOrig = nPlaySamples;

    // Cue-Abspielzeit erweitern?
    if(PopupMenuCuePlayer_PrePostAudition->Checked && nPlaySamples > 0)
    {
      // Beginn-Zeit nach vorne erweitern
      if(nExtendCueTime & EXT_BEGIN)
      {
        Extended fExtTimeBegin;
        try { fExtTimeBegin = StrToFloat(FormSettings->EditExtendCuePlayTimeBegin->Text); } catch(...) { fExtTimeBegin = 0; }
        int nExtSamplesBegin = fExtTimeBegin * nPlaySamplesPerSec;
        nExtSamplesBegin = std::min(nExtSamplesBegin, nPlaySampleOffset);
        nPlaySampleOffset -= nExtSamplesBegin;
        nPlaySamples += nExtSamplesBegin;
      }
      // Ende-Zeit nach hinten erweitern
      if(nExtendCueTime & EXT_END)
      {
        Extended fExtTimeEnd;
        try { fExtTimeEnd = StrToFloat(FormSettings->EditExtendCuePlayTimeEnd->Text); } catch(...) { fExtTimeEnd = 0; }
        int nExtSamplesEnd = fExtTimeEnd * nPlaySamplesPerSec;
        nPlaySamples += nExtSamplesEnd;
      }

      nExtendCueTime = EXT_NONE;
      bEnableDisplayExtended = true;
    }
  }
  else
  {
    MessageBox(Handle, ("Cue " + IntToStr(nPlayCue) + " doesn't exist.").c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
    fclose(fpWavFile);
    return false;
  }

  // Sample-Delta fr den Wiedergabe-Start aufgrund der Position des Schiebereglers ermitteln
  // (nur wenn die Wiedergabe nicht bereits luft -> siehe fortlaufende Wiedergabe der Cues
  // ohne Unterbrechung der Wave-Ausgabe, was ja leider noch nicht richtig funktioniert)
  int nSampleDelta = 0;
  if(!bPlaying)
  {
    nSampleDelta = (int)((hyper)nPlaySamples * TrackBarPlay->Position / TrackBarPlay->Max);
  }

  if(nPlaySampleOffset >= nPlaySamplesTotal)
  {
    MessageBox(Handle, "Cue offset is beyond WAV data.", "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
    fclose(fpWavFile);
    return false;
  }

  // Zu groe Werte anpassen
  if(nPlaySampleOffset + nPlaySamples >= nPlaySamplesTotal)
    nPlaySamples = nPlaySamplesTotal - nPlaySampleOffset;


  nPlaySamplesRemaining = nPlaySamples - nSampleDelta;
  if(nPlaySamplesRemaining == 0)
  {
    nPlaySamplesRemaining++;
    nSampleDelta--;
  }

  nChangedPlaySampleOffset = -nWaveBuffers;
  nChangedPlaySampleOffsetPrev = 0;
  nPlaySamplesDone = nSampleDelta;

  // Dateizeiger auf die Start-Position setzen
  int nNewFilePos = nPlayFileDataOffset + (nPlaySampleOffset + nSampleDelta) * nPlayBytesPerSample;
  if(fseek(fpWavFile, nNewFilePos, SEEK_SET) != 0)
  {
    MessageBox(Handle, "Seek error in WAV file.", "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
    fclose(fpWavFile);
    return false;
  }

  return true;
}

void TForm1::Play(int nCue)
{
  // Nr. der abzuspielenden Cue merken
  nPlayCue = nCue;

  // Falls Wiedergabe gerade aktiv, stoppen:
  if(bPlaying)
  {
    bStopped = true;
    Stop();
    Application->ProcessMessages();
  }

  if(!(bAudioFileIsValid && CanPlayFile())) return;
  if(nCue >= nCues) return;

  // Datei ffnen und zum Daten-Bereich gehen:
  bool nSuccess = false;
  bool bFileOpen = false;
  MMCKINFO RiffChunkInfo; // RIFF-Chunk
  MMCKINFO FormatChunkInfo; // Format-Subchunk (Wave-Parameter)
  MMCKINFO DataChunkInfo; // Data-Subchunk (Wave-Audio-Daten)

  do
  {
    fpWavFile = fopen(strAudioFileName.c_str(), "rb");
    if(fpWavFile == NULL) break;
    bFileOpen = true;

    // Find the RIFF chunk.
    memset(&RiffChunkInfo, 0, sizeof(MMCKINFO));
    RiffChunkInfo.ckid = StringToFOURCC("RIFF");
    if(FindChunk(fpWavFile, &RiffChunkInfo, NULL)) break;

    // Descend into the format chunk.
    memset(&FormatChunkInfo, 0, sizeof(MMCKINFO));
    FormatChunkInfo.ckid = StringToFOURCC("fmt");
    if(FindChunk(fpWavFile, &FormatChunkInfo, &RiffChunkInfo)) break;

    // Read the wave format.
    memset(&WaveFmtPlay, 0, sizeof(WAVEFORMATEX));
    int nBytesToRead = sizeof(WAVEFORMATEX) < FormatChunkInfo.cksize ? sizeof(WAVEFORMATEX) : FormatChunkInfo.cksize;
    fread((char*)&WaveFmtPlay, 1, nBytesToRead, fpWavFile);
    if(WaveFmtPlay.wFormatTag != WAVE_FORMAT_PCM && WaveFmtPlay.wFormatTag != WAVE_FORMAT_IEEE_FLOAT) break;

    // Ascend out of the format chunk.
    if(SeekBehindChunk(fpWavFile, &FormatChunkInfo)) break;

    // Descend into the data chunk.
    memset(&DataChunkInfo, 0, sizeof(MMCKINFO));
    DataChunkInfo.ckid = StringToFOURCC("data");
    if(FindChunk(fpWavFile, &DataChunkInfo, &RiffChunkInfo)) break;

    // Wave-Parameter merken fr Play()
    nPlayFileDataOffset = ftell(fpWavFile);
    nPlayBytesPerSample = (WaveFmtPlay.wBitsPerSample / 8) * WaveFmtPlay.nChannels;
    nPlaySamplesTotal = (nPlayBytesPerSample > 0) ? DataChunkInfo.cksize / nPlayBytesPerSample : 0;
    nPlaySamplesPerSec = WaveFmtPlay.nSamplesPerSec;

    nSuccess = (nPlaySamplesTotal > 0 && nPlaySamplesPerSec > 0);
  }
  while(false);

  if(!nSuccess)
  {
    MessageBox(Handle, "Invalid WAV file header.", "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
    if(bFileOpen) fclose(fpWavFile);
    return;
  }

  // Dateizeiger auf Beginn des abzuspielenden Blocks setzen
  if(!InitPlay())
  {
    fclose(fpWavFile);
    return;
  }

  UINT uWaveMapper = (UINT)FormSettings->ComboBoxWaveMapper->ItemIndex;

  // Sound-Device ffnen
  int nResult = waveOutOpen(&WaveHandle, uWaveMapper, &WaveFmtPlay, 0, 0, WAVE_FORMAT_QUERY);
  if(nResult)
  {
    WaveOutError(nResult);
    fclose(fpWavFile);
    return;
  }

  nResult = waveOutOpen(&WaveHandle, uWaveMapper, &WaveFmtPlay, (DWORD)Handle, 0, CALLBACK_WINDOW);
  if(nResult)
  {
    WaveOutError(nResult);
    fclose(fpWavFile);
    return;
  }

  // Und los geht's!
  Start();
}

void TForm1::Start()
{
  // Wiedergabe starten
  bPlaying = true;
  bPaused = false;
  bStopped = false;
  EnableControls();

  // Buffer queuen
  iBuffer = 0;
  nQueuedBuffers = 0;

  while(iBuffer < nWaveBuffers)
    QueuePlayBuffer(iBuffer++);
}

void TForm1::Pause()
{
  if(bPlaying && !bPaused)
  {
    // Wiedergabe anhalten
    waveOutPause(WaveHandle);
    bPaused = true;
    EnableControls();
  }
  else if(bPlaying && bPaused)
  {
    // Falls "Rollback"-Option aktiviert, zuerst zurckspringen
    if(PopupMenuCuePlayer_RollBackOnReleasePause->Checked)
    {
      Extended fRollBackTime;
      try { fRollBackTime = StrToFloat(FormSettings->EditRollBackTime->Text); } catch(...) { fRollBackTime = 0; }
      int nRollBackSamples = fRollBackTime * nPlaySamplesPerSec;
      int nCurrentPlaySampleOffset = nPlaySampleOffset + nPlaySamples - nPlaySamplesRemaining - (nWaveBuffers * MAKE_DIVISIBLE(nWaveBufferSize, nPlayBytesPerSample)) / nPlayBytesPerSample;
      nChangedPlaySampleOffset = nCurrentPlaySampleOffset - nRollBackSamples;
//      if(nChangedPlaySampleOffset < nPlaySampleOffset) nChangedPlaySampleOffset = nPlaySampleOffset;
      if(nChangedPlaySampleOffset < 0) nChangedPlaySampleOffset = 0;
      waveOutReset(WaveHandle);
      Application->ProcessMessages();
    }

    // Wiedergabe fortsetzen
    waveOutRestart(WaveHandle);
    bPaused = false;
    EnableControls();
  }
}

void TForm1::Stop()
{
  // Wiedergabe beenden
  nPlaySamplesRemaining = 0;
  waveOutReset(WaveHandle);

  bPlaying = false;
  bPaused = false;
  bEnableDisplayExtended = false;
  EnableControls();
}

void TForm1::QueuePlayBuffer(int nBuffer)
{
  if(nPlaySamplesRemaining == 0) return; // Nichts mehr abzuspielen

  // Neuer Sample-Offset durch manuelles Bewegen des Schiebereglers?
  if(nChangedPlaySampleOffset >= 0)
  {
    // Neue Position des File-Pointers berechnen und dann setzen:
    int nNewFilePos = nPlayFileDataOffset + nChangedPlaySampleOffset * nPlayBytesPerSample;
    if(fseek(fpWavFile, nNewFilePos, SEEK_SET) == 0)
      nPlaySamplesRemaining = nPlaySamples - (nChangedPlaySampleOffset - nPlaySampleOffset);
    nChangedPlaySampleOffsetPrev = nChangedPlaySampleOffset;
    nChangedPlaySampleOffset = 0;
    if(nPlaySamplesRemaining == 0) return; // Nichts mehr abzuspielen
  }

  // Ein negativer Wert, der <= -nWaveBuffers ist, bedeutet, da das Display aktualisiert werden darf
  nChangedPlaySampleOffset--;

  // Nchsten Block aus der Datei lesen (normalerweise nWaveBufferSize Bytes,
  // maximal jedoch so viele, wie noch abzuspielen sind):
  int nBytesToPlay = fread(pWaveData[iBuffer % nWaveBuffers], 1, std::min(MAKE_DIVISIBLE(nWaveBufferSize, nPlayBytesPerSample), nPlaySamplesRemaining * nPlayBytesPerSample), fpWavFile);

  // Bei Fehler Wiedergabe beenden
  if(nBytesToPlay == 0)
  {
    bStopped = true;
    Stop();
    return;
  }

  // Restliche Anzahl Samples anpassen
  nPlaySamplesRemaining -= nBytesToPlay / nPlayBytesPerSample;

  // Wave-Header initialisieren:
  WAVEHDR *whdr = &WaveHeader[iBuffer % nWaveBuffers];
  memset(whdr, 0, sizeof(WAVEHDR));
  whdr->lpData = pWaveData[iBuffer % nWaveBuffers];
  whdr->dwBufferLength = nBytesToPlay;
  // In das User-Feld den Sample-Offset (relativ zum Beginn der Cue) *nach*
  // Abspielen des Buffers schreiben (fr die Anzeige der Zeit im Display):
//  whdr->dwUser = (DWORD)(nPlaySamples - nPlaySamplesRemaining + min(nWaveBufferSize, nPlaySamplesRemaining * nPlayBytesPerSample) / nPlayBytesPerSample);
  // Anmerkung zu obigem Versuch: Es hat sich gezeigt, da dabei die im Display angezeigte Zeit
  // immer den nderungen des Schiebereglers und dem Loslassen des Pause-Buttons "hinterherhinkte".

  // Wave-Header queuen:
  waveOutPrepareHeader(WaveHandle, whdr, sizeof(WAVEHDR));
  waveOutWrite(WaveHandle, whdr, sizeof(WAVEHDR));
  nQueuedBuffers++;
}

void TForm1::OnWaveOutDone(TMessage& msg)
{
  if(msg.Msg == MM_WOM_DONE)
  {
    // Adresse des Wave-Headers des beendeten Buffers ermitteln
    WAVEHDR *whdr = (WAVEHDR*)msg.LParam;
    // Buffer unpreparen
    waveOutUnprepareHeader(WaveHandle, whdr, sizeof(WAVEHDR));
    // Anzahl der gequeueten Buffer vermindern
    nQueuedBuffers--;

    // Anzeige der abgespielten Zeit
//    nPlaySamplesDone = whdr->dwUser;  // (siehe Anmerkung zu dwUser in QueuePlayBuffer())
    nPlaySamplesDone = nPlaySamples - nPlaySamplesRemaining - (nQueuedBuffers * MAKE_DIVISIBLE(nWaveBufferSize, nPlayBytesPerSample)) / nPlayBytesPerSample;
    DisplayPlay();

    // Wenn noch Samples zu spielen sind, ...
    if(nPlaySamplesRemaining > 0)
    {
      // ... dann nchsten Buffer queuen, ...
      QueuePlayBuffer(iBuffer++);
    }
    else
    {
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
      Wiedergabe der Folge-Cue ohne Unterbrechung der Wave-Ausgabe. Probleme:
      - Das UpDown-Control mu weitergeschaltet werden, jedoch ist es dafr an dieser Stelle
        noch zu frh, da noch (nWaveBuffers - 1) Buffer wiedergegeben werden mssen, die sich
        auf die vorherige Cue beziehen. Folge: Die Anzeige "spinnt".
      - Wenn Cue-Points bersprungen werden, entsteht ein "Knackser" (drfte eigentlich nicht).
      - ... (?)
*/
/*
      // ... sonst: wenn Option aktiviert und Wiedergabe nicht gestoppt, ...
      if(!bStopped && PopupMenuCuePlayer_AutoContinue->Checked && nPlayCue != -1)
      {
        // ... nchste Cue vorbereiten und queuen, ...
        nPlayCue++;
        if(nPlayCue < nCues)
        {
          // Wenn diese (Folge-)Cue die letzte abzuspielende ist, dann 'Ende Erweitern' ermglichen
          if(nPlayCue + 1 == nCues) nExtendCueTime = EXT_END;
          if(InitPlay())
          {
            bAcceptUpDownPlayClickEvent = false;
            UpDownPlay->Position = (short)(nPlayCue + 1);
            bAcceptUpDownPlayClickEvent = true;

            QueuePlayBuffer(iBuffer++);
            return;
          }
        }
      }

      // ... sonst solange warten, bis alle gequeueten Buffer abgespielt sind und dann ...
      if(nQueuedBuffers == 0)
      {
        // ... die Wiedergabe beenden:
        Stop();
        TrackBarPlay->Position = 0;
        if(!bStopped)
        {
          if(PopupMenuCuePlayer_AutoContinue->Checked && nPlayCue != -1)
          {
            UpDownPlay->Position = 1;
            DisplayPlay();
          }
        }
        waveOutClose(WaveHandle);
        fclose(fpWavFile);
      }
*/
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
      // ... andernfalls solange warten, bis alle gequeueten Buffer abgespielt sind und dann ...
      if(nQueuedBuffers == 0)
      {
        // ... die Wiedergabe beenden:
        Stop();
        TrackBarPlay->Position = 0;
        if(!bStopped && PopupMenuCuePlayer_AutoContinue->Checked && nPlayCue != -1)
        {
          UpDownPlay->Position = 1;
          DisplayPlay();
        }
        waveOutClose(WaveHandle);
        fclose(fpWavFile);

        // Wenn Option aktiviert und Wiedergabe nicht gestoppt, nchste Cue abspielen
        // (funktioniert, aber zwischen den Cues entsteht natrlich eine kleine Lcke)
        if(!bStopped && PopupMenuCuePlayer_AutoContinue->Checked && nPlayCue != -1)
        {
          nPlayCue++;
          if(nPlayCue < nCues)
          {
            UpDownPlay->Position = (short)(nPlayCue + 1);
            // Wenn diese (Folge-)Cue die letzte abzuspielende ist, dann 'Ende Erweitern' ermglichen
            if(nPlayCue + 1 == nCues) nExtendCueTime = EXT_END;
            Play(nPlayCue);
          }
        }
      } // nQueuedBuffers == 0
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    } // nPlaySamplesRemaining > 0
  } // msg.Msg == MM_WOM_DONE
}

void TForm1::DisplayPlay()
{
  if(bPlaying)
  {
    DisplayPlay(nPlaySamplesDone, nPlaySamplesPerSec, nPlaySamples, nPlaySampleOffset + nPlaySamplesDone, nPlaySamplesTotal);
  }
  else
  {
    DisplayPlay(GetPlaySamplesTrackBar(), GetPlaySamplesPerSec(), GetPlaySamples(), GetPlaySamplesTrackBarAbsolute(), GetPlaySamplesTotal());
  }
}

void TForm1::DisplayPlay(int nSampleOffsetRel, int nSampleRate, int nSamples, int nSampleOffsetAbs, int nSamplesTotal)
{
  bAcceptTrackBarPlayChangeEvent = false;       // Bei nderungen des Schiebers per Programm sollen die
                                                // Change-Messages durch das Control nicht ausgewertet werden.
  String strExt = "  ";

  nSampleDisplay = nSampleOffsetAbs;            // Im Display des Cue-Players angezeigtes Sample fr AddCue()
  nSamplesPerSecDisplay = nSampleRate;          // Fr Anzeige im Display des Cue-Players verwendete Sample-Rate

  String strCue;
  if(UpDownPlay->Position > 0)
    strCue.sprintf("%02d  ", UpDownPlay->Position);
  else
    strCue = "File:";

  String strDisplay;

  // Anzeige, wenn keine Cues geladen sind:
  if(nSampleOffsetRel == -1)
  {
    strDisplay.sprintf("----   ----:----.--");
    TrackBarPlay->Position = 0;
  }
  // Anzeige, wenn zwar Cues existieren, aber keine gltige Watei geladen ist, um die Gesmatlnge zu bestimmen
  else if(PopupMenuCuePlayer_DisplayTotalTime->Checked && (nSampleOffsetAbs == -1 || nSamplesTotal == -1))
  {
    strDisplay.sprintf("%s ----:----.--", strCue.c_str());
    TrackBarPlay->Position = 0;
  }
  // Anzeige der aktuellen Position:
  else
  {
    // Relativwerte
    int nDisplaySampleOffset = nSampleOffsetRel;
    int nDisplaySamples = nSamples;

    // Gesamtzeit anzeigen?
    if(PopupMenuCuePlayer_DisplayTotalTime->Checked)
    {
      // Dann die Absolutwerte nehmen!
      nDisplaySampleOffset = nSampleOffsetAbs;
      nDisplaySamples = nSamplesTotal;
    }

    // Verstrichene Zeit anzeigen?
    if(PopupMenuCuePlayer_DisplayRemainingTime->Checked)
    {
      nDisplaySampleOffset = nDisplaySamples - nDisplaySampleOffset;
    }

    // Ist zu Beginn der Wiedergabe die Cue-Abspielzeit erweitert worden?
//    if(bEnableDisplayExtended)
    if(bPlaying)
    {
      // Anzuzeigenden relativen Sample-Offset korrigieren um den Betrag der zustzlichen Samples am Beginn der Cue
      if(!PopupMenuCuePlayer_DisplayTotalTime->Checked)
      {
        nDisplaySampleOffset -= (nPlaySampleOffsetOrig - nPlaySampleOffset); // (kann dadurch negativ werden)
      }

      // Wenn innerhalb der Bereiche der "Erweiterten Abspielzeit", dann kennzeichnen
      if(nSampleOffsetAbs < nPlaySampleOffsetOrig)
      {
        strExt = "<";
      }
      else if(nSampleOffsetAbs > nPlaySampleOffsetOrig + nPlaySamplesOrig)
      {
        strExt = ">";
      }
    }

    // Falls der anzuzeigende Wert negativ ist, Flag setzen und wieder positiv machen
    bool bMinusFlag = false;
    if(nDisplaySampleOffset < 0)
    {
      bMinusFlag = true;
      nDisplaySampleOffset *= -1;
    }

    // Sample-Wert in Zeit umrechnen
    double fSecTotal = (double)nDisplaySampleOffset / nSampleRate;
    int nMin = (int)fSecTotal / 60;
    double fSec = fSecTotal - nMin * 60;
    strDisplay.sprintf("  %s%s%02d:%04.1f%s", strCue.c_str(), bMinusFlag ? "-" : " ", nMin, fSec, strExt.c_str());

    // Schieberegler nur dann aktualisieren, wenn eine zuvor manuell vorgenommene
    // Vernderung der Abspiel-Position durch manuelles Bewegen des Reglers von
    // allen Buffern verarbeitet wurde, um "Springen" des Reglers zu vermeiden:
    if(nSamples > 0)
    {
      if(bPlaying && nChangedPlaySampleOffset <= -nWaveBuffers)
      {
        TrackBarPlay->Position = (int)((hyper)(nSampleOffsetRel + TrackBarPlay->Max - 1) * TrackBarPlay->Max / nSamples);
        if(TrackBarPlay->Position > TrackBarPlay->Max) TrackBarPlay->Position = TrackBarPlay->Max;
      }
    }
    else
    {
      TrackBarPlay->Position = 0;
    }
  }
  PanelPlay->Caption = strDisplay;

  bAcceptTrackBarPlayChangeEvent = true;
}

int TForm1::GetPlaySamplesTrackBar()
{
  int nSamples = GetPlaySamples();

  if(nSamples != -1)
  {
    nSamples = (int)((hyper)nSamples * TrackBarPlay->Position / TrackBarPlay->Max);
  }
  return nSamples;
}

int TForm1::GetPlaySamples()
{
  int nSamples = -1;

  int iCue = UpDownPlay->Position - 1;

  if(bPlaying)
  {
    nSamples = nPlaySamples;
  }
  else
  {
    if(iCue == -1 && bAudioFileIsValid)
    {
      nSamples = nAudioFileSamples;
    }
    else if(nCues > 0 && iCue > -1 && iCue < nCues)
    {
      nSamples = CueArray[iCue].nSamples;

      // Cue-Points
      if(nSamples == 0 && !PopupMenuCuePlayer_PlayCuePointsNotAtAll->Checked)
      {
        if(PopupMenuCuePlayer_PlayCuePointsToNextCue->Checked && iCue + 1 < nCues)
        {
          nSamples = CueArray[iCue + 1].StartSample - CueArray[iCue].StartSample;
        }
        else
        {
          // Die Werte der Audio-Datei nehmen
          if(bAudioFileIsValid)
          {
            int nCueListStartSample = CueArray[iCue].StartSample;
            // Sample-Wert ggf. anpassen
            if(nAudioFileSamplesPerSec != nCueListSamplesPerSec)
            {
              nCueListStartSample = (int)((hyper)nCueListStartSample * nAudioFileSamplesPerSec / nCueListSamplesPerSec);
            }
            nSamples = nAudioFileSamples - nCueListStartSample;
          }
        }
      }
    }
  }
  return nSamples;
}

int TForm1::GetPlaySamplesPerSec()
{
  int nSamplesPerSec = -1;

  int iCue = UpDownPlay->Position - 1;

  if(bPlaying)
  {
    nSamplesPerSec = nPlaySamplesPerSec;
  }
  else
  {
    if(iCue == -1 && bAudioFileIsValid)
    {
      nSamplesPerSec = nAudioFileSamplesPerSec;
    }
    else if(nCues > 0 && iCue > -1 && iCue < nCues)
    {
      nSamplesPerSec = nCueListSamplesPerSec;

      // Cue-Points
      if(CueArray[iCue].nSamples == 0 && !PopupMenuCuePlayer_PlayCuePointsNotAtAll->Checked && bAudioFileIsValid && (!PopupMenuCuePlayer_PlayCuePointsToNextCue->Checked || iCue + 1 >= nCues))
      {
        nSamplesPerSec = nAudioFileSamplesPerSec;
      }
    }
  }

  return nSamplesPerSec;
}

int TForm1::GetPlaySamplesTrackBarAbsolute()
{
  int nSamples = -1;
  int nSampleOffset = -1;

  int iCue = UpDownPlay->Position - 1;

  if(bPlaying)
  {
    nSampleOffset = nPlaySampleOffset;
  }
  else
  {
    if(iCue == -1 && bAudioFileIsValid)
    {
      nSampleOffset = 0;
    }
    else if(nCues > 0 && iCue > -1 && iCue < nCues)
    {
      nSampleOffset = CueArray[iCue].StartSample;
    }
  }

  if(nSampleOffset != -1)
  {
    nSamples = GetPlaySamples();

    if(nSamples != -1)
    {
      nSamples = (int)((hyper)nSamples * TrackBarPlay->Position / TrackBarPlay->Max) + nSampleOffset;
    }
  }
  return nSamples;
}

int TForm1::GetPlaySamplesTotal()
{
  int nSamples = -1;

  int iCue = UpDownPlay->Position - 1;

  if(bPlaying)
  {
    nSamples = nPlaySamplesTotal;
  }
  else if(bAudioFileIsValid)
  {
    nSamples = nAudioFileSamples;

    if(nCues > 0 && iCue > -1 && nAudioFileSamplesPerSec != nCueListSamplesPerSec)
    {
      nSamples = (int)((hyper)nSamples * nCueListSamplesPerSec / nAudioFileSamplesPerSec);
    }
  }
  return nSamples;
}

void TForm1::WaveOutError(DWORD nCode)
{
  char buff[256];
  waveOutGetErrorText(nCode, buff, sizeof(buff));
  MessageBox(Handle, buff, "Error", MB_OK | MB_ICONERROR | MB_APPLMODAL);
}

//---------------------------------------------------------------------------

void TForm1::Copy()
{
  RichEditCueList->SelectAll();
  RichEditCueList->CopyToClipboard();
  SetStatusBarText("Contents of text window have been copied to clipboard");
}
//---------------------------------------------------------------------------

void TForm1::CopySel()
{
  RichEditCueList->CopyToClipboard();
  SetStatusBarText("Selected text has been copied to clipboard");
}
//---------------------------------------------------------------------------

void TForm1::Drucken()
{
  RichEditCueList->Print(Form1->Caption);
  SetStatusBarText("Contents of text window have been sent to default printer");
}
//---------------------------------------------------------------------------

void TForm1::SaveTextFile(bool bNonInteractive, String strFileName)
{
  if(!bNonInteractive)
  {
    strFileName = ExtractFileName(strAudioFileName);
    if(strFileName.IsEmpty()) strFileName = ExtractFileName(OpenDialogCue->FileName);
    strFileName = ExtractFileName(strFileName.SubString(1, strFileName.Length() - ExtractFileExt(strFileName).Length()));
    SaveDialogTextFile->FileName = strFileName;
    if(!SaveDialogTextFile->Execute()) return;
    strFileName = SaveDialogTextFile->FileName;
  }

  if(ExtractFileExt(strFileName).LowerCase() == ".txt") RichEditCueList->PlainText = true;
  RichEditCueList->Lines->SaveToFile(strFileName);
  RichEditCueList->PlainText = false;
  SetStatusBarText("Text window has been saved to '" + ExtractFileName(strFileName) + "'");
}
//---------------------------------------------------------------------------

void TForm1::Settings()
{
  FormSettings->EditMaxCues->Text = IntToStr(nMaxCues);
  FormSettings->EditWaveBuffers->Text = IntToStr(nWaveBuffers);
  FormSettings->EditWaveBufferSize->Text = IntToStr(nWaveBufferSize);

  FormSettings->EditSampleCueWindow->Color = RichEditCueList->Color;
  FormSettings->EditSampleCueWindow->Font = RichEditCueList->Font;
  FormSettings->EditSampleCuePlayer->Color = PanelPlay->Color;
  FormSettings->EditSampleCuePlayer->Font = PanelPlay->Font;

  FormSettings->ShowModal();

  RichEditCueList->Color = FormSettings->EditSampleCueWindow->Color;
  RichEditCueList->Font = FormSettings->EditSampleCueWindow->Font;
  PanelPlay->Color = FormSettings->EditSampleCuePlayer->Color;
  PanelPlay->Font = FormSettings->EditSampleCuePlayer->Font;

  try { nMaxCuesNew = StrToInt(FormSettings->EditMaxCues->Text); } catch(...) { nMaxCuesNew = MAXCUES; }
  try { nWaveBuffersNew = StrToInt(FormSettings->EditWaveBuffers->Text); } catch(...) { nWaveBuffersNew = NBUFFERS; }
  try { nWaveBufferSizeNew = StrToInt(FormSettings->EditWaveBufferSize->Text); } catch(...) { nWaveBufferSizeNew = BUFSIZE; }

  if(nMaxCuesNew < 1) nMaxCuesNew = MAXCUES;
  if(nWaveBuffersNew < 2) nWaveBuffersNew = NBUFFERS;
  if(nWaveBufferSizeNew < 1024) nWaveBufferSizeNew = BUFSIZE;

  if(nMaxCues != nMaxCuesNew || nWaveBuffers != nWaveBuffersNew || nWaveBufferSize != nWaveBufferSizeNew)
  {
    MessageBox(Handle, "Some of the changes you made will not take effect until CueListTool is restarted.", "Information", MB_OK|MB_ICONINFORMATION|MB_APPLMODAL);
  }
}

//---------------------------------------------------------------------------

int TForm1::GetOccurrences(String strString, String strPattern)
{
  int nCount = 0;
  int iPos = 1;

  while(iPos > 0 && iPos < strString.Length())
  {
    strString = strString.SubString(iPos, strString.Length() - iPos + 1);
    iPos = strString.Pos(strPattern);
    if(iPos > 0)
    {
      nCount++;
      iPos++;
    }
  }

  return nCount;
}

int TForm1::GetCueAtCurrentCursorPosition()
{
  if(nCues == 0) return -1;

  int nTextLinesPerCueRange = GetOccurrences(strFormatRanges, "%nl") + 1;
  int nTextLinesPerCuePoint = GetOccurrences(strFormatPoints, "%nl") + 1;
  int nTextLinesOfHeader = (bFormatHeaderEnabled ? GetOccurrences(strFormatHeader, "%nl") + 1 : 0);

  int nCursorLine = RichEditCueList->CaretPos.y;
  int nLines = RichEditCueList->Lines->Count;
  int iLine = nTextLinesOfHeader;

  for(int iCue = 0; iCue < nCues && iLine < nLines; iCue++)
  {
    int iLineNextCue = iLine + (CueArray[iCue].nSamples == 0 ? nTextLinesPerCuePoint : nTextLinesPerCueRange);
    if(nCursorLine >= iLine && nCursorLine < iLineNextCue) return iCue;
    iLine = iLineNextCue;
  }

  return -1;
}

void TForm1::PlayCueUnderCursor(bool bPlay/* = true*/)
{
  int nCue;
  if(PageControlCueList->ActivePage == TabSheetView)
  {
    nCue = GetCueAtCurrentCursorPosition();
    if(nCue == -1) return;
  }
  else if(PageControlCueList->ActivePage == TabSheetEdit)
  {
    nCue = StringGrid->Row - 1;
    if(nCue < 0 || nCue >= nCues) return;
  }
  else return;

  if(bPlaying)
  {
    bStopped = true;
    Stop();
    Application->ProcessMessages();
  }

  TrackBarPlay->Position = 0;
  UpDownPlay->Position = (short)(nCue +1);
  DisplayPlay();

  if(bPlay)
  {
    // Da es sich um die erste abzuspielende Cue handelt: 'Beginn Erweitern' ermglichen
    nExtendCueTime = EXT_BEGIN;
    // Wenn nicht mehrere Cues in Folge abgespielt werden sollen, dann auch 'Ende Erweitern' ermglichen
    if(!PopupMenuCuePlayer_AutoContinue->Checked) nExtendCueTime |= EXT_END;
    Play(nCue);
  }
}

//---------------------------------------------------------------------------
// Funktionen zum Bearbeiten der Cues
//---------------------------------------------------------------------------

void TForm1::SetCueBeginEnd(int iCue, int nMode)    // nMode: 0 = Begin, 1 = End
{
  int nSample = nSampleDisplay;
  if(nSample == -1) nSample = 0;

  int nSamplesPerSec = nSamplesPerSecDisplay;
  if(nSamplesPerSec == -1) return;

  if(nSamplesPerSec != nCueListSamplesPerSec)
    nSample = (int)((hyper)nSample * nCueListSamplesPerSec / nSamplesPerSecDisplay);

  if(nMode == 0)
  {
    CueArray[iCue].nSamples += CueArray[iCue].StartSample - nSample;
    if(CueArray[iCue].nSamples < 0) CueArray[iCue].nSamples = 0;
    CueArray[iCue].StartSample = nSample;
  }
  else
  {
    CueArray[iCue].nSamples = nSample - CueArray[iCue].StartSample;
    if(CueArray[iCue].nSamples < 0)
    {
      CueArray[iCue].StartSample += CueArray[iCue].nSamples;
      CueArray[iCue].nSamples = 0;
    }
  }

  SetDirtyFlag();
  SetStatusBarText("Cue " + String((nMode == 0 ? "begin" : "end")) + " has been set.");
  Display(true);

}

void TForm1::AddCue(int iCueSelected)
{
  if(!VerifyCueIndex(nCues)) return;

  int nStartSample = nSampleDisplay;
  if(nStartSample == -1) nStartSample = 0;

  int nSamplesPerSec = nSamplesPerSecDisplay;
  if(nSamplesPerSec == -1) nSamplesPerSec = nCueListSamplesPerSec = DEFAULT_SAMPLERATE;

  if(nCues > 0 && nSamplesPerSec != nCueListSamplesPerSec)
    nStartSample = (int)((hyper)nStartSample * nCueListSamplesPerSec / nSamplesPerSecDisplay);

  int iCue;
  for(iCue = 0; iCue < nCues; iCue++)
  {
    if(CueArray[iCue].StartSample >= nStartSample) break;
  }

//  if(nCues > 0 && iCueSelected >= iCue)
//  {
    StringGrid->RowCount++;
//    StringGrid->Row++;
//  }
  StringGrid->Row = iCue + 1;

  // Alle Cues ab iCue im Array um 1 Position nach hinten verschieben:
  for(int iDestCue = nCues; iDestCue > iCue && iCue < nCues; iDestCue--)
  {
    CueArray[iDestCue].StartSample = CueArray[iDestCue - 1].StartSample;
    CueArray[iDestCue].nSamples    = CueArray[iDestCue - 1].nSamples;
    CueArray[iDestCue].Label       = CueArray[iDestCue - 1].Label;
    CueArray[iDestCue].Description = CueArray[iDestCue - 1].Description;
    CueArray[iDestCue].Type        = CueArray[iDestCue - 1].Type;
  }

  CueArray[iCue].StartSample = nStartSample;
  CueArray[iCue].nSamples    = 0;
  CueArray[iCue].Label       = "New Cue";
  CueArray[iCue].Description = "";
  CueArray[iCue].Type        = "rgn";
  if(nCueListSamplesPerSec == 0) nCueListSamplesPerSec = DEFAULT_SAMPLERATE;

  nCues++;
  SetDirtyFlag();
  SetStatusBarText("Cue " + IntToStr(iCue + 1) + " has been added.");
  Display(true);
}

void TForm1::DuplicateCue(int iCue)
{
  if(iCue < 0) return;
  if(!VerifyCueIndex(nCues)) return;

  // Alle Cues ab iCue im Array um 1 Position nach hinten verschieben:
  for(int iDestCue = nCues; iDestCue > iCue && iCue < nCues; iDestCue--)
  {
    CueArray[iDestCue].StartSample = CueArray[iDestCue - 1].StartSample;
    CueArray[iDestCue].nSamples    = CueArray[iDestCue - 1].nSamples;
    CueArray[iDestCue].Label       = CueArray[iDestCue - 1].Label;
    CueArray[iDestCue].Description = CueArray[iDestCue - 1].Description;
    CueArray[iDestCue].Type        = CueArray[iDestCue - 1].Type;
  }
  if(iCue < nCues)
  {
    CueArray[iCue].Label = "Copy of " + CueArray[iCue].Label;
  }
  else
  {
    CueArray[iCue].StartSample = 0;
    CueArray[iCue].nSamples    = 0;
    CueArray[iCue].Label       = "New Cue";
    CueArray[iCue].Description = "";
    CueArray[iCue].Type        = "rgn";
    if(nCueListSamplesPerSec == 0) nCueListSamplesPerSec = DEFAULT_SAMPLERATE;
  }

  nCues++;
  SetDirtyFlag();
  SetStatusBarText("Cue " + IntToStr(iCue + 1) + " has been added.");
  Display(true);
}

void TForm1::DeleteCue(int iCue)
{
  if(iCue < 0 || iCue >= nCues) return;

  // Alle Cues ab iCue + 1 im Array um 1 Position nach vorne verschieben:
  for(int iDestCue = iCue; iDestCue < nCues - 1; iDestCue++)
  {
    CueArray[iDestCue].StartSample = CueArray[iDestCue + 1].StartSample;
    CueArray[iDestCue].nSamples    = CueArray[iDestCue + 1].nSamples;
    CueArray[iDestCue].Label       = CueArray[iDestCue + 1].Label;
    CueArray[iDestCue].Description = CueArray[iDestCue + 1].Description;
    CueArray[iDestCue].Type        = CueArray[iDestCue + 1].Type;
  }

  nCues--;
  SetDirtyFlag(nCues > 0);
  SetStatusBarText("Cue " + IntToStr(iCue + 1) + " has been deleted.");
  Display(true);
}

int TForm1::GetSamplesIncrementCueTimes()
{
  int nSamples = 0;

  if(PopupMenuCueTimes_1->Checked) nSamples = 1;
  else if(PopupMenuCueTimes_10->Checked) nSamples = 10;
  else if(PopupMenuCueTimes_100->Checked) nSamples = 100;
  else if(PopupMenuCueTimes_1000->Checked) nSamples = 1000;

  if(PopupMenuCueTimes_Milliseconds->Checked) nSamples = nCueListSamplesPerSec * nSamples / 1000;
  else if(PopupMenuCueTimes_Frames->Checked) nSamples = nCueListSamplesPerSec * nSamples / 75;

  return nSamples;
}

void TForm1::ChangeCueBegin(bool bIncrease)
{
  int iCue = StringGrid->Row - 1;
  if(iCue < 0 || iCue >= nCues) return;

  int nStartSample = CueArray[iCue].StartSample;
  int nSamples = CueArray[iCue].nSamples;
  int nIncrementSamples = GetSamplesIncrementCueTimes();

  if(bIncrease)
  {
    nStartSample += nIncrementSamples;
    nSamples -= nIncrementSamples;
    if(nSamples < 0) nSamples = 0;
  }
  else
  {
    nStartSample -= nIncrementSamples;
    if(nStartSample < 0) nStartSample = 0;
    nSamples += (CueArray[iCue].StartSample - nStartSample);
  }

  if(CueArray[iCue].StartSample != nStartSample || CueArray[iCue].nSamples != nSamples)
  {
    CueArray[iCue].StartSample = nStartSample;
    CueArray[iCue].nSamples = nSamples;
    SetDirtyFlag();
    ShowChangedCueTimes(iCue);
  }
}

void TForm1::ChangeCueLength(bool bIncrease)
{
  int iCue = StringGrid->Row - 1;
  if(iCue < 0 || iCue >= nCues) return;

  int nStartSample = CueArray[iCue].StartSample;
  int nSamples = CueArray[iCue].nSamples;
  int nIncrementSamples = GetSamplesIncrementCueTimes();

  if(bIncrease)
  {
    nSamples += nIncrementSamples;
  }
  else
  {
    nSamples -= nIncrementSamples;
    if(nSamples < 0)
    {
      nStartSample += nSamples;
      nSamples = 0;
      if(nStartSample < 0) nStartSample = 0;
    }
  }

  if(CueArray[iCue].StartSample != nStartSample || CueArray[iCue].nSamples != nSamples)
  {
    CueArray[iCue].StartSample = nStartSample;
    CueArray[iCue].nSamples = nSamples;
    SetDirtyFlag();
    ShowChangedCueTimes(iCue);
  }
}

void TForm1::ShowChangedCueTimes(int iCue)
{
  EditCueBegin->Text = FormatTime((Extended)CueArray[iCue].StartSample / nCueListSamplesPerSec);
  EditCueEnd->Text = FormatTime((Extended)(CueArray[iCue].StartSample + CueArray[iCue].nSamples) / nCueListSamplesPerSec);
  EditCueLength->Text = FormatTime((Extended)CueArray[iCue].nSamples / nCueListSamplesPerSec);
}

//---------------------------------------------------------------------------
// Dirty-Flag
//---------------------------------------------------------------------------

bool TForm1::DiscardChanges()
{
  if(IsDirty())
  {
    if(MessageBox(Handle, "You have edited the Cue List. Discard the changes?", "Warning", MB_YESNO|MB_ICONWARNING|MB_APPLMODAL) == IDYES)
    {
      SetDirtyFlag(false);
    }
  }
  return !IsDirty();
}

void TForm1::SetDirtyFlag(bool nDirty/* = true*/)
{
  bCueListChanged = nDirty;

  // Titelzeile
  Caption = ExtractFileName(strAudioFileName) + (bCueListChanged ? "*" : "") + " - " + strInitialCaption;
  Application->Title = Caption;
}

bool TForm1::IsDirty()
{
  return bCueListChanged;
}

//---------------------------------------------------------------------------
// ffnen einer Datei in einer externen Applikation
//---------------------------------------------------------------------------

void TForm1::StartExtApp()        // Editor()
{
  if(strAudioFileName.IsEmpty()) return;

  while(FormSettings->strExtAppPath[FormSettings->RadioGroupExtApp->ItemIndex].IsEmpty())
  {
    if(MessageBox(Handle,
      ("External application no. " + IntToStr((FormSettings->RadioGroupExtApp->ItemIndex + 1) % 10) + " is not yet configured.\n"
      "Would you like to select an application now?").c_str(),
      "Start external application...", MB_YESNO|MB_ICONQUESTION|MB_APPLMODAL) != IDYES)
      return;

    FormSettings->PageControlSettings->ActivePage = FormSettings->TabSheetExtApp;
    Settings();
  }

  String strArgs;
  strArgs.sprintf(FormSettings->EditExtAppArgs->Text.c_str(), strAudioFileName.c_str());

  ShellExecute(
    Handle,
    "open",
    FormSettings->strExtAppPath[FormSettings->RadioGroupExtApp->ItemIndex].c_str(),
    strArgs.c_str(),
    NULL,
    SW_SHOWNORMAL
  );
}

void TForm1::SetExtApp(int nAppl)     // SetDefaultEditor()
{
  FormSettings->RadioGroupExtApp->ItemIndex = nAppl;
  switch(nAppl)
  {
    case 0:
      MenuExtApp1->Checked = true;
      PopupMenuExtApp1->Checked = true;
      break;
    case 1:
      MenuExtApp2->Checked = true;
      PopupMenuExtApp2->Checked = true;
      break;
    case 2:
      MenuExtApp3->Checked = true;
      PopupMenuExtApp3->Checked = true;
      break;
    case 3:
      MenuExtApp4->Checked = true;
      PopupMenuExtApp4->Checked = true;
      break;
    case 4:
      MenuExtApp5->Checked = true;
      PopupMenuExtApp5->Checked = true;
      break;
    case 5:
      MenuExtApp6->Checked = true;
      PopupMenuExtApp6->Checked = true;
      break;
    case 6:
      MenuExtApp7->Checked = true;
      PopupMenuExtApp7->Checked = true;
      break;
    case 7:
      MenuExtApp8->Checked = true;
      PopupMenuExtApp8->Checked = true;
      break;
    case 8:
      MenuExtApp9->Checked = true;
      PopupMenuExtApp9->Checked = true;
      break;
    case 9:
      MenuExtApp0->Checked = true;
      PopupMenuExtApp0->Checked = true;
      break;
  }
}

void TForm1::InitExtAppMenuItems()        // InitEditorMenuItems()
{
  SetExtApp(FormSettings->RadioGroupExtApp->ItemIndex);

  MenuExtApp1->Caption = "&1 " + GetExtAppName(0);
  PopupMenuExtApp1->Caption = "&1 " + GetExtAppName(0);

  MenuExtApp2->Caption = "&2 " + GetExtAppName(1);
  PopupMenuExtApp2->Caption = "&2 " + GetExtAppName(1);

  MenuExtApp3->Caption = "&3 " + GetExtAppName(2);
  PopupMenuExtApp3->Caption = "&3 " + GetExtAppName(2);

  MenuExtApp4->Caption = "&4 " + GetExtAppName(3);
  PopupMenuExtApp4->Caption = "&4 " + GetExtAppName(3);

  MenuExtApp5->Caption = "&5 " + GetExtAppName(4);
  PopupMenuExtApp5->Caption = "&5 " + GetExtAppName(4);

  MenuExtApp6->Caption = "&6 " + GetExtAppName(5);
  PopupMenuExtApp6->Caption = "&6 " + GetExtAppName(5);

  MenuExtApp7->Caption = "&7 " + GetExtAppName(6);
  PopupMenuExtApp7->Caption = "&7 " + GetExtAppName(6);

  MenuExtApp8->Caption = "&8 " + GetExtAppName(7);
  PopupMenuExtApp8->Caption = "&8 " + GetExtAppName(7);

  MenuExtApp9->Caption = "&9 " + GetExtAppName(8);
  PopupMenuExtApp9->Caption = "&9 " + GetExtAppName(8);

  MenuExtApp0->Caption = "&0 " + GetExtAppName(9);
  PopupMenuExtApp0->Caption = "&0 " + GetExtAppName(9);
}

String TForm1::GetExtAppName(int nAppl)        // GetApplicationName()
{
  if(!FormSettings->strExtAppName[nAppl].IsEmpty())
  {
    return FormSettings->strExtAppName[nAppl];
  }
  else
  {
    String strPath = FormSettings->strExtAppPath[nAppl];
    return ExtractFileName(strPath.SubString(1, strPath.Length() - ExtractFileExt(strPath).Length()));
  }
}

//---------------------------------------------------------------------------
// Event-Handler
//---------------------------------------------------------------------------

void __fastcall TForm1::ButtonOpenClick(TObject *Sender)
{
  SelectAudioFile();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuOpenClick(TObject *Sender)
{
  SelectAudioFile();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ButtonExitClick(TObject *Sender)
{
  Close();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuExitClick(TObject *Sender)
{
  Close();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ButtonCopyClick(TObject *Sender)
{
  Copy();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuCopyClick(TObject *Sender)
{
  Copy();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuCopySelClick(TObject *Sender)
{
  CopySel();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuAboutClick(TObject *Sender)
{
  FormAbout->ShowModal();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ButtonReadClick(TObject *Sender)
{
  ReadCueListFromAudioFile(strAudioFileName);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuReadClick(TObject *Sender)
{
  ReadCueListFromAudioFile(strAudioFileName);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ButtonSaveClick(TObject *Sender)
{
  SaveCueListFile();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuSaveClick(TObject *Sender)
{
  SaveCueListFile();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ButtonSaveCueSheetClick(TObject *Sender)
{
  SaveCueSheet();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuSaveCueSheetClick(TObject *Sender)
{
  SaveCueSheet();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ButtonLoadClick(TObject *Sender)
{
  LoadCueListFile();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuLoadClick(TObject *Sender)
{
  LoadCueListFile();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ButtonWriteClick(TObject *Sender)
{
  WriteCueListToAudioFile(strAudioFileName);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuWriteClick(TObject *Sender)
{
  WriteCueListToAudioFile(strAudioFileName);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ButtonPrintClick(TObject *Sender)
{
  Drucken();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuPrintClick(TObject *Sender)
{
  Drucken();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuShowTipsClick(TObject *Sender)
{
  Help();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuGotoWebsiteClick(TObject *Sender)
{
  GotoWebsite();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::RichEditCueListMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  static nSelStart = 0; // Statische Merkvariable fr Cursor-Position bei Einfach-Klick

  if(Button == mbLeft)
  {
    if(Shift.Contains(ssDouble))
    {
      // Doppelklick ins Textfenster startet Wiedergabe der betreffenden Cue:
      RichEditCueList->SelLength = 0; // Wort-Markierung entfernen
      RichEditCueList->SelStart = nSelStart;  // Cursor auf Einfach-Klick-Position setzen
      PlayCueUnderCursor();
    }
    else
    {
      // Einfach-Klick: Cursor-Position merken
      nSelStart = RichEditCueList->SelStart;
    }
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuOffsetClick(TObject *Sender)
{
  AddTimeOffsetToAllCues();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuDefineDisplayFormatClick(TObject *Sender)
{
  DefineDisplayFormat();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ButtonSaveTextFileClick(TObject *Sender)
{
  SaveTextFile();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuSaveTextFileClick(TObject *Sender)
{
  SaveTextFile();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ButtonLoadCueSheetClick(TObject *Sender)
{
  LoadCueSheet();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuLoadCueSheetClick(TObject *Sender)
{
  LoadCueSheet();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ButtonLoadAudacityLabelsClick(TObject *Sender)
{
  LoadAudacityLabels();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuLoadAudacityLabelsClick(TObject *Sender)
{
  LoadAudacityLabels();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ButtonSaveAudacityLabelsClick(TObject *Sender)
{
  SaveAudacityLabels();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuSaveAudacityLabelsClick(TObject *Sender)
{
  SaveAudacityLabels();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::RichEditCueListSelectionChange(TObject *Sender)
{
  EnableControls();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::UpDownPlayClick(TObject *Sender, TUDBtnType Button)
{
  if(!bAcceptUpDownPlayClickEvent) return;

  TrackBarPlay->Position = 0;
  if(bPlaying)
  {
    bStopped = true;
    Stop();
    Application->ProcessMessages();
    // Nchste abzuspielende Cue
    int nCue = UpDownPlay->Position - 1;
    // Wenn diese (Folge-)Cue die letzte abzuspielende ist, dann 'Ende Erweitern' ermglichen
    if(nCue + 1 == nCues) nExtendCueTime = EXT_END;
    Play(nCue);
  }
  else
  {
    DisplayPlay();
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ButtonPlayClick(TObject *Sender)
{
  if(bPlaying)
  {
    // Wiedergabe anhalten oder fortsetzen
    Pause();
  }
  else
  {
    // Abzuspielende Cue
    int nCue = UpDownPlay->Position - 1;
    // Da es sich um die erste abzuspielende Cue handelt: 'Beginn Erweitern' ermglichen
    nExtendCueTime = EXT_BEGIN;
    // Wenn nicht mehrere Cues in Folge abgespielt werden sollen, dann auch 'Ende Erweitern' ermglichen
    if(!PopupMenuCuePlayer_AutoContinue->Checked) nExtendCueTime |= EXT_END;
    Play(nCue);
    if(!bPlaying) EnableControls();     // nur fr den Fehlerfall, damit der Button wieder nach oben geht...
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ButtonStopClick(TObject *Sender)
{
  bStopped = true;
  Stop();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::TrackBarPlayChange(TObject *Sender)
{
  if(!bAcceptTrackBarPlayChangeEvent) return;

  if(bPlaying)
  {
    int nSampleOffset = nPlaySampleOffset + (int)((hyper)nPlaySamples * TrackBarPlay->Position / TrackBarPlay->Max);
    if(nSampleOffset != nChangedPlaySampleOffsetPrev) // "Stottern" vermeiden
    {
      nChangedPlaySampleOffset = nSampleOffset;
      waveOutReset(WaveHandle);
//      Application->ProcessMessages(); // doch wieder auskommentiert, da sonst Wiedergabe beim Schieben "abgehackt"
    }
  }
  else
  {
    DisplayPlay();
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuGenCuesClick(TObject *Sender)
{
  GenerateCues();
}
//---------------------------------------------------------------------------
// Popup-Men fr Cue-Player
//---------------------------------------------------------------------------

void __fastcall TForm1::PopupMenuCuePlayer_AutoContinueClick(TObject *Sender)
{
  PopupMenuCuePlayer_AutoContinue->Checked = !PopupMenuCuePlayer_AutoContinue->Checked;
}

void __fastcall TForm1::PopupMenuCuePlayer_SkipCuePointsClick(TObject *Sender)
{
  PopupMenuCuePlayer_SkipCuePoints->Checked = !PopupMenuCuePlayer_SkipCuePoints->Checked;
}

void __fastcall TForm1::PopupMenuCuePlayer_PlayCuePointsToNextCueClick(TObject *Sender)
{
  PopupMenuCuePlayer_PlayCuePointsToNextCue->Checked = true;
  DisplayPlay();
}

void __fastcall TForm1::PopupMenuCuePlayer_PlayCuePointsToEndOfFileClick(TObject *Sender)
{
  PopupMenuCuePlayer_PlayCuePointsToEndOfFile->Checked = true;
  DisplayPlay();
}

void __fastcall TForm1::PopupMenuCuePlayer_PlayCuePointsNotAtAllClick(TObject *Sender)
{
  PopupMenuCuePlayer_PlayCuePointsNotAtAll->Checked = true;
  DisplayPlay();
}

void __fastcall TForm1::PopupMenuCuePlayer_PrePostAuditionClick(TObject *Sender)
{
  PopupMenuCuePlayer_PrePostAudition->Checked = !PopupMenuCuePlayer_PrePostAudition->Checked;
}

void __fastcall TForm1::PopupMenuCuePlayer_PreferencesClick(TObject *Sender)
{
  FormSettings->PageControlSettings->ActivePage = FormSettings->TabSheetPlayer;
  Settings();
}

void __fastcall TForm1::PopupMenuCuePlayer_CloseClick(TObject *Sender)
{
  return;
}

void __fastcall TForm1::PopupMenuCuePlayer_DisplayTotalTimeClick(TObject *Sender)
{
  PopupMenuCuePlayer_DisplayTotalTime->Checked = !PopupMenuCuePlayer_DisplayTotalTime->Checked;
  DisplayPlay();
}

void __fastcall TForm1::PopupMenuCuePlayer_DisplayRemainingTimeClick(TObject *Sender)
{
  PopupMenuCuePlayer_DisplayRemainingTime->Checked = !PopupMenuCuePlayer_DisplayRemainingTime->Checked;
  DisplayPlay();
}

void __fastcall TForm1::PopupMenuCuePlayer_RollBackOnReleasePauseClick(TObject *Sender)
{
  PopupMenuCuePlayer_RollBackOnReleasePause->Checked = !PopupMenuCuePlayer_RollBackOnReleasePause->Checked;
}

void __fastcall TForm1::PopupMenuCuePlayer_PlayCueUnderCursorClick(TObject *Sender)
{
  PlayCueUnderCursor();
}

//---------------------------------------------------------------------------
// Popup-Men fr Cue-Zeiten
//---------------------------------------------------------------------------
void __fastcall TForm1::PopupMenuCueTimes_1Click(TObject *Sender)
{
  PopupMenuCueTimes_1->Checked = true;
}

void __fastcall TForm1::PopupMenuCueTimes_10Click(TObject *Sender)
{
  PopupMenuCueTimes_10->Checked = true;
}

void __fastcall TForm1::PopupMenuCueTimes_100Click(TObject *Sender)
{
  PopupMenuCueTimes_100->Checked = true;
}

void __fastcall TForm1::PopupMenuCueTimes_1000Click(TObject *Sender)
{
  PopupMenuCueTimes_1000->Checked = true;
}

void __fastcall TForm1::PopupMenuCueTimes_SamplesClick(TObject *Sender)
{
  PopupMenuCueTimes_Samples->Checked = true;
}

void __fastcall TForm1::PopupMenuCueTimes_MillisecondsClick(TObject *Sender)
{
  PopupMenuCueTimes_Milliseconds->Checked = true;
}

void __fastcall TForm1::PopupMenuCueTimes_FramesClick(TObject *Sender)
{
  PopupMenuCueTimes_Frames->Checked = true;
}

//---------------------------------------------------------------------------
// Popup-Men fr Auswahl der externen Applikation
//---------------------------------------------------------------------------

void __fastcall TForm1::PopupMenuExtAppPopup(TObject *Sender)
{
  InitExtAppMenuItems();
}

void __fastcall TForm1::PopupMenuExtApp_ConfigureClick(TObject *Sender)
{
  FormSettings->PageControlSettings->ActivePage = FormSettings->TabSheetExtApp;
  Settings();
}

void __fastcall TForm1::PopupMenuExtApp1Click(TObject *Sender)
{
  SetExtApp(0);
  StartExtApp();
}

void __fastcall TForm1::PopupMenuExtApp2Click(TObject *Sender)
{
  SetExtApp(1);
  StartExtApp();
}

void __fastcall TForm1::PopupMenuExtApp3Click(TObject *Sender)
{
  SetExtApp(2);
  StartExtApp();
}

void __fastcall TForm1::PopupMenuExtApp4Click(TObject *Sender)
{
  SetExtApp(3);
  StartExtApp();
}

void __fastcall TForm1::PopupMenuExtApp5Click(TObject *Sender)
{
  SetExtApp(4);
  StartExtApp();
}

void __fastcall TForm1::PopupMenuExtApp6Click(TObject *Sender)
{
  SetExtApp(5);
  StartExtApp();
}

void __fastcall TForm1::PopupMenuExtApp7Click(TObject *Sender)
{
  SetExtApp(6);
  StartExtApp();
}

void __fastcall TForm1::PopupMenuExtApp8Click(TObject *Sender)
{
  SetExtApp(7);
  StartExtApp();
}

void __fastcall TForm1::PopupMenuExtApp9Click(TObject *Sender)
{
  SetExtApp(8);
  StartExtApp();
}

void __fastcall TForm1::PopupMenuExtApp0Click(TObject *Sender)
{
  SetExtApp(9);
  StartExtApp();
}

void __fastcall TForm1::ButtonEditorClick(TObject *Sender)
{
  StartExtApp();
}
//---------------------------------------------------------------------------
// Popup-Men fr StringGrid
//---------------------------------------------------------------------------
void __fastcall TForm1::PopupMenuStringGrid_PlayCueNormalClick(TObject *Sender)
{
  PopupMenuCuePlayer_PrePostAudition->Checked = false;
  PlayCueUnderCursor();
}

void __fastcall TForm1::PopupMenuStringGrid_PlayCueExtendedClick(TObject *Sender)
{
  PopupMenuCuePlayer_PrePostAudition->Checked = true;
  PlayCueUnderCursor();
}

void __fastcall TForm1::PopupMenuStringGrid_SetCueBeginClick(TObject *Sender)
{
  if(PageControlCueList->ActivePage == TabSheetEdit) SetCueBeginEnd(StringGrid->Row - 1, 0);    // 0 = Begin
}

void __fastcall TForm1::PopupMenuStringGrid_SetCueEndClick(TObject *Sender)
{
  if(PageControlCueList->ActivePage == TabSheetEdit) SetCueBeginEnd(StringGrid->Row - 1, 1);    // 1 = End
}

void __fastcall TForm1::PopupMenuStringGrid_AddCueClick(TObject *Sender)
{
  if(PageControlCueList->ActivePage == TabSheetEdit) AddCue(StringGrid->Row - 1);
}

void __fastcall TForm1::PopupMenuStringGrid_DuplicateCueClick(TObject *Sender)
{
  DuplicateCue(StringGrid->Row - 1);
}

void __fastcall TForm1::PopupMenuStringGrid_DeleteCueClick(TObject *Sender)
{
  DeleteCue(StringGrid->Row - 1);
}

//---------------------------------------------------------------------------
// Popup-Men fr RichEdit-Feld
//---------------------------------------------------------------------------
void __fastcall TForm1::PopupMenuViewWindow_PlayCueNormalClick(TObject *Sender)
{
  PopupMenuCuePlayer_PrePostAudition->Checked = false;
  PlayCueUnderCursor();
}

void __fastcall TForm1::PopupMenuViewWindow_PlayCueExtendedClick(TObject *Sender)
{
  PopupMenuCuePlayer_PrePostAudition->Checked = true;
  PlayCueUnderCursor();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuSettingsClick(TObject *Sender)
{
  FormSettings->PageControlSettings->ActivePage = FormSettings->TabSheetOptions;
  Settings();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::StringGridSelectCell(TObject *Sender, int ACol,
      int ARow, bool &CanSelect)
{
  // Da die Variablen ACol und ARow die *neuen* Positionen enthalten, StringGrid->Row
  // aber noch auf dem alten Wert steht, wrde GetSelectedExample() in DrawWaveform()
  // ein falsches Ergebnis liefern. Deshalb wird zuerst StringGrid->Row = ARow gesetzt.
  // Da dies aber diese Funktion erneut aufrufen wrde, mu ein rekursiver Aufruf
  // unterbunden werden:
  static bool bInsideFunction = false;
  if(bInsideFunction) return;
  bInsideFunction = true;
  StringGrid->Row = ARow;
  DisplayCueDetails();
  bInsideFunction = false;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ComboBoxCueTypeChange(TObject *Sender)
{
  if(bDisplayCueDetails) return; // Wenn gerade die Details aktualisiert werden, dann nicht reagieren!
  bCueTypeChanged = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::EditCueLabelChange(TObject *Sender)
{
  if(bDisplayCueDetails) return; // Wenn gerade die Details aktualisiert werden, dann nicht reagieren!
  bCueLabelChanged = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::EditCueDescriptionChange(TObject *Sender)
{
  if(bDisplayCueDetails) return; // Wenn gerade die Details aktualisiert werden, dann nicht reagieren!
  bCueDescriptionChanged = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::ComboBoxCueTypeExit(TObject *Sender)
{
  if(!bCueTypeChanged) return;
  bCueTypeChanged = false;

  int iCue = StringGrid->Row - 1;
  if(iCue < 0 || iCue >= nCues) return;

  CueArray[iCue].Type = CueStringToType(ComboBoxCueType->Text);

  SetDirtyFlag();
  Display(true);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::EditCueLabelExit(TObject *Sender)
{
  if(!bCueLabelChanged) return;
  bCueLabelChanged = false;

  int iCue = StringGrid->Row - 1;
  if(iCue < 0 || iCue >= nCues) return;

  CueArray[iCue].Label = EditCueLabel->Text;

  SetDirtyFlag();
  Display(true);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::EditCueDescriptionExit(TObject *Sender)
{
  if(!bCueDescriptionChanged) return;
  bCueDescriptionChanged = false;

  int iCue = StringGrid->Row - 1;
  if(iCue < 0 || iCue >= nCues) return;

  CueArray[iCue].Description = EditCueDescription->Text;

  SetDirtyFlag();
  Display(true);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::EditCueLabelEnter(TObject *Sender)
{
  MenuStartStopPlaying->ShortCut = 0;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::EditCueDescriptionEnter(TObject *Sender)
{
  MenuStartStopPlaying->ShortCut = 0;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::StringGridMouseDown(TObject *Sender,
      TMouseButton Button, TShiftState Shift, int X, int Y)
{
  int nRow, nCol;
  StringGrid->MouseToCell(X, Y, nCol, nRow); // Spalte und Zeile der Zelle, die angeklickt wurde

  if(Button == mbRight) // rechte Maustaste gedrckt
  {
    if(nRow > 0 && nRow != -1) StringGrid->Row = nRow;
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::StringGridDblClick(TObject *Sender)
{
  PlayCueUnderCursor();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuDeleteCueListClick(TObject *Sender)
{
  DeleteCueListFromAudioFile(strAudioFileName);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::UpDownCueBeginClick(TObject *Sender, TUDBtnType Button)
{
  EditCueBegin->SetFocus();
  ChangeCueBegin(Button == Comctrls::btNext);
  bCueBeginChanged = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::UpDownCueEndClick(TObject *Sender, TUDBtnType Button)
{
  EditCueEnd->SetFocus();
  ChangeCueLength(Button == Comctrls::btNext);
  bCueLengthChanged = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::UpDownCueLengthClick(TObject *Sender, TUDBtnType Button)
{
  EditCueLength->SetFocus();
  ChangeCueLength(Button == Comctrls::btNext);
  bCueLengthChanged = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::EditCueBeginExit(TObject *Sender)
{
  if(!bCueBeginChanged) return;
  bCueBeginChanged = false;
  Display(true);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::EditCueEndExit(TObject *Sender)
{
  if(!bCueLengthChanged) return;
  bCueLengthChanged = false;
  Display(true);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::EditCueLengthExit(TObject *Sender)
{
  if(!bCueLengthChanged) return;
  bCueLengthChanged = false;
  Display(true);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::EditCueBeginKeyDown(TObject *Sender, WORD &Key, TShiftState Shift)
{
  if(Key == VK_UP)
  {
    ChangeCueBegin(true);
    bCueBeginChanged = true;
    Key = 0;
  }
  else if(Key == VK_DOWN)
  {
    ChangeCueBegin(false);
    bCueBeginChanged = true;
    Key = 0;
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::EditCueLengthKeyDown(TObject *Sender, WORD &Key, TShiftState Shift)
{
  if(Key == VK_UP)
  {
    ChangeCueLength(true);
    bCueLengthChanged = true;
    Key = 0;
  }
  else if(Key == VK_DOWN)
  {
    ChangeCueLength(false);
    bCueLengthChanged = true;
    Key = 0;
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuStartStopPlayingClick(TObject *Sender)
{
  PlayCueUnderCursor(!bPlaying);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuDisplayFormatPopup(TObject *Sender)
{
  // Remove items from menu
  while (MenuDisplayFormat->Count > 1)
    MenuDisplayFormat->Delete(0);

  // Copy indexes of display formats to new int array
  int *Indexes = new int[nNumberDisplayFormats];
  for(int i = 0; i < nNumberDisplayFormats; i++)
    Indexes[i] = i;

  // Bubblesort
  for(int iEnde = nNumberDisplayFormats - 1; iEnde >= 0 ; iEnde--)
  {
    for(int iElement = 0; iElement < iEnde; iElement++)
    {
      if(DisplayFormat[Indexes[iElement]].strName.AnsiCompare(DisplayFormat[Indexes[iElement + 1]].strName) > 0)
      {
        int iTemp = Indexes[iElement];
        Indexes[iElement] = Indexes[iElement + 1];
        Indexes[iElement + 1] = iTemp;
      }
    }
  }

  // Insert items into menu
  for(int i = 0; i < nNumberDisplayFormats; i++)
  {
    TMenuItem *item = new TMenuItem(MenuDisplayFormat);
    MenuDisplayFormat->Insert(i, item);

    item->Tag = Indexes[i];
    item->Caption = DisplayFormat[Indexes[i]].strName;
//    item->ImageIndex = 0;
    item->RadioItem = true;
    item->GroupIndex = 1;
    item->Checked = (Indexes[i] == GetIndexOfSelectedDisplayFormat());
    item->OnClick = MenuDisplayFormatItemClick;
  }

  delete[] Indexes;

  MenuDisplayFormat->InsertNewLineBefore(MenuDisplayFormat->Items[MenuDisplayFormat->Count - 1]);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::MenuDisplayFormatItemClick(TObject *Sender)
{
  TMenuItem *item = dynamic_cast<TMenuItem *>(Sender);
  if (item)
  {
    SelectDisplayFormat(item->Tag);
  }
}
//---------------------------------------------------------------------------

void TForm1::GetVersionInfo(int& nMajor, int& nMinor, int& nRevision, int& nBuild)
{
  bool DEBUG = false;

  DWORD dwSize = GetFileVersionInfoSize(Application->ExeName.c_str(), 0);
  if (dwSize > 0)
  {
    if (DEBUG) RichEditCueList->Lines->Add("VersionInfoSize = " + IntToStr(dwSize));

    char* pVersionInfo = new char[dwSize];
    GetFileVersionInfo(Application->ExeName.c_str(), 0, dwSize, pVersionInfo);

    VS_FIXEDFILEINFO *pFileInfo;
    UINT nLen;
    VerQueryValue(pVersionInfo, "\\", (LPVOID*)&pFileInfo, &nLen);
    delete[] pFileInfo;

    nMajor = HIWORD(pFileInfo->dwFileVersionMS);
    nMinor = LOWORD(pFileInfo->dwFileVersionMS);
    nRevision = HIWORD(pFileInfo->dwFileVersionLS);
    nBuild = LOWORD(pFileInfo->dwFileVersionLS);

    if (DEBUG)
    {
      String strVersion;
      strVersion.sprintf("%d.%d.%d.%d", nMajor, nMinor, nRevision, nBuild);
      RichEditCueList->Lines->Add("Version = " + strVersion);

      WORD* wLangInfo;
      VerQueryValue(pVersionInfo, "\\VarFileInfo\\Translation",(LPVOID*)&wLangInfo, &nLen);

      const String strInfoStringArray[10] = {"CompanyName", "FileDescription", "FileVersion", "InternalName", "LegalCopyright", "LegalTradeMarks", "OriginalFileName", "ProductName", "ProductVersion", "Comments"};
      //for (int i = 0; i < strInfoStringArray->Length(); i++)
      for (int i = 0; i < 10; i++)
      {
        String strSubBlock;
        strSubBlock.sprintf("\\StringFileInfo\\%04x%04x\\%s", wLangInfo[0], wLangInfo[1], strInfoStringArray[i]);

        char* pszValue;
        if (VerQueryValue(pVersionInfo, strSubBlock.c_str(), (LPVOID*)&pszValue, &nLen))
        {
          RichEditCueList->Lines->Add(strInfoStringArray[i] + " = " + pszValue);
        }
      }
    }

    delete[] pVersionInfo;
  }
  else
  {
    if (DEBUG) RichEditCueList->Lines->Add("No version information found.");
  }
}
//---------------------------------------------------------------------------

