;#define VERSION_FULL GetEnv('VERSION_FULL')
;#define VERSION GetEnv('VERSION')
;#define YEAR GetEnv('YEAR')

#define VERSION_FULL GetStringFileInfo("cueltool.exe", "FileVersion")
#define VERSION RemoveFileExt(VERSION_FULL)
#define YEAR GetFileDateTimeString("cueltool.exe", "yyyy", ".", ":");

[Setup]
AppName=CueListTool
AppVersion={#VERSION}
AppVerName=CueListTool {#VERSION}
AppCopyright=Copyright  2001-{#YEAR} by Stefan Bion
AppComments=The Swiss Army Knife for Cue Lists and Cue Sheets
AppPublisher=Stefan Bion
AppPublisherURL=https://www.stefanbion.de/cuelisttool/

VersionInfoProductName=CueListTool
VersionInfoVersion={#VERSION_FULL}
VersionInfoProductVersion={#VERSION}
VersionInfoCopyright=Copyright  2001-{#YEAR} by Stefan Bion
VersionInfoDescription=The Swiss Army Knife for Cue Lists and Cue Sheets
VersionInfoCompany=Stefan Bion

PrivilegesRequired=lowest
DisableStartupPrompt=yes
InfoBeforeFile=readme.txt
DefaultDirName={userpf}\CueListTool
DefaultGroupName=CueListTool
UninstallDisplayIcon={app}\cueltool.exe
OutputDir=.
OutputBaseFilename=cltsetup
WizardImageFile=install.bmp
WizardSmallImageFile=icon32x32x24.bmp
ChangesAssociations=yes
DisableWelcomePage=no

[Files]
Source: "readme.txt"; DestDir: "{app}"
Source: "manual.chm"; DestDir: "{app}"
Source: "cueltool.exe"; DestDir: "{app}"

[Icons]
Name: "{userdesktop}\CueListTool"; Filename: "{app}\cueltool.exe"; WorkingDir: "{app}"
Name: "{group}\CueListTool"; Filename: "{app}\cueltool.exe"; WorkingDir: "{app}"
Name: "{group}\CueListTool Manual"; Filename: "{app}\manual.chm"; WorkingDir: "{app}"
Name: "{group}\CueListTool Readme"; Filename: "{app}\readme.txt"; WorkingDir: "{app}"

[UninstallDelete]
Type: files; Name: "{app}\cueltool.ini"

[Registry]
Root: HKA; Subkey: "Software\Classes\.clt"; ValueType: string; ValueName: ""; ValueData: "CueListTool"; Flags: uninsdeletevalue
Root: HKA; Subkey: "Software\Classes\CueListTool"; ValueType: string; ValueName: ""; ValueData: "Cue List File"; Flags: uninsdeletekey
Root: HKA; Subkey: "Software\Classes\CueListTool\DefaultIcon"; ValueType: string; ValueName: ""; ValueData: "{app}\cueltool.exe,0" 
Root: HKA; Subkey: "Software\Classes\CueListTool\shell\open\command"; ValueType: string; ValueName: ""; ValueData: """{app}\cueltool.exe"" ""%1""" 
