//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "gencues.h"
#include "main.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFormGenCues *FormGenCues;
//---------------------------------------------------------------------------
__fastcall TFormGenCues::TFormGenCues(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TFormGenCues::FormShow(TObject *Sender)
{
  if(ButtonOK->Enabled)
    ActiveControl = ButtonOK;
  else
    ActiveControl = ButtonCancel;

  EnableButtonOK();
  FormGenCues->Left = Form1->Left + (Form1->Width - FormGenCues->Width) / 2;
  FormGenCues->Top = Form1->Top + (Form1->Height - FormGenCues->Height) / 2;
  CalculateNumberAndLastCue();
  bAcceptChangeEvents = true;
}
//---------------------------------------------------------------------------
void TFormGenCues::EnableButtonOK(void)
{
  ButtonOK->Enabled =
    !EditDistance->Text.IsEmpty() &&
    !EditFirstCue->Text.IsEmpty() &&
    (RadioButtonHowManyCues->Checked ? !EditHowManyCues->Text.IsEmpty() : !EditLastCueAt->Text.IsEmpty()) &&
    !EditCueLabels->Text.IsEmpty() &&
    !EditStartNumber->Text.IsEmpty();
}
//---------------------------------------------------------------------------
void __fastcall TFormGenCues::OnControlChange(TObject *Sender)
{
  EnableButtonOK();
}
//---------------------------------------------------------------------------
void __fastcall TFormGenCues::EditDistanceChange(TObject *Sender)
{
  EnableButtonOK();
  CalculateNumberAndLastCue();
}
//---------------------------------------------------------------------------
void __fastcall TFormGenCues::EditFirstCueChange(TObject *Sender)
{
  EnableButtonOK();
  CalculateNumberAndLastCue();
}
//---------------------------------------------------------------------------
void TFormGenCues::CalculateNumberAndLastCue(void)
{
  if(nSamples == 0 || nSamplesPerSec == 0) return;

  bool bError = false;
  Extended fDistance; try { fDistance = StrToFloat(EditDistance->Text); } catch(...) { bError = true; }
  Extended fFirstCue; try { fFirstCue = StrToFloat(EditFirstCue->Text); } catch(...) { bError = true; }
  if(bError) return;

  int nSamplesDistance = fDistance * nSamplesPerSec;
  int nSamplesFirstCue = fFirstCue * nSamplesPerSec;

  if(nSamplesDistance == 0) return;
  if(nSamplesFirstCue + (RadioButtonRanges->Checked ? 1 : 0) * nSamplesDistance > nSamples) return;

  int nCues = (nSamples - nSamplesFirstCue - (RadioButtonRanges->Checked ? 1 : 0) * nSamplesDistance) / nSamplesDistance + 1;
  int nSamplesLastCue = nSamplesFirstCue + (nCues - 1) * nSamplesDistance;

  Extended fLastCueAt = (Extended)(nSamplesLastCue) / nSamplesPerSec;

  bAcceptChangeEvents = false;
  EditHowManyCues->Text = IntToStr(nCues);
  EditLastCueAt->Text = FloatToStr(fLastCueAt);
  bAcceptChangeEvents = true;
}
//---------------------------------------------------------------------------
void __fastcall TFormGenCues::EditHowManyCuesChange(TObject *Sender)
{
  EnableButtonOK();
  if(!bAcceptChangeEvents) return;
  RadioButtonHowManyCues->Checked = true;
}
//---------------------------------------------------------------------------
void __fastcall TFormGenCues::EditLastCueAtChange(TObject *Sender)
{
  EnableButtonOK();
  if(!bAcceptChangeEvents) return;
  RadioButtonLastCueAt->Checked = true;
}
//---------------------------------------------------------------------------

void __fastcall TFormGenCues::RadioButtonPointsClick(TObject *Sender)
{
  CalculateNumberAndLastCue();
}
//---------------------------------------------------------------------------

void __fastcall TFormGenCues::RadioButtonRangesClick(TObject *Sender)
{
  CalculateNumberAndLastCue();
}
//---------------------------------------------------------------------------

