//---------------------------------------------------------------------------
#ifndef dispformH
#define dispformH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include "CSPIN.h"
#include <ExtCtrls.hpp>
//---------------------------------------------------------------------------
class TFormDisplayFormat : public TForm
{
__published:	// Von der IDE verwaltete Komponenten
        TButton *ButtonOK;
        TButton *ButtonCancel;
        TLabel *Label1;
        TEdit *EditFormatPoints;
        TLabel *Label2;
        TEdit *EditFormatTime;
        TButton *ButtonDefaultPoints;
        TButton *ButtonDefaultTime;
        TLabel *Label3;
        TLabel *Label4;
        TLabel *Label6;
        TEdit *EditFormatRanges;
        TButton *ButtonDefaultRanges;
        TCSpinEdit *CSpinEditFractionalDigitsHrs;
        TLabel *Label8;
        TCSpinEdit *CSpinEditLeadingDigitsHrs;
        TLabel *Label9;
        TCSpinEdit *CSpinEditLeadingDigitsMin;
        TCSpinEdit *CSpinEditFractionalDigitsMin;
        TCSpinEdit *CSpinEditLeadingDigitsSec;
        TCSpinEdit *CSpinEditFractionalDigitsSec;
        TLabel *Label5;
        TLabel *Label7;
        TLabel *Label10;
        TLabel *Label11;
        TEdit *EditSeparator;
        TLabel *Label12;
        TBevel *Bevel1;
        TBevel *Bevel2;
        TEdit *EditFormatSummary;
        TButton *ButtonDefaultSummary;
        TCheckBox *CheckBoxSummary;
        TLabel *Label14;
        TLabel *Label13;
        TLabel *Label15;
        TCheckBox *CheckBoxHeader;
        TEdit *EditFormatHeader;
        TButton *ButtonDefaultHeader;
        TBevel *Bevel3;
        TCSpinEdit *CSpinEditLeadingDigitsFrm;
        TCSpinEdit *CSpinEditFractionalDigitsFrm;
        TCSpinEdit *CSpinEditLeadingDigitsSmp;
        TCSpinEdit *CSpinEditFractionalDigitsSmp;
        TLabel *Label16;
        TLabel *Label17;
        TBevel *Bevel4;
        TLabel *Label18;
        TComboBox *ComboBoxPresets;
        TButton *ButtonDelete;
        TButton *ButtonAdd;
        void __fastcall FormShow(TObject *Sender);
        void __fastcall ButtonDefaultPointsClick(TObject *Sender);
        void __fastcall ButtonDefaultTimeClick(TObject *Sender);
        void __fastcall ButtonDefaultRangesClick(TObject *Sender);
        void __fastcall ButtonDefaultSummaryClick(TObject *Sender);
        void __fastcall ButtonDefaultHeaderClick(TObject *Sender);
        void __fastcall ComboBoxPresetsChange(TObject *Sender);
        void __fastcall ButtonAddClick(TObject *Sender);
        void __fastcall ComboBoxPresetsExit(TObject *Sender);
        void __fastcall FormActivate(TObject *Sender);
        void __fastcall ButtonDeleteClick(TObject *Sender);
        void __fastcall ComboBoxPresetsKeyPress(TObject *Sender,
          char &Key);
private:	// Anwenderdeklarationen
        bool bIgnoreChanges;
        String strItemTextSave;

        void AddPresetBegin(void);
        void AddPresetEnd(void);
        void DeletePreset(void);
        void DeletePreset(int nDisplayFormatToDelete);

public:		// Anwenderdeklarationen

        // Anzeigeformate
        #define DEFAULT_FORMAT_RANGES "%cue) %type: %begin - %end %note%sep%label (%length)"
        #define DEFAULT_FORMAT_POINTS "%cue) %type: %begin %note%sep%label"
        #define DEFAULT_FORMAT_TIME "%m:%s"
        #define DEFAULT_SEP " - "
        #define DEFAULT_FORMAT_HEADER "File: %file%nl"
        #define DEFAULT_FORMAT_SUMMARY "%nlCue ranges:%tab%ranges%tab|  CD title:%tab%title%nlCue points:%tab%points%tab|  Performer:%tab%perf%nlCues total:%tab%cues%tab|  Total time:%tab%time"
        String GetDefaultFormatRanges(void) { return DEFAULT_FORMAT_RANGES; }
        String GetDefaultFormatPoints(void) { return DEFAULT_FORMAT_POINTS; }
        String GetDefaultFormatTime(void) { return DEFAULT_FORMAT_TIME; }
        String GetDefaultSeparator(void) { return DEFAULT_SEP; }
        String GetDefaultFormatHeader(void) { return DEFAULT_FORMAT_HEADER; }
        String GetDefaultFormatSummary(void) { return DEFAULT_FORMAT_SUMMARY; }

        __fastcall TFormDisplayFormat(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TFormDisplayFormat *FormDisplayFormat;
//---------------------------------------------------------------------------
#endif

