//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "main.h"
#include "dispform.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma link "CSPIN"
#pragma resource "*.dfm"
TFormDisplayFormat *FormDisplayFormat;
//---------------------------------------------------------------------------
__fastcall TFormDisplayFormat::TFormDisplayFormat(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TFormDisplayFormat::FormShow(TObject *Sender)
{
  ActiveControl = ButtonOK;
  FormDisplayFormat->Left = Form1->Left + (Form1->Width - FormDisplayFormat->Width) / 2;
  FormDisplayFormat->Top = Form1->Top + (Form1->Height - FormDisplayFormat->Height) / 2;
}
//---------------------------------------------------------------------------
void __fastcall TFormDisplayFormat::ButtonDefaultPointsClick(
      TObject *Sender)
{
  EditFormatPoints->Text = DEFAULT_FORMAT_POINTS;
  EditSeparator->Text = DEFAULT_SEP;
}
//---------------------------------------------------------------------------
void __fastcall TFormDisplayFormat::ButtonDefaultRangesClick(
      TObject *Sender)
{
  EditFormatRanges->Text = DEFAULT_FORMAT_RANGES;
  EditSeparator->Text = DEFAULT_SEP;
}
//---------------------------------------------------------------------------
void __fastcall TFormDisplayFormat::ButtonDefaultTimeClick(TObject *Sender)
{
  EditFormatTime->Text = DEFAULT_FORMAT_TIME;
}
//---------------------------------------------------------------------------
void __fastcall TFormDisplayFormat::ButtonDefaultSummaryClick(
      TObject *Sender)
{
  EditFormatSummary->Text = DEFAULT_FORMAT_SUMMARY;
}
//---------------------------------------------------------------------------

void __fastcall TFormDisplayFormat::ButtonDefaultHeaderClick(
      TObject *Sender)
{
  EditFormatHeader->Text = DEFAULT_FORMAT_HEADER;
}

//---------------------------------------------------------------------------
// Presets
//---------------------------------------------------------------------------

void __fastcall TFormDisplayFormat::ComboBoxPresetsChange(TObject *Sender)
{
  if(bIgnoreChanges) return;
  if(ComboBoxPresets->ItemIndex == -1) return;

  for(int iDisplayFormat = 0; iDisplayFormat < Form1->nNumberDisplayFormats; iDisplayFormat++)
  {
    if(Form1->DisplayFormat[iDisplayFormat].strName == ComboBoxPresets->Text)
    {
      EditFormatPoints->Text = Form1->DisplayFormat[iDisplayFormat].strFormatPoints;
      EditFormatRanges->Text = Form1->DisplayFormat[iDisplayFormat].strFormatRanges;
      EditFormatTime->Text = Form1->DisplayFormat[iDisplayFormat].strFormatTime;
      EditSeparator->Text = Form1->DisplayFormat[iDisplayFormat].strFormatSeparator;
      EditFormatHeader->Text = Form1->DisplayFormat[iDisplayFormat].strFormatHeader;
      EditFormatSummary->Text = Form1->DisplayFormat[iDisplayFormat].strFormatSummary;
      CheckBoxHeader->Checked = Form1->DisplayFormat[iDisplayFormat].bFormatHeaderEnabled;
      CheckBoxSummary->Checked = Form1->DisplayFormat[iDisplayFormat].bFormatSummaryEnabled;
      CSpinEditLeadingDigitsHrs->Value = Form1->DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsHrs;
      CSpinEditFractionalDigitsHrs->Value = Form1->DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsHrs;
      CSpinEditLeadingDigitsMin->Value = Form1->DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsMin;
      CSpinEditFractionalDigitsMin->Value = Form1->DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsMin;
      CSpinEditLeadingDigitsSec->Value = Form1->DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsSec;
      CSpinEditFractionalDigitsSec->Value = Form1->DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsSec;
      CSpinEditLeadingDigitsFrm->Value = Form1->DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsFrm;
      CSpinEditFractionalDigitsFrm->Value = Form1->DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsFrm;
      CSpinEditLeadingDigitsSmp->Value = Form1->DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsSmp;
      CSpinEditFractionalDigitsSmp->Value = Form1->DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsSmp;

      return;
    }
  }
}

void __fastcall TFormDisplayFormat::ComboBoxPresetsKeyPress(TObject *Sender, char &Key)
{
  if(!bIgnoreChanges) return;

  if(Key == VK_ESCAPE)
  {
    ComboBoxPresets->Color = clBtnFace;
    ComboBoxPresets->Text = strItemTextSave;
    bIgnoreChanges = false;
  }
}

void __fastcall TFormDisplayFormat::ButtonAddClick(TObject *Sender)
{
  AddPresetBegin();
}

void __fastcall TFormDisplayFormat::ButtonDeleteClick(TObject *Sender)
{
  DeletePreset();
}

void __fastcall TFormDisplayFormat::ComboBoxPresetsExit(TObject *Sender)
{
  AddPresetEnd();
}

void TFormDisplayFormat::AddPresetBegin(void)
{
  if(bIgnoreChanges) return;

  bIgnoreChanges = true;
  strItemTextSave = ComboBoxPresets->Text;
  ComboBoxPresets->Text = "";
  ComboBoxPresets->SetFocus();
  ComboBoxPresets->Color = clWindow;
}

void TFormDisplayFormat::AddPresetEnd(void)
{
  if(!bIgnoreChanges) return;

  static bool bInsideFunction = false;
  if(bInsideFunction) return;
  bInsideFunction = true;

  ComboBoxPresets->Color = clBtnFace;

  // Kein Text eingegeben -> alten Wert wieder anzeigen und fertig
  String strNewPresetName = ComboBoxPresets->Text;
  if(strNewPresetName.IsEmpty())
  {
    ComboBoxPresets->Text = strItemTextSave;
    bIgnoreChanges = false;
    bInsideFunction = false;
    return;
  }

  // Prfen, ob der Preset-Name bereits in der Combobox existiert
  bool bReplace = false;
  int nItemToReplace = ComboBoxPresets->Items->IndexOf(strNewPresetName);

  if(nItemToReplace != -1)
  {
    // Wenn ja, fragen, ob der Preset berschrieben werden soll
    if(MessageBox(Handle, ("Preset '" + strNewPresetName + "' already exists. Replace?").c_str(), "Warning", MB_YESNO|MB_ICONWARNING|MB_APPLMODAL) == IDYES)
    {
      // Ja -> "Ersetzen"-Flag setzen
      bReplace = true;
    }
    else
    {
      // Nein -> alten Wert wieder anzeigen und fertig
      ComboBoxPresets->Text = strItemTextSave;
      bIgnoreChanges = false;
      bInsideFunction = false;
      return;
    }
  }

  // Index fr das hinzuzufgende Preset im DisplayFormat-Array bestimmen
  int iDisplayFormat;

  // a) Wenn der Preset-Name schon existiert, das zugehrige Preset-Element im Array suchen
  if(bReplace)
  {
    for(iDisplayFormat = 0; iDisplayFormat < Form1->nNumberDisplayFormats; iDisplayFormat++)
    {
      if(Form1->DisplayFormat[iDisplayFormat].strName == ComboBoxPresets->Text) break;
    }
    // Wenn kein Element gefunden, dann das Preset nicht ersetzen, sondern hinzufgen.
    // Dazu vorher den (berflssigen) Eintrag aus der Combobox lschen
    if(iDisplayFormat == Form1->nNumberDisplayFormats)
    {
      ComboBoxPresets->Items->Delete(nItemToReplace);
      bReplace = false;
    }
  }

  // b) Neues Array-Element anhngen
  if(!bReplace)
  {
    if(Form1->nNumberDisplayFormats + 1 >= Form1->MAX_DISPLAYFORMATS)
    {
      MessageBox(Handle, ("Maximum number of presets (" + IntToStr(Form1->MAX_DISPLAYFORMATS) + ") reached.").c_str(), "Error", MB_OK|MB_ICONERROR|MB_APPLMODAL);
      ComboBoxPresets->Text = strItemTextSave;
      bIgnoreChanges = false;
      bInsideFunction = false;
      return;
    }
    ComboBoxPresets->Items->Add(strNewPresetName);
    iDisplayFormat = Form1->nNumberDisplayFormats;
    Form1->nNumberDisplayFormats++;
  }

  Form1->DisplayFormat[iDisplayFormat].strName = strNewPresetName;
  Form1->DisplayFormat[iDisplayFormat].strFormatPoints = EditFormatPoints->Text;
  Form1->DisplayFormat[iDisplayFormat].strFormatRanges = EditFormatRanges->Text;
  Form1->DisplayFormat[iDisplayFormat].strFormatTime = EditFormatTime->Text;
  Form1->DisplayFormat[iDisplayFormat].strFormatSeparator = EditSeparator->Text;
  Form1->DisplayFormat[iDisplayFormat].strFormatHeader = EditFormatHeader->Text;
  Form1->DisplayFormat[iDisplayFormat].strFormatSummary = EditFormatSummary->Text;
  Form1->DisplayFormat[iDisplayFormat].bFormatHeaderEnabled = CheckBoxHeader->Checked;
  Form1->DisplayFormat[iDisplayFormat].bFormatSummaryEnabled = CheckBoxSummary->Checked;
  Form1->DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsHrs = CSpinEditLeadingDigitsHrs->Value;
  Form1->DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsHrs = CSpinEditFractionalDigitsHrs->Value;
  Form1->DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsMin = CSpinEditLeadingDigitsMin->Value;
  Form1->DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsMin = CSpinEditFractionalDigitsMin->Value;
  Form1->DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsSec = CSpinEditLeadingDigitsSec->Value;
  Form1->DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsSec = CSpinEditFractionalDigitsSec->Value;
  Form1->DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsFrm = CSpinEditLeadingDigitsFrm->Value;
  Form1->DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsFrm = CSpinEditFractionalDigitsFrm->Value;
  Form1->DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsSmp = CSpinEditLeadingDigitsSmp->Value;
  Form1->DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsSmp = CSpinEditFractionalDigitsSmp->Value;

  bIgnoreChanges = false;
  bInsideFunction = false;
}

void TFormDisplayFormat::DeletePreset(void)
{
  if(bIgnoreChanges) return;

  ComboBoxPresets->DroppedDown = true;  // Erforderlich, da sonst ItemIndex -1 ist.
  ComboBoxPresets->DroppedDown = false;

  int nItemToDelete = ComboBoxPresets->ItemIndex;
  if(nItemToDelete == -1) return;

  for(int iDisplayFormat = 0; iDisplayFormat < Form1->nNumberDisplayFormats; iDisplayFormat++)
  {
    if(Form1->DisplayFormat[iDisplayFormat].strName == ComboBoxPresets->Text)
    {
      DeletePreset(iDisplayFormat);
    }
  }

  ComboBoxPresets->Items->Delete(nItemToDelete);
}

void TFormDisplayFormat::DeletePreset(int nDisplayFormatToDelete)
{
  for(int iDisplayFormat = nDisplayFormatToDelete; iDisplayFormat < Form1->nNumberDisplayFormats - 1; iDisplayFormat++)
  {
    Form1->DisplayFormat[iDisplayFormat].strName = Form1->DisplayFormat[iDisplayFormat + 1].strName;
    Form1->DisplayFormat[iDisplayFormat].strFormatPoints = Form1->DisplayFormat[iDisplayFormat + 1].strFormatPoints;
    Form1->DisplayFormat[iDisplayFormat].strFormatRanges = Form1->DisplayFormat[iDisplayFormat + 1].strFormatRanges;
    Form1->DisplayFormat[iDisplayFormat].strFormatTime = Form1->DisplayFormat[iDisplayFormat + 1].strFormatTime;
    Form1->DisplayFormat[iDisplayFormat].strFormatSeparator = Form1->DisplayFormat[iDisplayFormat + 1].strFormatSeparator;
    Form1->DisplayFormat[iDisplayFormat].strFormatHeader = Form1->DisplayFormat[iDisplayFormat + 1].strFormatHeader;
    Form1->DisplayFormat[iDisplayFormat].strFormatSummary = Form1->DisplayFormat[iDisplayFormat + 1].strFormatSummary;
    Form1->DisplayFormat[iDisplayFormat].bFormatHeaderEnabled = Form1->DisplayFormat[iDisplayFormat + 1].bFormatHeaderEnabled;
    Form1->DisplayFormat[iDisplayFormat].bFormatSummaryEnabled = Form1->DisplayFormat[iDisplayFormat + 1].bFormatSummaryEnabled;
    Form1->DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsHrs = Form1->DisplayFormat[iDisplayFormat + 1].nFormatTimeLeadingDigitsHrs;
    Form1->DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsHrs = Form1->DisplayFormat[iDisplayFormat + 1].nFormatTimeFractionalDigitsHrs;
    Form1->DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsMin = Form1->DisplayFormat[iDisplayFormat + 1].nFormatTimeLeadingDigitsMin;
    Form1->DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsMin = Form1->DisplayFormat[iDisplayFormat + 1].nFormatTimeFractionalDigitsMin;
    Form1->DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsSec = Form1->DisplayFormat[iDisplayFormat + 1].nFormatTimeLeadingDigitsSec;
    Form1->DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsSec = Form1->DisplayFormat[iDisplayFormat + 1].nFormatTimeFractionalDigitsSec;
    Form1->DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsFrm = Form1->DisplayFormat[iDisplayFormat + 1].nFormatTimeLeadingDigitsFrm;
    Form1->DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsFrm = Form1->DisplayFormat[iDisplayFormat + 1].nFormatTimeFractionalDigitsFrm;
    Form1->DisplayFormat[iDisplayFormat].nFormatTimeLeadingDigitsSmp = Form1->DisplayFormat[iDisplayFormat + 1].nFormatTimeLeadingDigitsSmp;
    Form1->DisplayFormat[iDisplayFormat].nFormatTimeFractionalDigitsSmp = Form1->DisplayFormat[iDisplayFormat + 1].nFormatTimeFractionalDigitsSmp;
  }
  Form1->nNumberDisplayFormats--;
}

void __fastcall TFormDisplayFormat::FormActivate(TObject *Sender)
{
  bIgnoreChanges = true;

  ComboBoxPresets->Color = clBtnFace;
  ComboBoxPresets->Clear();

  // Combobox fllen
  for(int iItem = 0; iItem < Form1->nNumberDisplayFormats; iItem++)
  {
    ComboBoxPresets->Items->Add(Form1->DisplayFormat[iItem].strName);
  }

  // Gewhlten Eintrag selektieren
  int iDisplayFormat = Form1->GetIndexOfSelectedDisplayFormat();
  if (iDisplayFormat != -1)
    ComboBoxPresets->Text = Form1->DisplayFormat[iDisplayFormat].strName;

  bIgnoreChanges = false;
}
//---------------------------------------------------------------------------

