//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "main.h"
#include "cuesheet.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFormSaveCueSheet *FormSaveCueSheet;
//---------------------------------------------------------------------------
__fastcall TFormSaveCueSheet::TFormSaveCueSheet(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TFormSaveCueSheet::FormShow(TObject *Sender)
{
  ActiveControl = ButtonSave;
  bSaveButtonPressed = false;
  bSaveAndBurn = false;

  FormSaveCueSheet->Left = Form1->Left + (Form1->Width - FormSaveCueSheet->Width) / 2;
  FormSaveCueSheet->Top = Form1->Top + (Form1->Height - FormSaveCueSheet->Height) / 2;
}
//---------------------------------------------------------------------------
void __fastcall TFormSaveCueSheet::ButtonBrowseClick(TObject *Sender)
{
  OpenDialogAudiofile->FileName = EditAudioFileName->Text;
  if(!OpenDialogAudiofile->Execute()) return;
//  EditAudioFileName->Text = ExtractFileName(OpenDialogAudiofile->FileName);
  SetAudioFileName(OpenDialogAudiofile->FileName);
}
//---------------------------------------------------------------------------
void TFormSaveCueSheet::DisplayPerformerAndTitleFromAudioFileName(void)
{
  String strFileName = ExtractFileName(EditAudioFileName->Text.SubString(1, EditAudioFileName->Text.Length() - ExtractFileExt(EditAudioFileName->Text).Length()));

  if(!strFileName.IsEmpty())
  {
    int nPos = strFileName.Pos("-");
    if(nPos != 0)
    {
      EditTitle->Text = strFileName.SubString(nPos + 1, strFileName.Length() - nPos).Trim();
      EditPerformer->Text = strFileName.SubString(1, nPos - 1).Trim();
    }
    else
    {
      EditTitle->Text = strFileName;
      EditPerformer->Text = "";
    }
  }
}
//---------------------------------------------------------------------------
void TFormSaveCueSheet::SelectFileTag(void)
{
  ComboBoxFileTag->Text = ExtractFileExt(EditAudioFileName->Text).LowerCase() == ".mp3" ? "MP3" : "WAVE";
}
//---------------------------------------------------------------------------
void __fastcall TFormSaveCueSheet::EditAudioFileNameChange(TObject *Sender)
{
  DisplayPerformerAndTitleFromAudioFileName();
  SelectFileTag();
}
//---------------------------------------------------------------------------
void __fastcall TFormSaveCueSheet::FormCloseQuery(TObject *Sender,
      bool &CanClose)
{
  CanClose = true;

  if(bSaveButtonPressed)
  {
    bSaveButtonPressed = false;

    // Eigabefeld "Filename" berprfen
    if(EditAudioFileName->Text.IsEmpty())
    {
      if(MessageBox(Handle,
        "You didn't enter a name for an audio file!\n"
        "Do you really want to save the Cue Sheet without a filename?",
        "Warning", MB_YESNO | MB_ICONWARNING | MB_APPLMODAL) != IDYES)
      {
        CanClose = false;
        EditAudioFileName->SetFocus();
        return;
      }
    }

    // Eingabefeld "GapTime" berprfen
    if(CheckBoxInsertGaps->Checked)
    {
      try
      {
        fTemp = StrToFloat(EditGapTime->Text);
      }
      catch(...)
      {
        MessageBox(Handle, "Please enter a valid number!\n", "Error", MB_OK | MB_ICONWARNING | MB_APPLMODAL);
        CanClose = false;
        EditGapTime->SetFocus();
        return;
      }
    }

    // Eingabefeld "Time Offset" berprfen
    if(CheckBoxAddOffset->Checked)
    {
      try
      {
        fTemp = StrToFloat(EditOffsetTime->Text);
      }
      catch(...)
      {
        MessageBox(Handle, "Please enter a valid number!\n", "Error", MB_OK | MB_ICONWARNING | MB_APPLMODAL);
        CanClose = false;
        EditOffsetTime->SetFocus();
        return;
      }
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TFormSaveCueSheet::ButtonSaveClick(TObject *Sender)
{
  bSaveButtonPressed = true;
}
//---------------------------------------------------------------------------
void __fastcall TFormSaveCueSheet::ButtonSaveAndBurnClick(TObject *Sender)
{
  bSaveButtonPressed = true;
  bSaveAndBurn = true;
}
//---------------------------------------------------------------------------
void TFormSaveCueSheet::SetAudioFileName(String strFileName)
{
  strAudioFileName = strFileName;
  DisplayAudioFileName();
}
//---------------------------------------------------------------------------
String TFormSaveCueSheet::GetAudioFileName(void)
{
  String strFileName = ExtractFileName(EditAudioFileName->Text);
  String strFilePath = ExtractFilePath(EditAudioFileName->Text);
  if(strFilePath.IsEmpty()) strFilePath = ExtractFilePath(strAudioFileName);

  return strFilePath + strFileName;
}
//---------------------------------------------------------------------------
void TFormSaveCueSheet::DisplayAudioFileName()
{
  if(CheckBoxAbsolutePath->Checked)
    EditAudioFileName->Text = strAudioFileName;
  else
    EditAudioFileName->Text = ExtractFileName(strAudioFileName);
}
//---------------------------------------------------------------------------

void __fastcall TFormSaveCueSheet::CheckBoxAbsolutePathClick(
      TObject *Sender)
{
  DisplayAudioFileName();
}
//---------------------------------------------------------------------------

void __fastcall TFormSaveCueSheet::CheckBoxIncludeCDTextClick(TObject *Sender)
{
  Label1->Enabled = CheckBoxIncludeCDText->Checked;
  EditPerformer->Enabled = CheckBoxIncludeCDText->Checked;
  EditPerformer->Color = CheckBoxIncludeCDText->Checked ? clWindow : clBtnFace;
  Label2->Enabled = CheckBoxIncludeCDText->Checked;
  EditTitle->Enabled = CheckBoxIncludeCDText->Checked;
  EditTitle->Color = CheckBoxIncludeCDText->Checked ? clWindow : clBtnFace;
  Label6->Enabled = CheckBoxIncludeCDText->Checked;
  Label9->Enabled = CheckBoxIncludeCDText->Checked;
  CheckBoxUseCueNotesAsTrackPerformer->Enabled = CheckBoxIncludeCDText->Checked;
  Label8->Enabled = CheckBoxIncludeCDText->Checked;
  CheckBoxIfCueNoteEmptyUseAlbumPerformer->Enabled = CheckBoxIncludeCDText->Checked;
}
//---------------------------------------------------------------------------

