//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <registry.hpp>
#include "burncd.h"
#include "main.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFormBurn *FormBurn;
//---------------------------------------------------------------------------
__fastcall TFormBurn::TFormBurn(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TFormBurn::FormShow(TObject *Sender)
{
  ActiveControl = ButtonOK;
  ButtonOK->Enabled = !EditPath->Text.IsEmpty();
  FormBurn->Left = Form1->Left + (Form1->Width - FormBurn->Width) / 2;
  FormBurn->Top = Form1->Top + (Form1->Height - FormBurn->Height) / 2;
}
//---------------------------------------------------------------------------
void __fastcall TFormBurn::ButtonBrowseClick(TObject *Sender)
{
  String strPath = EditPath->Text.Trim();
  if(strPath.SubString(1, 1) == "\"") strPath = strPath.SubString(2, strPath.Length() - 1);
  if(strPath.SubString(strPath.Length(), 1) == "\"") strPath = strPath.SubString(1, strPath.Length() - 1);
  OpenDialogExe->FileName = strPath;

  if(OpenDialogExe->FileName.IsEmpty())
  {
    TRegistry *pReg = new TRegistry;
    pReg->RootKey = HKEY_LOCAL_MACHINE;
    pReg->OpenKey("SOFTWARE\\Microsoft\\Windows\\CurrentVersion", false);
    OpenDialogExe->InitialDir = pReg->ReadString("ProgramFilesDir");
    delete pReg;
  }

  if(!OpenDialogExe->Execute()) return;
  EditPath->Text = "\"" + OpenDialogExe->FileName + "\"";

}
//---------------------------------------------------------------------------
void __fastcall TFormBurn::DefaultClick(TObject *Sender)
{
  EditArguments->Text = DEFAULT_BURN_ARGS;
}
//---------------------------------------------------------------------------
void __fastcall TFormBurn::EditPathChange(TObject *Sender)
{
  ButtonOK->Enabled = !EditPath->Text.IsEmpty();
}
//---------------------------------------------------------------------------

