<p>Here is a small demonstration of text formatting options in HTML that can be achieved with the buttons in the toolbar at the top (buttons <b>P</b>, <b>H2</b>, <b>H3</b>, etc.) and the so-called "snippets" from the "<b>Insert...</b>" menu. To do this, simply select the text you want to format and click the desired button or select the desired snippet.</p>

<p>In addition, you can of course use all the other formatting options that HTML has to offer by writing the desired HTML tags directly into the source text.</p>

<p>To quickly remove formatting, simply select the text and click the <b>x</b> button. With each click on the <b>x</b> button, another format is removed from the outside to the inside or from left to right.</p>

<p>In addition, the standard keyboard shortcuts also work (at least under Windows), such as <b>Ctrl</b>+<b>Z</b> to undo changes, <b>Ctrl</b>+<b>Y</b> to restore changes that have been accidentally undone, and of course <b>Ctrl</b>+<b>C</b>, <b>Ctrl</b>+<b>X</b> and <b>Ctrl</b>+<b>V</b> to copy, cut and paste text via the clipboard.</p>

<p>Basically, the text to be formatted must be selected beforehand - whether with the mouse or the keyboard:</p>

<ul>
	<li>Dragging while holding down the left mouse button selects text character by character.</li>
	<li>Dragging while holding down the left mouse button after double-clicking selects text word by word.</li>
	<li>Double-clicking on a word selects the whole word.</li>
	<li>Triple-clicking in a paragraph selects the whole paragraph.</li>
	<li>Left/right/up/down arrow keys while holding down the Shift key selects text character by character or line by line.</li>
	<li>Left/right arrow keys while holding down the Shift and Ctrl keys at the same time selects text word by word.</li>
</ul>

<p>Here is a demonstration of the formatting options:</p>

<h2>Heading 2</h2>

<h3>Heading 3</h3>

<h4>Heading 4</h4>

<h5>Heading 5</h5>

<p>A normal paragraph with text in <b>bold</b>, <i>italic</i>, <u>underlined</u>, highlighted with a <mark>highlighter</mark>, with a <span style="background-color: #D0F0F0; padding: 0.2em; margin: -0.2em;">background color</span> or <span style="color: #00C000;">colored</span>.</p>

<p>Now to the demonstration of the snippets from the "<b>Insert...</b>" menu. To better understand how it works, the text to be selected is given first and then the end result after inserting the snippet.</p>

<h3>———— Images ————</h3>

<h4>Image without link</h4>

<p>Here the image URL and the image description text are each on one line:</p>

media/green-article-image.jpg
Image description

<div><figure><img src="media/green-article-image.jpg" /><figcaption>Image description</figcaption></figure></div>

<p>Alternatively, the image URL and image description text can also be on one line. In this case, they are separated from each other with |:</p>

media/green-article-image.jpg|Image description

<p>The result after selecting the text and applying the snippet is the same:</p>

<div><figure><img src="media/green-article-image.jpg" /><figcaption>Image description</figcaption></figure></div>

<p>This also applies to all the following snippets, so it will not be mentioned again below.</p>

<h4>Image with link</h4>

media/green-article-image.jpg
Image description

<div><figure><a href="media/green-article-image.jpg" target="_blank"><img src="media/green-article-image.jpg" /></a><figcaption>Image description</figcaption></figure></div>

<h4>Image with thin frame</h4>

media/default-favicon.png
Image description

<div><figure class="thinframe"><img src="media/default-favicon.png" /><figcaption>Image description</figcaption></figure></div>

<h4>Image carousel</h4>

<p>Here the images are first inserted from the media manager into the editor:</p>

media/green-article-image.jpg|Image description
media/default-favicon.png|Image description
media/green-article-image.jpg|Image description
media/default-favicon.png|Image description
media/green-article-image.jpg|Image description

<p>Then an image snippet is applied to each individual image (as demonstrated above). Finally, all images are selected and the "Image carousel" snippet is applied. The result:</p>

<div class="image-carousel bottom"> <!-- Vertical alignment: top|middle|bottom -->
	<!-- insert images here... -->
	<div><figure><img src="media/green-article-image.jpg" /><figcaption>Image description</figcaption></figure></div>
	<div><figure><img src="media/default-favicon.png" /><figcaption>Image description</figcaption></figure></div>
	<div><figure><img src="media/green-article-image.jpg" /><figcaption>Image description</figcaption></figure></div>
	<div><figure><img src="media/default-favicon.png" /><figcaption>Image description</figcaption></figure></div>
	<div><figure><img src="media/green-article-image.jpg" /><figcaption>Image description</figcaption></figure></div>
</div>

<h4>Columns for images etc.</h4>

<p>This allows several images to be arranged next to each other. On narrow displays, they are displayed one below the other.</p>

<p><b>Example with 2 images, top aligned:</b></p>

media/green-article-image.jpg|Image description
media/default-favicon.png|Image description

<div class="columns top"> <!-- Vertical alignment: top|middle|bottom -->
	<!-- insert images here... -->
	<div><figure><a href="media/green-article-image.jpg" target="_blank"><img src="media/green-article-image.jpg" /></a><figcaption>Image description</figcaption></figure></div>
	<div><figure><a href="media/default-favicon.png" target="_blank"><img src="media/default-favicon.png" /></a><figcaption>Image description</figcaption></figure></div>
</div>

<p><b>Example with 3 images, center aligned:</b></p>

media/green-article-image.jpg|Image description
media/default-favicon.png|Image description
media/green-article-image.jpg|Image description

<div class="columns middle"> <!-- Vertical alignment: top|middle|bottom -->
	<!-- insert images here... -->
	<div><figure><a href="media/green-article-image.jpg" target="_blank"><img src="media/green-article-image.jpg" /></a><figcaption>Image description</figcaption></figure></div>
	<div><figure><a href="media/default-favicon.png" target="_blank"><img src="media/default-favicon.png" /></a><figcaption>Image description</figcaption></figure></div>
	<div><figure><a href="media/green-article-image.jpg" target="_blank"><img src="media/green-article-image.jpg" /></a><figcaption>Image description</figcaption></figure></div>
</div>

<p><b>Example with 4 images, bottom aligned:</b></p>

media/green-article-image.jpg|Image description
media/default-favicon.png|Image description
media/green-article-image.jpg|Image description
media/default-favicon.png|Image description

<div class="columns bottom"> <!-- Vertical alignment: top|middle|bottom -->
	<!-- insert images here... -->
	<div><figure><a href="media/green-article-image.jpg" target="_blank"><img src="media/green-article-image.jpg" /></a><figcaption>Image description</figcaption></figure></div>
	<div><figure><a href="media/default-favicon.png" target="_blank"><img src="media/default-favicon.png" /></a><figcaption>Image description</figcaption></figure></div>
	<div><figure><a href="media/green-article-image.jpg" target="_blank"><img src="media/green-article-image.jpg" /></a><figcaption>Image description</figcaption></figure></div>
	<div><figure><a href="media/default-favicon.png" target="_blank"><img src="media/default-favicon.png" /></a><figcaption>Image description</figcaption></figure></div>
</div>

<h3>———— Links ————</h3>

<h4>Internal link</h4>

Welcome!
about

<p><a href="ueber">Welcome!</a></p>

<p>Instead of the two-line format above, the single-line format with | or [...] as a separator between the link text and the URL works here as well:</p>

Welcome [about] to my blog!

Welcome|about to my blog!

<p>(This also applies to the following examples.)</p>

<h4>External link</h4>

My blog
https://example.com/

<p><a href="https://example.com/" target="_blank" rel="noopener">My blog</a></p>

<h4>Internal button link</h4>

Welcome! | about

<p class="center"><a href="about" class="button-link">Welcome!</a></p>

<h4>External button link</h4>

My blog[https://example.com/]

<p class="center"><a href="https://example.com/" target="_blank" rel="noopener" class="button-link">My blog</a></p>

<h4>Article card internal</h4>

<p>Links tu internal articles are displayed as a "card".</p>

<p>Source text: The filenames of existing articles, inserted, for example, via the file manager. After applying the snippet, an alternative (shortened) description can optionally be specified.</p>

help
help

<div class="websites noprint">
	<?php include_once "snippets/article-card.php"; ArticleCard('help', 'This is a simple blogging system for people (like me) for whom WordPress with all its features and user management is actually „overkill“.'); ?>
	<?php include_once "snippets/article-card.php"; ArticleCard('help', ''); ?>
</div>

<h2>Website card external</h2>

<p>Links to external websites are displayed as a "card".</p>

<p>Source text: 4 lines with the following content:</p>

<p>Title
<br>File name (inserted via the file manager, excluding the .php suffix)
<br>Image link
<br>Description text</p>

Blog4u
https://www.stefanbion.de/blog4u/
https://www.stefanbion.de/blog4u/mein-blog.jpg
A nice little blogging system for you!

<div class="websites noprint">

	<div class="website">
		<a href="https://www.stefanbion.de/blog4u/" target="_blank" rel="noopener" title="Blog4u">
			<img src="https://www.stefanbion.de/blog4u/mein-blog.jpg">
			<div>
				<p class="website-title">Blog4u</p>
				<p class="website-description">A nice little blogging system for you!</p>
				<p class="center"><span class="button-link" ><?php echo GetString('VisitNow');?></span></p>
			</div>
		</a>
	</div>

	<!-- Insert more websites here (without the outer div) -->
</div>

<h4>Tooltip</h4>

Individual words can be provided with a tooltip[A tooltip is a short explanatory text&#10;that is displayed when the mouse&#10;pointer hovers over it. Line breaks&#10;are created using &amp;#10;.].

<p>Individual words can be provided with a <span class="tooltip" title="A tooltip is a short explanatory text&#10;that is displayed when the mouse&#10;pointer hovers over it. Line breaks&#10;are created using &amp;#10;.">tooltip</span>.

<h3>———— Highlighting ————</h3>

<h4>Quote</h4>

<p>The following also applies here: If there are links, they must first be processed with a link snippet. Then use the quote snippet. (It also works the other way around.)</p>

Every person has a hole in their heart that only God can fit into.
And nothing less than God can fill this hole.
Blaise Pascal (1623–1662)|https://www.pro-medienmagazin.de/blaise-pascal-der-philosoph-der-christ-wurde/

<blockquote>
	<p>Every person has a hole in their heart that only God can fit into.</p>
	<p>And nothing less than God can fill this hole.</p>
	<cite><a href="https://www.pro-medienmagazin.de/blaise-pascal-der-philosoph-der-christ-wurde/" target="_blank" rel="noopener">Blaise Pascal (1623–1662)</a></cite>
</blockquote>

<h4>Bible quote</h4>

<p>With this snippet, the last two lines are automatically converted into a link:</p>

You will seek me and find me, when you seek me with all your heart. I will be found by you, declares the Lord.
Jeremiah 29:13-14
https://www.bibleserver.com/ESV/Jeremia29%2C13-14

<blockquote class="biblequote">
	<p><i>You will seek me and find me, when you seek me with all your heart. I will be found by you, declares the Lord.</i></p>
	<cite>– <a href="https://www.bibleserver.com/ESV/Jeremia29%2C13-14" target="_blank" rel="noopener">Jeremiah 29:13-14</a> –</cite>
</blockquote>

<h4>Textbox</h4>

Surely goodness and mercy shall follow me all the days of my life, and I shall dwell in the house of the Lord forever.

<p class="textbox">Surely goodness and mercy shall follow me all the days of my life, and I shall dwell in the house of the Lord forever.</p>

<h4>Table</h4>

Column A | Column B | Column C
Cell A1 | Cell B1 | Cell C1
Cell A2 | Cell B2 | Cell C2
Cell A3 | Cell B3 | Cell C3
Table title

<figure>
	<table>
		<tr>
			<th>Column A</th>
			<th>Column B</th>
			<th>Column C</th>
		</tr>
		<tr>
			<td>Cell A1</td>
			<td>Cell B1</td>
			<td>Cell C1</td>
		</tr>
		<tr>
			<td>Cell A2</td>
			<td>Cell B2</td>
			<td>Cell C2</td>
		</tr>
		<tr>
			<td>Cell A3</td>
			<td>Cell B3</td>
			<td>Cell C3</td>
		</tr>
	</table>
	<figcaption>Table title</figcaption>
</figure>

<p>Instead of | you can also use tabs as separators:</p>

Column A	Column B	Column C
Cell A1	Cell B1	Cell C1
Cell A2	Cell B2	Cell C2
Cell A3	Cell B3	Cell C3
Table title

<h3>———— Embedding ————</h3>

<h4>Audio clip</h4>

media/Froschkonzert.mp3
Frog Concert

<figure>
	<audio controls src="media/Froschkonzert.mp3"></audio>
	<figcaption>Frog Concert</figcaption>
</figure>

<p>The MP3 file used is inserted from the media manager (upload it there beforehand if necessary). Of course, an external link can also be specified.</p>

<p>Only one audio clip is played at a time; i.e. if playback of an audio clip is started, playback of the currently playing audio clip is stopped.</p>

<h4>Audio clip for playlist</h4>

media/Froschkonzert.mp3
Frog concert

<figure class="playlist">
	<p>Frog concert</p>
	<p><audio controls src="media/Froschkonzert.mp3"></audio></p>
</figure>

<p>Unlike a simple audio clip (see above), this audio clip is part of a playlist. If several such audio clips are present on the page, they will be played sequentially. The currently playing audio clip will be visually highlighted.</p>

<h4>Video clip</h4>

media/wolken.mp4
Clouds

<figure>
	<video controls src="media/wolken.mp4"></video>
	<figcaption>Clouds</figcaption>
</figure>

<h4>YouTube video</h4>

<p>The embedding code can be obtained via the "Share" function on the YouTube page for a video.</p>

<p><i>Note: The following code is commented out to disable access to Google servers. To see the result of the demonstration, please remove the comment characters <!-- and -->.</i></p>

<!--
<iframe width="720" height="405" src="https://www.youtube.com/embed/PcxaUHkmnSQ" title="Ewigkeit - Outbreakband (Official Video)" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
Outbreakband: Ewigkeit
-->

<!--
<figure>
	<iframe width="720" height="405" src="https://www.youtube.com/embed/PcxaUHkmnSQ" title="Ewigkeit - Outbreakband (Official Video)" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
	<figcaption>Outbreakband: Ewigkeit</figcaption>
</figure>
-->

<h4>GoogleMaps map</h4>

<p>The embedding code for the map can be obtained via the "Share" function in the menu on the GoogleMaps page.</p>

<p><i>Note: The following code is commented out to disable access to Google servers. To see the result of the demonstration, please remove the comment characters <!-- and -->.</i></p>

<!--
<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d1331.6806453458598!2d11.513305599999997!3d48.1225556!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x5f875ba02a03736!2zNDjCsDA3JzIxLjIiTiAxMcKwMzAnNDcuOSJF!5e0!3m2!1sde!2sde!4v1660604605751!5m2!1sde!2sde" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
Our worship site in the Westpark
-->

<!--
<figure>
	<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d1331.6806453458598!2d11.513305599999997!3d48.1225556!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x5f875ba02a03736!2zNDjCsDA3JzIxLjIiTiAxMcKwMzAnNDcuOSJF!5e0!3m2!1sde!2sde!4v1660604605751!5m2!1sde!2sde" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
	<figcaption>Our worship site in the Westpark</figcaption>
</figure>
-->

<h3>———— Paragraph ————</h3>

<h4>Paragraph separator (* * *)</h4>

<p>Paragraph separators are suitable as visual separators between two paragraphs, e.g. to write a postscript.</p>

<h2 class="center">* * *</h2>

<p>Here follows the separated paragraph...</p>

<h4>Table of contents</h4>

<p>A table of contents is automatically generated based on the headings with IDs contained in the article. The IDs are used as jump targets. Here are a few example headings and then the automatically generated table of contents are shown:</p>

<div class="textbox">
	<h2 id="chapter-1">Chapter 1</h2>
	<h3 id="section-1-1">Section 1</h3>
	<h3 id="section-1-2">Section 2</h3>
	<h3 id="section-1-3">Section 3</h3>
	<h2 id="chapter-2">Chapter 2</h2>
	<h3 id="section-2-1">Section 1</h3>
	<h4 id="section-2-1-1">Subsection 1</h3>
	<h3 id="section-2-2">Section 2</h3>
	<h3 id="section-2-3">Section 3</h3>
</div>

<div class="toc"></div>

<h4>TOC, expandable</h4>

<p>As before, but expandable:</p>

<details class="toc textbox noprint" open>
	<summary><b>Table of contents</b></summary>
</details>

<p>If you omit the "open" attribute, the table of contents is initially collapsed. Another example can be found on the <a href="help">Help</a> page.</p>

<h4>Section, expandable</h4>

<p>A section is initially hidden and can be expanded by clicking on the title:</p>

Details
<p>Once upon a time...</p>
<p>And if they haven't died...</p>

<details class="textbox noprint">
	<summary><b>Details</b></summary>
	<p>Once upon a time...</p>
	<p>And if they haven't died...</p>
</details>

<h4>List (● ● ●)</h4>

Like Flexbox, Grid Layout is a very modern and simple way to create responsive and flexible layouts without having to use fixed sizes and other CSS settings such as position, float or clear.
Elements can be placed anywhere within a grid, even on top of each other if desired.
Grid Layout is supported in all modern browsers (and with vendor-prefix -ms- even in IE10- IE11).

<ul>
	<li>Like Flexbox, Grid Layout is a very modern and simple way to create responsive and flexible layouts without having to use fixed sizes and other CSS settings such as position, float or clear.</li>
	<li>Elements can be placed anywhere within a grid, even on top of each other if desired.</li>
	<li>Grid Layout is supported in all modern browsers (and with vendor-prefix -ms- even in IE10- IE11).</li>
</ul>

<p>Further indentations can also be made. However, this must be done be done manually:</p>

<ul>
	<li>Item 1</li>
	<li>Item 2
		<ul>
			<li>Subitem 1</li>
			<li>Subitem 2</li>
			<li>Subitem 3</li>
		</ul>
	</li>
	<li>Item 3</li>
</ul>

<h4>List (1. 2. 3.)</h4>

Like Flexbox, Grid Layout is a very modern and simple way to create responsive and flexible layouts without having to use fixed sizes and other CSS settings such as position, float or clear.
Elements can be placed anywhere within a grid, even on top of each other if desired.
Grid Layout is supported in all modern browsers (and with vendor-prefix -ms- even in IE10- IE11).

<ol>
	<li>Like Flexbox, Grid Layout is a very modern and simple way to create responsive and flexible layouts without having to use fixed sizes and other CSS settings such as position, float or clear.</li>
	<li>Elements can be placed anywhere within a grid, even on top of each other if desired.</li>
	<li>Grid Layout is supported in all modern browsers (and with vendor-prefix -ms- even in IE10- IE11).</li>
</ol>

<p>Here, too, further indentations can be achieved by manually entering HTML tags:</p>

<ol>
	<li>Item 1</li>
	<li>Item 2
		<ol>
			<li>Subitem 1</li>
			<li>Subitem 2</li>
			<li>Subitem 3</li>
		</ol>
	</li>
	<li>Item 3</li>
</ol>

<h4>Single footnote (*)</h4>

Name changed for privacy reasons.

<ul class="footnote" id="hinweis">
	<p><b>Note:</b></p>
	<li>Name changed for privacy reasons.</li>
</ul>

<h4>Multiple footnotes (1. 2. 3.)</h4>

Like Flexbox, Grid Layout is a very modern and simple way to create responsive and flexible layouts without having to use fixed sizes and other CSS settings such as position, float or clear.
Elements can be placed anywhere within a grid, even on top of each other if desired.
Grid Layout is supported in all modern browsers (and with vendor-prefix -ms- even in IE10- IE11).

<ol class="footnote" id="hinweise">
	<p><b>Notes:</b></p>
	<li>Like Flexbox, Grid Layout is a very modern and simple way to create responsive and flexible layouts without having to use fixed sizes and other CSS settings such as position, float or clear.</li>
	<li>Elements can be placed anywhere within a grid, even on top of each other if desired.</li>
	<li>Grid Layout is supported in all modern browsers (and with vendor-prefix -ms- even in IE10- IE11).</li>
</ol>

<p>Footnotes can also be provided with links to jump back and forth, such as the reference to pseudonyms<a href="#pseudonym">*</a> in this example:</p>

<ul class="footnote" id="pseudonym">
	<p><b>Note:</b></p>
	<li>Name changed for privacy reasons.</li>
</ul>

<h3>————— Line —————</h3>

<h4>No auto-wrapping</h4>

<p>If text lines are to be broken at "break points" first, then the connected parts between these break points can be formatted with this snippet:</p> 

First connected part, second connected part, third connected part.

<p><span class="nowrap">First connected part,</span> <span class="nowrap">second connected part,</span> <span class="nowrap">third connected part.</span></p>

<h3>———— Contact link ————</h3>

<h4>Link text</h4>

Contact form

<a href="contact">Contact form</a>

<p>Opens the contact form.</p>

<h4>Link text + subject</h4>

Contact form
Subject of the message

<a href="contact?subject=Subject of the message">Contact form</a>

<p>Opens the contact form with a pre-filled subject line.</p>

<h4>Link text, subject + message</h4>

Contact form
Subject of the message
Message line 1{}Message line 2{}Message line 3, indented{}{}Message line 5{}

<a href="contact?subject=Betreff der Nachricht&message=Message line 1{}Message line 2{}Message line 3, indented{}{}Message line 5{}">Contact form</a>

<p>Opens the contact form with a pre-filled subject line and message text.</p>

<p>Note: If the message text is multi-line, the individual lines of the message are separated from each other by {}.</p>

<h3>———— Translation ————</h3>

<h4>Link</h4>

<p>This snippet inserts a link that opens the link target in "Google Translate" and translates it into a target language. The source language to be used is specified in the <b>x-data-translate-from</b> attribute of the snippet (e.g. "de" for German). The target language is the language set in the user's browser (e.g. "en" for English). The link to "Google Translate" only occurs if the source and target languages differ.</p>

More information in the help file|help#setup.

<p>More information in the <a href="help#setup" target="_blank" rel="noopener" x-data-translate-from="de">Help</a> file.</p>

<h4>Translate this page</h4>

<p>This snippet inserts a button for translating the page with "Google Translate". The source language to be used is specified in the <b>x-data-translate-from</b> attribute of the snippet (e.g. "de" for German). The target language is the language set in the user's browser (e.g. "en" for English). The button is only visible if the source and target languages differ.</p>

<p>Without selected text, a standard link text is used:</p> 

<p class="translate center hidden" x-data-translate-from="de"></p>

<p>If you want to display your own link text for the button instead of the standard link text, you can specify this within the <b>&lt;p&gt;</b> tag. When inserting the snippet, the selected text is used:</p>

Translate

<p class="translate center hidden" x-data-translate-from="de">Translate</p>

<h3>———— Text blocks ————</h3>

<p>Text blocks are reusable texts that can be inserted into articles and are maintained centrally. Changes to a text block are immediately visible in all articles in which it is inserted.</p>

<p>Examples of text blocks:</p>

<h4>Example text block</h4>

<?php include 'textblocks/example-textblock.html';?>

<p>To create a new text block, create a new file with the file type "Text block" using the "<b>New</b>" button (top left). Then include it into the article using the PHP code above.</p>

<p>To integrate a text block as a snippet in the "Insert..." menu, create a new file with the file type "Snippet" and insert the PHP code there according to the example above. Then open the "snippets.xml" file from the "<b>Snippets</b>" area using the "<b>Open</b>" button (top) and insert the new snippet in the appropriate place.</p>

<p>Creating your own snippets is explained in detail on the <a href="help#snippets">Help</a> page under "<b>Create a snippet</b>".