<p>Hier eine kleine Demonstration von Textformatierungs-Möglichkeiten in HTML, die mit den Buttons in der Werkzeugleiste oben (Buttons <b>P</b>, <b>H2</b>, <b>H3</b> usw.) und den sogenannten "Snippets" (Schnipsel) aus dem "<b>Einfügen...</b>"-Menü erzielt werden können. Hierzu einfach den zu formatierenden Text markieren und den gewünschten Button anklicken oder das gewünschte Snippet auswählen.</p>

<p>Darüberhinaus können natürlich auch sämtliche weiteren Formatierungs-Möglichkeiten genutzt werden, die HTML zu bieten hat, indem man die gewünschten HTML-Tags direkt in den Quelltext schreibt.</p>

<p>Um eine Formatierung schnell wieder zu entfernen, einfach den Text markieren und den Button <b>x</b> anklicken. Mit jedem Klick auf den <b>x</b>-Button wird von außen nach innen bzw. von links nach rechts eine weitere Formatierung entfernt.</p>

<p>Zudem funktionieren (zumindest unter Windows) auch die Standard-Tastenkombinationen wie z.B. <b>Strg</b>+<b>Z</b>, um Änderungen rückgängig zu machen, <b>Strg</b>+<b>Y</b>, um versehentlich rückgängig gemachte Änderungen wiederherzustellen, und natürlich <b>Strg</b>+<b>C</b>, <b>Strg</b>+<b>X</b> und <b>Strg</b>+<b>V</b> zum Kopieren, Ausschneiden und Einfügen von Text über die Zwischenablage.</p>

<p>Grundsätzlich gilt, dass der zu formatierende Text zuvor markiert werden muss - egal ob mit der Maus oder mit der Tastatur:</p>

<ul>
	<li>Ziehen bei gedrückt gehaltener linker Maustaste markiert einen Text zeichenweise.</li>
	<li>Ziehen bei gedrückt gehaltener linker Maustaste nach Doppelklick markiert einen Text wortweise.</li>
	<li>Doppelklick auf ein Wort markiert das ganze Wort.</li>
	<li>Dreifachklick in einen Absatz markiert den ganzen Absatz.</li>
	<li>Pfeiltaste links/rechts/oben/unten bei gedrückt gehaltener Umschalt-Taste markiert einen Text zeichen- bzw. zeilenweise.</li>
	<li>Pfeiltaste links/rechts bei gleichzeitig gedrückt gehaltener Umschalt- und Strg-Taste markiert einen Text wortweise.</li>
</ul>

<p>Hier nun die Demonstration der Formatierungs-Möglichkeiten:</p>

<h2>Überschrift 2</h2>

<h3>Überschrift 3</h3>

<h4>Überschrift 4</h4>

<h5>Überschrift 5</h5>

<p>Ein normaler Absatz mit Text in <b>fett</b>, <i>kursiv</i>, <u>unterstrichen</u>, mit <mark>Textmarker</mark> markiert, mit einer <span style="background-color: #D0F0F0; padding: 0.2em; margin: -0.2em;">Hintergrundfarbe</span> hinterlegt oder <span style="color: #00C000;">farbig</span>.</p>

<p>Nun die Demonstration der Snippets aus dem "<b>Einfügen...</b>"-Menü. Um die Funktionsweise besser zu verstehen, wird jeweils zuerst der zu markierende Text angegeben und anschließend das Endergebnis nach Einfügen des Snippets.</p>

<h3>———— Bilder ————</h3>

<h4>Bild ohne Link</h4>

<p>Hier stehen die Bild-URL und der Bildbeschreibungstext in je einer Zeile:</p>

media/green-article-image.jpg
Bildbeschreibung

<div><figure><img src="media/green-article-image.jpg" /><figcaption>Bildbeschreibung</figcaption></figure></div>

<p>Alternativ können Bild-URL und Bildbeschreibungstext auch in einer Zeile stehen. Sie werden dann mit | voneinander getrennt:</p>

media/green-article-image.jpg|Bildbeschreibung

<p>Das Ergebnis nach Markieren und Auswählen des Snippets ist dasselbe:</p>

<div><figure><img src="media/green-article-image.jpg" /><figcaption>Bildbeschreibung</figcaption></figure></div>

<p>Dies gilt auch für alle folgenden Snippets, daher wird im weiteren Verlauf nicht wieder darauf eingegangen.</p>

<h4>Bild mit Link</h4>

media/green-article-image.jpg
Bildbeschreibung

<div><figure><a href="media/green-article-image.jpg" target="_blank"><img src="media/green-article-image.jpg" /></a><figcaption>Bildbeschreibung</figcaption></figure></div>

<h4>Bild mit dünnem Rahmen</h4>

media/default-favicon.png
Bildbeschreibung

<div><figure class="thinframe"><img src="media/default-favicon.png" /><figcaption>Bildbeschreibung</figcaption></figure></div>

<h4>Bilder-Karussell</h4>

<p>Hierzu werden die Bilder zuerst aus der Medienverwaltung in den Editor eingefügt:</p>

media/green-article-image.jpg|Bildbeschreibung
media/default-favicon.png|Bildbeschreibung
media/green-article-image.jpg|Bildbeschreibung
media/default-favicon.png|Bildbeschreibung
media/green-article-image.jpg|Bildbeschreibung

<p>Dann wird auf jedes einzelne Bild ein Bild-Snippet angewendet (wie oben demonstriert). Zuletzt werden alle Bilder markiert und das Snippet "Bilder-Karussell" ausgewählt. Ergebnis:</p>

<div class="image-carousel bottom"> <!-- Vertikale Ausrichtung: top|middle|bottom -->
	<!-- Hier Bilder einfügen... -->
	<div><figure><img src="media/green-article-image.jpg" /><figcaption>Bildbeschreibung</figcaption></figure></div>
	<div><figure><img src="media/default-favicon.png" /><figcaption>Bildbeschreibung</figcaption></figure></div>
	<div><figure><img src="media/green-article-image.jpg" /><figcaption>Bildbeschreibung</figcaption></figure></div>
	<div><figure><img src="media/default-favicon.png" /><figcaption>Bildbeschreibung</figcaption></figure></div>
	<div><figure><img src="media/green-article-image.jpg" /><figcaption>Bildbeschreibung</figcaption></figure></div>
</div>

<h4>Spalten für Bilder etc.</h4>

<p>Hiermit können mehrere Bilder nebeneinander angeordnet werden. Bei schmalen Displays werden sie untereinander angezeigt.</p>

<p><b>Beispiel mit 2 Bildern, oben ausgerichtet:</b></p>

media/green-article-image.jpg|Bildbeschreibung
media/default-favicon.png|Bildbeschreibung

<div class="columns top"> <!-- Vertikale Ausrichtung: top|middle|bottom -->
	<!-- Hier Bilder einfügen... -->
	<div><figure><a href="media/green-article-image.jpg" target="_blank"><img src="media/green-article-image.jpg" /></a><figcaption>Bildbeschreibung</figcaption></figure></div>
	<div><figure><a href="media/default-favicon.png" target="_blank"><img src="media/default-favicon.png" /></a><figcaption>Bildbeschreibung</figcaption></figure></div>
</div>

<p><b>Beispiel mit 3 Bildern, mittig ausgerichtet:</b></p>

media/green-article-image.jpg|Bildbeschreibung
media/default-favicon.png|Bildbeschreibung
media/green-article-image.jpg|Bildbeschreibung

<div class="columns middle"> <!-- Vertikale Ausrichtung: top|middle|bottom -->
	<!-- Hier Bilder einfügen... -->
	<div><figure><a href="media/green-article-image.jpg" target="_blank"><img src="media/green-article-image.jpg" /></a><figcaption>Bildbeschreibung</figcaption></figure></div>
	<div><figure><a href="media/default-favicon.png" target="_blank"><img src="media/default-favicon.png" /></a><figcaption>Bildbeschreibung</figcaption></figure></div>
	<div><figure><a href="media/green-article-image.jpg" target="_blank"><img src="media/green-article-image.jpg" /></a><figcaption>Bildbeschreibung</figcaption></figure></div>
</div>

<p><b>Beispiel mit 4 Bildern, unten ausgerichtet:</b></p>

media/green-article-image.jpg|Bildbeschreibung
media/default-favicon.png|Bildbeschreibung
media/green-article-image.jpg|Bildbeschreibung
media/default-favicon.png|Bildbeschreibung

<div class="columns bottom"> <!-- Vertikale Ausrichtung: top|middle|bottom -->
	<!-- Hier Bilder einfügen... -->
	<div><figure><a href="media/green-article-image.jpg" target="_blank"><img src="media/green-article-image.jpg" /></a><figcaption>Bildbeschreibung</figcaption></figure></div>
	<div><figure><a href="media/default-favicon.png" target="_blank"><img src="media/default-favicon.png" /></a><figcaption>Bildbeschreibung</figcaption></figure></div>
	<div><figure><a href="media/green-article-image.jpg" target="_blank"><img src="media/green-article-image.jpg" /></a><figcaption>Bildbeschreibung</figcaption></figure></div>
	<div><figure><a href="media/default-favicon.png" target="_blank"><img src="media/default-favicon.png" /></a><figcaption>Bildbeschreibung</figcaption></figure></div>
</div>

<h3>———— Links ————</h3>

<h4>Link intern</h4>

Herzlich willkommen!
ueber

<p><a href="ueber">Herzlich willkommen!</a></p>

<p>Statt der obigen zweizeiligen Schreibweise funktioniert auch hier wieder die einzeilige Schreibweise mit | oder [...] als Trenner zwischen dem Linktext und der URL:</p>

Sei herzlich willkommen [ueber] auf meinem Blog!

Sei herzlich willkommen|ueber auf meinem Blog!

<p>(Dies gilt auch wieder für die nachfolgenden Beispiele.)</p>

<h4>Link extern</h4>

Mein Blog
https://beispiel.de/

<p><a href="https://beispiel.de/" target="_blank" rel="noopener">Mein Blog</a></p>

<h4>Button-Link intern</h4>

Willkomen! | ueber

<p class="center"><a href="ueber" class="button-link">Willkomen!</a></p>

<h4>Button-Link extern</h4>

Mein Blog[https://beispiel.de/]

<p class="center"><a href="https://beispiel.de/" target="_blank" rel="noopener" class="button-link">Mein Blog</a></p>

<h4>Artikel-Card intern</h4>

<p>Links zu internen Artikeln werden als "Card" dargestellt.</p>

<p>Ausgangs-Text: Die Dateinamen existierender Artikel, eingefügt z.B. über die Dateiverwaltung. Nach Anwendung des Snippets kann optional ein alternativer (verkürzter) Beschreibungstext angegeben werden.</p>

help
help

<div class="websites noprint">
	<?php include_once "snippets/article-card.php"; ArticleCard('help', 'Dies ist ein einfaches Blog-System für Leute (wie mich), für die WordPress mit all seinen Möglichkeiten und der Benutzerverwaltung eigentlich „Overkill“ ist.'); ?>
	<?php include_once "snippets/article-card.php"; ArticleCard('help', ''); ?>
</div>

<h2>Website-Card extern</h2>

<p>Links zu externen Websites werden als "Card" dargestellt.</p>

<p>Ausgangs-Text: 4 Zeilen mit folgendem Inhalt:</p>

<p>Titel
<br>Dateiname (eingefügt über die Dateiverwaltung, ohne die Endung .php)
<br>Bild-Link
<br>Beschreibungstext</p>

Blog4u
https://www.stefanbion.de/blog4u/
https://www.stefanbion.de/blog4u/mein-blog.jpg
Ein nettes kleines Blog-System für dich!

<div class="websites noprint">

	<div class="website">
		<a href="https://www.stefanbion.de/blog4u/" target="_blank" rel="noopener" title="Blog4u">
			<img src="https://www.stefanbion.de/blog4u/mein-blog.jpg">
			<div>
				<p class="website-title">Blog4u</p>
				<p class="website-description">Ein nettes kleines Blog-System für dich!</p>
				<p class="center"><span class="button-link" ><?php echo GetString('VisitNow');?></span></p>
			</div>
		</a>
	</div>

	<!-- Weitere Websites hier einfügen (ohne das äußere div) -->
</div>

<h4>Tooltip</h4>

Einzelne Wörter können mit einem Tooltip[Ein Tooltip ist ein kurzer Erklärungstext,&#10;der beim Darüberhalten des Mauszeigers&#10;angezeigt wird. Zeilenumbrüche werden&#10;mittels &amp;#10; erzeugt.] versehen werden.

<p>Einzelne Wörter können mit einem <span class="tooltip" title="Ein Tooltip ist ein kurzer Erklärungstext,&#10;der beim Darüberhalten des Mauszeigers&#10;angezeigt wird. Zeilenumbrüche werden&#10;mittels &amp;#10; erzeugt.">Tooltip</span> versehen werden.</p>

<h3>———— Hervorhebungen ————</h3>

<h4>Zitat</h4>

<p>Auch hier gilt: Wenn Links vorhanden sind, müssen diese zuerst mit einem Link-Snippet bearbeitet werden. Anschliend das Zitat-Snippet anwenden. (Es funktioniert aber auch umgekehrt.)</p>

Jeder Mensch hat in seinem Herzen ein Loch, in das nur Gott hineinpasst.
Und nichts weniger als Gott kann dieses Loch ausfüllen.
Blaise Pascal (1623–1662)|https://www.pro-medienmagazin.de/blaise-pascal-der-philosoph-der-christ-wurde/

<blockquote>
	<p>Jeder Mensch hat in seinem Herzen ein Loch, in das nur Gott hineinpasst.</p>
	<p>Und nichts weniger als Gott kann dieses Loch ausfüllen.</p>
	<cite><a href="https://www.pro-medienmagazin.de/blaise-pascal-der-philosoph-der-christ-wurde/" target="_blank" rel="noopener">Blaise Pascal (1623–1662)</a></cite>
</blockquote>

<h4>Bibelzitat</h4>

<p>Bei diesem Snippet werden die letzten beiden Zeilen automatisch in einen Link umgewandelt:</p>

Und sucht ihr mich, so werdet ihr mich finden, ja, fragt ihr mit eurem ganzen Herzen nach mir, so werde ich mich von euch finden lassen, spricht der HERR.
Jeremia 29,13-14
https://www.bibleserver.com/ELB/Jeremia29%2C13-14

<blockquote class="biblequote">
	<p><i>Und sucht ihr mich, so werdet ihr mich finden, ja, fragt ihr mit eurem ganzen Herzen nach mir, so werde ich mich von euch finden lassen, spricht der HERR.</i></p>
	<cite>– <a href="https://www.bibleserver.com/ELB/Jeremia29%2C13-14" target="_blank" rel="noopener">Jeremia 29,13-14</a> –</cite>
</blockquote>

<h4>Textbox</h4>

Gutes und Barmherzigkeit werden mir folgen mein Leben lang, und ich werde bleiben im Hause des HERRN immerdar.

<p class="textbox">Gutes und Barmherzigkeit werden mir folgen mein Leben lang, und ich werde bleiben im Hause des HERRN immerdar.</p>

<h4>Tabelle</h4>

Spalte A | Spalte B | Spalte C
Zelle A1 | Zelle B1 | Zelle C1
Zelle A2 | Zelle B2 | Zelle C2
Zelle A3 | Zelle B3 | Zelle C3
Tabellentitel

<figure>
	<table>
		<tr>
			<th>Spalte A</th>
			<th>Spalte B</th>
			<th>Spalte C</th>
		</tr>
		<tr>
			<td>Zelle A1</td>
			<td>Zelle B1</td>
			<td>Zelle C1</td>
		</tr>
		<tr>
			<td>Zelle A2</td>
			<td>Zelle B2</td>
			<td>Zelle C2</td>
		</tr>
		<tr>
			<td>Zelle A3</td>
			<td>Zelle B3</td>
			<td>Zelle C3</td>
		</tr>
	</table>
	<figcaption>Tabellentitel</figcaption>
</figure>

<p>Als Trenner eignen sich statt | auch Tabulatoren:</p>

Spalte A	Spalte B	Spalte C
Zelle A1	Zelle B1	Zelle C1
Zelle A2	Zelle B2	Zelle C2
Zelle A3	Zelle B3	Zelle C3
Tabellentitel

<h3>———— Einbettungen ————</h3>

<h4>Audioclip</h4>

media/Froschkonzert.mp3
Froschkonzert

<figure>
	<audio controls src="media/Froschkonzert.mp3"></audio>
	<figcaption>Froschkonzert</figcaption>
</figure>

<p>Die verwendete MP3-Datei wird aus der Medienverwaltung eingefügt (ggf. zuvor dort hochladen). Natürlich kann auch ein externer Link angegeben werden.</p>

<p>Es wird immer nur ein Audioclip zur selben Zeit abgespielt, d.h. wenn die Wiedergabe eines Audioclips gestartet wird, so wird die Wiedergabe des aktuell abgespielten Audioclips gestoppt.</p>

<h4>Audioclip für Playlist</h4>

media/Froschkonzert.mp3
Froschkonzert

<figure class="playlist">
	<p>Froschkonzert</p>
	<p><audio controls src="media/Froschkonzert.mp3"></audio></p>
</figure>

<p>Im Unterschied zum einfachen Audioclip (s.o.) ist dieser Audioclip Teil einer Playlist. Sind mehrere solcher Audioclips auf der Seite vorhanden, werden diese der Reihe nach abgespielt. Der aktuell abgespielte Audioclip wird dabei optisch hervorgehoben.</p>

<h4>Videoclip</h4>

media/wolken.mp4
Wolken

<figure>
	<video controls src="media/wolken.mp4"></video>
	<figcaption>Wolken</figcaption>
</figure>

<h4>YouTube-Video</h4>

<p>Den Einbettungs-Code erhält man über die "Teilen"-Funktion auf der YouTube-Seite zu einem Video.</p>

<p><i>Hinweis: Der folgende Code ist auskommentiert, um den Zugriff auf Google-Server zu deaktivieren. Um das Ergebnis der Demonstration zu sehen, bitte die Kommentarzeichen <!-- und --> entfernen.</i></p>

<!--
<iframe width="720" height="405" src="https://www.youtube.com/embed/PcxaUHkmnSQ" title="Ewigkeit - Outbreakband (Official Video)" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
Outbreakband: Ewigkeit
-->

<!--
<figure>
	<iframe width="720" height="405" src="https://www.youtube.com/embed/PcxaUHkmnSQ" title="Ewigkeit - Outbreakband (Official Video)" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
	<figcaption>Outbreakband: Ewigkeit</figcaption>
</figure>
-->

<h4>GoogleMaps-Karte</h4>

<p>Den Einbettungs-Code für die Karte erhält man über die "Teilen"-Funktion im Menü auf der GoogleMaps-Seite.</p>

<p><i>Hinweis: Der folgende Code ist auskommentiert, um den Zugriff auf Google-Server zu deaktivieren. Um das Ergebnis der Demonstration zu sehen, bitte die Kommentarzeichen <!-- und --> entfernen.</i></p>

<!--
<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d1331.6806453458598!2d11.513305599999997!3d48.1225556!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x5f875ba02a03736!2zNDjCsDA3JzIxLjIiTiAxMcKwMzAnNDcuOSJF!5e0!3m2!1sde!2sde!4v1660604605751!5m2!1sde!2sde" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
Unser Worship-Platz im Westpark
-->

<!--
<figure>
	<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d1331.6806453458598!2d11.513305599999997!3d48.1225556!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x5f875ba02a03736!2zNDjCsDA3JzIxLjIiTiAxMcKwMzAnNDcuOSJF!5e0!3m2!1sde!2sde!4v1660604605751!5m2!1sde!2sde" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
	<figcaption>Unser Worship-Platz im Westpark</figcaption>
</figure>
-->

<h3>———— Absatz ————</h3>

<h4>Absatztrenner (* * *)</h4>

<p>Absatztrenner eignen sich als optische Trenner zwischen zwei Absätzen, z.B. um einen Nachsatz zu schreiben.</p>

<h2 class="center">* * *</h2>

<p>Hier folgt dann der abgetrennte Absatz...</p>

<h4>Inhaltsverzeichnis</h4>

<p>Anhand der im Artikel enthaltenen Überschriften mit ID wird automatisch ein Inhaltsverzeichnis generiert. Die IDs werden dabei als Sprungziele verwendet. Hier zunächst ein paar Beispiel-Überschriften und anschließend das daraus automatisch generierte Inhaltsverzeichnis:</p>

<div class="textbox">
	<h2 id="chapter-1">Kapitel 1</h2>
	<h3 id="section-1-1">Abschnitt 1</h3>
	<h3 id="section-1-2">Abschnitt 2</h3>
	<h3 id="section-1-3">Abschnitt 3</h3>
	<h2 id="chapter-2">Kapitel 2</h2>
	<h3 id="section-2-1">Abschnitt 1</h3>
	<h4 id="section-2-1-1">Unterabschnitt 1</h3>
	<h3 id="section-2-2">Abschnitt 2</h3>
	<h3 id="section-2-3">Abschnitt 3</h3>
</div>

<div class="toc"></div>

<h4>Inhaltsv. aufklappbar</h4>

<p>Wie zuvor, aber zum Aufklappen:</p>

<details class="toc textbox noprint" open>
	<summary><b>Inhaltsverzeichnis</b></summary>
</details>

<p>Wenn man das Attribut "open" weglässt, ist das Inhaltsverzeichnis initial zugeklappt. Ein weiteres Beispiel findet sich in der <a href="help">Hilfe</a>.</p>

<h4>Bereich aufklappbar</h4>

<p>Ein Abschnitt ist initial versteckt und kann durch Anklicken des Titels aufgeklappt werden:</p>

Details
<p>Es war einmal...</p>
<p>Und wenn sie nicht gestorben sind...</p>

<details class="textbox noprint">
	<summary><b>Details</b></summary>
	<p>Es war einmal...</p>
	<p>Und wenn sie nicht gestorben sind...</p>
</details>

<h4>Aufzählung (● ● ●)</h4>

Grid Layout ist wie Flexbox eine sehr moderne und einfache Möglichkeit, responsive und flexible Layouts zu erstellen, ohne feste Größenangaben und weitere CSS-Einstellungen wie position, float oder clear nutzen zu müssen.
Dabei können Elemente beliebig innerhalb eines Rasters platziert werden, wenn gewünscht, auch übereinander.
Grid Layout wird in allen modernen Browsern (und mit vendor-prefix -ms- selbst in IE10- IE11) unterstützt.

<ul>
	<li>Grid Layout ist wie Flexbox eine sehr moderne und einfache Möglichkeit, responsive und flexible Layouts zu erstellen, ohne feste Größenangaben und weitere CSS-Einstellungen wie position, float oder clear nutzen zu müssen.</li>
	<li>Dabei können Elemente beliebig innerhalb eines Rasters platziert werden, wenn gewünscht, auch übereinander.</li>
	<li>Grid Layout wird in allen modernen Browsern (und mit vendor-prefix -ms- selbst in IE10- IE11) unterstützt.</li>
</ul>

<p>Es können auch weitere Einrückungen vorgenommen werden. Dies muss aber manuell gemacht werden:</p>

<ul>
	<li>Punkt 1</li>
	<li>Punkt 2
		<ul>
			<li>Unterpunkt 1</li>
			<li>Unterpunkt 2</li>
			<li>Unterpunkt 3</li>
		</ul>
	</li>
	<li>Punkt 3</li>
</ul>

<h4>Aufzählung (1. 2. 3.)</h4>

Grid Layout ist wie Flexbox eine sehr moderne und einfache Möglichkeit, responsive und flexible Layouts zu erstellen, ohne feste Größenangaben und weitere CSS-Einstellungen wie position, float oder clear nutzen zu müssen.
Dabei können Elemente beliebig innerhalb eines Rasters platziert werden, wenn gewünscht, auch übereinander.
Grid Layout wird in allen modernen Browsern (und mit vendor-prefix -ms- selbst in IE10- IE11) unterstützt.

<ol>
	<li>Grid Layout ist wie Flexbox eine sehr moderne und einfache Möglichkeit, responsive und flexible Layouts zu erstellen, ohne feste Größenangaben und weitere CSS-Einstellungen wie position, float oder clear nutzen zu müssen.</li>
	<li>Dabei können Elemente beliebig innerhalb eines Rasters platziert werden, wenn gewünscht, auch übereinander.</li>
	<li>Grid Layout wird in allen modernen Browsern (und mit vendor-prefix -ms- selbst in IE10- IE11) unterstützt.</li>
</ol>

<p>Auch hier können durch manuell eingegebene HTML-Tags weitere Einrückungen erreicht werden:</p>

<ol>
	<li>Punkt 1</li>
	<li>Punkt 2
		<ol>
			<li>Unterpunkt 1</li>
			<li>Unterpunkt 2</li>
			<li>Unterpunkt 3</li>
		</ol>
	</li>
	<li>Punkt 3</li>
</ol>

<h4>Einzelne Fußnote (*)</h4>

Name aus Datenschutzgründen geändert.

<ul class="footnote" id="hinweis">
	<p><b>Hinweis:</b></p>
	<li>Name aus Datenschutzgründen geändert.</li>
</ul>

<h4>Mehrere Fußnoten (1. 2. 3.)</h4>

Grid Layout ist wie Flexbox eine sehr moderne und einfache Möglichkeit, responsive und flexible Layouts zu erstellen, ohne feste Größenangaben und weitere CSS-Einstellungen wie position, float oder clear nutzen zu müssen.
Dabei können Elemente beliebig innerhalb eines Rasters platziert werden, wenn gewünscht, auch übereinander.
Grid Layout wird in allen modernen Browsern (und mit vendor-prefix -ms- selbst in IE10- IE11) unterstützt.

<ol class="footnote" id="hinweise">
	<p><b>Hinweise:</b></p>
	<li>Grid Layout ist wie Flexbox eine sehr moderne und einfache Möglichkeit, responsive und flexible Layouts zu erstellen, ohne feste Größenangaben und weitere CSS-Einstellungen wie position, float oder clear nutzen zu müssen.</li>
	<li>Dabei können Elemente beliebig innerhalb eines Rasters platziert werden, wenn gewünscht, auch übereinander.</li>
	<li>Grid Layout wird in allen modernen Browsern (und mit vendor-prefix -ms- selbst in IE10- IE11) unterstützt.</li>
</ol>

<p>Fußnoten können auch mit Links zum Hin- und Zurückspringen versehen werden, wie etwa in diesem Beispiel der Hinweis auf Pseudonyme<a href="#pseudonym">*</a>:</p>

<ul class="footnote" id="pseudonym">
	<p><b>Hinweis:</b></p>
	<li>Name aus Datenschutzgründen geändert.</li>
</ul>

<h3>———— Zeile —————</h3>

<h4>Kein automat. Umbruch</h4>

<p>Wenn Textzeilen zuerst an "Sollbruchstellen" umgebrochen werden sollen, dann können die zusammengehörigen Teile zwischen diesen Sollbruchstellen mit diesem Snippet formatiert werden:</p> 

Erster zusammengehöriger Teil, zweiter zusammengehöriger Teil, dritter zusammengehöriger Teil.

<p><span class="nowrap">Erster zusammengehöriger Teil,</span> <span class="nowrap">zweiter zusammengehöriger Teil,</span> <span class="nowrap">dritter zusammengehöriger Teil.</span></p>

<h3>———— Kontakt-Link ————</h3>

<h4>Linktext</h4>

Kontaktformular

<a href="kontakt">Kontaktformular</a>

<p>Öffnet das Kontaktformular.</p>

<h4>Linktext + Betreff</h4>

Kontaktformular
Betreff der Nachricht

<a href="kontakt?subject=Betreff der Nachricht">Kontaktformular</a>

<p>Öffnet das Kontaktformular mit vorausgefüllter Betreffzeile.</p>

<h4>Linktext, Betreff + Nachricht</h4>

Kontaktformular
Betreff der Nachricht
Nachricht Zeile 1{}Nachricht Zeile 2{}Nachricht Zeile 3, eingerückt{}{}Nachricht Zeile 5{}

<a href="kontakt?subject=Betreff der Nachricht&message=Nachricht Zeile 1{}Nachricht Zeile 2{}Nachricht Zeile 3, eingerückt{}{}Nachricht Zeile 5{}">Kontaktformular</a>

<p>Öffnet das Kontaktformular mit vorausgefüllter Betreffzeile und Nachrichtentext.</p>

<p>Hinweis: Bei mehrzeiligem Nachrichtentext werden die einzelnen Zeilen der Nachricht durch {} voneinander getrennt.</p>

<h3>———— Übersetzung ————</h3>

<h4>Link</h4>

<p>Dieses Snippet fügt einen Link ein, der das Linkziel in "Google Translate" öffnet und in eine Zielsprache übersetzt. Die zu verwendende Quellsprache wird im Attribut <b>x-data-translate-from</b> des Snippets angegeben (z.B. "de" für Deutsch). Die Zielsprache ist die im Browser des Benutzers eingestellte Sprache (z.B. "en" für Englisch). Die Weiterleitung an "Google Translate" erfolgt nur, wenn Quell- und Zielsprache voneinander abweichen.</p>

Mehr dazu in der Hilfe|help#setup.

<p>Mehr dazu in der <a href="help#setup" target="_blank" rel="noopener" x-data-translate-from="de">Hilfe</a>.</p>

<h4>Diese Seite übersetzen</h4>

<p>Dieses Snippet fügt einen Button zum Übersetzen der Seite mit "Google Translate" ein. Die zu verwendende Quellsprache wird im Attribut <b>x-data-translate-from</b> des Snippets angegeben (z.B. "de" für Deutsch). Die Zielsprache ist die im Browser des Benutzers eingestellte Sprache (z.B. "en" für Englisch). Der Button ist nur sichtbar, wenn Quell- und Zielsprache voneinander abweichen.</p>

<p>Ohne markierten Text wird ein Standard-Linktext verwendet:</p> 

<p class="translate center hidden" x-data-translate-from="de"></p>

<p>Wenn statt des Standard-Linktextes ein eigener Linktext für den Button angezeigt werden soll, kann dieser innerhalb des <b>&lt;p&gt;</b>-Tags angegeben werden. Beim Einfügen des Snippets wird hierfür der markierte Text verwendet:</p>

Übersetzen

<p class="translate center hidden" x-data-translate-from="de">Übersetzen</p>

<h3>———— Textbausteine ————</h3>

<p>Textbausteine sind wiederverwendbare Texte, die in Artikel eingefügt werden können und zentral gepflegt werden. Änderungen an einem Textbaustein werden sofort in allen Artikeln sichtbar, in denen er eingefügt ist.</p>

<p>Beispiele für Textbausteine:</p>

<h4>Beispiel-Textbaustein</h4>

<?php include 'textblocks/beispiel-textbaustein.html';?>

<p>Um einen neuen Textbaustein zu erstellen, lege über den Button "<b>Neu</b>" (oben links) eine neue Datei mit dem Dateityp "Textbaustein" an. Binde diese dann mit dem obigen PHP-Code in den Artikel ein.</p>

<p>Um einen Textbaustein als Snippet in das "Einfügen..."-Menü einzubinden, erstelle eine neue Datei mit dem Dateityp "Snippet" und füge dort den PHP-Code nach obigem Beispiel ein. Öffne anschließend über den Button "<b>Öffnen</b>" (oben) die Datei "snippets.xml" aus dem Bereich "<b>Snippets</b>" und füge das neue Snippet an passender Stelle ein.</p>

<p>Ausführlich erklärt wird das Erstellen eigener Snippets in der <a href="help#snippets">Hilfe</a> unter "<b>Ein Snippet erstellen</b>".