<!-- PHP-Code für Snippet "Artikel-Card" -->

<?php
	function ArticleCard($link, $description = '')
	{
		global $fileTypes;
		global $fileTitles;
		global $fileDescriptions;
		global $fileImages;
		global $fileDates;

		$file = "$link.php";
		$type = def_type($fileTypes[$file] ?? null);
		$title = def_title($fileTitles[$file] ?? null);

		if (empty($description))
			$description = def_description($fileDescriptions[$file] ?? null);

		$image = def_image($fileImages[$file] ?? null);

		$date = def_date($fileDates[$file] ?? null);
		$displayDate = $type === 'post' ? MakeDisplayDate($date) : '';

		echo "	<div class=\"website\">\n";
		echo "		<a href=\"$link\" title=\"$title\">\n";
		echo "			<img src=\"$image\">\n";
		echo "			<div>\n";
		echo "				<p class=\"website-title\">$title</p>\n";
		echo "				<p class=\"website-date\">$displayDate</p>\n";
		echo "				<p class=\"website-description\">$description</p>\n";
		echo "				<p class=\"center\"><span class=\"button-link\" >" . GetString('ReadNow') . "</span></p>\n";
		echo "			</div>\n";
		echo "		</a>\n";
		echo "	</div>\n";
	}
?>
