<!-- Widget "Schlagworte" (Schlagwortwolke) -->

<?php
	function FillWidgetTags()
	{
		global $indexFile;
		global $tagSums;

		$minFontsize = 70;
		$maxFontsize = 180;

		$deltaFontsize = $maxFontsize - $minFontsize;

		echo '<p class="tag-cloud">';
		if (count($tagSums) > 0)
		{
			$minSum = PHP_INT_MAX;
			$maxSum = 0;
			foreach ($tagSums as $tag => $n)
			{
				$minSum = min($minSum, $n);
				$maxSum = max($maxSum, $n);
			}

			$deltaSum = $maxSum - $minSum;

			foreach ($tagSums as $tag => $n)
			{
				$fontsize = 100;
				if ($deltaSum > 0)
				{
					$fontsize = $minFontsize + ($n - $minSum) * $deltaFontsize / $deltaSum;
					// Damit die Größenverteilung etwas "natürlicher" aussieht, mit Hilfe des 10er-Logarithmus
					// den Anstieg der Schriftgröße nach oben hin etwas "flacher" machen:
					$normalized = ($fontsize - $minFontsize) / $deltaFontsize; # 0...1
					$fontsize = (int)($minFontsize + (log10($normalized + 0.1) + 1 - log10(1.1)) * $deltaFontsize);
				}
				echo '<a href="./' . $indexFile . '?tags=' . $tag . '" title="' . $n . ' Artikel" style="font-size: ' . $fontsize . '%">' . $tag . '</a> ';
			}
		}
		echo '</p>';
	}

	FillWidgetTags();
?>
