<?php
	$type = 'page';
	$published = false;
	$title = 'Hilfe zum Blog-System';
	$description = '';
	$image = '';
	$cats = '';
	$tags = '';
	$date = '2024-06-01';
	$listed = false;
	$pinned = false;
	$front = false;
	include 'lib/default-header.php';
?>

<p class="translate center hidden" x-data-translate-from="de"></p>

<details class="toc textbox noprint">
	<summary><b>Inhaltsverzeichnis</b></summary>
</details>

<p>Dies ist ein einfaches Blog-System für Leute (wie mich), für die WordPress mit all seinen Möglichkeiten und der Benutzerverwaltung eigentlich "Overkill" ist. Die einfach nur einen Blog oder eine Website erstellen möchten, ohne sich ständig um Updates kümmern oder sich um die weitere Verfügbarkeit und Kompatibilität von Plugins sorgen zu müssen. Denen der Block-Editor etwas "suspekt" ist und die keine Angst vor HTML haben, sondern lieber die volle Kontrolle über ihren Code behalten. Die ihre Erzeugnisse nicht so gerne einer obskuren Datenbank anvertrauen, sondern lieber offenen, transparenten Plaintext-Dateien...</p>

<p>Dieses Blog-System kommt mit einer Handvoll PHP-Dateien aus und benötigt keine Datenbank-Anbindung. Das gesamte Blog-Design und die Konfiguration des dahinterliegenden Blog-Systems erfolgt über einfach zu pflegende Textdateien. Auch die Artikel werden inklusive ihrer Metadaten wie Kategorien und Schlagwörter in je einer PHP-Datei im Hauptverzeichnis des Webservers gespeichert.</p>

<p>Die Artikel können in einem beliebigen Text-Editor verfasst und per SFTP hochgeladen werden, oder es kann der integrierte <a href="lib/editor" target="_blank" rel="noopener">Blog-Editor</a> verwendet werden, der noch über einige Sonderfunktionen verfügt, die das Erstellen von Artikeln vereinfachen können, wie z.B. die Angabe der Metadaten, einfache Textformatierungen oder das Einfügen von Medien (Bildern, Audio- und Videoclips, etc.).</p>

<p>Textformatierungen erfolgen durch direkte Zuweisung von HTML-Tags wie z.B. <b>&lt;p&gt;</b>Paperlapapp<b>&lt;/p&gt;</b> für einen Absatz (Paragraph) oder <b>&lt;b&gt;</b>Blabla<b>&lt;/b&gt;</b> für <b>Fettschrift</b> (Bold). Wie Texte formatiert werden, wird in der Vorlage-Datei <b>"Demo.php"</b> ausführlich erläutert und demonstriert. Dort kann man diese Funktionen einfach mal ausprobieren. Hier in diesem Beitrag soll es um die grundsätzliche Funktionsweise des Blog-Systems gehen.</p>

<h2 id="user-controls">Die Bedienelemente des Blog-Editors</h2>

<p>Die Ansicht des Blog-Editors ist zweigeteilt: In der linken Hälfte befindet sich der eigentliche Text-Editor, und in der rechten Hälfte die Vorschau. Links gibt man HTML-Code ein, rechts erscheint das Ergebnis - so, wie die der Artikel im Blog erscheinen wird.</p>

<p>Um das Ergebnis in der Vorschau (rechte Hälfte) bei verschiedenen Display-Breiten zu kontrollieren, kann man die Größenaufteilung zwischen linker und rechter Hälfte verändern. Hierzu einfach mit der Maus den kleinen dreieckigen "Anfasser" unten in der Mitte in horizontaler Richtung "ziehen".</p>

<p>Alle Funktionen des Editors sind erreichbar über die <i>Menüleiste</i> am oberen Rand mit den Buttons <b>Neu,</b> <b>Öffnen</b>, <b>Speichern</b> (usw.) und die darunter liegende <i>Werkzeugleiste</i> mit den Buttons <b>P</b>, <b>H2</b>, <b>H3</b> (usw.).</p>

<h2 id="menu-bar">Die Menüleiste</h2>

<p>Über die Buttons der Menüleiste sind alle Funktionen des Blog-Editors zugänglich:</p>

<h3 id="new">Button "Neu"</h3>

<p>Erstellt eine neue Datei (z.B. Blog-Artikel) im Editor. Zunächst kann hier eine <b>Vorlage ausgewählt</b> werden, die als Basis für die neue Datei dient. Es können auch eigene Vorlagen erstellt werden - dazu <a href="#templates">weiter unten</a> mehr.</p>

<p>Nach Auswahl einer Vorlage oder einfach "Leere Seite" öffnet sich das Fenster <b>Datei-Informationen bearbeiten</b>. Hier kann man - muss aber nicht - Angaben zur Datei machen, etwa Titel und Dateiname, Veröffentlichungsdatum, Kategorien und Schlagworte. Will man an dieser Stelle noch nichts eingeben, sondern diekt mit dem Schreiben loslegen, kann man den Dialog auch einfach mit dem "Abbrechen"-Button schließen. Er kann später jederzeit über den Menü-Button "Bearbeiten" erneut aufgerufen werden. Spätestens beim Speichern muss hier zumindest ein Dateiname angegeben werden.</p>

<p>Wenn man keinen Blog-Artikel (Beitrag oder Seite) erstellen möchte, sondern z.B. ein <a href="#widgets">Widget</a> oder ein <a href="#snippets">Snippet</a>, kann man im "Bearbeiten"-Dialog einen anderen Dateityp auswählen.</p>

<h3 id="open">Button "Öffnen"</h3>

<p>Öffnet die <b>Dateiverwaltung</b>. Dort können sämtliche vom Blog-System verwalteten Dateien aufgelistet, im Editor geöffnet, bearbeitet oder gelöscht werden. Außerdem können hier auch Datensicherungen (Backups) verwaltet werden.</p>

<h4 id="open-files">Die Dateiliste</h4>

<p>In der Liste werden die vorhandenen Dateien aufgelistet. Um sie anders zu sortieren, einfach auf die Spalten im Tabellenkopf klicken. In der Spalte ganz links sind eckige Auswahlelemente (Checkboxen) zu sehen. Diese dienen zur Auswahl eine oder mehrerer Dateien, um anschließend etwas mit ihnen zu machen, z.B. im Editor öffnen, oder löschen. Dateien können auch aus-/abgewählt werden, indem man einfach auf den Dateinamen oder eine andere Angabe in der Tabellenzeile klickt.</p>

<p>Oberhalb der Dateiliste befinden sich mehrere eingerahmte Bereiche, in denen zusammengehörige Bedienelemente gruppiert sind:</p>

<h4 id="open-list">Der Bereich "Auflisten"</h4>

<p>Hier kann ausgewählt werden, welche Art von Dateien aufgelistet werden sollen: Artikel (Beiträge, Seiten), Vorlagen, Textbausteine, Snippets, Widgets, Systemdateien und Backups. Je nach ausgewählter Dateiart ändert sich die Liste und die zur Verfügung stehenden Bedienelemente.</p>

<h4 id="open-functions">Der Bereich "Funktionen"</h4>

<p>Hier gibt es drei Buttons mit verschiedenen Funktionen:</p>

<ul>
	<li><b>Löschen:</b> Hiermit kann die in der Dateiliste ausgwählte Datei gelöscht werden. Artikel werden zunächst in den Papierkorb verschoben, alle anderen Dateiarten werden sofort und unwiderruflich gelöscht.</li>

	<li><b>Papierkorb:</b> Öffnet den Papierkorb. Hier können die dorthin verschobenen Artikel und Medien entweder wiederhergestellt oder endgültig gelöscht werden. Die Funktionen des Papierkorbs werden <a href="#trash">an anderer Stelle</a> genauer erklärt.</li>

	<li><b>Vergleichen:</b> Vergleicht die in der Dateiliste ausgewählte Datei mit dem Inhalt des Editors und zeigt in einem neuen Fenster die Unterschiede an. Mehr zu dieser Funktion weiter unten im Abschnitt <a href="#compare">Dateien vergleichen</a>.</li>
</ul>

<h4 id="open-insert">Der Bereich "Einfügen"</h4>

<p>Dieser Bereich ist nur bei der Auflistung "Artikel" sichtbar. Durch Klick auf den Button <b>Einfügen</b> können verschiedene Angaben zur ausgewählten Datei in den Text im Editor eingefügt werden. Was eingefügt werden soll, kann im Auswahlmenü links neben dem Button ausgewählt werden: Link, Titel und/oder Dateiname. Die Auswahl "Link" ist beispielsweise nützlich, um in einem Artikel einen anderen Artikel zu verlinken.</p> 

<h4 id="open-backup">Der Bereich "Backup"</h4>

<p>Dieser Bereich ist nur bei der Auflistung von "Backups" sichtbar. Hier können Datensicherungen des Blog-Systems (oder von Teilen davon) durchgeführt und heruntergeladen werden. Es gibt hier zwei Buttons:</p>

<ul>
	<li><b>Erstellen:</b> Öffnet ein weiteres, kleines Dialogfenster zum Erstellen einer Datensicherung. Hier gibt es folgende Bedien-Elemente:
		<ul>
			<li><b>Dateiname:</b> Der Name der erzeugten ZIP-Datei. Dieser wird vorausgefüllt und enthält den aktuellen Zeitstempel. Der Name kann beliebig abgeändert werden. Falls bereits eine Datei mit dem eingegebenen Namen existiert, wird sie kommentarlos überschrieben.</li>

			<li><b>Auswahl:</b> Dies bezieht sich auf die nachfolgend aufgeführten Verzeichnisse. Es können entweder alle Verzeichnisse aus- oder abgewäht, die Auswahl umgekehrt oder nur die Standard-Verzeichnisse ausgewählt werden.</li>

			<li><b>Verzeichnisse:</b> Hier werden alle gefundenen Verzeichnisse aufgeführt. Die <b>fett</b> geschriebenen Verzeichnisse sind die oben erwähnten Standard-Verzeichnisse - diese gehören zum Blog-System, die übrigen nicht (z.B. selbst angelegte Verzeichnisse). Die Blog-Artikel liegen im obersten Verzeichnis (das mit dem einzelnen Punkt als Namen). Über die Checkboxen kann ausgewählt werden, welche dieser Verzeichnisse in der Datensicherung enthalten sein sollen.</li>

			<li><b>Start:</b> Dieser Button startet das Backup. Je nach Menge und Größe der zu sichernden Dateien kann das zwischen ein paar Sekunden und Minuten dauern. Während und nach Erstellung des Backups wird unter "Meldung" ein entsprechender Hinweistext ausgegeben - oder eine Fehlermeldung, falls etwas schiefgeht.</li>
		</ul>
	</li>
	<li><b>Download:</b> Über diesen Button kann die in der Dateiliste ausgewählte Datensicherung als ZIP-Datei auf den lokalen Rrchner heruntergeladen werden.</p></li>
</ul>

<p>Eine Rücksicherungs-Funktion ist im Blog-System nicht implementiert. Um eine Datensicherung wieder zurückzuspielen, gibt es zwei Möglichkeiten: Entweder die heruntergeladene ZIP-Datei auf dem lokalen Rechner entpacken und per SFTP auf den Webserver hochladen (zuvor am besten dem Inhalt des Remote-Verzeichnisses löschen oder verschieben), oder per SSH auf dem Webserver anmelden und die ZIP-Datei aus dem Verzeichnis "backup" entpacken (diese dazu am besten vorher in ein Arbeitsverzeichnis verschieben und das Web-Verzeichnis, in dem die Dateien des Blog-Systems liegen, leeren).</p> 

<h3 id="save">Button "Speichern"</h3>

<p>Durch Klick auf diesen Button oder durch die <a href="#keyboard-shortcuts">Tastenkombination</a> <b>Strg+S</b> wird die aktuell im Editor geöffnete Datei gespeichert, sofern sie geändert wurde. Geänderte Dateien sind an dem roten Disketten-Symbol links unten in der Statusleiste erkennbar, wo auch Titel und Dateiname der bearbeiteten Datei angezeigt werden. Falls bisher noch kein Dateiname eingegeben wurde, öffnet sich der Dialog <b>Datei-Informationen bearbeiten</b> zur Eingabe des Dateinamens und ggf. weiterer Angaben.</p>

<p>Handelt es sich bei der Datei um einen Blog-Artikel (Beitrag, Seite, Index), wird bei jedem Speichern ein "Snapshot" (Schnappschuss / Momentaufnahme) erstellt. Snapshots landen im Papierkorb (unter "Auflisten: Snapshots"). Von dort können sie bei Bedarf "wiederhergestellt" (d.h. in den Ursprungsordner zurückverschoben) werden. So lassen sich gemachte Änderungen bei Bedarf später wieder rückgängig machen.</p>

<h3 id="edit">Button "Bearbeiten"</h3>

<p>Dieser Button öffnet den weiter oben schon mehrfach erwähnten Dialog <b>Datei-Informationen bearbeiten</b>. Hier können verschiedene Angaben zur geöffneten Datei gemacht werden. Durch Klick auf einen der drei Buttons unten wird das Dialogfenster geschlossen. Der Button "Speichern" speichert dabei die Datei, der Button "Schließen" übernimmt nur die Angaben in die Datei, ohne sie zu speichern, und der Button "Abbrechen" verwirft die vorgenommenen Änderungen.</p>

<p>Folgende Angaben zur Datei können gemacht werden:</p>

<h4 id="edit-type">Dateityp</h4>

<p>Blog-Artikel haben den Dateityp <b>Beitrag</b>, <b>Seite</b> oder <b>Index</b>. Des weiteren gibt es die Dateitypen <b>Vorlage</b>, <b>Textbaustein</b>, <b>Snippet</b>, <b>Widget</b> und <b>Systemdatei</b>. Je nach ausgewähltem Dateityp stehen in dem Bereich darunter mehr oder weniger Eingabefelder für zusätzliche Angaben zur Datei zur Verfügung.</p>

<ul>
	<li>Dateityp <b>Beitrag</b>: Blog-Artikel, der auf der Übersichts-Seite erscheinen soll.</li>

	<li>Dateityp <b>Seite</b>: Blog-Seite, die im Menü oder in einem Widget in der Seitenleiste verlinkt werden soll.</li>

	<li>Dateityp <b>Index</b>: Übersichts-Seite für Blog-Beiträge. Hier erscheinen die aufgelisteten Artikel in chronologischer Folge, wobei die neueren Artikel weiter oben stehen.</li>

	<li>Dateityp <b>Vorlage</b>: Eine Datei mit beliebigem Inhalt (z.B. HTML oder PHP), die beim Erstellen neuer Artikel/Dateien über den Menü-Button <b>Neu</b> zur Auswahl angeboten wird und als Vorlage für die neu zu erstellende Datei dient. Siehe auch <a href="#templates">Eine Vorlage erstellen</a>.</li>

	<li>Dateityp <b>Textbaustein</b>: Ebenfalls eine Datei mit beliebigem Inhalt (z.B. HTML oder PHP), der in einen Artikel eingefügt werden kann. Textbausteine werden zentral gepflegt, so dass Änderungen an einem Textbaustein sofort in allen Artikeln sichtbar werden, in denen er eingefügt ist. Siehe auch <a href="#textboxes">Einen Textbaustein erstellen</a>.</li>

	<li>Dateityp <b>Snippet</b>: Ein kleines Text- oder HTML-"Schnipsel", das über das "<b>Einfügen...</b>"-Menü in der Werkzeugleiste ausgewählt werden kann, und dessen Inhalt dann in den Text im Editor eingefügt wird. Snippets können spezielle Variablen enthalten, die beim Einfügen durch den im Editor markierten Text ersetzt werden. Mehr dazu weiter unten im Abschnitt <a href="#snippets">Ein Snippet erstellen</a>.</li>

	<li>Dateityp <b>Widget</b>: Eine Datei mit HTML- oder PHP-Inhalt, der als Element in die Seitenleiste des Blogs eingebunden wird. Das kann ein ganz einfacher Link mit Bild sein oder auch ein PHP-Programm zur Ausgabe spezieller Informationen. Standardmäßig sind schon einige Widgets enthalten, z.B. "Neueste Beiträge", "Kategorien", "Schlagwörter", "Blog durchsuchen". Siehe auch <a href="#widgets">Widgets einrichten</a>.</li>

	<li>Dateityp <b>Systemdatei</b>: Ein "Konglomerat" verschiedener Systemdateien zur weitreichenden Anpassung des Blogs. Auch die PHP-Programmdateien des Blog-Systems liegen hier. Genauer werden die Systemdateien und was man mit ihnen machen kann, <a href="#config">an anderer Stelle</a> erklärt.</li>
</ul>

<p>Durch entsprechende Benennung der Artikel (Beitrag, Seite, Index) kann festgelegt werden, ob als <a href="#homepage">Startseite</a> (d.h. als erste Seite, die beim Aufruf des Blogs im Browser erscheint) eine Übersichts-Seite aller Blog-Artikel (Dateityp: Index), eine Blog-Seite (Dateityp: Seite) oder sogar ein Blog-Beitrag (Dateityp: Beitrag) verwendet werden soll: Dazu gibt man der entsprechenden Datei einfach den Dateinamen "index" (kleingeschrieben).</p>

<h4 id="edit-date">Datum</h4>

<p>Das Veröffentlichungsdatum des Artikels. Es wird bei Beiträgen oben unter dem Beitragstitel angezeigt, und es bestimmt die Sortierung auf der Übersichts-Seite: Neuere Beiträge werden weiter oben aufgeführt. Die Eingabe erfolgt im Format JJJJ-MM-TT, wobei JJJJ das vierstellige Jahr, MM der zweistellige Monat und TT der zweistellige Tag ist (z.B. 2023-12-31).</p>

<h4 id="edit-title">Titel</h4>

<p>Titel des Artikels. Er wird bei Beiträgen und Seiten ganz oben angezeigt und auch in die Meta-Daten der erzeugten Blog-Seite übernommen, von wo er (wie die Kurzbeschreibung und das Beitragsbild) von Suchmaschinen oder von Social-Media-Anwendungen beim "Teilen" des Artikels ausgewertet werden kann.</p>

<h4 id="edit-filename">Dateiname</h4>

<p>Unter diesem Namen wird die Datei gespeichert. Bei Blog-Artikeln ist er auch Teil der URL, über die die Datei im Browser aufgerufen werden kann. Er sollte daher nach der Veröffentlichung eines Artikels nicht mehr geändert werden.</p>

<p>Bei Eingabe eines Titels wird für neue Dateien ein passender Dateiname vorgegeben, er kann aber manuell geändert werden. Ein Dateiname für Artikel, der ja auch als URL-Bestandteil verwendet wird, sollte möglichst nur aus Zahlen, Buchstaben und Bindestrichen bestehen und weder Umlaute, Sonderzeichen oder Leerzeichen enthalten.</p>

<p>Rechts neben dem Eingabefeld befinden sich zwei Buttons: Der "Zauberstab"-Button fügt einen anhand des Titels automatisch erzeugten Dateinamen ein, nachdem dieser manuell geändert wurde. Der "Rückgängig"-Button stellt den ursprünglichen Dateinamen wieder her.</p>

<p>Falls unter dem eingegebenen Dateinamen schon eine Datei existiert, wird ein entsprechender Hinweis ausgegeben. Wird die Datei trotzdem unter diesem Namen gespeichert, dann wird die existierende Datei überschrieben. Für Artikel wird dabei ein Snapshot erstellt, so dass die überschriebene Datei bei Bedarf später wiederhergestellt werden kann.</p>

<p>Wird der Dateiname eines Blog-Artikels, der bereits gespeichert wurde, geändert, so wird er unter diesem neuen Namen gespeichert. In diesem Fall erscheint eine Checkbox "Umbenennen". Wird dort ein Häkchen gesetzt, dann wird der unter dem alten Namen gespeicherte Artikel gelöscht und zusätzlich ein Snapshot erstellt. Ohne Häkchen wird der vorhandene Artikel nicht gelöscht.</p>

<h4 id="edit-baseurl">Basis-URL</h4>

<p>Diese Angabe ist sinnvoll, wenn der Artikel in einem anderen Verzeichnis verwendet werden soll, beispielsweise als Template für ein Script, dessen Pfad sich im Unterverzeichnis "lib/cgi-bin" befindet. In diesem Fall kann z.B. <b>/</b> oder <b>../</b> als Basis-URL angegeben werden. Dadurch werden die im Artikel verlinkten Ressourcen (Bilder, JavaScript- und CSS-Dateien) weiterhin gefunden. Normalerweise wird diese Angabe nicht benötigt und sollte daher leergelassen werden.</p>

<h4 id="edit-description">Beschreibung</h4>

<p>Eine kurze (!) Beschreibung des Artikel-Inhalts (1-2 Sätze). Sie wird auf der Übersichtsseite ausgegeben und auch in die Meta-Daten der erzeugten Blog-Seite übernommen, von wo sie (wie der Titel und das Beitragsbild) von Suchmaschinen oder von Social-Media-Anwendungen beim "Teilen" des Artikels ausgewertet werden kann.</p>

<h4 id="edit-image">Beitragsbild</h4>

<p>Ein Bild, das zusammen mit dem Beschreibungstext auf der Übersichtsseite angezeigt wird. Es wird bei Beiträgen und Seiten auch in die Meta-Daten der erzeugten Blog-Seite übernommen, von wo es (wie die der Titel und die Kurzbeschreibung) von Suchmaschinen oder von Social-Media-Anwendungen beim "Teilen" des Artikels übernommen und angezeigt werden kann. Durch Anklicken des rechts daneben befindlichen Buttons kann ein Bild aus der <a href="#media">Medienverwaltung</a> ausgewählt werden.</p>

<h4 id="edit-cats">Kategorien</h4>

<p>Beliebige Begriffe, unter denen der Artikel eingeordnet wird und gefunden werden können soll, beispielsweise über das "Kategorien"-Widget . Durch Anklicken des rechts daneben befindlichen Buttons können Kategorien, die bereits in anderen Artikeln verwendet werden, ausgewählt und in diesen Artikel übernommen werden. Neue Kategorien können hinzugefügt werden, indem man sie in das Eingabefeld schreibt. Die dort angegebenen Kategorien müssen durch Kommas voneinander getrennt werden.</p>

<h4 id="edit-tags">Schlagwörter</h4>

<p>Beliebige Begriffe, unter denen der Artikel verschlagwortet wird und gefunden werden können soll, beispielsweise über das "Schlagwörter"-Widget (Schlagwort-Wolke). Durch Anklicken des rechts daneben befindlichen Buttons können Schlagwörter, die bereits in anderen Artikeln verwendet werden, ausgewählt und in diesen Artikel übernommen werden. Neue Schlagwörter können hinzugefügt werden, indem man sie in das Eingabefeld schreibt. Die dort angegebenen Schlagwörter müssen durch Kommas voneinander getrennt werden.</p>

<h4 id="edit-published">Veröffentlicht</h4>

<p>Wenn dieses Häkchen gesetzt ist, gilt der Artikel als veröffentlicht, d.h. er wird dann auf der Website (Übersichts-Seite, Widgets) automatisch verlinkt. Zudem wird er in die Sitemap (<a href="sitemap.xml" target="_blank" rel="noopener">sitemap.xml</a>) aufgenommen und kann so von Suchmaschinen leichter gefunden werden. Ein ungesetztes Häkchen eignet sich für Artikel im Entwurfsstadium oder wenn ein Artikel nicht automatisch verlinkt werden soll.</p>

<p><b>Hinweis:</b> Ein nichtveröffentlichter Artikel kann weiterhin über seine Seitenadresse (URL) aufgerufen werden. Er ist nur "versteckt", aber nicht gesperrt! Wenn eine Seite oder ein Beitrag im <a href="#menu">Menü</a> oder in einem <a href="#widgets">Sidebar-Widget</a> manuell verlinkt wird, kann er von dort geöffnet werden. Auch wer die Seitenadresse kennt, kann den Artikel öffnen und lesen.</p>

<h4 id="edit-listed">Auflisten</h4>

<p>Ist hier ein Häkchen gesetzt, erscheint der Artikel auf der Übersichts-Seite; sonst nicht. Sinnvoll z.B. für Seiten oder Beiträge, die keine Blog-Einträge sind und nicht auf der Übersichts-Seite aufgelistet werden sollen, sondern nur im <a href="#menu">Menü</a> oder in einem <a href="#widgets">Sidebar-Widget</a> verlinkt werden sollen.</p>

<h4 id="edit-pinned">Anpinnen</h4>

<p>Ein hier gesetztes Häkchen bewirkt, dass ein Artikel in der Beitrags-Übersicht oben gehalten wird und somit eine höhere Aufmerksamkeit erhält.</p>

<h4 id="edit-front">Vollständig</h4>

<p>Ist dieses Häkchen gesetzt, dann wird statt des Beschreibungstextes der komplette Inhalt des Artikels auf der Übersichtsseite ausgegeben. In Kombination mit dem Häkchen "Anpinnen" lässt sich so z.B. ein einführender "Wilkommen"-Artikel oben auf der Übersichts-Seite plazieren.</p>

<h3 id="media">Button "Medien"</h3>

<p>Öffnet die <b>Medienverwaltung</b>. Hier können beliebige Dateien wie Bilder, Audio- und Videoclips oder z.B. auch PDF-Dateien hochgeladen werden, um sie anschließend in einen Artikel einzufügen. </p>

<h4 id="media-files">Die Dateiliste</h4>

<p>In der Dateiliste werden die vorhandenen Medien aufgelistet. Um sie anders zu sortieren, einfach auf die Spalten im Tabellenkopf klicken. Die Checkboxen in der ersten Spalte von links dienen zur Auswahl einer oder mehrerer Mediendateien. Mediendateien können auch aus-/abgewählt werden, indem man einfach auf den Dateinamen oder eine andere Angabe in der Tabellenzeile klickt. Durch Klick auf den Button <b>Einfügen</b> werden die Links der ausgewählten Dateien in den gerade bearbeiteten Text eingefügt.</p>

<p>In der zweiten Spalte wird eine Vorschau der Mediendatei angezeigt. Bei Audio- und Video-Dateien gibt es einen kleinen Player für die Wiedergabe. Bilder werden durch Anklicken in einem neuen Browser-Tab in voller Größe geöffnet. Die letzte Spalte (Verwendung) gibt an, wie oft eine Mediendatei in Blog-Artikeln verwendet wird. Die Dateinamen der betreffenden Artikel werden in der Spalte "Dateiname" ausgegeben. Ein Fragezeichen (?) in der letzten Spalte bedeutet, dass die Verwendung der Mediendatei nicht ermittelt werden konnte. Sie wird endweder nicht verwendet oder ist in einer anderen Datei eingebunden, die kein Artikel (Beitrag, Seite) ist.</p>

<p>Oberhalb der Dateiliste befinden sich mehrere eingerahmte Bereiche, in denen zusammengehörige Bedienelemente gruppiert sind:</p>

<h4 id="media-select">Der Bereich "Auswahl"</h4>

<p>Hier gibt es vier Buttons, um die Auswahl von Mediendateien zu unterstützen:</p>

<ul>
	<li><b>Alle:</b> Wählt alle in der Liste zu sehenden Mediendateien aus.</li>

	<li><b>Keine:</b> Entfernt das Auswahlhäkchen aller in der Liste zu sehenden Mediendateien.</li>

	<li><b>Umkehren:</b> Kehrt die Auswahl um: Gesetzte Häkchen werden entfernt, nicht gesetzte Häkchen werden gesetzt.</li>

	<li><b>Bereiche:</b> Setzt alle Häkchen zwischen zwei gesetzten Häkchen. Um also die 5. bis 10. Datei auszuwählen, braucht man nicht alle 6 Häkchen einzeln zu setzen, sondern nur zwei, und klickt dann auf "Bereiche".</li>
</ul>

<p>Die Auswahl-Buttons beziehen sich nur auf die gerade sichtbaren Dateien. Wenn ein Filter aktiv ist (siehe nachfolgende Überschrift) und dadurch Dateien ausgeblendet werden, bleiben deren Häkchen unverändert.</p>

<h4 id="media-filter">Der Bereich "Filter"</h4>

<p>Hier kann die Liste der angezeigten Dateien eingeschränkt werden:</p>
<ul>
	<li><b>Medientyp:</b> Einschränkung auf Audio-, Video-, Bild- und sonstige Dateien.</li>

	<li><b>Datei-Endung:</b> Einschränkung auf Dateien mit einer bestimmten Endung (z.B. *.jpg oder *.mp3).</li>

	<li><b>Datei-Jahr:</b> Einschränkung auf Dateien mit einem bestimmten Jahr des Dateidatums.</li>

	<li><b>Datei-Monat:</b> Einschränkung auf Dateien mit einem bestimmten Monat des Dateidatums.</li>
</ul>

<p>Das Dateidatum, das auch in der Listen-Spalte "Datum" angezeigt wird, ist entweder das Hochlade-Datum oder das Zuletzt-Geändert-Datum - je nachdem, ob beim Hochladen der Datei das Häkchen "Ursprüngliches Dateidatum beibehalten" gesetzt wurde oder nicht.</p>

<h4 id="media-functions">Der Bereich "Funktionen"</h4>

<p>Hier gibt es drei Buttons mit verschiedenen Funktionen:</p>

<ul>
	<li><b>Hinzufügen:</b> Öffnet ein weiteres, kleines Dialogfenster zum Hochladen einer Mediendatei vom lokalen Rechner. Dort gibt es folgende Bereiche:
		<ul>
			<li><b>Datei:</b> Hier klicken, um die hochzuladende Mediendatei von der Festplatte auszuwählen.</li>

			<li><b>Datum:</b> Wird hier ein Haken gesetzt, dann behält die hochgeladene Datei ihr originales Änderungsdatum. Andernfalls bekommt sie das aktuelle Datum (Hochlade-Datum).</li>

			<li><b>Hochladen:</b> Nach Klick auf diesen Button startet der Upload. Das kann bei größeren Dateien schonmal ein paar Sekunden dauern. Anschließend wird eine Fertigmeldung angezeigt (oder eine Fehlermeldung, falls etwas schiefgelaufen ist).</li>
		</ul>
	</li>
	<li><b>Löschen:</b> Verschiebt die ausgewählten Mediendateien in den Papierkorb.</li>

	<li><b>Papierkorb:</b> Offnet den Papierkorb. Hier können die dorthin verschobenen Artikel und Medien entweder wiederhergestellt oder endgültig gelöscht werden. Die einzelnen Funktionen des Papierkorbs werden <a href="#trash">weiter unten</a> genauer erklärt.</li>
</ul>

<h3 id="view">Button "Anzeigen"</h3>

<p>Öffnet die "Live"-Version (d.h. die zuletzt gespeicherte Version) des gerade bearbeiteten Blog-Artikels in einem neuen Browser-Tab. Wenn sich kein Blog-Artikel im Editor befindet, wird die Start-Seite des Blogs geladen.</p>

<h3 id="preview">Button "Vorschau"</h3>

<p>Öffnet den gerade bearbeiteten Blog-Artikel im Vorschau-Modus in einem neuen Browser-Tab. Wenn sich kein Blog-Artikel im Editor befindet, wird die Start-Seite des Blogs geladen. Im Vorschau-Modus werden andere Stylesheets als im Live-Modus verwendet (mehr dazu weiter unten unter <a href="#design-preview">Vorschau-Modus</a>).</p>

<p>Um eine Blog-Seite im Vorschau-Modus zu öffnen, wird an die URL der Parameter <b>preview</b> angehängt (z.B. <span style="color: #0000FF;">https://beispiel.de/artikel?<b>preview</b></span>). Auch alle internen Links werden dann automatisch so geändert, dass der Vorschau-Modus aktiv bleibt, wenn man auf Links zu Unterseiten klickt.</p>

<h3 id="help">Button "Hilfe"</h3>

<p>Öffnet die Hilfe-Seite (<i>diese</i> Seite) in einem neuen Browser-Tab. Je nachdem, welche Sprache in der <b>config.php</b> <a href="#config">konfiguriert</a> wurde, wird die Hilfe-Seite in der entsprechenden Übersetzung geöffnet. Falls für die konfigurierte Sprache (noch) keine Hilfe-Seite existiert, wird die deutsche Übersetzung angezeigt.</p>

<h3 id="trash">Der Papierkorb</h3>

<p>Den Papierkorb erreicht man über gleichnamigen Button, der im Bereich "Funktionen" von Dateiverwaltung (Menü-Button <b>Öffnen</b>) und Medienverwaltung (Menü-Button <b>Medien</b>) zu finden ist. Hier landen die "gelöschten" Blog-Artikel und Mediendateien sowie die Snapshots, die bei jedem Speichern eines Artikels automatisch erzeugt werden.</p>

<p>Auch hier gibt es oberhalb der Liste mehrere eingerahmte Bereiche, in denen zusammengehörige Bedienelemente gruppiert sind:</p>

<h4 id="trash-select">Der Bereich "Auswahl"</h4>

<p>Hier gibt es vier Buttons, um die Auswahl von Mediendateien zu unterstützen. Deren Funktion entspricht exakt denen in der Medienverwaltung (<a href="#media-select">siehe dort</a>).</p>

<h4 id="trash-list">Der Bereich "Auflisten"</h4>

<p>Über diese Radiobuttons kann ausgewählt werden, welche Art von Dateien aufgelistet werden sollen: Artikel (Beiträge, Seiten), Snapshots und Mediendateien.</p>

<h4 id="trash-functions">Der Bereich "Funktionen"</h4>

<p>Hier gibt es drei Buttons mit verschiedenen Funktionen:</p>

<ul>
	<li><b>Wiederherstellen:</b> Die ausgewählte Datei wird in ihren Ursprungsordner zurückverschoben. Dies funktioniert nur, wenn genau 1 Datei ausgewählt ist, nicht mit mehreren auf einmal.</li>

	<li><b>Endgültig löschen:</b> Löscht die ausgewählten Dateien aus dem Papierkorb. Sie sind dann "futsch" und können nicht wiederhergestellt werden.</li>

	<li><b>Vergleichen:</b> Vergleicht zwei in der Dateiliste ausgewählte Dateien miteinander und zeigt in einem neuen Fenster die Unterschiede an. Ist nur eine Datei ausgewählt, wird diese mit dem Inhalt des Editors verglichen. Mehr zu dieser Funktion weiter unten im Abschnitt <a href="#compare">Dateien vergleichen</a>.</li>
</ul>

<h3 id="compare">Dateien vergleichen</h3>

<p>Die Funktion "Dateien vergleichen" erreicht man über den <b>Vergleichen</b>-Button im Bereich "Funktionen" von Dateiverwaltung (Menü-Button <b>Öffnen</b>) oder <a href="#trash">Papierkorb</a>. In einem Textfenster werden die gefundenen Unterschiede zwischen Datei 1 (alter Stand) und Datei 2 (neuer Stand) farblich wie folgt gekennzeichnet:</p>

<ul>
	<li><span style="background-color: #FF0000; color: white; padding: 0.2em; margin: -0.2em;">Rot hinterlegt</span> sind <b>Löschungen</b>, d.h. Teile von Datei 1, die in Datei 2 fehlen.</li>

	<li><span style="background-color: #00C000; color: white; padding: 0.2em; margin: -0.2em;">Grün hinterlegt</span> sind <b>Hinzufügungen</b>, d.h. sind Teile von Datei 2, die in Datei 1 fehlen.</li>
</ul>

<p>Wird die Funktion "Vergleichen" aus der <b>Dateiverwaltung</b> heraus aufgerufen, dann wird die in der Dateiliste ausgewählte Datei (alter Stand) mit dem Inhalt des Editors (neuer Stand) verglichen. Hierbei ist zu beachten, dass die beiden PHP-Blöcke am Anfang und am Ende von Artikeln als vermeintlich "gelöscht" angezeigt werden, da diese zwar Teil der Datei sind (sie enthalten einige Variablen mit Metadaten), aber nicht in den Editor geladen werden.</p>

<p>Wird die Funktion "Vergleichen" aus dem <b>Papierkorb</b> heraus aufgerufen, dann hängt es von der Anzahl der ausgewählten Dateien ab, was womit verglichen wird: Ist nur <i>eine</i> Datei ausgewählt, wird diese mit dem Inhalt des Editors verglichen (wie in der Dateiverwaltung). Sind <i>zwei</i> Dateien ausgewählt, werden diese miteinander verglichen. Hierbei gilt die <i>zuerst</i> ausgewählte Datei als "Datei 1" (alter Stand) und die <i>zuletzt</i> ausgewählte Datei als "Datei 2" (neuer Stand).</p>

<p>Der Dateivergleich kann speziell bei "Snapshots" nützlich sein, um zu sehen, welche Änderungen bei den einzelnen Speichervorgängen eines Artikels vorgenommen wurden.</p>

<p>Einige "unsichtbare" Zeichen werden im Textfenster in roter Schrift visualisiert: Leerzeichen (<span style="color: #FF0000; font-size: 0.7em;">&bull;</span>), Tabulator (<span style="color: #FF0000; font-size: 0.7em;">HT</span>), Wagenrücklauf (<span style="color: #FF0000; font-size: 0.7em;">CR</span>) und Zeilenvorschub (<span style="color: #FF0000; font-size: 0.7em;">LF</span>). Dadurch sollen Änderungen noch genauer erkennbar werden.</p>

<p>Oberhalb der Liste gibt es wieder mehrere eingerahmte Bereiche, in denen zusammengehörige Bedienelemente gruppiert sind:</p>

<h4 id="compare-skip">Der Bereich "Springen"</h4>

<p>Hier gibt es zwei Buttons, um innerhalb des Textfensters zum <b>vorherigen</b> und zum <b>nächsten</b> Unterschied zu springen. Statt auf die Buttons zu klicken, kann man auch die <a href="#keyboard-shortcuts">Tastenkürzel</a> <b>Strg+Pfeil hoch</b> bzw. <b>Strg+Pfeil runter</b> benutzen.</p>

<h4 id="compare-filenames">Die Bereiche "Datei 1" und "Datei 2"</h4>

<p>Hier werden die Namen der beiden miteinander verglichenen Dateien angezeigt.</p>

<p><i>Hinweis:</i> Bei größeren Dateien kann der Vergleich schonmal etwas länger dauern. In der Fußzeile wird dann der Hinweis "Bitte warten..." angezeigt.</p>

<h2 id="toolbar">Die Werkzeugleiste</h2>

<p>Unterhalb der Menüleiste befindet sich die Werkzeugleiste für den Texteditor mit den Buttons zur Textformatierung und dem Auswahlmenü für die "Snippets".</p>

<p>Wie in der Einleitung bereits gesagt, verfügt dieses Blog-System über keinen "WYSIWYG-Editor" ("What You See Is What You Get"), sondern die Blog-Artikel werden direkt in HTML geschrieben. So hat man die volle Kontrolle über das Ergebnis, allerdings kann das Einfügen der HTML-Tags manchmal etwas lästig sein, denn beim Schreiben will man sich ja eigentlich auf den Inhalt konzentrieren. Auch kann HTML-Code schonmal etwas unübersichtlich sein.</p>

<p>Daher gibt es in der Werkzeugleiste einige nützliche Funktionen zur Textformatierung, die das Einfügen der HTML-Tags erleichtert. Außerdem gibt es eine "Live-Vorschau": Während links der Text geschrieben wird, ist rechts sofort das Ergebnis zu sehen.</p>

<h3 id="toolbar-format">Textformatierung</h3>

<p>Wird einer der Buttons angeklickt oder das dazugehörige <a href="#keyboard-shortcuts">Tastaturkürzel</a> eingegeben, dann werden die entsprechenden HTML-Tags direkt in den Text eingefügt. Ist kein Text markiert, werden leere Tags an die aktuelle Cursorposition eingefügt (z.B. <span style="background-color: #C0E0FF; padding: 0.2em; margin: -0.2em;">&lt;p&gt;&lt;/p&gt;</span>). Ist Text markiert, wird der Text mit den Tags umschlossen (z.B. <span style="background-color: #C0E0FF; padding: 0.2em; margin: -0.2em;">&lt;p&gt;Markierter Text&lt;/p&gt;</span>).</p>

<figure>
	<table>
		<tr>
			<th>Button</th>
			<th>Tastaturkürzel</th>
			<th>Funktion</th>
		</tr>
		<tr>
			<td><b>P</b></td>
			<td>Alt+P</td>
			<td>Absatzformatierung einfügen</td>
		</tr>
		<tr>
			<td><b>H2</b> bis <b>H5</b></td>
			<td>Alt+2...5</td>
			<td>Überschrift 2...5 einfügen</td>
		</tr>
		<tr>
			<td><b>B</b></td>
			<td>Alt+B</td>
			<td>Text <b>fett</b> formatieren</td>
		</tr>
		<tr>
			<td><b><i>I</i></b></td>
			<td>Alt+I</td>
			<td>Text <i>kursiv</i> formatieren</td>
		</tr>
		<tr>
			<td><b><u>U</u></b></td>
			<td>Alt+U</td>
			<td>Text <u>unterstrichen</u> formatieren</td>
		</tr>
	</table>
</figure>

<p>Zusätzlich zu den oben angegebenen Tastaturkürzeln und den Standard-Tastaturkürzeln des Browsers wie z.B. <b>Strg+C/X/V</b> für die Zwischenablage gibt es noch folgende weitere:</p>

<ul>
	<li><b>Strg+Enter:</b> Trennt einen Absatz an der aktuellen Cursorposition auf, indem <b>&lt;/p&gt;&lt;p&gt;</b> eingefügt wird. Wenn man etwa beim Schreiben in der Mitte eines Absatzes feststellt, dass der Absatz schon viel zu lang geworden ist, drückt man Strg+Enter und <i>schwupps</i> steht der Text in zwei Absätzen.</li>

	<li><b>Umschalt+Enter:</b> Fügt einen Zeilenwechsel (<b>&lt;br&gt;</b>) ein. Wenn der Text innerhalb eines Absatzes in einer neuen Zeile weitergehen soll, einfach Umschalt+Enter drücken.</li>

	<li><b>Strg+D:</b> Dupliziert den markierten Text oder, wenn kein Text markiert ist, die ganze Zeile, in der sich der Cursor gerade befindet.</li>

	<li><b>Strg+Hoch/Runter:</b> Zeilenweises Scrollen des Editor-Inhalts.</li>
</ul>

<p>Es können auch eigene Tastaturkürzel angelegt werden - Genaueres dazu im Abschnitt <a href="#keyboard-shortcuts">Eigene Tastaturkürzel anlegen</a>.</p>

<h3 id="toolbar-colors">Farben</h3>

<p>Daneben gibt es noch 3 weitere Buttons für die farbliche Formatierung des Textes:</p>

<figure>
	<table>
		<tr>
			<th>Funktion</th>
			<th>Beispiel</th>
		</tr>
		<tr>
			<td>Textmarker</td>
			<td><mark>Beispiel</mark></td>
		</tr>
		<tr>
			<td>Hintergrundfarbe</td>
			<td><span style="background-color: #FFC0FF; padding: 0.2em; margin: -0.2em;">Beispiel</span></td>
		</tr>
		<tr>
			<td>Schriftfarbe</td>
			<td><span style="color: #00C000;">Beispiel</span></td>
		</tr>
	</table>
</figure>

<p>Der <b>Textmarker</b> hat eine vom Browser vorgegebene Farbe (meist gelb). Die <b>Hintergrundfarbe</b> und die <b>Schriftfarbe</b> können frei gewählt werden. Hierzu gibt es zwei Farbpicker. Diese sehen auf den verschiedenen Browsern etwas unterschiedlich aus. Grundsätzlich sind sie aber zweigeteilt: Mit Klick auf die rechte Hälfte wird die Farbe ausgewählt, und ein Klick auf die linke Hälfte fügt die Farb-Tags in den Editor ein.</p>

<h3 id="toolbar-remove">Formatierung entfernen</h3>

<p>Um eine Formatierung wieder zu entfernen, einfach den Text inklusive der Tags markieren und den Button <b>x</b> anklicken. Mit jedem Klick auf den <b>x</b>-Button wird von außen nach innen bzw. von links nach rechts eine weitere Formatierung entfernt. Welches Tag-Paar entfernt wird, ist in dem Tooltip zu sehen, das erscheint, wenn man den Mauszeiger über den <b>x</b>-Button hält (ohne zu klicken).</p>

<h3 id="toolbar-snippets">Das Snippet-Menü</h3>

<p>Snippets sind (wie schon der Name suggeriert) kleine Schnipsel von HTML- oder PHP-Code, die in den Text eingefügt werden können. Sie können Variablen enthalten, die dann durch die im Text markierten Zeilen / Textteile ersetzt werden. Als Trenner zwischen den einzelnen Text-Teilen fungieren dabei der Zeilenumbruch, der Tabulator und die drei Zeichen <b>[</b> <b>|</b> <b>]</b>.</p>

<p>Die Snippets können aus der Auswahlbox ganz rechts in der Werkzeugleiste (im folgenden einfach "Snippet-Menü" genannt) oder - falls vorhanden - durch Eingabe einer <a href="#keyboard-shortcuts">Tastenkombination</a> ausgewählt werden.</p>

<p>Ist kein Text markiert, wird ein "leeres" Snippet in den Text eingefügt. Ist Text markiert, dann wird es mit dem markierten Text "ausgefüllt". So lassen sich markierte Textteile ganz einfach z.B. als Link, Bild, Zitat, Tabelle oder Aufzählungsliste formatieren.</p>

<p>Eine Demonstration aller Snippets ist in der Datei <b>Demo.php</b> unter "Vorlagen" enthalten. Wie man eigene Snippets erstellt, wird weiter unten im Abschnitt <a href="#snippets">Ein Snippet erstellen</a> erklärt.</p>

<h2 id="installation">Installation und Einrichtung des Blog-Systems</h2>

<p>Um das Blog-System nutzen zu können, muss es auf einem Webserver installiert werden, der PHP unterstützt. Hier gibt es sowohl kommerzielle als auch <a href="https://duckduckgo.com/?q=webspace+php+kostenlos" target="_blank" rel="noopener">kostenlose Anbieter</a>. Möchte man eine eigene Domain für die Website haben (z.B. <b>beispiel.de</b>), wird man wohl zu einem kommerziellen Anbieter greifen müssen. Bei <a href="https://www.strato.de/hosting/" target="_blank" rel="noopener">Strato</a> beispielsweise bekommt man 50 GB Webspace inklusive 1 Domain mit SSL-Zertifikat (https) für 5 €/Monat; bei <a href="https://www.manitu.de/webhosting/" target="_blank" rel="noopener">Manitu</a> kostet es sogar nur die Hälfte (Stand: Juni 2024).</p>

<h3 id="upload">Dateien auf den Webspace hochladen</h3>

<p>Zuerst wird die heruntergeladene ZIP-Datei in ein Verzeichnis auf dem lokalen Rechner entpackt. Folgende Verzeichnisse sollten nun zu sehen sein:</p>

<ul>
	<li><b>common:</b> Gemeinsame Dateien für alle Sprachen.</li>
	<li><b>de:</b> Dateien für die Sprache Deutsch.</li>
	<li><b>en:</b> Dateien für die Sprache Englisch.</li>
</ul>

<p>Als nächstes wird der Inhalt des Verzeichnisses <b>common</b> auf den Webserver hochgeladen. Dazu startet man ein SFTP-Programm (z.B. <a href="https://www.filezilla.de" target="_blank" rel="noopener">FileZilla</a> oder <a href="https://winscp.net/" target="_blank" rel="noopener">WinSCP</a>), verbindet sich mit dem Webserver, öffnet im linken Fenster das lokale Verzeichnis "common", markiert alle dort zu sehenden Dateien und Unterverzeichnisse startet den Upload.</p>

<p>Danach lädt man auf die gleiche Weise den Inhalt <i>eines</i> der beiden lokalen Verzeichnisse <b>de</b> <i>oder</i> <b>en</b> hoch - je nachdem, in welcher Sprache (Deutsch oder Englisch) man das Blog-System nutzen möchte. (Nicht wundern, dass <b>common</b> und <b>de</b>/<b>en</b> identische Unterverzeichnisse enthalten - das gehört so!)</p>

<p>Jetzt sollte die Website durch Eingabe der Adresse (z.B. "beispiel.de") im Browser aufgerufen werden können.</p>

<h3 id="setup">Grundeinstellungen vornehmen mit dem Setup-Programm</h3>

<p>Nun sollten noch einige Grundeinstellungen vorgenommen werden. Dazu ruft man aus dem Menü den Punkt "Admin &gt; <a href="lib/setup" target="_blank" rel="noopener">Setup</a>" auf. Wichtig sind zunächst folgende Einstellungen:</p>

<ul>
	<li><b>Zugriffsschutz:</b> Hier sollte <b>Aktiv</b> auf <b>ja</b> gesetzt werden. Dadurch wird der Administrationsbereich des Blog-Systems durch eine Benutzeranmeldung geschützt. Vorkonfiguriert ist der Benutzername "admin" und das Passwort "start", was aber durch Angabe eines neuen Benutzernamens und eines neuen Passwortes in die entsprechenden Eingabefelder geändert werden kann. Zumindest das Passwort sollte unbedingt geändert werden, sonst kann sich jeder in den Administrationsbereich einloggen, der diese Hilfe-Datei kennt! Es können auch weitere Benutzer angelegt werden, falls mehrere Personen den Blog administrieren und Beiträge erstellen sollen.</li>
	<li><b>CGI-Scripts:</b> Hier sollte <b>Ausführbar setzen</b> auf <b>ja</b> gesetzt sein. Dies ist schon automatisch so voreingestellt, wenn das Setup zum ersten Mal nach einer neuen Installation ausgeführt wird. Dadurch wird das Ausführen-Flag der .pl-Dateien im Unterverzeichnis "cgi-bin" gesetzt. Ist dies einmal geschehen, dann kann die Auswahl bei späteren Aufrufen des Setup auf "nein" bleiben.</li>
	<li><b>Sprache und Region:</b> Hier gibt es folgende Einstellungen:
		<ul>
			<li><b>Sprache:</b> Die Sprache, in der die Webseiten erstellt werden sollen. Diese Angabe bestimmt auch die Übersetzung der Texte dieses Blog-Systems.</li>
			<li><b>Land:</b> Das Land, in dem das Blog-System benutzt wird. Diese Angabe bestimmt die Formatierung von Datumsangaben und die Sortierung von Listen.</li>
			<li><b>Zeitzone:</b> Die Zeitzone für Datumsberechnungen.</li>
			<li><b>Datumsformat (für Editor):</b> Das Format des Zeitstempels von Dateien im Editor.</li>
		</ul>
		Welche Werte für die obigen Felder zulässig sind, kann man durch Klick auf das Info-Icon 🛈 erfahren.
	</li>
	<li><b>Angaben zur Website:</b> Diese Angaben erscheinen auf den einzelnen Seiten des Blogs:
		<ul>
			<li><b>Adresse der Website:</b> Die Basis-URL für Metadaten, Sitemap und Aufruf der Suchfunktion. Wenn hier nichts eingetragen wird, dann wird die Adresse anhand der Seiten-URL automatisch ermittelt.</li>
			<li><b>Name der Website:</b> Der Name der Website für Logo und E-Mail-Absender.</li>
			<li><b>Titel des Seiten-Headers:</b> Der Titel des Seiten-Headers.</li>
			<li><b>Untertitel des Seiten-Headers:</b> Der Untertitel des Seiten-Headers.</li>
		</ul>
		Der Seiten-Header erscheint oben quer über jeder Seite des Blogs.
	</li>
</ul>

<p>Zum Speichern der vorgenommenen Eingaben muss dann nur noch auf den Button <b>Speichern</b> unten geklickt werden. Dabei werden im Hintergrund die Dateien config.php, .htpasswd und .htaccess angepasst sowie das X-Flag .pl-Dateien im Unterverzeichnis "cgi-bin" gesetzt.</p>

<h3 id="setup-manual">Alternativ: Grundeinstellungen manuell vornehmen</h3>

<p>Anstelle der Verwendung des Setup-Programms können die Grundeinstellungen auch durch manuelle Bearbeitung einzelner Dateien vorgenommen werden:</p>

<p>Zuerst sollten für die .pl-Dateien im Unterverzeichnis <b>lib/cgi-bin</b> (und den darunterliegenden) die Ausführungsrechte gesetzt werden. Dazu verbindet man sich per SFTP oder SSH mit dem Webserver, wechselt in das Unterverzeichnis <b>lib/cgi-bin</b> und setzt das X-Flag der .pl-Dateien. Im SFTP-Programm markiert man die Dateien und ruft durch Rechtsklick das Eigenschaften-Menü auf, wo man mittels Checkboxen das X-Flag setzen kann. Im SSH-Terminal gibt man den Befehl "<code><b>chmod 755 *.pl</b></code>" ein.</p>

<p>Anschließend ruft man den <a href="lib/editor" target="_blank" rel="noopener">Blog-Editor</a> auf. Diesen erreicht man nach Eingabe der Blog-URL (z.B. <b>beispiel.de</b>) im Browser über das Menü "Admin &gt; Editor" oder über die Adresse <b><i>beispiel.de</i>/lib/editor</b> (wobei <b><i>beispiel.de</i></b> natürlich dem verwendeten Domainnamen entspricht).</p>

<p>Dort sollte zuerst ein Benutzer und ein Passwort vergeben werden, damit nur berechtigte Personen den Editor aufrufen können. Dazu öffnet man die Datei <b>lib/.htpasswd</b> im Editor ("Öffnen > Auflisten: System > Datei: .htaccess > Öffnen"). Die Datei <b>.htpasswd</b> enthält die folgende Zeile:</p>

<pre class="textbox">
admin:$2y$10$V1xgLMroqleW56Sja.s0c.szh2oXgST.vVqZ1FiCowrJdZjMkaLn.
</pre>

<p>Der Teil vor dem Doppelpunkt ist der Benutzername (hier "admin"), dahinter steht das verschlüsselte Passwort (hier "start"). Ersetze den Benutzernamen einfach durch einen beliebigen Namen (ohne Leerzeichen und Sonderzeichen), z.B. "fritz", oder belasse ihn auf "admin". Das Passwort sollte nicht zu einfach zu erraten sein. Schreibe es einfach im Klartext hinter den Doppelpunkt. Um es zu verschlüsseln, markiere es...</p>

<pre class="textbox">
fritz:<span style="background-color: #C0E0FF; padding: 0.2em; margin: -0.2em;">test1234</span>
</pre>

<p>...und klicke auf den Button <b>Passwort verschlüsseln</b> in der Werkzeugleiste. Das Passwort sollte nun verschlüsselt sein und die Datei kann gespeichert werden:

<pre class="textbox">
fritz:$2y$10$AdnOhm3i.xhEX0yC0KmHwuSmXY5Jy0irPux4meh67TNkI.Zy.uiCu
</pre>

<p>Um nun den Zugriffsschutz zu aktivieren, öffne die Vorlage-Datei <b>.htaccess.tpl</b> im Editor. Dann klicke auf den Menü-Button <b>Bearbeiten</b> und ändere den Dateinamen zu <b>.htaccess</b>. Wichtig: An dieser Stelle die Datei noch <i>nicht speichern</i>, sondern den Dialog durch Klick auf <b>Schließen</b> schließen! (Andernfalls wird eine nicht funktioniernde .htaccess-Datei gespeichert und es erscheint eine Server-Fehlermeldung "Internal Server Error". In diesem Fall muss die .htaccess-Datei per SFTP oder SSH gelöscht werden.)</p>

<p>Die Datei enthält folgende Zeilen (Auszug):</p>

<pre class="textbox">
AuthType Basic
AuthName "Bitte anmelden"
<span style="background-color: #C0E0FF; padding: 0.2em; margin: -0.2em;">AuthUserFile /path/to/lib/.htpasswd</span>
Require valid-user
</pre>

<p>Markiere oder lösche die Zeile mit dem "AuthUserFile". Klicke nun auf den Button <b>AuthUserFile</b> in der Werkzeugleiste. Dadurch wird eine neue AuthUserFile-Zeile in die Datei eingefügt, die nun den tatsächlichen Server-Pfad zur Datei <b>.htpasswd</b> enthält:</p>

<pre class="textbox">
AuthType Basic
AuthName "Bitte anmelden"
<span style="color: #0000FF;">AuthUserFile /home/strato/http/premium/rid/12/34/567890/htdocs/beispiel.de/lib/.htpasswd</span>
Require valid-user
</pre>

<p>Jetzt kann die Datei durch Klick auf den Menü-Button <b>Speichern</b> gespeichert werden.</p>

<p>Wenn alles funktioniert hat, sollte jetzt beim nächsten Öffnen des Editors oder beim Aufruf bestimmter Funktionen ein Anmeldefenster kommen, in das die soeben konfigurierten Anmeldedaten (Benutzer + Passwort) eingegeben werden können, um sich zu authentifizieren. Falls stattdessen eine Server-Fehlermeldung "Internal Server Error" erscheint, die .htaccess-Datei per SFTP oder SSH löschen und nochmal probieren.</p>

<h3 id="config">Die Website-Konfiguration anpassen</h3>

<p>Nach erfolgter Installation sollten als erstes einige grundlegende Einstellungen zur Website vorgenommen werden, etwa Sprache und Region, Adresse und Name der Website, Header-Titel und -Untertitel. Wenn dies nicht bereits mit Hilfe des <a href="#setup">Setup-Programms</a> durchgeführt wurde, kann dies auch manuell konfiguriert werden.</p>

<p>Hierzu wird die Datei <b>lib/config.php</b> bearbeitet - entweder die Kopie auf dem lokalen Rechner, die anschließend per SFTP auf den Server hochgeladen wird, oder direkt im Editor des Blog-Systems über "Öffnen > Auflisten: System > Dateiname: config.php > Öffnen". Letzteres hat den Vorteil, dass man in der Vorschau auf der rechten Seite gleich das Ergebnis der Änderungen sieht.</p>

<pre class="textbox">
<span style="color: #00AA00;">// Sprache und Region</span>
$lang = '<span style="color: #0000FF;">de</span>';
$locale = '<span style="color: #0000FF;">de_DE</span>';
$phpLocale = '<span style="color: #0000FF;">de_DE.utf8</span>';
$timezone = '<span style="color: #0000FF;">Europe/Berlin</span>';
$DateTimeFormat = '<span style="color: #0000FF;">d.m.Y H:i:s</span>';

<span style="color: #00AA00;">// Angaben zur Website</span>
$baseUrl = '<span style="color: #0000FF;">https://beispiel.de</span>';
$websiteName = '<span style="color: #0000FF;">Mein Blog</span>';
$headerTitle = '<span style="color: #0000FF;">Mein Blog</span>';
$headerSubtitle = '<span style="color: #0000FF;">Willkommen auf | meinem Blog</span>';
</pre>

<p>Die Angabe der Adresse der Website (Variable <b>$baseUrl</b>) ist optional; wenn sie fehlt, wird sie anhand der URL der Seite automatisch ermittelt. Der Name der Website (Variable <b>$websiteName</b>) wird u.a. für das Logo über dem Header (Kopfbereich der Website) verwendet. Header-Titel und -Untertitel (Variablen <b>$headerTitle</b> und <b>$headerSubtitle</b>) werden über das Header-Bild (s.u.) geschrieben. Dieses befindet sich oben quer über jeder Webseite. Das Zeichen <b>|</b> im Header-Untertitel wird nicht mit ausgegeben; es fügt eine "Sollbruchstelle" ein, an der der Text auf schmalen Displays zuerst umgebrochen wird, damit er auch dann noch symmetrisch erscheint.</p>

<p>Weitere Hinweise zu den möglichen Anpassungen enthalten die Kommentare in der <b>config.php</b>.</p>

<h2 id="customizing">Individuelle Anpassungen</h2>

<p>Das Blog-System kann in weiten Teilen individuell angepasst werden ("Customizing"). Hier ein Überblick über die verschiedenen Möglichkeiten:</p>

<h3 id="appearance">Das Aussehen anpassen</h3>

<p>Grundlegende Anpassungen, die das Erscheinungsbild der Website betreffen, etwa Farben, Ecken-Radien und Bilder, lassen sich in der Datei <b>lib/user.css</b> vornehmen. Dabei handelt es sich um einen Ausschnitt aus dem großen Standard-Stylesheet <b>lib/default.css</b>. Hier ein Auszug aus dieser Datei mit einigen anschließenden Erläuterungen:</p>

<pre class="textbox">
--WebsiteIcon: url('<span style="color: #0000FF;">media/default-favicon.png</span>');
--DefaultFgColor: <span style="color: #0000FF;">#000000</span>;
--DefaultBgColor: <span style="color: #0000FF;">#E6E9EC</span>;
--DefaultBorderRadius: <span style="color: #0000FF;">7px</span>;
--HeaderImage: url('<span style="color: #0000FF;">media/default-header-image.jpg</span>');
--ContentBgImage: url('<span style="color: #0000FF;">media/default-article-image.jpg</span>');
</pre>

<p>Die auf "Color" endenden Variablen sind die Farbvariablen. Die Farbwerte sind hier in Hexadezimal-Schreibweise angegeben, aber man kann natürlich auch andere Schreibweisen verwenden wie z.B. rgb(...). Mehr zur Anpassung der Farben weiter unten unter <a href="#design-user-css">Ein Benutzer-Stylesheet erstellen</a>. </p>

<p>Das Website-Icon (Variable <b>--WebsiteIcon</b>) wird z.B. im Browser beim Lesezeichen oder in der Tab-Leiste angezeigt. Das Header-Bild (Variable <b>--HeaderImage</b>) wird oben quer über jeder Webseite des Blogs angezeigt. Das Standard-Beitragsbild (Variable <b>--ContentBgImage</b>) wird verwendet, wenn man zu einem Artikel kein individuelles Beitragsbild angibt. Das Beitragsbild wird in der Beitragsübersicht angezeigt und auch beim "Teilen" des Links in Messengern und Sozialen Netzwerken verwendet.</p>

<p>Die angegebenen Bilder sind bereits in der Grundinstallation enthalten. Eigene Bilder können über die Medienverwaltung hochgeladen und deren Pfade (media/...) dann hier eingefügt werden.</p>

<p>Dies ist nur ein kleiner Teil der möglichen Anpassungen am Design und am Layout der Website. Mehr dazu <a href="#design">weiter unten</a>.</p>

<h3 id="translation">Eine Übersetzung hinzufügen</h3>

<p>In der <b>config.php</b> gibt es den Parameter <b>$lang</b> für die verwendete Sprache. Dieser kann z.B. 'de' für Deutsch oder 'en' für Englisch lauten. Wird eine andere Sprache gewünscht, kann deren zweistelliges Kürzel hier angegeben werden (z.B. <b>$lang = 'fr';</b> für Französisch). Falls für eine Sprache noch keine Übersetzung existiert, wird Englisch verwendet.</p>

<p>Um eine Übersetzung für eine neue Sprache zu erstellen, kann man eine der vorhandenen Sprachdateien <b>lib/lang-en.php</b> oder <b>lib/lang-de.php</b> öffnen und anpassen. Die neue Sprachdatei wird dann unter dem Namen <b>lang-<i>xx</i>.php</b> abgespeichert, wobei <b><i>xx</i></b> das Sprachkürzel ist, z.B. <b>lang-fr.php</b> für Französisch.</p>

<h3 id="design">Das Design und das Layout ändern</h3>

<p>Das Design umfasst das Aussehen einzelner Elemente wie z.B. die Farben, Randabstände oder Rundungen. Das Layout bezieht sich auf die Anordnung der einzelnen Elemente, z.B. ob die Seitenleiste links oder rechts neben dem Hauptinhalt angezeigt wird.</p>

<p>Alle Änderungen am Design und am Layout werden an Stylesheet-Dateien (*.css) vorgenommen, die im Unterverzeichnis <b>lib</b> liegen. Welche Stylesheets aktiv sind, kann in der Datei <b>config.php</b> angegeben werden:</p>

<pre class="textbox">
<span style="color: #00AA00;">// Stylesheets für den "Live"-Modus</span>
$stylesheet = '<b>default.css</b>'; <span style="color: #00AA00;">// Standard-Stylesheet</span>
$userStylesheet = '<b>user.css</b>'; <span style="color: #00AA00;">// Benutzer-Stylesheet (optional)</span>
</pre>

<p>Das Standard-Stylesheet ist <b>default.css</b>. Zusätzlich ist es möglich, ein optionales Benutzer-Stylesheet zu erstellen und dessen Dateinnamen dann hier einzutragen (hier <b>user.css</b>), um einzelne Angaben des Standard-Stylesheets zu "überschreiben" (siehe dazu weiter unten im Abschnitt <a href="#design-user-css">Ein Benutzer-Stylesheet erstellen</a>).</p>

<p>Einige beispielhafte Benutzer-Stylesheets und die dazugehörigen Bilder (Website-Icon, Header-Bild, Standard-Beitragsbild) werden bereits mitgeliefert:</p>

<ul>
	<li><b>user.css:</b> Ein Ausschitt aus dem Standard-Stylesheet <b>default.css</b>.</li>
	<li><b>cool.css:</b> Ein Stylesheet mit kühlen Farbtönen (entspricht dem Standard-Stylesheet).</li>
	<li><b>warm.css:</b> Ein Stylesheet mit warmen Farbtönen.</li>
	<li><b>green.css:</b> Ein Stylesheet mit hellgrünen Farbtönen.</li>
	<li><b>dark.css:</b> Ein Stylesheet mit sehr dunklen Farben.</li>
</ul>

<p>Um eins dieser Stylesheets zu aktivieren und zu sehen, wie es das Design der Website verändert, einfach mal einen dieser Dateinamen in die <b>config.php</b> unter <code>$userStylesheet</code> eintragen und die Website neu laden.</p> 

<p>Möchte man nicht nur geringfügige Änderungen am vorgegebenen Design vornehmen (z.B. nur die Farben oder die Rundungsradien der Ecken ändern), sondern ein komplett neues Design erstellen, legt man sich dafür am besten ein neues Stylesheet an und gibt dessen Namen in der <b>config.php</b> unter <code>$stylesheet</code> an. Dazu kann man sich eine Kopie der <b>default.css</b> erstellen und diese anpassen.</p>

<h4 id="design-preview">Vorschau-Modus</h4>

<p>Damit sich Änderungen am Design und am Layout nicht sofort auf das "Live-System" auswirken, gibt es einen speziellen Vorschau-Modus mit einem eigenen Satz von Stylesheets.</p>

<p>Um die Blog-Seiten im Vorschau-Modus zu betrachten, einfach auf den Menü-Button <b>Vorschau</b> klicken. Im Vorschau-Fenster auf der rechten Seite des Editors ist der Vorschau-Modus immer aktiv.</p>

<p>Standardmäßig sind die Stylesheets von "Live"- und Vorschau-Modus identisch. Während der Entwicklung eines neuen Layouts oder Designs können für den Vorschau-Modus andere Stylesheets in der <b>config.php</b> angegeben werden, z.B.:</p>

<pre class="textbox">
<span style="color: #00AA00;">// Stylesheets für den Vorschau-Modus</span>
$stylesheet<u>Preview</u> = '<span style="color: #0000FF;">mein-neues-layout.css</span>';
$userStylesheet<u>Preview</u> = '<span style="color: #0000FF;">mein-design.css</span>';
</pre>

<p>Wenn das neue Layout oder Design fertig ist, können die Vorschau-Stylesheets "scharfgeschaltet" werden, indem man sie in der <b>config.php</b> auch für das "Live-System" übernimmt.</p>

<h4 id="design-user-css">Ein Benutzer-Stylesheet erstellen</h4>

<p>Geringfügige Anpassungen, die das Erscheinungsbild betreffen, etwa das Website-Icon, ein Header-Bild, ein Standard-Beitragsbild und die Farben, kann man entweder im Benutzer-Stylesheet <b>user.css</b> vornehmen, oder man erstellt man sich dafür ein eigenes Benutzer-Stylesheet. Dieses enthält nur die gegenüber dem Standard-Stylesheet abweichenden Definitionen und ist somit sehr klein und übersichtlich.</p>

<p>Um ein neues Benutzer-Stylesheet zu erstellen, legt man über den Menü-Button <b>Neu</b> eine neue, leere Datei mit dem Dateityp "System" an, trägt als Dateiname z.B. <span style="color: #0000FF;">mein-design.css</span> ein uns speichert sie ab. Dann trägt man diesen Namen in die <b>config.php</b> unter <code>$userStylesheetPreview</code> ein:</p>

<pre class="textbox">
<span style="color: #00AA00;">// Stylesheets für den Vorschau-Modus</span>
$stylesheetPreview = 'default.css';
$userStylesheetPreview = '<span style="color: #0000FF;">mein-design.css</span>';
</pre>

<p>Dann kopiert man sich aus der <b>default.css</b> die Zeilen aus dem oberen Teil mit den Variablen von "<b>html {</b>" bis einschließlich zum dazugehörigen "<b>}</b>" in die Zwischenablage (markieren und <b>Strg+C</b>) und fügt ihn mit <b>Strg+V</b> in das Benutzer-Stylesheet ein:</p>

<pre class="textbox">
html {
	--DefaultFgColor: #000000;
	--DefaultBgColor: #E0E3F2;
	--DefaultBorderRadius: 10px;
	<span style="color: #666666;">... (usw.) ...</span>
}
</pre>

<p>Man braucht nicht alle Zeilen zu kopieren, sondern nur die, deren Werte man gegenüber dem Standard-Stylesheet verändern möchte.</p>

<p>Diese Datei kann man nun "nach Herzenslust" anpassen. Keine Angst, man kann nichts kaputtmachen, da man ja nur die Vorschau-Version verändert, die keine Auswirkungen auf das Live-System hat.</p> 

<p>Öffnet man eine CSS-Datei im Editor ("Öffnen > Auflisten: System > Dateiname: default.css > Öffnen"), dann werden in der Vorschau auf der rechten Seite die Farb-Variablen visuell dargestellt.</p>

<p>Zur Anpassung einer Farbe markiert man im Editor (linke Seite) den Farbwert mit der Maus (z.B. <span style="background-color: #C0E0FF; padding: 0.2em; margin: -0.2em;">#E0E3F2</span>) und klickt auf den Farbpicker oben in der Werkzeugleiste, um eine andere Farbe auszuwählen und in den Editor einzufügen.</p>

<p>Der Farbpicker sieht auf den verschiedenen Browsern etwas unterschiedlich aus. Grundsätzlich ist er aber zweigeteilt: Mit Klick auf die rechte Hälfte wird die Farbe ausgewählt, und ein Klick auf die linke Hälfte fügt den Farbcode in den Editor ein.</p>

<p>Um das Ergebnis der Anpassungen zu kontrollieren, speichert man die Datei ab und klickt auf den <b>Vorschau</b>-Button im Menü. Dadurch öffnet sich die Hauptseite des Blogs in einem neuen Browser-Tab. Falls die Seite bereits in einem anderen Tab geöffnet ist, kann man dort F5 drücken zum Neuladen.</p>

<p>Ist alles fertig, übernimmt man den Namen des neuen Benutzerstylesheets auch in die <b>config.php</b>-Variable <code>$userStylesheet</code>:</p>

<pre class="textbox">
<span style="color: #00AA00;">// Stylesheets für den "Live"-Modus</span>
$stylesheet = 'default.css';
$userStylesheet = '<span style="color: #0000FF;">mein-design.css</span>';
</pre>

<h4 id="design-layout">Änderung am Webseiten-Layout</h4>

<p>Hätte man z.B. auf großen Displays die Seitenleiste mit den Widgets lieber links vom Hauptinhalt, dann übernimmt man den folgenden Abschnitt aus dem Standard-Stylesheet in das Benutzer-Stylesheet und vertauscht dort im Abschnitt...</p>

<pre class="textbox">
@media (min-width: 800px) {
	body {
		grid-template-areas:
			"menu-left-space     menu                menu                menu-right-space"
			"header              header              header              header"
			"left-space          <span style="color: #0000FF;">main</span>                <span style="color: #00C000;">sidebar</span>             right-space"
			"left-space          footer              footer              right-space";
		grid-template-columns:
			auto                 <span style="color: #0000FF;">minmax(auto, 800px)</span> <span style="color: #00C000;">280px</span>               auto;
	}
}
</pre>

<p>... die <span style="color: #0000FF;">blau</span> mit den <span style="color: #00C000;">grün</span> gekennzeichneten Angaben, so dass dann "sidebar" links von "main" und "280px" links von "minmax(...)" steht. Ein Beispiel dafür ist im Benutzer-Stylesheet <b>dark.css</b> zu finden.</p>

<p>Das soll als Anregung an dieser Stelle erst einmal genügen. Durch entsprechend umfangreiche Änderungen an der default.css lässt sich im Prinzip ein komplett anderes "Theme" (wie man bei WordPress sagen würde) erstellen. Und falls man sich mal "verkonfiguriert" hat, einfach die Originaldatei wieder auf den Server hochladen und nochmal probieren...</p>

<h3 id="homepage">Eine Startseite erstellen</h3>

<h4 id="homepage-options">Blog oder klassische Website?</h4>

<p>Reine Blogs listen die vorhandenen Artikel meist direkt auf der Startseite auf. Dazu erstellt man eine leere Datei mit dem Dateityp "Index" und speichert sie unter dem Dateinamen "index" ab - fertig. Diese Variante ist im Auslieferungszustand bereits vorgegeben.</p>

<p>Hat man als Startseite lieber eine statische Seite und die Auflistung der Artikel auf einer Unterseite, dann erstellt man eine neue Datei mit dem Dateityp "Seite" und speichert sie unter dem Dateinamen "index" ab. Dann erstellt man eine leere Datei mit dem Dateityp "Index" und speichert sie unter einem beliebigen anderen Dateinamen ab, z.B. "blog". Unter diesem Namen kann man sie dann im Menü verlinken.</p>

<p>Theoretisch wäre es natürlich auch möglich, eine Website nur aus statischen Seiten zu erstellen, ohne die Blog-Funktionalität zu nutzen.</p>

<h3 id="menu">Das Menü einrichten</h3>

<p>Das Menü erscheint beim vorgegebenen Design am oberen Seitenrand. Wenn genügend Platz vorhanden ist, sind alle Menüpunkte nebeneinander zu sehen. Auf schmalen Displays oder wenn zu viele Menüpunkte vorhanden sind, erscheint stattdessen ein "Hamburger-Symbol" (☰). Klickt man darauf (oder tippt es auf Touchscreens an), öffnet sich das Menü, wobei die Menüpunkte diesmal untereinander dargestellt werden.</p>

<p>Im Menü kann alles verlinkt werden, was eine URL hat: Interne Artikel (Beiträge, Seiten), externe Seiten, ein Kontaktformular, ... etc. Standardmäßig sind einige Beispiel-Menüpunkte enthalten, die aber nach Belieben angepasst oder auch gelöscht werden können.</p>

<p>Nach der Installation enthält das Menü bereits einige Beispiel-Menüpunkte und Untermenüs, die angepasst oder entfernt werden können. Insbesondere wäre zu überlegen, das "Admin"-Untermenü zu entfernen und sich die dort enthaltenen Links zum <a href="lib/editor" target="_blank" rel="noopener">Blog-Editor</a>, zum <a href="lib/setup" target="_blank" rel="noopener">Setup-Programm</a>, zur <a href="lib/cgi-bin/showlog.pl" target="_blank" rel="noopener">Website-Statistik</a> und zur <a href="help" target="_blank" rel="noopener">Hilfe-Seite</a> als Browser-Bookmarks abzuspeichern.</p>

<p>Um das Menü anzupassen, bearbeitet man die Datei <b>lib/menu.xml</b>. Öffnet man diese über "Öffnen > Auflisten: System > Dateiname: menu.xml > Öffnen" im Blog-Editor, dann sieht man rechts auch gleich eine Vorschau, wie das Menü aussehen wird.</p> 

<p>Die Datei menu.xml hat folgenden Aufbau:</p>

<pre class="textbox">
&lt;menu&gt;
	&lt;item link="<b>URL</b>"&gt;<b>LABEL</b>&lt;/item&gt;
&lt;/menu&gt;
</pre>

<p>Hierbei steht <b>URL</b> für die Adresse der zu verlinkenden Seite und <b>LABEL</b> für den Text des Menüpunktes. Also z.B.:</p>

<pre class="textbox">
&lt;menu&gt;
	&lt;item link="<span style="color: #0000FF;">about</span>"&gt;<span style="color: #0000FF;">Über diese Seite</span>&lt;/item&gt;
&lt;/menu&gt;
</pre>

<p>Weitere Menüpunkte werden nach demselben Schema hinzugefügt, indem man die item-Zeile dupliziert und entsprechend anpasst.</p>

<p>Links zu Blog-Artikeln lassen sich auch über die Dateiverwaltung einfügen: Öffnen > Auflisten: Artikel > (den gewünschten Artikel auswählen) > (in der Dropdown-Box links neben dem Einfügen-Button "Dateiname" auswählen) > Einfügen.</p>

<p>Möchte man, dass sich die verlinkte Seite in einem neuen Browser-Tab öffnet, kann man noch <code><span style="color: #0000FF;">newtab="true"</span></code> angeben:</p>

<pre class="textbox">
&lt;menu&gt;
	&lt;item link="help" <span style="color: #0000FF;">newtab="true"</span>&gt;Hilfe&lt;/item&gt;
&lt;/menu&gt;
</pre>

<p>Das Menü kann theoretisch beliebig tief "verschachtelt" werden. Um ein Untermenü hinzuzufügen, wird folgende Syntax verwendet (<span style="color: #0000FF;">blau</span> hervorgehoben):</p>

<pre class="textbox">
&lt;menu&gt;
	&lt;item link="about"&gt;Über diese Seite&lt;/item&gt;
	<span style="color: #0000FF;">&lt;item&gt;Untermenü&lt;/item&gt;
	&lt;menu&gt;
		&lt;item link="<b>URL</b>"&gt;<b>LABEL</b>&lt;/item&gt;
	&lt;/menu&gt;</span>
&lt;/menu&gt;
</pre>

<p>Auch hier können nach demselben Schema weitere Menüpunkte zum Untermenü hinzugefügt werden, nämlich indem man die item-Zeile dupliziert und entsprechend anpasst. Auch lassen sich innerhalb des inneren menu-Blocks weitere Untermenüs einfügen.</p>

<p>Schließlich gibt es noch zwei Typen von "automatischen Untermenüs": Neue Beiträge und Beitragskategorien (ebenfalls <span style="color: #0000FF;">blau</span> hervorgehoben):</p>

<pre class="textbox">
&lt;menu&gt;
	&lt;item link="about"&gt;Über diese Seite&lt;/item&gt;
	&lt;item&gt;Untermenü&lt;/item&gt;
	&lt;menu&gt;
		&lt;item link="aktuell"&gt;Aktuell&lt;/item&gt;
	&lt;/menu&gt;
	<span style="color: #0000FF;">&lt;item type="recent-posts" max="10"&gt;Neu&lt;/item&gt;
	&lt;item type="categories" max="10"&gt;Themen&lt;/item&gt;</span>
&lt;/menu&gt;
</pre>

<p>Das Attribut <b>type</b> gibt an, was in das Untermenü eingefügt wird: "recent-posts" fügt die Titel der neuesten Blog-Einträge ein, "categories" die vorhandenen Kategorien. Das Attribut <b>max</b> gibt an, wieviele Menüpunkte (Beiträge bzw. Kategorien) maximal in das jeweilige Untermenü eingefügt werden sollen.</p>

<h3 id="contact">Ein Kontaktformular erstellen</h3>

<p>Das Kontaktformular emöglicht es den Besuchern der Seite, dir eine E-Mail-Nachricht zukommen zu lassen, ohne dass auf der Website deine E-Mail-Adresse angegeben werden muss. So kann diese nicht von Datensammlern abgegriffen werden und ist zudem vor Spam geschützt.</p>

<p>Es können beliebig viele Kontaktformulare erstellt werden, etwa für unterschiediche Empfänger oder zu unterschiedlichen Zwecken. Das eigentliche Formular sieht jedoch immer gleich aus und enthält immer die vier Felder Name, E-Mail-Adresse, Betreff und Nachricht. (Um das Layout des Formulars zu ändern, müsste die Systemdatei <b>contact.php</b> angepasst werden.)</p>

<p>Um ein neues Kontaktformular zu erstellen, lege über den Menü-Button <b>Neu</b> eine neue Datei an. Wähle die Vorlage "Kontaktformular" aus. Im Dialog <b>Datei-Informationen bearbeiten</b> wähle als Dateityp "Seite" aus und gib einen Titel an (z.B. "Kontakt"). Als Dateiname wird dann "kontakt" vorgeschlagen. Klicke auf <b>Schließen</b> oder <b>Speichern</b>. Rechts wird jetzt eine Vorschau des Kontaktformulars angezeigt, und im Editor steht folgender Code:</p>

<pre class="textbox">
&lt;?php
<span style="color: #00AA00;">//$infoText = '';</span>
	$recipientEmail = '<span style="color: #0000FF;">me@example.com</span>';
	$recipientName = '<span style="color: #0000FF;">My Name</span>';
	$subjectPrefix = '<span style="color: #0000FF;">[Prefix]</span>';
	$adminDataEnabled = <span style="color: #0000FF;">false</span>;
	$sessionLogEnabled = <span style="color: #0000FF;">false</span>;
	$captchaEnabled = <span style="color: #0000FF;">false</span>;
	$captchaSecret = '<span style="color: #0000FF;">A1b2C3d4E5f6</span>';
	include 'lib/contact.php';
?&gt;
</pre>

<p>(Diesen Code kannst Du natürlich auch manuell in einen bestehenden Artikel kopieren.)</p>

<p>Passe nun die Werte nach Bedarf an:</p>

<ul>
	<li><b>$infoText:</b> Ein kurzer Einleitungstext oder -satz, der über dem Kontaktformular ausgegeben werden soll. Falls ein Fehler auftritt, oder wenn die Nachricht erfolgreich gesendet wurde, erscheint stattdessen eine entsprechende Meldung. Entferne die beiden Kommentarzeichen <span style="color: #00AA00;"><b>//</b></span> am Zeilenbeginn, um den Infotext zu aktivieren; andernfalls wird ein Standardtext ausgegeben. Die Angabe <b>%s</b> im Infotext kann als Platzhalter für den Namen des Empfängers (s.u.) verwendet werden. Wenn aktiviert, aber leer, wird kein Infotext ausgegeben.</li>

	<li><b>$recipientEmail:</b> Die E-Mail-Adresse, an die die Nachricht geschickt werden soll.</li>

	<li><b>$recipientName:</b> Der Name des Empfängers. Kann auch leer bleiben (dann wird der Name der Website verwendet).</li>

	<li><b>$subjectPrefix:</b> Ein kurzer Text, der der Betreffzeile vorangestellt werden soll. Das soll es erleichtern, schon im Posteingang zu erkennen, ob eine Mail über das Kontaktformular versendet wurde. Kann auch leer bleiben.</li>

	<li><b>$adminDataEnabled:</b> Auf <span style="color: #0000FF;">true</span> setzen, um einige administrative Daten an die E-Mail anzuhängen (IP-Adresse, Referrer, Sprache, Browser).</li>

	<li><b>$sessionLogEnabled:</b> Auf <span style="color: #0000FF;">true</span> setzen, um einige Informationen an die E-Mail anzuhängen, aus denen hervorgeht, wie der Besucher mit dem Kontaktformular interagiert hat. Dies soll es ermöglichen, zukünftig geeignete Maßnahmen gegen Spambots zu ergreifen, z.B. falls erkennbar ist, dass die Formularfelder schneller ausgefüllt worden sind, als das ein Mensch normalerweise schafft.</li>

	<li><b>$captchaEnabled:</b> Auf <span style="color: #0000FF;">true</span> setzen, wenn eine Spamschutz-Aufgabe (Captcha) verwendet werden soll. Ist das Captcha aktiviert, wird unter dem Formular ein Schachbrett eingeblendet, auf das durch Klicken oder Tippen zwei Smileys auf die richtigen Felder gesetzt werden müssen. Bei einer falschen Antwort gibt es nach dem Absenden eine Verzögerung von einigen Sekunden (dies soll Brute-Force-Angriffe abwehren), bevor eine Fehlermeldung ausgegeben wird.</li>

	<li><b>$captchaSecret:</b> Ein geheimer Text, mit dem die Captcha-Antwort beim Absenden des Formulars verschlüsselt wird. Das soll es den "bösen Buben" erschweren, den Spamschutz zu umgehen. Das kann einfach irgend eine zufällige Folge von Buchstaben und Zahlen sein.</li>
</ul>

<p>Zusätzlich kann das Kontaktformular natürlich - wie jeder andere Artikel auch - mit individuellen Texten, Bildern und beliebigen anderen Inhalten "angereichert" werden.</p>

<p>Ist alles konfiguriert, speichere die Datei.</p>

<h4 id="contact-usage">Verwendung</h4>

<p>Das Kontaktformular kann nun über seinen Dateinamen aufgerufen werden oder im Menü oder in einem Artikel verlinkt werden. Lautet der Dateiname z.B. "kontakt", kann man es ins Menü einbinden, indem man Folgendes in die <b>menu.xml</b> einfügt:</p>

<pre class="textbox">
&lt;menu&gt;
	<b>&lt;item link="<span style="color: #0000FF;">kontakt</span>"&gt;Kontakt&lt;/item&gt;</b>
&lt;/menu&gt;
</pre>

<p>Ebenso einfach kann das Kontaktformular auch in einem Artikel verlinkt werden.</p>

<pre class="textbox">
&lt;a href="<span style="color: #0000FF;">kontakt"</span>&gt;Kontaktformular&lt;/a&gt;
</pre>

<p>Es ist auch möglich, den Betreff und/oder das Nachrichtenfeld mit einem Text vorzubelegen:</p>

<pre class="textbox">
&lt;a href="kontakt<span style="color: #0000FF;">?subject=Bestellung</span>"&gt;Bestellen&lt;/a&gt;
</pre>

<p></p>

<pre class="textbox">
&lt;a href="kontakt?subject=Betreff<span style="color: #0000FF;">&message=Nachricht Zeile 1{}Nachricht Zeile 2</span>"&gt;Kontaktformular&lt;/a&gt;
</pre>

<p>Der Platzhalter <b>{}</b> bewirkt im Nachrichtentext einen Zeilenwechsel.</p>

<p>Zum komfortablen Einbinden des Kontaktformulars in einen Artikel existieren beispielhaft drei Snippets (contact*.html), in denen aber ggf. noch der Dateiname des Kontaktformulars angepasst werden muss.</p>

<h3 id="widgets">Widgets einrichten</h3>

<p>Widgets (übersetzt in etwa "Dingsbums") sind Elemente, die in die Seitenleiste eingebunden werden können. Sie können beliebigen Inhalt anzeigen, sollten aber auf jeweils eine Aufgabe beschränkt sein.
Klassische Widgets sind bei Blogs so Sachen wie "Neueste Beiträge", "Beitragskategorien", "Schlagwörter" und "Suche". Diese sind auch Bestandteil dieses Blog-Systems. Zudem noch ein Losungs-Widget und ein Bild-mit-Link-Widget. Letzteres macht nichts anderes, als ein Bild anzuzeigen, das mit einem Link versehen ist. Wenn der Besucher das Bild anklickt, wird er auf die verlinkte Seite geleitet.</p>

<p>Die Widget-Dateien befinden sich im Unterverzeichnis "widgets" und können mit dem Blog-Editor bearbeitet werden ("Öffnen > Auflisten: Widgets > Dateiname: (die gewünschte Datei auswählen) > Öffnen"), was den Vorteil hat, dass man rechts gleich eine Vorschau sieht.</p>

<p>Dateien mit der Endung .php oder .html sind die Widget-Dateien. Diese enthalten PHP- und/oder HTML-Code zur Darstellung des Inhalts. Über die Konfigurationsdatei <b>widgets.xml</b> werden die Widgets in die Seitenleiste eingebunden. Die Syntax ist ganz einfach:</p>

<pre class="textbox">
&lt;widgets&gt;
	&lt;item filename="<span style="color: #0000FF;">dateiname.php</span>"&gt;<span style="color: #0000FF;">Titel</span>&lt;/item&gt;
&lt;/widgets&gt;
</pre>

<p><span style="color: #0000FF;">dateiname.php</span> ist der Dateiname des Widgets, also z.B. "tags.php". <span style="color: #0000FF;">Titel</span> ist der Widget-Titel, so wie er in der Seitenleiste erscheinen soll.</p>

<p>Die Widgets erscheinen in genau der Reihenfolge und mit den Titeln in der Seitenleiste, wie sie auch in der <b>widgets.xml</b> angegeben sind. Um ein Widget aus der Seitenleiste zu entfernen, kann man die betreffende item-Zeile entweder löschen oder mit &lt;!-- und --&gt; auskommentieren.</p>

<h4 id="widgets-create">Ein neues Widget erstellen</h4>

<p>Um nun ein neues Widget zu erstellen, legt man eine neue, leere Datei mit Dateityp "Widget" an. Um - als einfaches Beispiel - ein Widget mit Bild-Link zu erstellen, kann man folgenden HTML-Code verwenden:</p>

<pre class="textbox">
&lt;p&gt;&lt;a href="<span style="color: #0000FF;">artikel-link</span>"&gt;&lt;img src="<span style="color: #0000FF;">media/bild.jpg</span>"&gt;&lt;/a&gt;&lt;/p&gt;
</pre>

<p>Den Link zu einem Artikel (<span style="color: #0000FF;">artikel-link</span>) kann man direkt hinschreiben, oder man fügt ihn über die Dateiverwaltung ein ("Öffnen > Auflisten: Artikel > (den gewünschten Artikel auswählen) > (in der Dropdown-Box links neben dem Einfügen-Button „Dateiname“ auswählen) > Einfügen"). Den Bild-Link (<span style="color: #0000FF;">media/bild.jpg</span>) kann man aus der Medienverwaltung einfügen ("Medien > (die gewünschten Mediendatei auswählen) > Einfügen").</p>

<p>Im Vorschau-Bereich rechts müsste nun das neue Widget zu sehen sein, allerdings noch mit einem Standard-Titel. Wenn alles so aussieht, wie es soll, speichert man die Widget-Datei unter einem neuen Namen ab, z.B. <span style="color: #0000FF;">test-widget.html</span>, öffnet die Konfigurationsdatei <b>widgets.xml</b> und fügt das neue Widget dort zusammen mit einem kurzen Titel (z.B. <span style="color: #0000FF;">Test-Widget</span>) ein:</p>

<pre class="textbox">
&lt;widgets&gt;
	&lt;item filename="<span style="color: #0000FF;">test-widget.html</span>"&gt;<span style="color: #0000FF;">Test-Widget</span>&lt;/item&gt;
&lt;/widgets&gt;
</pre>

<p>In der Vorschau rechts müsste das Test-Widget nun zusammen mit den anderen Widgets zu sehen sein. Nach Speichern der geänderten <b>widgets.xml</b> erscheint das neue Widget dann auch auf der "echten" Website.</p>

<h3 id="templates">Eine Vorlage erstellen</h3>

<p>Wenn man oft neue Blog-Artikel erstellt, kann es sinnvoll ein, sich dafür eine Vorlage zu machen, die einige immer wiederkehrende Elemente enthält, etwa ein Aufmacher-Bild, ein kurzer Anreißer-Text in Fettschrift und z.B. eine Datumsangabe. Nichts leichter als das! Aus dem Menü wählen: "Neu > Leere Seite > OK > Dateityp: Vorlage > Dateiname: (irgendwas Aussagekräftiges) > Schließen". Dann Text eingeben und speichern. Das war's!</p>

<p>Um nun einen neuen Artikel auf Basis dieser Vorlage zu erstellen, einfach den Menü-Button <b>Neu</b> anklicken, die neue Vorlage auswählen und loslegen...</p>

<h3 id="textboxes">Einen Textbaustein erstellen</h3>

<p>Textbausteine sind wiederverwendbare kurze Texte, die in Artikel eingefügt werden können und zentral gepflegt werden. Änderungen an einem Textbaustein werden sofort in allen Artikeln sichtbar, in denen er eingefügt ist.</p>

<p>Um einen neuen Textbaustein zu erstellen, lege über den Menü-Button <b>Neu</b> eine neue Datei mit dem Dateityp "Textbaustein" an, schreibe den gewünschten Text hinein und speichere sie unter einem sprechenden Namen ab.</p>

<p>Mit folgendem PHP-Code wird dieser Textbaustein dann in einen Artikel eingebunden, wobei <span style="color: #0000FF;">dateiname.html</span> dem Dateinamen der soeben abgespeicherten Datei entspricht:</p>

<pre class="textbox">
&lt;?php include 'textblocks/<span style="color: #0000FF;">dateiname.html</span>';?&gt;
</pre>

<p>Und weil man das natürlich nicht jedesmal tippen will, legt man sich dafür sinnvollerweise ein Snippet an und bindet dieses in das Snippet-Menü ein: Erstelle eine neue Datei mit dem Dateityp "Snippet" und füge dort obigen PHP-Code ein. Öffne anschließend die Datei "snippets.xml" aus dem Bereich <b>Snippets</b> und füge das neue Snippet an passender Stelle ein.</p>

<p>Das Erstellen eigener Snippets wird im nächsten Abschnitt ausführlich erklärt.</p>

<h3 id="snippets">Ein Snippet erstellen</h3>

<p>Um ein neues <a href="#toolbar-snippets">Snippet</a> für den Editor zu erzeugen, einfach über den Menü-Button <b>Neu</b> eine neue Datei (Vorlage: "Leere Seite") mit dem Dateityp "Snippet" erstellen, einen Dateinamen vergeben, den Code einfügen und abspeichern. Anschließend über den Menü-Button <b>Öffnen</b> die Datei <b>snippets.xml</b> aus dem Bereich <b>Snippets</b> öffnen und nach folgendem Beispiel das neue Snippet an gewünschter Stelle einbinden:</p>

<pre class="textbox">
&lt;snippets&gt;
	&lt;<span style="color: #FF8000;">section</span> <b>caption</b>="<span style="color: #0000FF;">——— Abschnitt ———</span>"&gt;
		&lt;<span style="color: #FF8000;">item</span> <b>filename</b>="<span style="color: #0000FF;">snippet-dateiname.html</span>"&gt;<span style="color: #0000FF;">Snippet-Titel</span>&lt;/<span style="color: #FF8000;">item</span>&gt;
	&lt;/<span style="color: #FF8000;">section</span>&gt;
&lt;/snippets&gt;
</pre>

<p>Das Snippet-Menü besteht aus beliebig vielen Abschnitten (<span style="color: #FF8000;">section</span>-Blöcke). Jeder Abschnitt hat eine Überschrift (<b>caption</b>) und enthält seinerseits wiederum beliebig viele Snippet-Elemente (<span style="color: #FF8000;">item</span>-Zeilen). Ein Snippet-Element (<span style="color: #FF8000;">item</span>-Zeile) enthält den Dateinamen des Snippets (<b>filename</b>) und den Titel, der im Menü angezeigt wird.</p>

<p>In der Vorschau rechts sollte das neue Snippet nun aufgeführt und sein Inhalt angezeigt werden. Falls unter dem angegebenen Dateinamen kein Snippet gefunden werden kann, wird eine entsprechende Fehlermeldung angezeigt. Nach Speichern der <b>snippets.xml</b> ist das neue Snippet im Snippet-Menü auswählbar.</p>

<p>Ein Snippet kann verschiedene Variablen enthalten, die beim Einfügen in den Text durch die im Text markierten Zeilen / Textteile ersetzt werden. Als Trenner zwischen den einzelnen Text-Teilen fungieren dabei der Zeilenumbruch, der Tabulator und die Zeichen [ | ].</p>

<p>Es gibt 3 unterschiedliche Snippet-Typen:</p>

<h4 id="snippets-inline">1. Inline-Snippets</h4>

<p>Diese bestehen meist aus einer einzelnen Zeile (z.B. einem Link) und können bis zu 5 einzelne Teile enthalten:</p>

<ul>
	<li>Die Variablen <span style="color: #0000FF;">@PART1@</span> bis <span style="color: #0000FF;">@PART5@</span> werden durch den 1., 2., 3., 4. oder 5. markierten Teil bzw. Zeile ersetzt.</li>
</ul>

<p>Beispiel-Snippet:</p>

<pre class="textbox">
&lt;a href="<span style="color: #0000FF;">@PART2@</span>"&gt;<span style="color: #0000FF;">@PART1@</span>&lt;/a&gt;
</pre>

<p>Markierter Text:</p>

<p><span style="background-color: #C0E0FF; padding: 0.2em; margin: -0.2em;">Herzlich willkommen!|willkommen</span></p>

<p>Der erste Teil des markierten Textes (<span style="color: #0000FF;">Herzlich willkommen!</span>) wird in die Variable <span style="color: #0000FF;">@PART1@</span> eingesetzt, der zweite Teil (<span style="color: #0000FF;">willkommen</span>) in die Variable <span style="color: #0000FF;">@PART2@</span>. Das Ergebnis nach Einfügen des Snippets wäre dann:</p>

<pre class="textbox">
&lt;a href="<span style="color: #0000FF;">willkommen</span>"&gt;<span style="color: #0000FF;">Herzlich willkommen!</span>&lt;/a&gt;
</pre>

<p>Darstellung auf der Webseite:</p>

<p><a href="willkommen">Herzlich willkommen!</a></p>

<h4 id="snippets-multiline">2. Multiline-Snippets</h4>

<p>Bei diesen werden die Variablen durch die markierten Zeilen ersetzt:</p>

<ul>
	<li><span style="color: #0000FF;">@LINE1@</span> bis <span style="color: #0000FF;">@LINE3@</span> wird durch die 1., 2. oder 3. markierte Zeile ersetzt.</li>

	<li><span style="color: #0000FF;">@MULTILINE@</span> wird durch weitere aufeinanderfolgende, markierte Zeilen ersetzt (z.B. mehrere Absätze bei Zitaten). Hierzu wird die Snippet-Zeile, die das @MULTILINE@ enthält, entsprechend oft vervielfältigt.</li>

	<li><span style="color: #0000FF;">@LASTLINE@</span> wird durch die letzte markierte Zeile ersetzt (z.B. für eine Zitatquelle oder einen Bild-Untertitel). Falls nicht benötigt, bitte eine Leerzeile zusätzlich markieren.</li>
</ul>

<p>Beispiel-Snippet:</p>

<pre class="textbox">
&lt;blockquote&gt;
	&lt;p&gt;<span style="color: #0000FF;">@MULTILINE@</span>&lt;/p&gt;
	&lt;cite&gt;<span style="color: #0000FF;">@LASTLINE@</span>&lt;/cite&gt;
&lt;/blockquote&gt;
</pre>

<p>Markierter Text:</p>

<p><span style="background-color: #C0E0FF; padding: 0.2em; margin: -0.2em;">Dies ist ein schlaues Zitat von irgendjemand ganz Berühmten.
<br>Etwas ganz Tolles, das er irgendwann mal gesagt haben soll.
<br>Quelle: Vergessen</span></p>

<p>Ergebnis nach Einfügen des Snippets:</p>

<pre class="textbox">
&lt;blockquote&gt;
	&lt;p&gt;<span style="color: #0000FF;">Dies ist ein schlaues Zitat von irgendjemand ganz Berühmten.</span>&lt;/p&gt;
	&lt;p&gt;<span style="color: #0000FF;">Etwas ganz Tolles, das er irgendwann mal gesagt haben soll.</span>&lt;/p&gt;
	&lt;cite&gt;<span style="color: #0000FF;">Quelle: Vergessen</span>&lt;/cite&gt;
&lt;/blockquote&gt;
</pre>

<p>Darstellung auf der Webseite:</p>

<blockquote>
	<p>Dies ist ein schlaues Zitat von irgendjemand ganz Berühmten.</p>
	<p>Etwas ganz Tolles, das er irgendwann mal gesagt haben soll.</p>
	<cite>Quelle: Vergessen</cite>
</blockquote>

<h4 id="snippets-table">3. Tabellen-Snippets</h4>

<p>Zum Einfügen von Tabellen. Hierbei handelt es sich quasi um ein "zweidimensionales" Multiline-Snippet: Jede markierte Zeile kann mehrere Teile enthalten. Folgende Variablen gibt es hier:</p>

<ul>
	<li><span style="color: #0000FF;">@TH@</span> wird durch die in der <u>ersten</u> markierten Zeile enthaltenen Teile ersetzt (Tabellenkopf mit mehreren Spalten). Hierzu wird die Snippet-Zeile mit dem @TH@ entsprechend oft vervielfältigt. Die einzelnen Spalten können durch | oder das Tabulator-Zeichen voneinander getrennt werden.</li>
	<li><span style="color: #0000FF;">@TD@</span> wird durch die in den <u>weiteren</u> markierten Zeilen enthaltenen Teile ersetzt (Tabellenrumpf). Hierzu wird für jede Tabellenspalte die Snippet-Zeile mit dem @TD@ und für jede Tabellenzeile zusätzlich die davor und dahinter liegende Zeile mit dem &lt;tr&gt; und &lt;/tr&gt; entsprechend oft vervielfältigt. Die Anzahl der Teile (Tabellenspalten) sollte in allen Zeilen mit @TH@ und @TD@ gleich sein!</li>
	<li><span style="color: #0000FF;">@LASTLINE@</span> wird durch die letzte markierte Zeile ersetzt (Tabellen-Untertitel). Falls nicht benötigt, bitte eine Leerzeile zusätzlich markieren.</li>
</ul>

<p>Beispiel-Snippet:</p>

<pre class="textbox">
&lt;figure&gt;
	&lt;table&gt;
		&lt;tr&gt;
			&lt;th&gt;<span style="color: #0000FF;">@TH@</span>&lt;/th&gt;
		&lt;/tr&gt;
		&lt;tr&gt;
			&lt;td&gt;<span style="color: #0000FF;">@TD@</span>&lt;/td&gt;
		&lt;/tr&gt;
	&lt;/table&gt;
	&lt;figcaption&gt;<span style="color: #0000FF;">@LASTLINE@</span>&lt;/figcaption&gt;
&lt;/figure&gt;
</pre>

<p>Markierter Text:</p>

<p><span style="background-color: #C0E0FF; padding: 0.2em; margin: -0.2em;">Spalte A | Spalte B | Spalte C
<br>Zelle A1 | Zelle B1 | Zelle C1
<br>Zelle A2 | Zelle B2 | Zelle C2
<br>Zelle A3 | Zelle B3 | Zelle C3
<br>Tabelle</span></p>

<p>Ergebnis nach Einfügen des Snippets:</p>

<pre class="textbox">
&lt;figure&gt;
	&lt;table&gt;
		&lt;tr&gt;
			&lt;th&gt;<span style="color: #0000FF;">Spalte A</span>&lt;/th&gt;
			&lt;th&gt;<span style="color: #0000FF;">Spalte B</span>&lt;/th&gt;
			&lt;th&gt;<span style="color: #0000FF;">Spalte C</span>&lt;/th&gt;
		&lt;/tr&gt;
		&lt;tr&gt;
			&lt;td&gt;<span style="color: #0000FF;">Zelle A1</span>&lt;/td&gt;
			&lt;td&gt;<span style="color: #0000FF;">Zelle B1</span>&lt;/td&gt;
			&lt;td&gt;<span style="color: #0000FF;">Zelle C1</span>&lt;/td&gt;
		&lt;/tr&gt;
		&lt;tr&gt;
			&lt;td&gt;<span style="color: #0000FF;">Zelle A2</span>&lt;/td&gt;
			&lt;td&gt;<span style="color: #0000FF;">Zelle B2</span>&lt;/td&gt;
			&lt;td&gt;<span style="color: #0000FF;">Zelle C2</span>&lt;/td&gt;
		&lt;/tr&gt;
		&lt;tr&gt;
			&lt;td&gt;<span style="color: #0000FF;">Zelle A3</span>&lt;/td&gt;
			&lt;td&gt;<span style="color: #0000FF;">Zelle B3</span>&lt;/td&gt;
			&lt;td&gt;<span style="color: #0000FF;">Zelle C3</span>&lt;/td&gt;
		&lt;/tr&gt;
	&lt;/table&gt;
	&lt;figcaption&gt;<span style="color: #0000FF;">Tabelle</span>&lt;/figcaption&gt;
&lt;/figure&gt;
</pre>

<p>Darstellung auf der Webseite:</p>

<figure>
	<table>
		<tr>
			<th>Spalte A</th>
			<th>Spalte B</th>
			<th>Spalte C</th>
		</tr>
		<tr>
			<td>Zelle A1</td>
			<td>Zelle B1</td>
			<td>Zelle C1</td>
		</tr>
		<tr>
			<td>Zelle A2</td>
			<td>Zelle B2</td>
			<td>Zelle C2</td>
		</tr>
		<tr>
			<td>Zelle A3</td>
			<td>Zelle B3</td>
			<td>Zelle C3</td>
		</tr>
	</table>
	<figcaption>Tabelle</figcaption>
</figure>

<h3 id="keyboard-shortcuts">Eigene Tastaturkürzel anlegen</h3>

<p>Im Editor gibt es bereits einige Tastaturkürzel (siehe Abschnitt <a href="#toolbar-format">Textformatierung</a>). Zusätzlich können auch eigene Tastaturkürzel angelegt oder vorhandene geändert oder entfernt werden. Dies geschieht durch Bearbeiten der Datei <b>keyboard.xml</b> im Bereich <b>System</b>. Das grundsätzliche Format dieser Datei sieht so aus:</p>

<pre class="textbox">
&lt;keyboard&gt;
	&lt;<span style="color: #FF8000;">shortcut</span> <b>key</b>="<span style="color: #0000FF;">x</span>" <b>ctrl</b>="<span style="color: #0000FF;">true</span>" <b>shift</b>="<span style="color: #0000FF;">false</span>" <b>alt</b>="<span style="color: #0000FF;">false</span>" <b>meta</b>="<span style="color: #0000FF;">false</span>"&gt;
		&lt;<span style="color: #FF8000;">command</span> <b>name</b>="<span style="color: #0000FF;">Kommando</span>" <b>value</b>="<span style="color: #0000FF;">Parameter</span>" /&gt;
	&lt;/<span style="color: #FF8000;">shortcut</span>&gt;
&lt;/keyboard&gt;
</pre>

<p>Für jedes Tastaturkürzel gibt es dort einen &lt;<span style="color: #FF8000;">shortcut</span>&gt;...&lt;/<span style="color: #FF8000;">shortcut</span>&gt;-Block mit Angaben zu den gedrückten Tasten:</p>

<ul>
	<li><b>key:</b> Der Tastencode der gedrückten Taste (z.B. ein Buchstabe oder eine Zahl). Um einen Tastencode einzufügen, einfach den Button <b>Tastencode</b> oben in der Werkzeugleiste anklicken und innerhalb von 5 Sekunden eine Taste drücken.</li>

	<li><b>ctrl:</b> <span style="color: #0000FF;">true</span>, wenn gleichzeitig die "Strg"-Taste gedrückt werden muss.</li>

	<li><b>shift:</b> <span style="color: #0000FF;">true</span>, wenn gleichzeitig die "Umschalt"-Taste gedrückt werden muss.</li>

	<li><b>alt:</b> <span style="color: #0000FF;">true</span>, wenn gleichzeitig die "Alt"-Taste gedrückt werden muss.</li>

	<li><b>meta:</b> <span style="color: #0000FF;">true</span>, wenn gleichzeitig die "Meta"-Taste gedrückt werden muss. Unter Windows ist das die "Windows"-Taste.</li>
</ul>

<p>Wenn eine der Tasten "Strg", "Umschalt", "Alt" oder "Meta" nicht gedrückt werden muss, kann der Attributwert <span style="color: #0000FF;">false</span> oder anders oder leer sein, oder das Attribut kann auch ganz fehlen, so wie in dem Beispiel weiter unten.</p>

<p>Innerhalb des <span style="color: #FF8000;">shortcut</span>-Blocks gibt es einen oder mehrere <span style="color: #FF8000;">command</span>-Zeilen mit Angaben zu dem Kommando, das ausgeführt werden soll, wenn das Tastaturkürzel betätigt wurde: <b>name</b> ist der Name des Kommandos, <b>value</b> ein optionaler Parameterwert für das Kommando. Je nach Kommando sind nur bestimmte Parameterwerte zulässig. Folgende Kommandos (name) und Parameter (value) sind möglich:</p>

<figure>
	<table>
		<tr>
			<th>name</th>
			<th>value</th>
			<th>Anmerkung</th>
		</tr>
		<tr>
			<td>Duplicate</td>
			<td></td>
			<td>Dupliziert den im Editor markierten Text oder - wenn kein Text markiert ist - die gesamte Zeile, in der sich der Cursor befindet.</td>
		</tr>
		<tr>
			<td>Insert&shy;Snippet</td>
			<td>Dateiname</td>
			<td>Fügt ein <a href="#toolbar-snippets">Snippet</a> in den Editor ein. Als Parameter muss der Dateiname eines existierenden Snippets angegeben werden (siehe Abschnitt <a href="#snippets">Ein Snippet erstellen</a>). Das Tastaturkürzel wird im Snippet-Menü als Tooltip angezeigt, wenn die Maus dort über den Snippet-Namen gehalten wird (ohne zu klicken).</td>
		</tr>
		<tr>
			<td>Insert&shy;String</td>
			<td>Text</td>
			<td>Fügt den als Parameter angegebenen Text in den Editor ein. Ist dort Text markiert, wird er durch den eingefügten Text ersetzt. Die Zeichen <b>&lt;</b> und <b>&gt;</b> müssen als <b>&amp;lt;</b> und <b>&amp;gt;</b> geschrieben werden.</td>
		</tr>
		<tr>
			<td>Insert&shy;Tag</td>
			<td>Text</td>
			<td>Fügt den als Parameter angegebenen Text in Form von HTML-Tags in den Editor ein. Wenn dort Text markiert ist, wird dieser von den Tags umschlossen.</td>
		</tr>
		<tr>
			<td>Save</td>
			<td></td>
			<td>Speichert die gerade bearbeitete Datei, sofern ungespeicherte Änderungen vorliegen.</td>
		</tr>
		<tr>
			<td>Scroll&shy;Line</td>
			<td>Zahl</td>
			<td>Scrollt den Text im Editor um die angegebene Anzahl von Zeilen hoch (negativer Wert) oder runter (positiver Wert). Der Wert -3 scrollt z.B. 3 Zeilen hoch.</td>
		</tr>
	</table>
	<figcaption></figcaption>
</figure>

<h4>Beispiel:</h4>

<p>Das Tastenkürzel <b>Alt+C</b> soll den markierten Text im Editor in die HTML-Tags <b>&lt;code&gt;</b> und <b>&lt;/code&gt;</b> einschließen.</p>

<pre class="textbox">
&lt;keyboard&gt;
	&lt;shortcut key="<span style="color: #0000FF;">c</span>" alt="<span style="color: #0000FF;">true</span>"&gt;
		&lt;command name="<span style="color: #0000FF;">InsertTag</span>" value="<span style="color: #0000FF;">code</span>" /&gt;
	&lt;/shortcut&gt;
&lt;/keyboard&gt;
</pre>

<p>Damit die Änderungen an der <b>keyboard.xml</b> wirksam werden, muss die Editor-Anwendung einmal neu geladen werden (F5-Taste im Browser).</p>

<p class="translate center hidden" x-data-translate-from="de"></p>

<?php include 'lib/default-footer.php'; ?>
